/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttributeFilter
implements Filter,
AttributeCondition {
    protected String prefix;
    protected String namespaceURI;
    protected String name = null;
    protected String value = null;

    public AttributeFilter(String name, String value) {
        this(null, null, name, value);
    }

    public AttributeFilter(String prefix, String namespaceURI, String name, String value) {
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
        this.name = name;
        this.value = value;
    }

    public boolean accept(Element target) {
        if (target == null || this.name == null) {
            return false;
        }
        if (this.namespaceURI == null) {
            NamedNodeMap attributes = target.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                if (attr.getNodeName().equals(this.name) && this.acceptAttribute(attr.getValue())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.namespaceURI.length() == 0) {
            NamedNodeMap attributes = target.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                if (attr.getNamespaceURI() == null && attr.getName().equals(this.name)) {
                    return this.acceptAttribute(attr.getValue());
                }
                ++i;
            }
            return false;
        }
        String attribute = target.getAttributeNS(this.namespaceURI, this.name);
        if (attribute == null || attribute.length() == 0) {
            return false;
        }
        return this.acceptAttribute(attribute);
    }

    public int getSpecificity() {
        return 10;
    }

    public short getConditionType() {
        return 4;
    }

    public short getSelectorType() {
        return 0;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public boolean getSpecified() {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    protected boolean acceptAttribute(String attributeValue) {
        if (this.value == null) {
            return true;
        }
        return this.value.equals(attributeValue);
    }

    public String toString() {
        if (this.prefix == null) {
            if (this.value == null) {
                return "[" + this.name + "]";
            }
            return "[" + this.name + "=\"" + this.value + "\"]";
        }
        if (this.value == null) {
            return "[" + this.prefix + "|" + this.name + "]";
        }
        return "[" + this.prefix + "|" + this.name + "=\"" + this.value + "\"]";
    }
}

