/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.w3c.css.sac.ElementSelector;
import org.w3c.dom.Element;

public class ElementFilter
implements Filter,
ElementSelector {
    private final String prefix;
    private final String namespaceURI;
    private final String localName;

    public ElementFilter(String localName) {
        this(null, null, localName);
    }

    public ElementFilter(String prefix, String namespaceURI, String localName) {
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
        this.localName = localName == null ? "*" : localName;
    }

    public boolean accept(Element target) {
        if (this.namespaceURI == null) {
            return this.acceptLocalName(target);
        }
        if (this.namespaceURI.length() == 0) {
            if (target.getNamespaceURI() != null) {
                return false;
            }
            return this.acceptLocalName(target);
        }
        String uri = target.getNamespaceURI();
        if (uri == null || uri.length() == 0 || !uri.equals(this.namespaceURI)) {
            return false;
        }
        return this.acceptLocalName(target);
    }

    private boolean acceptLocalName(Element target) {
        if (this.localName.equals("*")) {
            return true;
        }
        String name = target.getLocalName();
        if (name == null) {
            name = target.getTagName();
        }
        return this.localName.equals(name);
    }

    public int getSpecificity() {
        if (this.localName.equals("*")) {
            return 0;
        }
        return 1;
    }

    public short getConditionType() {
        return 2;
    }

    public short getSelectorType() {
        return 4;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String toString() {
        if (this.prefix == null) {
            return this.localName;
        }
        return String.valueOf(this.prefix) + "|" + this.localName;
    }
}

