/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.AbstractPseudoFilter;
import org.trix.cuery.util.I18nUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.Element;

public class PseudoElementFilter
extends AbstractPseudoFilter {
    private static final String[] PSEUDO_ELEMENTS_CSS2 = new String[]{"after", "before", "first-letter", "first-line"};
    private static final String[] PSEUDO_ELEMENTS_CSS3 = new String[]{"alternate", "choices", "line-maker", "maker", "outside", "repeat-index", "repeat-item", "selection", "value"};
    private int level;
    private String name;

    public PseudoElementFilter(String namespaceURI, String name) {
        if (namespaceURI == null || namespaceURI.length() == 0 || name == null || name.length() == 0) {
            throw new CSSException(I18nUtil.getText("parser.invalidPseudo", name));
        }
        int i = 0;
        while (i < PSEUDO_ELEMENTS_CSS2.length) {
            if (name.equals(PSEUDO_ELEMENTS_CSS2[i])) {
                this.level = 2;
                this.name = name;
                return;
            }
            ++i;
        }
        if (namespaceURI.equals("http://www.w3.org/TR/REC-CSS2/")) {
            throw new CSSException(I18nUtil.getText("parser.invalidPseudo", name));
        }
        i = 0;
        while (i < PSEUDO_ELEMENTS_CSS3.length) {
            if (name.equals(PSEUDO_ELEMENTS_CSS3[i])) {
                this.level = 3;
                this.name = name;
                return;
            }
            ++i;
        }
        throw new CSSException(I18nUtil.getText("parser.invalidPseudo", name));
    }

    public boolean accept(Element target) {
        return false;
    }

    public int getSpecificity() {
        return 0;
    }

    public String toString() {
        if (this.level == 2) {
            return ":" + this.name;
        }
        return "::" + this.name;
    }

    protected String getPseudoName() {
        return this.name;
    }
}

