/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.util.ArrayList;
import java.util.List;
import org.trix.cuery.StyleContext;
import org.trix.cuery.property.AbstractProperty;
import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyDescription;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.util.DOMUtil;
import org.trix.cuery.value.CSSValue;
import org.w3c.dom.Element;

public class CascadableProperty
extends AbstractProperty {
    private List properties = new ArrayList();
    private int author = 0;
    private int user = 0;
    private Element element;

    public CascadableProperty() {
    }

    public CascadableProperty(Element element) {
        this.element = element;
    }

    public CSSValue getValue(String name) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);
        CSSValue value = this.getSpecifiedValue(definition);
        Property parent = StyleContext.getProperty(DOMUtil.getParentElement(this.element));
        return definition.getComputedValue(value, this, parent);
    }

    private CSSValue getSpecifiedValue(PropertyDefinition definition) {
        String name = definition.getName();
        CSSValue result = this.searchValue(name, this.author, this.user, true);
        if (result != null) {
            return result;
        }
        result = this.searchValue(name, 0, this.author, true);
        if (result != null) {
            return result;
        }
        result = this.searchValue(name, 0, this.author, false);
        if (result != null) {
            return result;
        }
        result = this.searchValue(name, this.author, this.user, false);
        if (result != null) {
            return result;
        }
        result = this.searchValue(name, this.user, this.properties.size(), false);
        if (result != null) {
            return result;
        }
        Element parent = DOMUtil.getParentElement(this.element);
        if (parent != null && definition.isInheritable()) {
            return StyleContext.getProperty(parent).getValue(name);
        }
        return definition.getInitialValue();
    }

    private CSSValue searchValue(String name, int start, int end, boolean important) {
        int i = start;
        while (i < end) {
            CSSValue value;
            PropertyDescription description = (PropertyDescription)this.properties.get(i);
            Property property = description.property;
            if ((!important || property.isImportant(name)) && (value = property.getValue(name)) != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public boolean isImportant(String name) {
        return false;
    }

    public void addProperty(PropertyDescription description) {
        switch (description.origin) {
            case 3: {
                this.addProperty(description, 0, this.author);
                ++this.author;
                ++this.user;
                break;
            }
            case 2: {
                this.addProperty(description, this.author, this.user);
                ++this.user;
                break;
            }
            case 1: {
                this.addProperty(description, this.user, this.properties.size());
                break;
            }
        }
    }

    private void addProperty(PropertyDescription description, int start, int end) {
        int specificity = description.filter.getSpecificity();
        int i = start;
        while (i < end) {
            PropertyDescription target = (PropertyDescription)this.properties.get(i);
            int targetSpecificity = target.filter.getSpecificity();
            if (specificity > targetSpecificity) {
                this.properties.add(i, description);
                return;
            }
            if (specificity == targetSpecificity && description.position > target.position) {
                this.properties.add(i, description);
                return;
            }
            ++i;
        }
        this.properties.add(end, description);
    }

    public void clear() {
        this.properties.clear();
        this.author = 0;
        this.user = 0;
    }
}

