/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import org.trix.cuery.property.AbstractProperty;
import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.value.CSSValue;

public class InheritableProperty
extends AbstractProperty {
    public static final InheritableProperty ROOT = new InheritableProperty(null);
    private Property parent;

    public InheritableProperty(Property parent) {
        this.parent = parent;
    }

    public CSSValue getValue(String name) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);
        if (this.parent == null) {
            return definition.getComputedValue(definition.getInitialValue(), this, this);
        }
        if (definition.isInheritable()) {
            return this.parent.getValue(name);
        }
        return definition.getComputedValue(definition.getInitialValue(), this, this.parent);
    }

    public boolean isImportant(String name) {
        if (this.parent == null) {
            return false;
        }
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);
        if (definition.isInheritable()) {
            return this.parent.isImportant(name);
        }
        return false;
    }
}

