/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.trix.cuery.property.AbstractProperty;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.value.CSSValue;

public class SimpleProperty
extends AbstractProperty {
    private List properties = new ArrayList(8);

    public CSSValue getValue(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.properties.size()) {
            Object[] objects = (Object[])this.properties.get(i);
            if (name.equals(objects[0])) {
                return (CSSValue)objects[1];
            }
            ++i;
        }
        return null;
    }

    public boolean isImportant(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.properties.size()) {
            Object[] objects = (Object[])this.properties.get(i);
            if (name.equals(objects[0])) {
                return (Boolean)objects[2];
            }
            ++i;
        }
        return false;
    }

    public void setProperty(String name, CSSValue value, boolean important) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);
        if (definition == null) {
            return;
        }
        Map result = definition.parse(value);
        if (result == null) {
            return;
        }
        Boolean importance = important;
        this.properties.add(new Object[]{name, value, importance});
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.properties.add(new Object[]{entry.getKey(), entry.getValue(), importance});
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        int i = 0;
        while (i < this.properties.size()) {
            Object[] objects = (Object[])this.properties.get(i);
            buffer.append(objects[0]);
            buffer.append(" : ");
            buffer.append(objects[1]);
            Boolean importance = (Boolean)objects[2];
            if (importance.booleanValue()) {
                buffer.append(" !important");
            }
            if (i == this.properties.size() - 1) {
                buffer.append(';');
            } else {
                buffer.append(";    ");
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

