/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.trix.cuery.filter.AcceptFilter;
import org.trix.cuery.filter.AttributeFilter;
import org.trix.cuery.filter.ChildFilter;
import org.trix.cuery.filter.ClassFilter;
import org.trix.cuery.filter.DescendantFilter;
import org.trix.cuery.filter.DirectAdjacentFilter;
import org.trix.cuery.filter.ElementFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.HyphenTokensFilter;
import org.trix.cuery.filter.IDFilter;
import org.trix.cuery.filter.MultipleFilter;
import org.trix.cuery.filter.PseudoClassFilter;
import org.trix.cuery.filter.TokensFilter;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.EMLength;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public final class CSSUtil {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final int ENCODING_BUFFER_SIZE = 100;
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^@charset\\s[\"']([^\\s]+)[\"']");

    private CSSUtil() {
    }

    public static InputSource getSource(String uri) throws IOException {
        if (uri == null || uri.length() == 0) {
            throw new IOException("This input uri is null.");
        }
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        try {
            URL url = new URL(uri);
            return CSSUtil.getSource(url.openStream(), uri);
        }
        catch (MalformedURLException e) {
            return CSSUtil.getSource(new FileInputStream(uri), uri);
        }
        catch (IOException e) {
            throw new IOException("This input uri can't open stream. '" + uri + "'");
        }
    }

    public static InputSource getSource(File file) throws IOException {
        if (file == null) {
            throw new IOException("This input is null file.");
        }
        String uri = file.getPath();
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        return CSSUtil.getSource(new FileInputStream(file), uri);
    }

    public static InputSource getSource(InputStream input) throws IOException {
        return CSSUtil.getSource(input, null);
    }

    public static InputSource getSource(InputStream input, String uri) throws IOException {
        InputStreamReader reader;
        if (input == null) {
            throw new IOException("This input is null input stream.");
        }
        PushbackInputStream pushback = null;
        pushback = input instanceof PushbackInputStream ? (PushbackInputStream)input : new PushbackInputStream(input, 100);
        byte[] buffer = new byte[100];
        int length = pushback.read(buffer, 0, buffer.length);
        pushback.unread(buffer, 0, length);
        InputSource source = new InputSource();
        Matcher matcher = ENCODING_PATTERN.matcher(new String(buffer, 0, length, "ASCII"));
        if (matcher.lookingAt()) {
            reader = new InputStreamReader((InputStream)pushback, matcher.group(1));
            source.setEncoding(matcher.group(1));
        } else {
            reader = new InputStreamReader((InputStream)pushback, DEFAULT_ENCODING);
            source.setEncoding(DEFAULT_ENCODING);
        }
        source.setCharacterStream((Reader)new BufferedReader(reader));
        source.setURI(uri);
        return source;
    }

    public static Filter convert(Condition condition) {
        if (condition instanceof Filter) {
            return (Filter)condition;
        }
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition combo = (CombinatorCondition)condition;
                return new MultipleFilter(CSSUtil.convert(combo.getFirstCondition()), CSSUtil.convert(combo.getSecondCondition()));
            }
            case 4: {
                AttributeCondition attr = (AttributeCondition)condition;
                return new AttributeFilter(attr.getLocalName(), attr.getValue());
            }
            case 9: {
                AttributeCondition clazz = (AttributeCondition)condition;
                return new ClassFilter(clazz.getValue());
            }
            case 5: {
                AttributeCondition id = (AttributeCondition)condition;
                return new IDFilter(id.getValue());
            }
            case 8: {
                AttributeCondition hyphen = (AttributeCondition)condition;
                return new HyphenTokensFilter(hyphen.getLocalName(), hyphen.getValue());
            }
            case 7: {
                AttributeCondition one = (AttributeCondition)condition;
                return new TokensFilter(one.getLocalName(), one.getValue());
            }
            case 6: {
                LangCondition lang = (LangCondition)condition;
                return new HyphenTokensFilter("xml:lang", lang.getLang());
            }
            case 10: {
                AttributeCondition pseudo = (AttributeCondition)condition;
                return new PseudoClassFilter(pseudo.getValue());
            }
        }
        return AcceptFilter.SINGLETON;
    }

    public static Filter convert(Selector selector) {
        if (selector instanceof Filter) {
            return (Filter)selector;
        }
        switch (selector.getSelectorType()) {
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                return new MultipleFilter(CSSUtil.convert((Selector)conditional.getSimpleSelector()), CSSUtil.convert(conditional.getCondition()));
            }
            case 4: {
                ElementSelector element = (ElementSelector)selector;
                return new ElementFilter(null, element.getNamespaceURI(), element.getLocalName());
            }
            case 11: {
                DescendantSelector child = (DescendantSelector)selector;
                return new ChildFilter(child.getAncestorSelector(), child.getSimpleSelector());
            }
            case 10: {
                DescendantSelector descendant = (DescendantSelector)selector;
                return new DescendantFilter(descendant.getAncestorSelector(), descendant.getSimpleSelector());
            }
            case 12: {
                SiblingSelector sibling = (SiblingSelector)selector;
                return new DirectAdjacentFilter(sibling.getNodeType(), sibling.getSelector(), sibling.getSiblingSelector());
            }
        }
        return AcceptFilter.SINGLETON;
    }

    public static CSSValue convert(LexicalUnit unit) {
        if (unit == null) {
            return null;
        }
        if (unit instanceof CSSValue) {
            return (CSSValue)unit;
        }
        switch (unit.getLexicalUnitType()) {
            case 15: {
                return new EMLength(unit.getStringValue(), CSSUtil.convert(unit.getPreviousLexicalUnit()));
            }
        }
        return null;
    }

    public static String displayFloat(float value) {
        int intValue = (int)value;
        if (value == (float)intValue) {
            return Integer.toString(intValue, 10);
        }
        return Float.toString(value);
    }

    public static String getErrorMessage(CSSParseException exception) {
        StringBuffer buffer = new StringBuffer("CSS parsing error is occured in '");
        buffer.append(exception.getURI());
        buffer.append("' at line ");
        buffer.append(exception.getLineNumber());
        buffer.append(", column ");
        buffer.append(exception.getColumnNumber());
        buffer.append(".");
        buffer.append(SEPARATOR);
        buffer.append("Message : ");
        buffer.append(exception.getMessage());
        if (exception.getException() != null) {
            buffer.append(SEPARATOR);
            buffer.append("Caused by : ");
            buffer.append(exception.getException().getMessage());
        }
        return buffer.toString();
    }
}

