/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSS.java,v 1.01 2006/03/24 16:03:01 Teletha Exp $
 */
public final class CSS {

    /** The namespace uri for CSS Level2. */
    public static final String LEVEL2 = "http://www.w3.org/TR/REC-CSS2/";

    /** The namespace uri for CSS Level3. */
    public static final String LEVEL3 = "http://www.w3.org/TR/REC-CSS3/";

    /** This is the UA's default stylesheet. */
    public static final int ORIGIN_AGENT = 1;

    /** This is the user's stylesheet. */
    public static final int ORIGIN_USER = 2;

    /** This is the author's stylesheet. */
    public static final int ORIGIN_AUTHOR = 3;

    /** The state for dynamic pseudo-classes. */
    public static final int NORMAL = 0;

    /** The state for dynamic pseudo-classes. */
    public static final int ACTIVE = 1 << 1;

    /** The state for dynamic pseudo-classes. */
    public static final int FOCUS = 1 << 2;

    /** The state for dynamic pseudo-classes. */
    public static final int HOVER = 1 << 3;

    /** The state for dynamic pseudo-classes. */
    public static final int LINK = 1 << 4;

    /** The state for dynamic pseudo-classes. */
    public static final int VISITED = 1 << 5;

    /** The state for target pseudo-class. */
    public static final int TARGET = 1 << 6;

    /** The state for UI element states pseudo-classes. */
    public static final int DEFAULT = 1 << 7;

    /** The state for UI element states pseudo-classes. */
    public static final int CHECKED = 1 << 8;

    /** The state for UI element states pseudo-classes. */
    public static final int DISABLED = 1 << 9;

    /** The state for UI element states pseudo-classes. */
    public static final int ENABLED = 1 << 10;

    /** The state for form element pseudo-classes. */
    public static final int IN_RANGE = 1 << 11;

    /** The state for form element pseudo-classes. */
    public static final int OUT_OF_RANGE = 1 << 12;

    /** The state for form element pseudo-classes. */
    public static final int REQUIRED = 1 << 13;

    /** The state for form element pseudo-classes. */
    public static final int OPTIONAL = 1 << 14;

    /** The state for form element pseudo-classes. */
    public static final int READ_ONLY = 1 << 15;

    /** The state for form element pseudo-classes. */
    public static final int READ_WRITE = 1 << 16;

    /** The state for form element pseudo-classes. */
    public static final int INVALID = 1 << 17;

    /** The state for form element pseudo-classes. */
    public static final int VALID = 1 << 18;
}
