/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.value.CSSValue;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: Property.java,v 1.05 2005/12/06 11:34:17 Teletha Exp $
 */
public interface Property {

    /** The state for normal. */
    int NORMAL = 0;

    /** The state for pseudo-elements. */
    int AFTER = 1 << 1;

    /** The state for pseudo-elements. */
    int ALTERNATE = 1 << 2;

    /** The state for pseudo-elements. */
    int BEFORE = 1 << 3;

    /** The state for pseudo-elements. */
    int FIRST_LETTER = 1 << 4;

    /** The state for pseudo-elements. */
    int FIRST_LINE = 1 << 5;

    /** The state for pseudo-elements. */
    int LINE_MAKER = 1 << 6;

    /** The state for pseudo-elements. */
    int MAKER = 1 << 7;

    /** The state for pseudo-elements. */
    int OUTSIDE = 1 << 8;

    /** The state for pseudo-elements. */
    int SELECTION = 1 << 9;

    /** The state for form element pseudo-elements. */
    int CHOICES = 1 << 10;

    /** The state for form element pseudo-elements. */
    int REPEAT_INDEX = 1 << 11;

    /** The state for form element pseudo-elements. */
    int REPEAT_ITEM = 1 << 12;

    /** The state for form element pseudo-elements. */
    int VALUE = 1 << 13;

    /**
     * Return a property value.
     * 
     * @param name A property name.
     * @return A property value.
     */
    CSSValue getValue(String name);

    /**
     * Retrieve the string value of the specified property.
     * 
     * @param name A property name.
     * @return A property value.
     */
    String getValueAsString(String name);

    /**
     * Retrieve the string value of the specified property. If the specified property cannot be
     * found, defaultValue is returned.
     * 
     * @param name A property name.
     * @param defaultValue A default value.
     * @return A string property value.
     */
    String getValueAsString(String name, String defaultValue);

    /**
     * Retrieve the int value of the specified property.
     * 
     * @param name A property name.
     * @return A integer property value.
     */
    int getValueAsInteger(String name);

    /**
     * Retrieve the int value of the specified property. If the specified property cannot be found,
     * defaultValue is returned.
     * 
     * @param name A property name.
     * @param defaultValue A default value.
     * @return A integer property value.
     */
    int getValueAsInteger(String name, int defaultValue);

    /**
     * Retrieve the float value of the specified property.
     * 
     * @param name A property name.
     * @return A float property value.
     */
    float getValueAsFloat(String name);

    /**
     * Retrieve the float value of the specified property. If the specified property cannot be
     * found, defaultValue is returned.
     * 
     * @param name A property name.
     * @param defaultValue A default value.
     * @return A float property value.
     */
    float getValueAsFloat(String name, float defaultValue);

    /**
     * Check whether this property is important or not.
     * 
     * @param name A property name.
     * @return A result.
     */
    boolean isImportant(String name);
}
