/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import junit.framework.TestCase;

import org.trix.cuery.CSS;
import org.trix.cuery.filter.AcceptFilter;
import org.trix.cuery.value.Identifier;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CascadablePropertyTest.java,v 1.0 2005/11/18 22:01:34 Teletha Exp $
 */
public class CascadablePropertyTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.CascadableProperty.getValue(String)'
     */
    public void testGetValue() {
        SimpleProperty block = new SimpleProperty();
        block.setProperty("display", new Identifier("block"), false);

        SimpleProperty inline = new SimpleProperty();
        inline.setProperty("display", new Identifier("inline"), false);

        CascadableProperty property = new CascadableProperty();
        property.addProperty(new PropertyDescription(AcceptFilter.SINGLETON, CSS.ORIGIN_AGENT, 1, inline));
        property.addProperty(new PropertyDescription(AcceptFilter.SINGLETON, CSS.ORIGIN_AGENT, 2, block));
        assertEquals("block", property.getValue("display").getCssText());

        property.clear();
        assertEquals("inline", property.getValue("display").getCssText());
    }
}
