/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import junit.framework.TestCase;

import org.trix.cuery.CSS;
import org.trix.cuery.filter.AcceptFilter;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: PropertyTestCase.java,v 1.0 2005/12/21 6:55:44 Teletha Exp $
 */
public abstract class PropertyTestCase extends TestCase {

    /**
     * Helper method to create PropertyDescription.
     * 
     * @param property A single property.
     * @return A created PropertyDescription.
     */
    protected PropertyDescription createDescription(Property property) {
        return new PropertyDescription(AcceptFilter.SINGLETON, CSS.ORIGIN_AGENT, 1, property);
    }
}
