/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import junit.framework.TestCase;

import org.trix.cuery.value.Identifier;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SimplePropertyTest.java,v 1.0 2005/11/18 21:57:05 Teletha Exp $
 */
public class SimplePropertyTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.SimpleProperty.isImportant(String)'
     */
    public void testIsImportant() {
        SimpleProperty property = new SimpleProperty();
        property.setProperty("display", new Identifier("inline"), false);
        property.setProperty("overflow", new Identifier("hidden"), true);
        
        assertEquals(false, property.isImportant("display"));
        assertEquals(true, property.isImportant("overflow"));
    }
}
