/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import junit.framework.TestCase;

import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.value.CSSColor;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.PointLength;
import org.trix.cuery.value.ValueUtil;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BorderBoxDefinitionTest.java,v 1.0 2005/09/01 2:33:21 Teletha Exp $
 */
public class BorderBoxDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderBoxDefinition.parse(CSSValue)'
     */
    public void testParse1() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new CSSColor(1, 1, 1, value);
        new PointLength(2, value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-top", value, false);

        assertEquals("#010101", property.getValueAsString("border-top-color"));
        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("2", property.getValueAsString("border-top-width"));

        assertEquals("solid rgb(1, 1, 1) 2pt", ValueUtil.toString(property.getValue("border-top")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderBoxDefinition.parse(CSSValue)' whether
     * the order of the css values is independent or not.
     */
    public void testParse2() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new PointLength(2, value);
        new CSSColor(1, 1, 1, value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-left", value, false);

        assertEquals("#010101", property.getValueAsString("border-left-color"));
        assertEquals("solid", property.getValueAsString("border-left-style"));
        assertEquals("2", property.getValueAsString("border-left-width"));

        assertEquals("solid 2pt rgb(1, 1, 1)", ValueUtil.toString(property.getValue("border-left")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderBoxDefinition.parse(CSSValue)' whether
     * 'inherit' identifier is acceptable or not.
     */
    public void testParse3() {
        // test inherit
        CSSValue value = new Identifier("inherit", null);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-right", value, false);

        assertEquals("inherit", property.getValueAsString("border-right-color"));
        assertEquals("inherit", property.getValueAsString("border-right-style"));
        assertEquals("inherit", property.getValueAsString("border-right-width"));

        assertEquals("inherit", ValueUtil.toString(property.getValue("border-right")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderBoxDefinition.parse(CSSValue)' with a
     * invalid value.
     */
    public void testParse4() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new CSSColor(1, 1, 1, value);
        new Identifier("double", value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-bottom", value, false);

        assertNull(property.getValueAsString("border-bottom-color"));
        assertNull(property.getValueAsString("border-bottom-style"));
        assertNull(property.getValueAsString("border-bottom-width"));
        assertNull(property.getValue("border-bottom"));
    }
}
