/*! @file
    File     : CoFox.cpp
    @brief   : q FoxɂCppUniteXgpXPg𐶐 Cuppa Family
    @author  : ahiru (http://www3.to/ahirus)
    @date $Date: 2002/08/27 08:38:41 $
    $Revision: 1.2 $
    @note :
*/

#include "fx.h"

#define OUTPUTOPTION
static char rcsid[]="$Id: CoFox.cpp,v 1.2 2002/08/27 08:38:41 smorino Exp $";

#pragma warning(disable:4786)       // STLgpwarning
#include <iostream>
#include <fstream>   // ofstream
#include <vector>
#include <string>
#include <map>

#include "cuppa/cocuppa.h"
#include "cuppa/tokenizer.h"

using namespace std;


/**
 * CEBhE
 */
class CoFox : public FXMainWindow
{
  FXDECLARE(CoFox)
protected:
  FXMenubar *        menubar;
  FXMenuPane *       filemenu;
  FXMenuPane *       helpmenu;
  FXStatusbar *      status;
  FXSwitcher *       switcher;
  FXButton *         runBtn;
  FXText *           results;
  FXText *           includes;
  FXText *           methods;
  FXList *           skList;

  FXSplitter *       splitter;

  /// CppUnit TestRunnerpCW[pp[^
  struct mparams {
  	mparams():force(0) {}
    FXString  main;
    FXint     force;
  };

  /// Tester XPgpp[^
  struct sparams {
  	sparams(){clear();}
    FXString  suite;
    FXString  nms;
    FXString  super;
    FXString  inc;
    FXString  method;
    FXint     abstract;
    FXint     force;
    FXint     regist;
    FXint     separate;
    FXint     prefix;

    /// eNA
    void clear() {
      suite.clear();nms.clear();super.clear();inc.clear();
      abstract=force=regist=separate=prefix=0;
    }
  };

  /// TestRunnerpp[^
  mparams           mprm_;
  /// ʏł̃XPgp[^
  sparams           sprm_;

  // GUIƃp[^f[^p
  FXDataTarget      mainDT;
  FXDataTarget      mforceDT;
  FXDataTarget      suiteDT;
  FXDataTarget      nmsDT;
  FXDataTarget      superDT;
  FXDataTarget      sforceDT;
  FXDataTarget      registDT;
  FXDataTarget      separateDT;
  FXDataTarget      abstractDT;
  FXDataTarget      prefixDT;

  typedef std::map<std::string,sparams> SparamSets;
  /**
   * ̃XPgp[^ݒ
   * <br>
   * XPĝɂĊ֘AtĂp[^
   */
  SparamSets        spSets_;

protected:
  CoFox()
    :menubar(NULL),status(NULL)
    ,filemenu(NULL),helpmenu(NULL)
    ,switcher(NULL),splitter(NULL)
    ,includes(NULL),methods(NULL)
    ,results(NULL)
    ,mainDT(mprm_.main)
    ,mforceDT(mprm_.force)
    ,suiteDT(sprm_.suite)
    ,nmsDT(sprm_.nms)
    ,superDT(sprm_.super)
    ,sforceDT(sprm_.force)
    ,registDT(sprm_.regist)
    ,separateDT(sprm_.separate)
    ,abstractDT(sprm_.abstract)
    ,prefixDT(sprm_.prefix)
    {}

public:
  long onCmdAbout(FXObject*,FXSelector,void*);
  long onCmdRun(FXObject*,FXSelector,void*);
  long onDndEnter(FXObject*,FXSelector,void*);
  long onDndLeave(FXObject*,FXSelector,void*);
  long onDndDrop(FXObject*,FXSelector,void*);
  long onDndMotion(FXObject*,FXSelector,void*);
  long onCmdRefInc(FXObject*,FXSelector,void*);
  long onCmdSkeAdd(FXObject*,FXSelector,void*);
  long onCmdSkeDel(FXObject*,FXSelector,void*);
  long onCmdSkeMod(FXObject*,FXSelector,void*);
  long onSelSkList(FXObject*,FXSelector,void*);

public:
  enum {
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_RUN,
    ID_INCLUDE,
    ID_METHOD,
    ID_RESULTS,
    ID_REF_INC,
    ID_ADD,
    ID_REMOVE,
    ID_MODIFY,
    ID_SK_LIST,
    ID_LAST
    };

public:
  CoFox(FXApp* a);
  virtual void create();
  virtual ~CoFox() {
    delete filemenu;
    delete helpmenu;
  }
protected:
  void set_opt_label_and_text(FXComposite * parent,FXDataTarget & dt,const char *op,const char * tip,const char * hlp);
  void init_opt_gui(FXComposite * parent);
  long runCuppa(mparams & pm,SparamSets & ss);
  bool suite_build(sparams & sp);
  bool exist(const string& path) ;
  void make_suite(cuppa::cocuppa& co, bool force);
  ofstream* open_file(const string & path,bool force_open=false);
  sparams * searchSS(const char * sname);
  void clear_param();
};



/*******************************************************************************/

// Map
FXDEFMAP(CoFox) CoFoxMap[]={
  FXMAPFUNC(SEL_COMMAND, CoFox::ID_ABOUT, CoFox::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND, CoFox::ID_RUN, CoFox::onCmdRun),
  FXMAPFUNC(SEL_DND_ENTER, CoFox::ID_INCLUDE, CoFox::onDndEnter),
  FXMAPFUNC(SEL_DND_LEAVE, CoFox::ID_INCLUDE, CoFox::onDndLeave),
  FXMAPFUNC(SEL_DND_DROP, CoFox::ID_INCLUDE, CoFox::onDndDrop),
  FXMAPFUNC(SEL_DND_MOTION, CoFox::ID_INCLUDE, CoFox::onDndMotion),
  FXMAPFUNC(SEL_COMMAND, CoFox::ID_REF_INC, CoFox::onCmdRefInc),
  FXMAPFUNC(SEL_COMMAND, CoFox::ID_ADD, CoFox::onCmdSkeAdd),
  FXMAPFUNC(SEL_COMMAND, CoFox::ID_REMOVE, CoFox::onCmdSkeDel),
  FXMAPFUNC(SEL_COMMAND, CoFox::ID_MODIFY, CoFox::onCmdSkeMod),
  FXMAPFUNC(SEL_SELECTED, CoFox::ID_SK_LIST, CoFox::onSelSkList),
  };

// Object implementation
FXIMPLEMENT(CoFox,FXMainWindow,CoFoxMap,ARRAYNUMBER(CoFoxMap))

/// Make some windows
CoFox::CoFox(FXApp* a)
  :FXMainWindow(a,"CoFox - (Cuppa family)",NULL,NULL,DECOR_ALL,100,100,400,500)
{
  int i;

  // Menu bar
  menubar=new FXMenubar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

  // Status bar
  status=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // File menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"Run\tCtl-R",NULL,this,ID_RUN);
  new FXMenuCommand(filemenu,"Quit\tCtl-X",NULL,getApp(),FXApp::ID_QUIT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);

  // Help menu
  helpmenu=new FXMenuPane(this);
  new FXMenuCommand(helpmenu,"version\tCtl-A",NULL,this,ID_ABOUT);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu);

  // s{^
  FXHorizontalFrame * erea=new FXHorizontalFrame(this,FRAME_THICK|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
  //FXMatrix *erea=new FXMatrix(this,2,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXLabel(erea,"Build ..");
  runBtn=new FXButton(erea,"Run",NULL,this,ID_RUN,FRAME_RAISED|FRAME_THICK);

  // Switcher
  switcher=new FXSwitcher(this,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_THICK);

  /// IvVwyC
  FXVerticalFrame * frm=new FXVerticalFrame(switcher,LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);

  /// ʕ\yC
  results=new FXText(switcher,this,ID_RESULTS,TEXT_READONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y|TEXT_SHOWACTIVE);
  results->setHiliteMatchTime(300000);
//  results->setBarColumns(3);

  // IvVGUIƂ̐ڑׂ̈̐ݒ
  mainDT.connect(mprm_.main);
  mforceDT.connect(mprm_.force);
  suiteDT.connect(sprm_.suite);
  nmsDT.connect(sprm_.nms);
  superDT.connect(sprm_.super);
  sforceDT.connect(sprm_.force);
  registDT.connect(sprm_.regist);
  separateDT.connect(sprm_.separate);
  abstractDT.connect(sprm_.abstract);
  prefixDT.connect(sprm_.prefix);

  /* {^̃\[X
   *  p͓K
   *  ꉞc[`bv͓{AXe[^Xo[͉p\L
   *  ŏIIɂ̓\[Xׂł傤Ȃ
   */
#if defined(__unix__) || defined(__linux__)
  const char * mm1="&main:\tThe name of Main module is registered.\tThe name of Main module is registered.";
  const char * mm2="forc&e:\tA former file is overwritten.\tA former file is overwritten.";
  const char * mm1_tip="The name of Main module is registered.";
  const char * mm1_hlp="The name of Main module is registered.";
  const char * ss1="&add\tRegistration of Skeleton and an option setup\tRegistration of Skeleton and an option setup";
  const char * ss2="&remove\tDeletion of a registered setup\tDeletion of a registered setup";
  const char * ss3="&mod\tChange of a registered setup\tChange of a registered setup";
#else
  const char * mm1="&main:\tMain modulê̖o^\tadd name of main module";
  const char * mm2="forc&e:\tt@C㏑\tmode of force overwrite";
  const char * mm1_tip="Main modulê̖o^";
  const char * mm1_hlp="add name of main module";
  const char * ss1="&add\tSkeletonуIvVݒ̓o^\tadd Skeleton and Options";
  const char * ss2="&remove\to^ςݐݒ̍폜\tremove Skeleton and Options set";
  const char * ss3="&mod\to^ςݐݒ̕ύX\tmodify Skeleton and Options set";
#endif

  FXVerticalFrame *pane;
  FXHorizontalFrame * main=new FXHorizontalFrame(frm,LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
  /// main
  new FXLabel(main,mm1);
  {
  FXTextField * pt;
  pt=new FXTextField(main,20,&mainDT,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW,0,0,0,0, 0,0,0,0);
  pt->setTipText(mm1_tip);
  pt->setHelpText(mm1_hlp);
  }
  new FXCheckButton(frm,mm2,&mforceDT,FXDataTarget::ID_VALUE,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP);
    // Horizontal divider line
    new FXHorizontalSeparator(frm,SEPARATOR_GROOVE|LAYOUT_FILL_X);

  FXSplitter * pspl;
  pspl=new FXSplitter(frm,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING|SPLITTER_VERTICAL);
  pane=new FXVerticalFrame(pspl,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  new FXLabel(pane,"Skeleton's parameters:");
  FXHorizontalFrame * ske=new FXHorizontalFrame(pane,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  /// add button
  new FXButton(ske,ss1,NULL,this,ID_ADD,FRAME_RAISED|FRAME_THICK);
  /// remove button
  new FXButton(ske,ss2,NULL,this,ID_REMOVE,FRAME_RAISED|FRAME_THICK);
  /// modify button
  new FXButton(ske,ss3,NULL,this,ID_MODIFY,FRAME_RAISED|FRAME_THICK);
  skList=new FXList(ske,1,this,ID_SK_LIST,FRAME_THICK|LAYOUT_FILL_Y|LAYOUT_FILL_X|LIST_BROWSESELECT);
  /*
  skList->appendItem("foo\ttest 1");
  skList->appendItem("bar\ttest 2---");
  */

  FXVerticalFrame *opt_pane;
  opt_pane=new FXVerticalFrame(pspl,FRAME_RAISED|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);

  init_opt_gui(opt_pane);

  // Make a tool tip
  new FXTooltip(getApp());

  dropEnable();
}

/**
 * IvV͗peLXgtB[h̐ݒ
 * <br>
 * ToolTipsуXe[^Xo[\p̐ݒ
 */
void CoFox::set_opt_label_and_text(FXComposite * parent,FXDataTarget & dt,const char *op,const char * tip,const char * hlp)
{
  new FXLabel(parent,op);
  FXTextField * pt;
  pt=new FXTextField(parent,20,&dt,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK);
  pt->setTipText(tip);
  pt->setHelpText(hlp);
}

/**
 * XPgpIvVGUIʐݒ
 */
void CoFox::init_opt_gui(FXComposite * parent)
{
#if defined(__unix__) || defined(__linux__)
  const char * op1="&skeleton:\tSkeleton set name of skeleton\tset name of skeleton";
  const char * op1_tip="set name of skeleton\nThis name is registered into a list.";
  const char * op1_hlp="set name of skeleton";

  const char * op2="&namespace:\tset name of namespace\tset name of namespace";
  const char * op2_tip="set name of namespace";
  const char * op2_hlp="set name of namespace";

  const char * op3="&Super:\tset class of super\tset class of super";
  const char * op3_tip="set class of super";
  const char * op3_hlp="set class of super";

  const char * ck1="for&ce:\tskeleton is overwritten\tskeleton is overwritten";
  const char * ck2="&No regist:\tThe generated test class is not registered into a registry.\tThe generated test class is not registered into a registry.";
  const char * ck3="se&parate:\tA definition and implementation file of tskeleton are separated.\tA definition and implementation file of tskeleton are separated.";
  const char * ck4="a&bstract:\tThe test case of a pure virtual method is implemented.\tThe test case of a pure virtual method is implemented.";
  const char * ck5="prefi&x:\t'test' is attached to the head of a method name.\t'test' is attached to the head of a method name.";
  const char * ii="&includes\tSpecification of a file that it include(s) to skeleton\tSpecification of a file that it include(s) to skeleton";
  const char * mm="metho&ds\tSpecification of a method name that a test case is mounted\tSpecification of a method name that a test case is mounted";
#else
  const char * op1="&skeleton:\tSkeleton ̐ݒ\tset name of skeleton";
  const char * op1_tip="Skeleton ̐ݒ\n̖̂Xgɓo^܂";
  const char * op1_hlp="set name of skeleton";

  const char * op2="&namespace:\tNamespace̐ݒ\tset name of namespace";
  const char * op2_tip="Namespace ̐ݒ";
  const char * op2_hlp="set name of namespace";

  const char * op3="&Super:\tSuperNX̐ݒ\tset class of super";
  const char * op3_tip="Super NX̐ݒ";
  const char * op3_hlp="set class of super";

  const char * ck1="for&ce:\tskeleton̏㏑\toverwrite of skeleton";
  const char * ck2="&No regist:\tCppUnit̓o^Ȃ\tno regist of CppUnit";
  const char * ck3="se&parate:\tskeleton̒`ƃCvgt@C𕪗\tseparate to file of header and source";
  const char * ck4="a&bstract:\tz\bh̃eXgP[XCvg\timplement of abstruct method";
  const char * ck5="prefi&x:\t\bh̓'test'\t'test' is added before a method name";
  const char * ii="&includes\tskeletonincludet@C̎w\tset file of include in skeleton";
  const char * mm="metho&ds\teXgP[X郁\bh̎w\tset name of method for test case";
#endif

  FXMatrix *matrix=new FXMatrix(parent,2,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  /// skeleton
  set_opt_label_and_text(matrix,suiteDT,op1,op1_tip,op1_hlp);
  /// namespace
  set_opt_label_and_text(matrix,nmsDT,op2,op2_tip,op2_hlp);
  /// super
  set_opt_label_and_text(matrix,superDT,op3,op3_tip,op3_hlp);

  FXMatrix *chkbase=new FXMatrix(parent,5,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X);
  // options
  new FXCheckButton(chkbase,ck1,&sforceDT,FXDataTarget::ID_VALUE,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP);
  new FXCheckButton(chkbase,ck2,&registDT,FXDataTarget::ID_VALUE,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP);
  new FXCheckButton(chkbase,ck3,&separateDT,FXDataTarget::ID_VALUE,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP);
  new FXCheckButton(chkbase,ck4,&abstractDT,FXDataTarget::ID_VALUE,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP);
  new FXCheckButton(chkbase,ck5,&prefixDT,FXDataTarget::ID_VALUE,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP);

  // Splitter
  splitter=new FXSplitter(parent,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING|SPLITTER_VERTICAL);
  FXComposite * spane=splitter;
  {
  FXVerticalFrame *textbox;
  textbox=new FXVerticalFrame(spane,FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  new FXButton(textbox,ii,NULL,this,ID_REF_INC,FRAME_RAISED|FRAME_THICK);
  includes=new FXText(textbox,this,ID_INCLUDE,TEXT_NO_TABS|LAYOUT_FILL_Y|LAYOUT_FILL_X|TEXT_SHOWACTIVE);
  includes->setHiliteMatchTime(300000);
  includes->setBarColumns(3);
  includes->dropEnable();
  }
  {
  FXVerticalFrame *textbox;
  textbox=new FXVerticalFrame(spane,FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  new FXLabel(textbox,mm);
  methods=new FXText(textbox,this,ID_METHOD,TEXT_NO_TABS|LAYOUT_FILL_X|LAYOUT_FILL_Y|TEXT_SHOWACTIVE);
  methods->setHiliteMatchTime(300000);
  methods->setBarColumns(3);
  }
}

/**
 * CEBhE
 */
void CoFox::create()
{
  FXMainWindow::create();
  if(!textType){textType=getApp()->registerDragType(textTypeName);}
  show(PLACEMENT_SCREEN);
}

/// o[W\
long CoFox::onCmdAbout(FXObject*,FXSelector,void*)
{
  FXMessageBox::information(this,MBOX_OK,"About CoFox",
    "  CoFox 1.4 ($Revision: 1.2 $)\n"
    "http://sourceforge.jp/projects/cuppa/\n\n"
    "CoCuppa is a really, really cool tools!"
    );
  return 1;
}

/// XPgo͎s
long CoFox::onCmdRun(FXObject* ,FXSelector,void*)
{
  FXLabel * plbl=runBtn;
  /*
  FXString str=plbl->getText();
  results->appendText(str.text(),str.length());
  */
  if (switcher->getCurrent()==0) {
    /// IvVݒAs
      sprm_.inc=includes->getText();
      sprm_.method=methods->getText();
      plbl->setText("&Return");
      switcher->setCurrent(1);
      runCuppa(mprm_,spSets_);
      return 1;
  } else {
    /// sʕ\AIvVݒ֖߂
      switcher->setCurrent(0);
      results->setText("",0);
      plbl->setText("&Run");
  }
  return 1;
}

/**
 * s𕶎xNg̈vfƂĊi[
 */
void line2vec(vector<string> & sv,const char * org,const int len)
{
  string org_(org,len);
  string tok;
  cuppa::tokenizer<> tokenizer(org_);
  while( tokenizer.next_token(" \t\n", tok) ) {
    if (tok.length()>0) sv.push_back(tok);
  }
}

/**
 * XPgIvVɑ΂鏈s
 */
long CoFox::runCuppa(mparams & pm,SparamSets & ss)
{

  /// Ssuitep[^̏
  SparamSets::iterator it;
  for(it=ss.begin();it!=ss.end();it++) {
    suite_build( (*it).second );
  }

#ifdef OUTPUTOPTION
  {
  FXString tmp;
  tmp="=== main option ===\n";
  results->appendText(tmp.text(),tmp.length());
  tmp.format("main=[%s]\n",pm.main.text());
  results->appendText(tmp.text(),tmp.length());
  }
#endif
  if (pm.main.length()>0) {
    string path=pm.main.text();
    path+=IMPL_SUFFIX;
    ofstream* strm = open_file(path, pm.force);
    if ( strm ) {
      cuppa::cocuppa::make_main(*strm);
      delete strm;
    }
  }

  /*
  if (splitter) {
    FXFileStream stream;
    stream.open("datafile.dat",FXStreamSave);
    stream.saveObject(splitter);
    stream.close();
  }
  */
  return 1;
}

/**
 * ̃XPgIvVɑ΂鏈s
 * @param sp XPgIvVf[^
 */
bool CoFox::suite_build(sparams & sp)
{
  FXString tmp;

  vector<string> incs;
  vector<string> methods;
  line2vec(incs,sp.inc.text(),sp.inc.length());
  line2vec(methods,sp.method.text(),sp.method.length());

  tmp="=== option list ===\n";
  results->appendText(tmp.text(),tmp.length());
#ifdef OUTPUTOPTION
  {
  tmp.format("suite=[%s]\n",sp.suite);
  results->appendText(tmp.text(),tmp.length());
  tmp.format("namespace=[%s]\n",sp.nms);
  results->appendText(tmp.text(),tmp.length());
  tmp.format("super=[%s]\n",sp.super);
  results->appendText(tmp.text(),tmp.length());
  tmp.format("force=[%d]\n",sp.force);
  results->appendText(tmp.text(),tmp.length());
  tmp.format("regist=[%d]\n",sp.regist);
  results->appendText(tmp.text(),tmp.length());
  tmp.format("separate=[%d]\n",sp.separate);
  results->appendText(tmp.text(),tmp.length());
  tmp.format("abstract=[%d]\n",sp.abstract);
  results->appendText(tmp.text(),tmp.length());
  vector<string>::iterator it;
  tmp="include list --------->\n";
  results->appendText(tmp.text(),tmp.length());
  for(it=incs.begin();it!=incs.end();it++) {
    if ((*it).length()==0) continue;
    results->appendText((*it).c_str(),(*it).length());
    results->appendText("\n",1);
  }
  tmp="method list --------->\n";
  results->appendText(tmp.text(),tmp.length());
  for(it=methods.begin();it!=methods.end();it++) {
    if ((*it).length()==0) continue;
    results->appendText((*it).c_str(),(*it).length());
    results->appendText("\n",1);
  }
  }
#endif
  tmp="=== end of option list ===\n";
  results->appendText(tmp.text(),tmp.length());

  cuppa::cocuppa co;
  if (sp.abstract) {
    co.set_standalone(false);
    co.set_noregist(true);
  }
  if (sp.regist) co.set_noregist(true);
  if (sp.prefix) co.set_prefix(true);
  if (sp.separate) co.set_standalone(false);
  if (!sp.super.empty()) co.set_super(sp.super.text());
  if (!sp.nms.empty()) co.set_namespace(sp.nms.text());
  if (!sp.suite.empty()) co.set_suite(sp.suite.text());
  bool force=(sp.force)?true:false;

  vector<string>::iterator it;
  // includeo^
  for(it=incs.begin();it!=incs.end();it++) {
    if ((*it).length()>0) co.add_include((*it).c_str());
  }

  // suite
//  string outofline(sp.ool.text());
  if ( !co.get_suite().empty() ) {
    for(it=methods.begin();it!=methods.end();it++) {
      int len;
      if ( (len=(*it).length())==0 ) continue;
      if ( *((*it).rbegin()) == '.') {
      	(*it).erase( (*it).begin()+len-1 );
        co.add_case((*it), true);
      } else {
        co.add_case((*it), false);
      }
    }
    make_suite(co, force);
  }

  return true;
}

/*
 * ̃t@Cɑ΂ true Ԃ
 */
bool CoFox::exist(const string& path) {
  ifstream stream(path.c_str());
  return stream.is_open();
}

/*
 * /eLXg [hŃt@CJ
 */
ofstream* CoFox::open_file(const string& path, bool force_open)
{
  results->appendText(path.c_str(),path.length());
  string tmp;
  tmp=" ...";
  results->appendText(tmp.c_str(),tmp.length());
  ofstream* strm = 0;
  if ( !force_open && exist(path) ) {
    tmp="already exists. (skip)\n";
    results->appendText(tmp.c_str(),tmp.length());
  } else {
    strm = new ofstream(path.c_str());
    if ( strm->is_open() ) {
      tmp="create.\n";
      results->appendText(tmp.c_str(),tmp.length());
    } else {
      tmp="creation fail.\n";
      results->appendText(tmp.c_str(),tmp.length());
      delete strm;
      strm = 0;
    }
  }
  return strm;
}


/*
 * suite 
 */
void CoFox::make_suite(cuppa::cocuppa& co, bool force)
{
  ofstream* strm;
  if ( co.get_standalone() ) {
    strm = open_file(co.get_suite() + IMPL_SUFFIX, force);
    if ( strm ) {
      co.make_suite_decl(*strm);
      co.make_suite_impl(*strm);
      delete strm;
    }
  } else {
    strm = open_file(co.get_suite() + DECL_SUFFIX, force);
    if ( strm ) {
      co.make_suite_decl(*strm);
      delete strm;
      strm = open_file(co.get_suite() + IMPL_SUFFIX, force);
      if ( strm ) {
        co.make_suite_impl(*strm);
        delete strm;
      }
    }
  }
}


long CoFox::onDndEnter(FXObject*,FXSelector,void*)
{
  return 1;
}

long CoFox::onDndLeave(FXObject*,FXSelector,void*)
{
  return 1;
}

long CoFox::onDndDrop(FXObject*,FXSelector,void*)
{
  /*
  FXString txt = getApp()->getDragTypeName(textType);
  methods->appendText(txt.text(),txt.length());
  acceptDrop();
  */
  FXchar *data; FXuint len;
  if(getDNDData(FROM_DRAGNDROP,urilistType,(FXuchar*&)data,len)){
    FXString urilist(data,len);
    FXString file=FXURL::fileFromURL(urilist.before('\r'));
    FXFREE(&data);
    if(file.empty()) return 1;
    /*
    if(!saveChanges()) return 1;
    loadFile(file);
    readBookmarks(file);
    readView(file);
    */
      includes->appendText(file.text(),file.length());
      includes->appendText("\n",1);
    return 1;
  }
  return 0;
}

long CoFox::onDndMotion(FXObject*,FXSelector,void*)
{
  if(offeredDNDType(FROM_DRAGNDROP,textType)){
    acceptDrop(DRAG_COPY);
    return 1;
    }
  return 0;
}

/**
 * Includet@CQƓ
 */
static const FXchar includefile[]="C++ Header Files (*.hpp,*.hxx,*.h,*.h)\nAny Extension (*.*)\nThree Letter (*.???)\nAll Files (*)\n";
long CoFox::onCmdRefInc(FXObject*,FXSelector,void*)
{
  FXString* files=FXFileDialog::getOpenFilenames(this,"Select include files","./",includefile);
  if(files){
    for(int i=0; !files[i].empty(); i++){
      includes->appendText(files[i].text(),files[i].length());
      includes->appendText("\n",1);
    }
    delete [] files;
  }

  return 1;
}

/**
 * w肳ꂽX[ĉp[^Zbg擾
 *
 * @param sname suite
 */
CoFox::sparams * CoFox::searchSS(const char * sname)
{
  SparamSets::iterator it=spSets_.find(sname);
  return (spSets_.end()==it)?NULL:&((*it).second);
}

/**
 * X[cpp[^NA
 */
void CoFox::clear_param()
{
  sprm_.clear();
  includes->setText("",0);
  methods->setText("",0);
  skList->killSelection();
}

/**
 * ADD{^̏
 * <br>
 * ͂ꂽp[^ݒspSets_֊i[
 */
long CoFox::onCmdSkeAdd(FXObject*,FXSelector,void*)
{
#if defined(__unix__) || defined(__linux__)
	const char * errmsg1="It is already a registered name.";
	const char * errmsg2="An empty suit cannot be registered.";
#else
  const char * errmsg1="ɓo^ς݂̖̂ł";
  const char * errmsg2="̃X[co^ł܂";
#endif
  if (sprm_.suite.empty()) {
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg2);
    return 1;
  }
  sparams * psp=searchSS(sprm_.suite.text());
  if (psp) {
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg1);
    return 1;
  }
  sprm_.inc=includes->getText();
  sprm_.method=methods->getText();
  spSets_.insert(SparamSets::value_type(sprm_.suite.text(),sprm_));
  skList->appendItem(sprm_.suite.text());
  clear_param();
  return 1;
}

/**
 * Remove{^̏
 * <br>
 * IꂽXgڂɊ֘Atꂽp[^ݒ폜
 *
 */
long CoFox::onCmdSkeDel(FXObject*,FXSelector,void*)
{
#if defined(__unix__) || defined(__linux__)
  const char * errmsg1="It can process, after choosing a list.";
  const char * errmsg2="Is it all right although the parameter setting item of %s is deleted?";

#else
  const char * errmsg1="XgIĂ珈\ł";
  const char * errmsg2="%s ̃p[^ݒ荀ڂ폜܂A낵łH";
#endif
  FXint idx=skList->getCurrentItem();
  if (idx<0) {
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg1);
  	return 1;
  }
  FXString nm = skList->getItemText(idx);
  sparams * psp=searchSS(nm.text());
  FXint q=FXMessageBox::question(this,MBOX_YES_NO,"CoFox",errmsg2,nm.text());
  if (q!=MBOX_CLICKED_YES) return 1;
  if (psp) {
    spSets_.erase(nm.text());
    skList->removeItem(idx);
  }
  clear_param();
  return 1;
}

/**
 * MOD{^̏
 * <br>
 * ͂ꂽp[^ݒspSets_֊i[
 *
 */
long CoFox::onCmdSkeMod(FXObject*,FXSelector,void*)
{
#if defined(__unix__) || defined(__linux__)
  const char * errmsg1="It can process, after choosing a list.";
	const char * errmsg2="An empty suit cannot be registered.";
	const char * errmsg3="It cannot process normally because of data mismatching. (%d:%s)";
#else
  const char * errmsg1="XgIĂ珈\ł";
  const char * errmsg2="̃X[co^ł܂";
  const char * errmsg3="f[^sׁ̈Aɏł܂ (%d:%s)";
#endif
  FXint idx=skList->getCurrentItem();
//  FXMessageBox::information(this,MBOX_OK,"About CoFox","idx=%d",idx);
  if (idx<0) {
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg1);
  	return 1;
  }
  if (sprm_.suite.empty()) {
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg2);
    return 1;
  }
  FXString nm = skList->getItemText((FXint)idx);
  sparams * psp=searchSS(nm.text());
  if (psp==NULL) {
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg3,idx,nm.text());
    return 1;
  }
  *psp=sprm_;
  psp->inc=includes->getText();
  psp->method=methods->getText();
  clear_param();
  return 1;
}

/**
 * XPgIvVXgIꂽƂ
 */
long CoFox::onSelSkList(FXObject*,FXSelector,void* idx)
{
  FXString nm = skList->getItemText((FXint)idx);
  sparams * psp=searchSS(nm.text());
  if (psp==NULL) {
#if defined(__unix__) || defined(__linux__)
  	const char * errmsg="It cannot process normally because of data mismatching. (%d:%s)";
#else
    const char * errmsg="f[^sׁ̈Aɏł܂ (%d:%s)";
#endif
    FXMessageBox::error(this,MBOX_OK,"CoFox",errmsg,idx,nm.text());
    return 1;
  }
  sprm_=*psp;
  includes->setText(sprm_.inc);
  methods->setText(sprm_.method);
  return 1;
}

int main(int argc,char **argv)
{
  FXApp  application("CoFox","CuppaProject");
  application.init(argc,argv);
  CoFox * mainwindow=new CoFox(&application);
  application.create();
  mainwindow->show();
  return application.run();
}

