/*
 * Curie by Doxygen 0.5.3
 Consolidation of Unit tests by 
 Reorganization of XML documents 
 Incredibly-Extracted by Doxygen.
*/


#include "curie.h"

#include <iostream>  // cerr/cout/endl
#include <xercesc/util/PlatformUtils.hpp>


/*
 * Ƃ}N
 */

// VXeɂgetopt̎킹Ȃ
#define NO_GETOPT


/*
 * getopt
 */
#ifdef NO_GETOPT
#ifndef __STDC__
#  define __STDC__ 1
#  include "getopt.h" // getopt_long
#  undef __STDC__
#else
#  include "getopt.h" // getopt_long
#endif
#else
#include <getopt.h>
#endif

/*
 * O
 */
using namespace std;

/*
 * ւ
 */
void usage() {
  cerr << "curie [options] <XML files>\n"
    "--help, -h                     : display this message\n"
    "--version, -v                  : print version\n"
    "--main, -m <Name>              : create Name.cpp that implements main()\n"
    "--makeargs, -M                 : output arguments for Make\n"
    "--force, -f                    : force to generate source files.\n"
    "--relative, -r                 : output relative include path.\n";
}

/*
 * ΁[
 */
void version() {
  cout << "Curie 0.5.1" << endl;
}


using namespace curie;
	
int main(int argc, char *argv[]) {
  Curie cu;
  bool   outputMakeArgs = false;

  // Options
  
  XMLPlatformUtils::Initialize();
  
  // R}hC
  while ( true ) {
    int option_index = 0;
    static struct option long_options[] = {
      { "help",      0, 0, 'h'},
      { "version",   0, 0, 'v'},
      { "makeargs",  0, 0, 'M'},
      { "main",      1, 0, 'm'},
      { "force", 0, 0, 'f'},
      { "strip-path", 1, 0, 's'},
      { "relative", 0, 0, 'r'},
      { 0, 0, 0, 0 }
    };
    
    int c = getopt_long(argc, argv, "rchvs:Mm:f", long_options, &option_index);
    if ( c == -1 ) break;
    
    switch ( c ) {
    case 'h' : usage();   return 0;
    case 'v' : version(); return 0;
    case 'M' : outputMakeArgs = true; break;
    case 'm' : cu.setMainName(optarg); break;
    case 'f' : cu.setForceEnabled(true); break;
    case 'r' : cu.setRelative(true); break;
    case 's' : cu.setStripPath(optarg); break;
    default :
      cerr << "Unknown option" << endl;
      usage(); 
      return 1;
    }
  }
  
  if (optind == argc) {
    std::cerr << "No file specified." << std::endl;
    exit (1);
  }

  // t@C
  while (optind < argc) {
    cu.addFile(argv[optind]);
    ++optind;
  }

  if (cu.createTestDefs()){
    std::cerr << "Operation Failed." << std::endl;
    exit (1);
  }
  
  // o͐
  cu.outputMain(std::cout);
  cu.outputSkeletons(std::cout);
  if (outputMakeArgs)
    cu.outputMakeArgs(std::cout);
  
  XMLPlatformUtils::Terminate();
  
  return 0;
}
