#include "curie.h"
#include <map>       // map
#include <stdio.h>

namespace {
  using namespace std;
  using namespace curie;

  typedef map<string, string> MangleMap;


  struct LessTestMethod {
    bool operator()(const TestMethod &m1, const TestMethod& m2) const {
      if (m1.name_ < m2.name_)
	return true;
      else if (m1.name_ == m2.name_)
	if ((m1.pureVirtual_ == false) && (m2.pureVirtual_ == true))
	  return true;
      return false;
    }
  };


  // 񑀍p֐Q
  // remove Spaces
  string removeSpaces(const string &str) {
    string ret;
    for (string::size_type i = 0; i != str.length(); ++i)
      if (str.at(i) != ' ')
	ret += str.at(i);
    return ret;
  }

  string replaceSpacesToUnderscores(const string &str){
    string ret;
    for (string::size_type i = 0; i != str.length(); ++i)
      if (str.at(i) == ' ')
	ret += "_";
      else
	ret += str.at(i);
    return ret;
  }


  // remove Spaces
  string removeMultipleSpaces(const string &str) {
    string ret = str;
    while (true) {
      string::size_type pos = ret.find("  ");
      if (pos == string::npos)
	break;
      ret = ret.substr(0, pos + 1) + ret.substr(pos + 2, ret.length());
    }
    return ret;
  }


  // namespace ::  _ns_ ɕϊ
  string mangleNamespace(const string &str) {
    string ret = str;
    while (true) {
      string::size_type pos = ret.find("::");
      if (pos == string::npos)
	break;
      ret = string(ret, 0, pos) + "_ns_" + string(ret, pos + 2, ret.length());
    }
    return ret;
  }


  void constructMangleMap(MangleMap &mmap) {
    struct MangleTable { const char *token; const char *mangled; };
    static MangleTable table[] =   {
      {"operator+", "operator__pl"},
      {"operator-", "operator__mi"},
      {"operator*", "operator__ml"},
      {"operator/", "operator__dv"},
      {"operator%", "operator__md"},
      {"operator^", "operator__er"},
      {"operator&", "operator__ad"},
      {"operator|", "operator__or"},
      {"operator~", "operator__td"},
      {"operator!", "operator__nt"},
      {"operator=", "operator__as"},
      {"operator<", "operator__lt"},
      {"operator>", "operator__gt"},
      {"operator+=", "operator__apl"},
      {"operator-=", "operator__ami"},
      {"operator*=", "operator__amu"},
      {"operator/=", "operator__adv"},
      {"operator%=", "operator__amd"},
      {"operator^=", "operator__aer"},
      {"operator&=", "operator__aad"},
      {"operator|=", "operator__aor"},

      {"operator>>", "operator__rs"},
      {"operator<<", "operator__ls"},
      {"operator>>=", "operator__ars"},
      {"operator<<=", "operator__als"},

      {"operator==", "operator__eq"},
      {"operator!=", "operator__ne"},
      {"operator<=", "operator__le"},
      {"operator>=", "operator__ge"},

      {"operator&&", "operator__aa"},
      {"operator||", "operator__oo"},
      {"operator++", "operator__pp"},
      {"operator--", "operator__mm"},

      {"operator->*", "operator__rm"},
      {"operator,", "operator__cm"},
      {"operator->", "operator__rf"},
      {"operator[]", "operator__vc"},
      {"operator()", "operator__cl"},

      {"operatornew", "operator__nw"},
      {"operatornew[]", "operator__nwvc"},

      {"operatordelete", "operator__dl"},
      {"operatordelete[]", "operator__dlvc"},
      { NULL, NULL}};

    for (const MangleTable *index = table; index->token != NULL; ++index)
      mmap.insert(MangleMap::value_type(index->token, index->mangled));

  }

  //
  // pXϊ
  //

  // CN[hpX̓̕strip
  string stripPath(const string &prefix, const string &path){
    return path.find(prefix) == 0 ?
      path.substr(prefix.length(), path.length()) :
      path;
  }

  string createIncludeName(const string &prefix, const string includeName) {
    // @\F΃pXΉ
    return stripPath(prefix, includeName);
  }


  // eXgo͐֐Q
  void createTestMethodNames(const ClassDef& def, TestDef &testdef) {

    typedef map<TestMethod, int, LessTestMethod> Occurence;

    MangleMap mmap;
    constructMangleMap(mmap);

    TestMethods methods;
    for (Methods::const_iterator it = def.methods_.begin();
	 it != def.methods_.end(); ++it){
      string testMethodName = removeSpaces(it->name_);//Ƃ肠eXg

      if (testMethodName.find("operator") == 0) {
	MangleMap::iterator mit = mmap.find(testMethodName);
	if (mit != mmap.end())//}OIy[^
	  testMethodName = mit->second;
	else{// operator ( class ) ();// ^ϊ̃Iy[^
	  testMethodName = removeMultipleSpaces(it->name_);
	  testMethodName = replaceSpacesToUnderscores(testMethodName);
	  methods.push_back(TestMethod(testMethodName));
	}
      }
      else  //  ʂ̃\bh
	testMethodName = it->name_;

      if (it->const_) //const\bhɂ́A_constĂB
	testMethodName += "_const";
      methods.push_back(TestMethod(testMethodName, it->isPureVirtual_));
    }

	 Occurence occ;
	 {
			for (TestMethods::const_iterator it = methods.begin();
				it != methods.end(); ++it)
				if (occ.find(*it) == occ.end())
					occ[*it] = 1;
				else
					++ occ[*it];
	 }

    for (Occurence::iterator ocit = occ.begin(); ocit != occ.end(); ++ocit){
      string testName("test_");
      if (ocit->second > 1) {
	char buf[16];
	sprintf(buf, "%i_", ocit->second);
	testName += buf;
      }
      testName += ocit->first.name_;
      testdef.testMethods_.push_back(TestMethod(testName, ocit->first.pureVirtual_));
    }
    testdef.hasPureVirtual_ = def.hasPureVirtual();
  }


}


namespace curie {

  void createTestNames(const ClassDefs &classes, const string &prefix, TestDefs &tests) {
    for (ClassDefs::const_iterator cit = classes.begin();
	 cit != classes.end(); ++cit) {
      TestDef test;
      test.testName_ = mangleNamespace(cit->name_) + "Test";
      createTestMethodNames(*cit, test);
      test.includeName_ = createIncludeName(prefix, cit->includeName_);
      tests.push_back(test);
    }
  }
}
