#include <fx.h>
#include <iostream>
#include <string>
#include <cppunit/TestRunner.h>
#include <cppunit/TestListener.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestFailure.h>
//#include <cppunit/TestPath.h>
#include <cppunit/SourceLine.h>
#include <cppunit/Exception.h>
#include <cppunit/extensions/TestFactoryRegistry.h>

class listenerFox : public FXMainWindow
                  , public CppUnit::TestListener
{
  FXDECLARE(listenerFox)
protected:
  struct prog_set {
    prog_set():prog(0),cnt(0),pbar(NULL) {}
    void init() {prog=cnt=0;}
    FXint             prog;
    FXDataTarget      progDT;
    FXProgressBar *   pbar;
    FXint             cnt;
    FXDataTarget      cntDT;
  };
  prog_set ok_;
  prog_set fail_;
  prog_set err_;

  FXMenubar *       menubar;
  FXMenuPane *      filemenu;
  FXMenuPane *      runmenu;
  FXMenuPane *      helpmenu;
  FXStatusbar *     status;
  FXText *          log;
  FXTabBook *       tabbook;
  FXTabItem *       tab1;
  FXTabItem *       tab2;
  FXIconList *      list_;

  int mode_;
  std::string ns_;
  int allcnt_;
  int curcnt_;
  bool isok_;
protected:
  listenerFox():mode_(0),allcnt_(0),curcnt_(0)
               ,filemenu(NULL),runmenu(NULL),helpmenu(NULL)
  {}

  void initprog(FXComposite * parent,prog_set & ps,const char * lbl,FXColor col);

public:
  long onCmdRun(FXObject*,FXSelector,void*);
  long onCmdTimer(FXObject*,FXSelector,void*);
  long onCmdAbout(FXObject*,FXSelector,void*);

public:
  enum {
    ID_TIMER=FXMainWindow::ID_LAST,
    ID_PANEL,
    ID_LOG,
    ID_HEADER,
    ID_RUN,
    ID_ABOUT,
    ID_LAST
    };
public:
  listenerFox(FXApp *a,std::string ns,int mode,bool arun);
  void create();
  virtual ~listenerFox() {
    delete filemenu;
    delete runmenu;
    delete helpmenu;
  }
  void run();
  void setStatusText(const FXString & msg);
  void initial();

  /// TestListener virtual method group
  void startTest(CppUnit::Test * test);
  void endTest(CppUnit::Test * test);
  void addFailure( const CppUnit::TestFailure &failure );
  void startTestRun( CppUnit::Test *test, 
                     CppUnit::TestResult *eventManager );
  void endTestRun( CppUnit::Test *test, 
                   CppUnit::TestResult *eventManager );
};

FXDEFMAP(listenerFox) listenerFoxMap[]={
  FXMAPFUNC(SEL_COMMAND,listenerFox::ID_RUN,listenerFox::onCmdRun),
  FXMAPFUNC(SEL_TIMEOUT,listenerFox::ID_TIMER,listenerFox::onCmdTimer),
  FXMAPFUNC(SEL_COMMAND, listenerFox::ID_ABOUT, listenerFox::onCmdAbout),
};
// Object implementation
FXIMPLEMENT(listenerFox,FXMainWindow,listenerFoxMap,ARRAYNUMBER(listenerFoxMap))

listenerFox::listenerFox(FXApp* a,std::string ns,int mode,bool arun)
  :FXMainWindow(a,"FoxFire ..",NULL,NULL,DECOR_ALL,100,100,450,400)
  ,allcnt_(0),curcnt_(0),mode_(mode)
  ,filemenu(NULL),runmenu(NULL),helpmenu(NULL)
{
  ns_=ns;

  menubar=new FXMenubar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  status=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // File menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"Quit\tCtl-X",NULL,getApp(),FXApp::ID_QUIT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  runmenu=new FXMenuPane(this);
  new FXMenuCommand(runmenu,"Run\tCtl-R",NULL,this,ID_RUN);
  new FXMenuTitle(menubar,"&Run",NULL,runmenu);

  // Help menu
  helpmenu=new FXMenuPane(this);
  new FXMenuCommand(helpmenu,"version\tCtl-A",NULL,this,ID_ABOUT);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu);

  FXComposite * parent;
  if (mode_==1) {
    parent=this;
  } else {
    //parent=new FXMatrix(this,6,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_CENTER_X);
	  parent=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  }
  initprog(parent,ok_,  "ok  : ",FXRGB(0,255,0));
  initprog(parent,fail_,"fail: ",FXRGB(255,255,0));
  initprog(parent,err_, "err : ",FXRGB(255,0,0));

  // Switcher
  tabbook=new FXTabBook(this,this,ID_PANEL,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT);

  {
  tab1=new FXTabItem(tabbook,"&LogView");
  //FXComposite * frm; frm=tabbook;
  FXVerticalFrame * frm=new FXVerticalFrame(tabbook,LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
  log=new FXText(frm,this,ID_LOG,TEXT_READONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y|TEXT_SHOWACTIVE);
  log->setHiliteMatchTime(300000);
  if (arun) getApp()->addTimeout(1000,this,ID_TIMER);
  }

  {
  tab2=new FXTabItem(tabbook,"failure/&error");
  FXVerticalFrame * frm=new FXVerticalFrame(tabbook,LAYOUT_FILL_Y|LAYOUT_FILL_X);
  list_=new FXIconList(frm,this,ID_HEADER,LAYOUT_FILL_X|LAYOUT_FILL_Y|ICONLIST_SINGLESELECT|ICONLIST_DETAILED);
  list_->getHeader()->setHeaderStyle(HEADER_HORIZONTAL|HEADER_TRACKING);
  list_->appendHeader("Stat",NULL,40);
  list_->appendHeader("File",NULL,100);
  list_->appendHeader("Line",NULL,30);
  list_->appendHeader("content",NULL,180);
  list_->appendHeader("Description",NULL,100);
  }
}

void listenerFox::initprog(FXComposite * parent,prog_set & ps,const char * lbl,FXColor col)
{
  ps.cnt=0;
  ps.cntDT.connect(ps.cnt);
  ps.prog=0;
  ps.progDT.connect(ps.prog);
  FXMatrix *hor;
  if (mode_==1) {
    hor=new FXMatrix(parent,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X);
  } else {
	  parent=new FXHorizontalFrame(parent,LAYOUT_FILL_X|FRAME_THICK);
    hor=new FXMatrix(parent,2);
  }
  new FXLabel(hor,lbl);
  FXTextField * pt;
  pt=new FXTextField(hor,5,&ps.cntDT,FXDataTarget::ID_VALUE,TEXTFIELD_READONLY|TEXTFIELD_INTEGER);
  pt->setJustify(JUSTIFY_RIGHT);
  if (mode_==1) {
    ps.pbar=new FXProgressBar(parent,&ps.progDT,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK);
  } else {
//    ps.pbar=new FXProgressBar(parent,&ps.progDT,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|PROGRESSBAR_DIAL);
//    ps.pbar=new FXProgressBar(parent,&ps.progDT,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|PROGRESSBAR_DIAL);
    ps.pbar=new FXProgressBar(parent,&ps.progDT,FXDataTarget::ID_VALUE,PROGRESSBAR_DIAL|LAYOUT_CENTER_X);
  }
  ps.pbar->setBarColor(col);
  //ps.pbar->showNumber();
}

/**
 * CEBhE
 */
void listenerFox::create()
{
  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
}

/// o[W\
long listenerFox::onCmdAbout(FXObject*,FXSelector,void*)
{
  FXMessageBox::information(this,MBOX_OK,"About FoxFire",
    "  FoxFire $Revision: 1.2 $\n"
    "http://sourceforge.jp/projects/cuppa/\n\n"
    "CoCuppa is a really, really cool tools!"
    );
  return 1;
}

long listenerFox::onCmdRun(FXObject*,FXSelector,void*)
{
  initial();
  getApp()->addTimeout(100,this,ID_TIMER);
  /*
  setStatusText("start (run) .........");
  run();
  */
  return 0;
}

long listenerFox::onCmdTimer(FXObject*,FXSelector,void*){
  setStatusText("start (run) .........");
  run();
  return 0;
}

void listenerFox::setStatusText(const FXString & msg)
{
  status->getStatusline()->setText(msg);
  log->appendText(msg.text(),msg.length());
  log->appendText("\n",1);
}

void listenerFox::initial()
{
  allcnt_=curcnt_=0;
  ok_.init();
  fail_.init();
  err_.init();
  list_->clearItems();
}

int main(int argc, char* argv[])
{
  std::string ns;
  int mode=0;
  bool arun=false;
  for ( int i = 1; i < argc; ++i ) {
    std::string arg(argv[i]);
    if ( arg == "-namespace" ) ns   = argv[++i];
    if ( arg == "-mode"      ) mode = atoi(argv[++i]);
    if ( arg == "-auto"      ) arun = atoi(argv[++i]);
  }
  FXApp application("FoxFire","CuppaProject");
  application.init(argc,argv);
  listenerFox * mainwindow=new listenerFox(&application,ns,mode,arun);
  application.create();
  mainwindow->show();
  return application.run();
}


void listenerFox::startTest(CppUnit::Test * )
{
  curcnt_++;
  isok_=true;
}
void listenerFox::endTest(CppUnit::Test * )
{
  if (isok_) {
    ok_.cnt++;
    ok_.prog+= ((double)ok_.cnt/allcnt_)*100;
    FXString msg; msg.format("  %d : success",curcnt_);
    setStatusText(msg);
    /*
    CppUnit::TestPath tp;
    if (test->findTestPath(test->getName(),tp)) {
    	setStatusText(tp.toString().c_str());
    }
    */

    /*
    OK̂Ƃ́AKvȂ
    msg.format("OK\t \t \t%s\t ",test->getName().c_str());
    list_->appendItem(msg.text());
    list_->forceRefresh();
    */

    ok_.pbar->forceRefresh();
    forceRefresh();
  }
}
void listenerFox::addFailure( const CppUnit::TestFailure &failure )
{
  isok_=false;
  CppUnit::SourceLine sl = failure.sourceLine();
  if (failure.isError()) {
    // error
    FXString msg; msg.format("%s (%d): (E) %d - %s [%s]"
        ,sl.fileName().c_str()
        ,sl.lineNumber()
        ,curcnt_
        ,failure.failedTestName().c_str()
        ,failure.thrownException()->what()
      );
    setStatusText(msg);
    err_.cnt++;
    err_.prog=((double)err_.cnt/allcnt_)*100;
    err_.pbar->forceRefresh();
  } else {
    // failure
    FXString msg; msg.format("%s (%d): (F) %d - %s [%s]"
        ,sl.fileName().c_str()
        ,sl.lineNumber()
        ,curcnt_
        ,failure.failedTestName().c_str()
        ,failure.thrownException()->what()
      );
    setStatusText(msg);
    fail_.cnt++;
    fail_.prog=((double)fail_.cnt/allcnt_)*100;
    fail_.pbar->forceRefresh();
  }

  FXString msg;
  msg.format("%s\t%s\t%d\t%s\t%s",
    (failure.isError())?"ERR":"FAIL",
    sl.fileName().c_str(),
    sl.lineNumber(),
    failure.failedTestName().c_str(),
    failure.thrownException()->what());
  list_->appendItem(msg.text());
  list_->forceRefresh();
  forceRefresh();
}
void listenerFox::startTestRun( CppUnit::Test *test, 
                                CppUnit::TestResult * )
{
  allcnt_=test->countTestCases();
  FXString msg; msg.format("start ... (%d)",allcnt_);
  setStatusText(msg);
}
void listenerFox::endTestRun( CppUnit::Test *, 
                              CppUnit::TestResult * )
{
  setStatusText("end of test ...");
}

void listenerFox::run()
{
  CppUnit::TestResult controller;
  controller.addListener(this);

//  CppUnit::TextUi::TestRunner runner;
  CppUnit::TestRunner runner;
  CppUnit::Test * pt;
  if ( ns_.empty() )
    pt=CppUnit::TestFactoryRegistry::getRegistry().makeTest();
  else
    pt=CppUnit::TestFactoryRegistry::getRegistry(ns_).makeTest();
  runner.addTest(pt);
  /// Linuxł̓R[obNĂ΂Ȃ̂ŁAłݒ肵Ă
  allcnt_=pt->countTestCases();
  FXString msg; msg.format("start ... (%d)",allcnt_);
  setStatusText(msg);
  /*
  CppUnit::Outputter* outputter = 0;
  std::ostream* stream = target ? &std::cerr : &std::cout;
  switch ( format ) {
  case 0 :
    outputter = new CppUnit::TextOutputter(&runner.result(),*stream);
    break;
  case 1 :
    outputter = new CppUnit::XmlOutputter(&runner.result(),*stream, "shift_jis");
    static_cast<CppUnit::XmlOutputter*>(outputter)->setStyleSheet(xsl);
    break;
  case 2 :
    outputter = new CppUnit::CompilerOutputter(&runner.result(),*stream);    break;
  }
  */
  runner.run(controller);
//  runner.setOutputter(outputter);
//  return runner.run() ? 0 : 1;
}
