/*
 * 'cocuppa' : COmpact CppUnit Pre Process Aid
 *   $Revision: 1.3 $ $Date: 2002/08/27 08:38:42 $
 *
 *    by episteme
 *
 *  creates test-skeletons for CppUnit 1.9.2 or later
 */

#include "cuppa/cocuppa.h"   // Cocuppa

namespace cuppa {

void cocuppa::make_suite_decl(std::ostream& strm) const {

  // --separate
  if ( !standalone ) {
    strm << "#ifndef " << suite << "_h\n"
            "#define " << suite << "_h\n\n";
  }

  // --include
  strm << "//CUPPA:include=+\n";
  for ( incs_type::const_iterator ii = incs.begin(); ii != incs.end(); ++ii ) {
    if ( ii->second ) {
      strm << "#include <" << ii->first << ">\n";
    } else {
      strm << "#include \"" << ii->first << "\"\n";
    }
  }
  strm << "//CUPPA:include=-\n";

  // --super
  if ( !super.empty() ) {
    strm << "#include \"" << super << DECL_SUFFIX "\"\n";
  }

  strm << "#include <cppunit/extensions/HelperMacros.h>\n";
  strm << "#include <cppunit/TestAssert.h>\n\n";

  // --namespace
  strm << "//CUPPA:namespace=+\n";
  if ( !ns.empty() ) { 
    strm << "namespace " << ns << " {\n";
  }
  strm << "//CUPPA:namespace=-\n\n";

  // --skeleton
  strm << "class " << suite << " : public ";

  // --super
  if ( super.empty() ) {
    strm << "CppUnit::TestFixture {\n"
            "  CPPUNIT_TEST_SUITE(" << suite << ");\n";
  } else {
    strm << super << " {\n"
            "  CPPUNIT_TEST_SUB_SUITE(" << suite << ',' << super << ");\n";
  }

  strm << "//CUPPA:suite=+\n";
  cases_type::const_iterator it;
  for ( it = cases.begin(); it != cases.end(); ++it ) {
    std::string method;
    if ( it->first[0] != '.' ) {
      method = it->first;
    } else {
      method = it->first.substr(1);
    }
    if ( prefix ) {
      method = "test" + method;
    }
    if ( it->first[0] != '.' ) {
      strm << "  CPPUNIT_TEST(" << method << ");\n";
    } else {
      strm << "//CPPUNIT_TEST(" << method << ");\n";
    }
  }
  strm << "//CUPPA:suite=-\n"
          "  CPPUNIT_TEST_SUITE_END();\n"
          "private:\n\n  // your stuff...\n\n"
          "public:\n\n"
          "  virtual void setUp() { /* initialize */ }\n"
          "  virtual void tearDown() { /* terminate */ }\n\n"
          "//CUPPA:decl=+\n";
  for ( it = cases.begin(); it != cases.end(); ++it ) {
    std::string method;
    if ( it->first[0] != '.' ) {
      method = it->first;
    } else {
      method = it->first.substr(1);
    }
    if ( prefix ) {
      method = "test" + method;
    }
    strm << "  void " << method << "()";
    strm << (it->second ?
             ";\n" : " {\n    CPPUNIT_FAIL(\"no implementation\");\n  }\n");
  }
  strm << "//CUPPA:decl=-\n"
          "};\n\n";

  // --namespace
  if ( !ns.empty() ) { strm << "}\n\n"; }

  // --separate
  if ( !standalone ) { strm << "#endif\n"; }

}

void cocuppa::make_suite_impl(std::ostream& strm) const {

  // --separate
  if ( !standalone ) {
    strm << "#include \"" << suite << DECL_SUFFIX "\"\n\n"
            "#include <cppunit/TestAssert.h>\n\n";
  }

  // --namespace
  if ( !ns.empty() ) { strm << "namespace " << ns << " {\n"; }

  strm << "//CUPPA:impl=+\n";
  cases_type::const_iterator it;
  for ( it = cases.begin(); it != cases.end(); ++it ) {
    if ( it->second ) {
      strm << "/** @test description */\nvoid " << suite << "::";
      std::string method;
      if ( it->first[0] != '.' ) {
        method = it->first;
      } else {
        method = it->first.substr(1);
      }
      if ( prefix ) {
        method = "test" + method;
      }
      strm << method << "() {\n  CPPUNIT_FAIL(\"no implementation\");\n}\n\n";
    }
  }
  strm << "//CUPPA:impl=-\n\n";

  // -- noregist
  if ( noregist ) { strm << "//"; }

  strm << "CPPUNIT_TEST_SUITE_REGISTRATION(" << suite << ");\n";

  // --namespace
  if ( !ns.empty() ) {
    if ( noregist ) { strm << "//"; }
    strm << "CPPUNIT_TEST_SUITE_NAMED_REGISTRATION("
         << suite << ",\"" << ns << "\");\n";
  }

  // --namespace
  if ( !ns.empty() ) { strm << "\n}\n"; }

}

void cocuppa::make_main(std::ostream& strm) {
  strm <<
"#include <iostream>\n" \
"#include <string>\n"
"#include <cppunit/ui/text/TestRunner.h>\n"
"#include <cppunit/XmlOutputter.h>\n"
"#include <cppunit/TextOutputter.h>\n"
"#include <cppunit/CompilerOutputter.h>\n"
"#include <cppunit/extensions/TestFactoryRegistry.h>\n\n"
"int main(int argc, char* argv[]) {\n"
"  int format = 0;\n"
"  int target = 0;\n"
"  std::string xsl;\n"
"  std::string ns;\n"
"  for ( int i = 1; i < argc; ++i ) {\n"
"    std::string arg(argv[i]);\n"
"    if ( arg == \"--text\"      ) format = 0;\n"
"    if ( arg == \"--xml\"       ) format = 1;\n"
"    if ( arg == \"--compiler\"  ) format = 2;\n"
"    if ( arg == \"--cerr\"      ) target = 1;\n"
"    if ( arg == \"--xsl\"       ) xsl = argv[++i];\n"
"    if ( arg == \"--namespace\" ) ns  = argv[++i];\n"
"  }\n"
"  CppUnit::TextUi::TestRunner runner;\n"
"  if ( ns.empty() )\n"
"    runner.addTest(CppUnit::TestFactoryRegistry::getRegistry().makeTest());\n"
"  else\n"
"    runner.addTest(CppUnit::TestFactoryRegistry::getRegistry(ns).makeTest());\n"
"  CppUnit::Outputter* outputter = 0;\n"
"  std::ostream* stream = target ? &std::cerr : &std::cout;\n"
"  switch ( format ) {\n"
"  case 0 :\n"
"    outputter = new CppUnit::TextOutputter(&runner.result(),*stream);\n"
"    break;\n"
"  case 1 :\n"
"    outputter = new CppUnit::XmlOutputter"
            "(&runner.result(),*stream, \"" XML_ENCODING "\");\n"
"    static_cast<CppUnit::XmlOutputter*>(outputter)->setStyleSheet(xsl);\n"
"    break;\n"
"  case 2 :\n"
"    outputter = new CppUnit::CompilerOutputter(&runner.result(),*stream);"
"    break;\n"
"  }\n"
"  runner.setOutputter(outputter);\n"
"  return runner.run() ? 0 : 1;\n"
"}\n"
;
}

}

