module Umigame
  class ArrayOptParser
  
    NO_ARGUMENT = 0
    REQUIRED_ARGUMENT = 1
    REQUIRED_ARG_MULTI = 2
    
    attr_accessor :other
    
    def initialize
      @dic = Hash.new
      @arias = Hash.new
      @other = Array.new
    end
    
    def parse(opt)
      jump = false
      command=""
      opt.each_index do |i|
        unless jump
          if opt[i] =~ /^--/  
            unless @dic.has_key?(opt[i])
              @other.push ('--' + opt[i])
            else
              command = opt[i]
              if @dic[command].first == NO_ARGUMENT
                @dic[command].push true
              elsif @dic[command].first == REQUIRED_ARG_MULTI
                @dic[command].last.push opt[i+1]
                jump = true
              else
                @dic[command].push opt[i+1]
                jump = true
              end
            end
          elsif opt[i] =~ /^-(.*)/
            $1.each_byte do |arias|
              comcode = arias.chr
              unless @arias.has_key?(comcode)
                @other.push ('-' + comcode)
              else
                command = @arias[comcode]
                if @dic[command].first == NO_ARGUMENT
                  @dic[command].push true
                elsif @dic[command].first == REQUIRED_ARG_MULTI
                  @dic[command].last.push opt[i+1]
                  jump = true
                else
                  @dic[command].push opt[i+1]
                  jump = true
                end
              end
            end
          else
            @other.push opt[i]
          end
        else
          jump = false
        end
      end    
    end
    
    def set_option(*opt)
      opt.each do |arg|
        newitem = Array.new
        newitem.push arg.pop
        newitem.push [] if newitem.last == REQUIRED_ARG_MULTI
        key = arg.shift
        arg.each do |arias|
          @arias[arias[0,1]] = key
        end
        @dic[key] = newitem
      end
    end
    
    def [](key)
      key = '--' + key
      return false unless @dic.has_key?(key)
      return false if @dic[key].size == 1
      @dic[key].last
    end
    
    def other
      @other
    end
  end
end
