require 'fox'
require 'umigame'

class CreatorWindow < Fox::FXMainWindow
  def initialize(app)
    super(app, "Umigame Creator", nil, nil, DECOR_ALL, 0, 0, 0, 0)
    top = FXVerticalFrame.new(self, FRAME_RAISED|FRAME_SUNKEN|FRAME_THICK||LAYOUT_FILL_X|LAYOUT_FILL_ROW)
      forms = FXVerticalFrame.new(top, FRAME_RAISED|FRAME_SUNKEN|FRAME_THICK|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X)
        FXLabel.new(forms, "&skeleton")
        @skeleton = FXTextField.new(forms, 30)
        FXLabel.new(forms, "Require File List")
        @include = FXText.new(forms, nil, 0, TEXT_NO_TABS|LAYOUT_FILL_X|TEXT_SHOWACTIVE)
        FXLabel.new(forms, "Test Method List")
        @methods = FXText.new(forms, nil, 0, TEXT_NO_TABS|LAYOUT_FILL_X|TEXT_SHOWACTIVE)
      checkbox = FXHorizontalFrame.new(top, FRAME_RAISED|FRAME_SUNKEN|FRAME_THICK|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X)
        @prefix = FXCheckButton.new(checkbox, "&Prefix", nil, 0,ICON_AFTER_TEXT|LAYOUT_SIDE_TOP)
      buttons = FXHorizontalFrame.new(top, FRAME_RAISED|FRAME_SUNKEN|FRAME_THICK|LAYOUT_SIDE_BOTTOM|FRAME_NONE|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH)
        FXButton.new(buttons, "&Create", nil, nil, 0, FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y).connect(SEL_COMMAND, method(:on_create))
        FXButton.new(buttons, "&Cancel", nil, nil, 0, FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y).connect(SEL_COMMAND, method(:on_cancel))
  end
  
  def on_create(sender, sel, ptr)
    if @skeleton.getText == ""
      FXMessageBox.error(self, MBOX_OK, "Parameter Error", "You need fill skeleton name")
      return
    end
    umigame = Umigame::Core.new
    method = @methods.getText.gsub(/\n/, ' ')
    include = (@include.getText.empty? ? "" : " -i ") + @include.getText.gsub(/\n/, ' -i ')
    opt = "--cout -s #{@skeleton.getText} #{@prefix.getCheck ? "-P" : ""} #{method} #{include}".split
    umigame.eval_argv(opt)
    exit(0)
  end
  
  def on_cancel(sender, sel, ptr)
    exit(0)
  end
end

application = Fox::FXApp.new("WindowSize", "shibu.jp")
application.init(ARGV)

main = CreatorWindow.new(application)

application.create()
main.show(PLACEMENT_SCREEN)
application.run()
