#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <Console.h>

#include "strvec.h" // what we wanna make.

strvec* sv = 0;

static int init(void) {
  sv = strvec_new(1);
  return 0;
}

static int term(void) {
  strvec_del(sv);
  return 0;
}

static void test_init(void) {
  ASSERT( 0 != sv );
  ASSERT( 0 == strvec_size(sv) );
  ASSERT( 1 == strvec_capacity(sv) );
}

static void test_push_back(void) {
  strvec_push_back(sv, "one");
  ASSERT( 1 == strvec_size(sv) );
  strvec_push_back(sv, "two");
  strvec_push_back(sv, "three");
  strvec_push_back(sv, "four");
  ASSERT( 4 == strvec_size(sv) );
  strvec_push_back(sv, "five");
  ASSERT( 5 == strvec_size(sv) );
  ASSERT( 5 <= strvec_capacity(sv) );
}

static void test_insert_before(void) {
  strvec_clear(sv);
  strvec_push_back(sv, "one");
  strvec_push_back(sv, "two");
  strvec_push_back(sv, "three");
  strvec_push_back(sv, "four");
  strvec_push_back(sv, "six");
  ASSERT( 5 == strvec_size(sv) );
  strvec_insert_before(sv, 0, "zero");
  ASSERT( 6 == strvec_size(sv) );
  ASSERT( !strcmp("zero", strvec_get(sv,0)) );
  ASSERT( !strcmp("one",  strvec_get(sv,1)) );
  ASSERT( !strcmp("six",  strvec_get(sv,5)) );
  strvec_insert_before(sv, 5, "five");
  ASSERT( !strcmp("four", strvec_get(sv,4)) );
  ASSERT( !strcmp("five", strvec_get(sv,5)) );
  ASSERT( !strcmp("six",  strvec_get(sv,6)) );
  ASSERT( 7 == strvec_size(sv) );
  strvec_insert_before(sv, -1, "dummy");
  ASSERT( 7 == strvec_size(sv) );
  strvec_insert_before(sv,  7, "dummy");
  ASSERT( 7 == strvec_size(sv) );
}

static void test_erase(void) {
  strvec_clear(sv);
  strvec_push_back(sv, "zero");
  strvec_push_back(sv, "one");
  strvec_push_back(sv, "two");
  strvec_push_back(sv, "three");
  strvec_push_back(sv, "four");
  strvec_push_back(sv, "five");
  ASSERT( 6 == strvec_size(sv) );
  strvec_erase(sv, 5);
  ASSERT( 5 == strvec_size(sv) );
  strvec_erase(sv, 2);
  ASSERT( 4 == strvec_size(sv) );
  ASSERT( !strcmp("three", strvec_get(sv, 2)) );
}

static void test_clear(void) {
  strvec_push_back(sv, "one");
  ASSERT( strvec_size(sv) );
  strvec_clear(sv);
  ASSERT( !strvec_size(sv) );
}

static void test_get(void) {
  strvec_clear(sv);
  strvec_push_back(sv, "one");
  strvec_push_back(sv, "two");
  strvec_push_back(sv, "three");
  strvec_push_back(sv, "four");
  ASSERT( 4 == strvec_size(sv) );
  ASSERT( !strcmp("one",  strvec_get(sv,0)) );
  ASSERT( !strcmp("two",  strvec_get(sv,1)) );
  ASSERT( !strcmp("three",strvec_get(sv,2)) );
  ASSERT( !strcmp("four", strvec_get(sv,3)) );
}

static void test_find(void) {
  strvec_clear(sv);
  strvec_push_back(sv, "zero");
  strvec_push_back(sv, "one");
  strvec_push_back(sv, "two");
  strvec_push_back(sv, "three");
  ASSERT( 4 == strvec_size(sv) );
  ASSERT( 0 == strvec_find(sv, "zero") );
  ASSERT( 3 == strvec_find(sv, "three") );
  ASSERT( 0 >  strvec_find(sv, "nowhere") );
}

void strvec_suite() {
  TestGroup* pGroup;
  pGroup = add_test_group("strvec", init, term);
  add_test_case(pGroup, "test_init",          test_init);
  add_test_case(pGroup, "test_push_back",     test_push_back);
  add_test_case(pGroup, "test_insert_before", test_insert_before);
  add_test_case(pGroup, "test_erase",         test_erase);
  add_test_case(pGroup, "test_clear",         test_clear);
  add_test_case(pGroup, "test_get",           test_get);
  add_test_case(pGroup, "test_find",          test_find);
}

int main() {
  initialize_registry();
  strvec_suite();
  console_run_tests();
  cleanup_registry();
  return 0;
}
