/*
 *  CUnit - A Unit testing framework library for C.
 *  Copyright (C) 2001  Anil Kumar
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	Contains ASSERT implementation which handles the assert.
 *	If logs if the Condition is false else it ignores it.
 *
 *	Created By     : Anil Kumar on ...(in month of Aug 2001)
 *	Last Modified  : 09/Aug/2001
 *	Comment	       : Added only skeleton function.
 *	Email          : aksaharan@yahoo.com
 *
 *	Last Modified  : 19/Aug/2001
 *	Comment	       : Added add_failure routine call.
 *	Email          : aksaharan@yahoo.com
 *
 *      Revised By     : 'Cuppa' project team
 *      Last Modified  : 06/Jun/2002
 *      Comment        : new assertImplementations are introduced for long/double
 *      WWW            : http://sourceforge.jp/projects/cuppa/
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TestDB.h"
#include "TestRun.h"


void assertImplementation(unsigned int uiValue, unsigned int uiLine,
		char strCondition[], char strFile[], char strFunction[])
{
	add_failure(uiLine, strCondition, strFile, g_pTestGroup, g_pTestCase);
}

int assertImplementation_long(long expected, long actual, unsigned int uiLine,
				char strCondition[], char strFile[], char strFunction[])
{
  static char message[256];
  if ( expected == actual ) return TRUE;
  sprintf(message, "\nexpected: %ld\nbut was:  %ld", expected, actual);
  add_failure(uiLine, message, strFile, g_pTestGroup, g_pTestCase);
  return FALSE;
}

int assertImplementation_double(double expected, double actual, double delta, unsigned int uiLine,
				char strCondition[], char strFile[], char strFunction[])
{
  static char message[256];
  double diff = expected - actual;
  if ( diff < 0.0 ) diff = -diff;
  if ( diff < delta ) return TRUE;
  sprintf(message, "\nexpected: %f (allowance: %f)\nbut was:  %f", expected, delta, actual);
  add_failure(uiLine, message, strFile, g_pTestGroup, g_pTestCase);
  return FALSE;
}

int assertImplementation_cstr(const char* expected, const char* actual, unsigned int uiLine,
				char strCondition[], char strFile[], char strFunction[]) {
  char* message;
  if ( !strcmp(expected,actual) ) return TRUE;
  message = (char*)malloc(strlen(expected) + strlen(actual) + 32);
  sprintf(message, "\nexpected: '%s'\nbut was:  '%s'", expected, actual);
  add_failure(uiLine, message, strFile, g_pTestGroup, g_pTestCase);
  free(message);
  return FALSE;
}

