# bcc32 -c -I../CUnit/Headers ../CUnit/Sources/Framework/AssertImpl.c
#                              ../CUnit/Sources/Framework/TestDB.c
#                              ../CUnit/Sources/Framework/TestRun.c
#                              ../CUnit/Sources/Framework/Util.c
#  bcc32 -c -I../CUnit/Headers ../CUnit/Sources/Console/Console.c
#  bcc32 -c -I../CUnit/Headers ../CUnit/Sources/Automated/Automated.c
#  tlib CUnit.lib +AssertImpl.obj +TestDB.obj +TestRun.obj
#                 +Util.obj +Console.obj +Automated.obj

BCB=c:\bcc55
BCC32=bcc32
LIB=tlib

## target
### static lib.
CUNIT_RELEASE_LIB=cunit_bc5.lib
#CUNIT_DEBUG_LIB=cunitd_bc5.lib
### DLL
#CUNIT_RELEASE_DLL=cunit_bc5_dll.dll
#CUNIT_DEBUG_DLL=cunitd_bc5_dll.dll

CUNIT_SOURCE_PATH=../CUNIT/Sources/Framework;../CUNIT/Sources/Console;../CUNIT/Sources/Automated;

##SOURCE=AssertImpl.c TestDB.c TestRun.c Util.c Console.c Automated.c
OBJDIR=objdir
OBJS=$(OBJDIR)\AssertImpl.obj $(OBJDIR)\TestDB.obj $(OBJDIR)\TestRun.obj $(OBJDIR)\Util.obj $(OBJDIR)\Console.obj $(OBJDIR)\Automated.obj
OBJS_FOR_LIB= +$(OBJDIR)\AssertImpl.obj +$(OBJDIR)\TestDB.obj +$(OBJDIR)\TestRun.obj +$(OBJDIR)\Util.obj +$(OBJDIR)\Console.obj +$(OBJDIR)\Automated.obj
INCLUDE=../CUnit/Headers
FLAGS_COMMON= -I$(INCLUDE) -jb -j1 -w -c -w-aus -w-par -DWIN32
CXXFLAGS_RELEASE= $(FLAGS_COMMON) -O2

.PATH.C = $(CUNIT_SOURCE_PATH)

.c.obj:
    $(BCB)\BIN\$(BCC32) -w-pro $(CXXFLAGS_RELEASE) -n$(@D) $<
#    $(BCB)\BIN\$(BCC32) -w-pro $(CXXFLAGS_RELEASE) -n$(@D) {$< }

all: $(OBJDIR) $(CUNIT_RELEASE_LIB)

$(OBJDIR):
	@if not exist $< (md $<) else echo already exist $< dirctory

$(CUNIT_RELEASE_LIB): $(OBJS)
	$(BCB)\bin\$(LIB) $< $(OBJS_FOR_LIB)

clean:
	@if exist $(OBJDIR) (del /q $(OBJDIR)\*)
	@if exist $(OBJDIR) (rmdir /q $(OBJDIR))
	@del /q *.lib
	@del /q *.map *.tds
