require 'umigame/arrayoptparser'
require 'test/unit/assertions'

module Umigame
  class Creator
    include Test::Unit::Assertions
    
    attr_accessor :skeleton, :main, :testmethod, :force, :include, :noregist, :include, :prefix
    
    def initialize
      @testmethod = []
      @include = []
      @parser = ArrayOptParser.new
      @parser.set_option(
      ['--add', 'a', ArrayOptParser::REQUIRED_ARGUMENT],
      ['--include', 'i', ArrayOptParser::REQUIRED_ARG_MULTI],
      ['--main', 'm', ArrayOptParser::REQUIRED_ARGUMENT],
      ['--noregist', 'N', ArrayOptParser::NO_ARGUMENT],
      ['--prefix', 'P', ArrayOptParser::NO_ARGUMENT],
      ['--skeleton', 's', ArrayOptParser::REQUIRED_ARGUMENT]
      )
    end
    
    def print_skeleton
      return write_skeleton if @skeleton
      return nil
    end
    
    def print_main
      return write_main if @main
      return nil
    end
    
    def set_argv(argv)
      @parser.parse(argv)
      @main = @parser['main']
      @testmethod = @parser.other
      @skeleton = @parser['skeleton']
      @include = @parser['include']
      @noregist = @parser['noregist']
      @prefix = @parser['prefix']
      eval_argv
    end
    
    def output
      ret = {}
      if @skeleton
        ret.store(filename(@skeleton), write_skeleton) 
      end
      if @main
        ret.store(filename(@main), write_main)
      end
      return ret
    end
    
  protected

    def filename(name)
      # fook method
    end
    
    def method_info(name)
      if name =~ /^\.(\w+)/
        return methodprefix + $1, true
      else
        return methodprefix + name, false
      end
    end
    
    def eval_argv
      # fook method
    end
    
    def write_skeleton
      # fook method
    end
    
    def write_main
      # fook method
    end
  end
end
