/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.seasar.framework.mock.sql.MockResultSetMetaData;
import org.seasar.framework.mock.sql.MockStatement;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.BigDecimalConversionUtil;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.ByteConversionUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.ShortConversionUtil;
import org.seasar.framework.util.SqlDateConversionUtil;
import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.util.TimeConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class MockResultSet
implements ResultSet {
    private MockResultSetMetaData metaData;
    private List rowDataList = new ArrayList();
    private int row = 0;
    private int type;
    private int concurrency;
    private boolean closed = false;
    private int fetchSize;
    private MockStatement statement;

    public MockResultSet() {
        this(null);
    }

    public MockResultSet(MockResultSetMetaData metaData) {
        this(metaData, 1003, 1007);
    }

    public MockResultSet(MockResultSetMetaData metaData, int type, int concurrency) {
        this.setMockMetaData(metaData);
        this.setType(type);
        this.setConcurrency(concurrency);
    }

    public ArrayMap getRowData() {
        return this.getRowData(this.row);
    }

    public ArrayMap getRowData(int index) {
        return (ArrayMap)this.rowDataList.get(index - 1);
    }

    public Object getColumnData(int index) {
        return this.getRowData().get(index - 1);
    }

    public Object getColumnData(String columnName) {
        return this.getRowData().get(columnName);
    }

    public void addRowData(ArrayMap rowData) {
        this.rowDataList.add(rowData);
    }

    public boolean absolute(int row) throws SQLException {
        this.assertCursor();
        if (row > 0 && row <= this.rowDataList.size()) {
            this.row = row;
            return true;
        }
        return false;
    }

    protected void assertCursor() throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("cursor not supported");
        }
    }

    public void afterLast() throws SQLException {
        this.assertCursor();
        this.row = this.rowDataList.size() + 1;
    }

    public void beforeFirst() throws SQLException {
        this.assertCursor();
        this.row = 0;
    }

    public void cancelRowUpdates() throws SQLException {
        this.assertUpdatable();
    }

    protected void assertUpdatable() throws SQLException {
        if (this.concurrency == 1007) {
            throw new SQLException("update not supported");
        }
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void deleteRow() throws SQLException {
        this.assertUpdatable();
    }

    public int findColumn(String columnName) throws SQLException {
        return this.metaData.findColumn(columnName);
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int columnIndex) throws SQLException {
        return (Array)this.getColumnData(columnIndex);
    }

    public Array getArray(String columnName) throws SQLException {
        return (Array)this.getColumnData(columnName);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.getColumnData(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return (InputStream)this.getColumnData(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return BigDecimalConversionUtil.toBigDecimal(this.getColumnData(columnIndex));
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return BigDecimalConversionUtil.toBigDecimal(this.getColumnData(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(columnIndex);
        if (value == null) {
            return null;
        }
        value = value.setScale(scale);
        return value;
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(columnName);
        if (value == null) {
            return null;
        }
        value = value.setScale(scale);
        return value;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.getColumnData(columnIndex);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return (InputStream)this.getColumnData(columnName);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.getColumnData(columnIndex);
    }

    public Blob getBlob(String columnName) throws SQLException {
        return (Blob)this.getColumnData(columnName);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return BooleanConversionUtil.toPrimitiveBoolean(this.getColumnData(columnIndex));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return BooleanConversionUtil.toPrimitiveBoolean(this.getColumnData(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        return ByteConversionUtil.toPrimitiveByte(this.getColumnData(columnIndex));
    }

    public byte getByte(String columnName) throws SQLException {
        return ByteConversionUtil.toPrimitiveByte(this.getColumnData(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getColumnData(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return (byte[])this.getColumnData(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getColumnData(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return (Reader)this.getColumnData(columnName);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.getColumnData(columnIndex);
    }

    public Clob getClob(String columnName) throws SQLException {
        return (Clob)this.getColumnData(columnName);
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return SqlDateConversionUtil.toDate(this.getColumnData(columnIndex));
    }

    public Date getDate(String columnName) throws SQLException {
        return SqlDateConversionUtil.toDate(this.getColumnData(columnName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return DoubleConversionUtil.toPrimitiveDouble(this.getColumnData(columnIndex));
    }

    public double getDouble(String columnName) throws SQLException {
        return DoubleConversionUtil.toPrimitiveDouble(this.getColumnData(columnName));
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return FloatConversionUtil.toPrimitiveFloat(this.getColumnData(columnIndex));
    }

    public float getFloat(String columnName) throws SQLException {
        return FloatConversionUtil.toPrimitiveFloat(this.getColumnData(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        return IntegerConversionUtil.toPrimitiveInt(this.getColumnData(columnIndex));
    }

    public int getInt(String columnName) throws SQLException {
        return IntegerConversionUtil.toPrimitiveInt(this.getColumnData(columnName));
    }

    public long getLong(int columnIndex) throws SQLException {
        return LongConversionUtil.toPrimitiveLong(this.getColumnData(columnIndex));
    }

    public long getLong(String columnName) throws SQLException {
        return LongConversionUtil.toPrimitiveLong(this.getColumnData(columnName));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getMockMetaData();
    }

    public MockResultSetMetaData getMockMetaData() {
        return this.metaData;
    }

    public void setMockMetaData(MockResultSetMetaData metaData) {
        this.metaData = metaData;
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumnData(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getColumnData(columnName);
    }

    public Object getObject(int columnIndex, Map arg1) throws SQLException {
        return this.getObject(columnIndex);
    }

    public Object getObject(String columnName, Map arg1) throws SQLException {
        return this.getObject(columnName);
    }

    public Ref getRef(int columnIndex) throws SQLException {
        return (Ref)this.getColumnData(columnIndex);
    }

    public Ref getRef(String columnName) throws SQLException {
        return (Ref)this.getColumnData(columnName);
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public short getShort(int columnIndex) throws SQLException {
        return ShortConversionUtil.toPrimitiveShort(this.getColumnData(columnIndex));
    }

    public short getShort(String columnName) throws SQLException {
        return ShortConversionUtil.toPrimitiveShort(this.getColumnData(columnName));
    }

    public Statement getStatement() throws SQLException {
        return this.getMockStatement();
    }

    public MockStatement getMockStatement() {
        return this.statement;
    }

    public void setMockStatement(MockStatement statement) {
        this.statement = statement;
    }

    public String getString(int columnIndex) throws SQLException {
        return StringConversionUtil.toString(this.getColumnData(columnIndex));
    }

    public String getString(String columnName) throws SQLException {
        return StringConversionUtil.toString(this.getColumnData(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return TimeConversionUtil.toTime(this.getColumnData(columnIndex));
    }

    public Time getTime(String columnName) throws SQLException {
        return TimeConversionUtil.toTime(this.getColumnData(columnName));
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(columnName);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return TimestampConversionUtil.toTimestamp(this.getColumnData(columnIndex));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return TimestampConversionUtil.toTimestamp(this.getColumnData(columnName));
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    public int getType() throws SQLException {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.getColumnData(columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        return (URL)this.getColumnData(columnName);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.getColumnData(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return (InputStream)this.getColumnData(columnName);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        this.assertUpdatable();
    }

    public boolean isAfterLast() throws SQLException {
        return this.row > this.rowDataList.size();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.row == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.row == 1;
    }

    public boolean isLast() throws SQLException {
        return this.row == this.rowDataList.size();
    }

    public boolean last() throws SQLException {
        return this.absolute(this.rowDataList.size());
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
    }

    public boolean next() throws SQLException {
        if (this.row < this.rowDataList.size()) {
            ++this.row;
            return true;
        }
        if (this.row == this.rowDataList.size()) {
            ++this.row;
            return false;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        this.assertCursor();
        if (this.row > 1) {
            --this.row;
            return true;
        }
        if (this.row == 1) {
            --this.row;
            return false;
        }
        return false;
    }

    public void refreshRow() throws SQLException {
    }

    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.row + rows);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.assertUpdatable();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.assertUpdatable();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.assertUpdatable();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.assertUpdatable();
    }

    public void updateNull(String columnName) throws SQLException {
        this.assertUpdatable();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.assertUpdatable();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.assertUpdatable();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateRow() throws SQLException {
        this.assertUpdatable();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.assertUpdatable();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.assertUpdatable();
    }

    public boolean wasNull() throws SQLException {
        return false;
    }
}

