/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.nagesen.nich;

import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.curewallet.nagesen.NagesenException;
import org.curewallet.nagesen.nich.GetNichData;
import org.curewallet.nagesen.nich.GetNichDataResult;
import org.curewallet.nagesen.nich.NichData;

public class GetNichDataImpl
implements GetNichData {
    private static Logger log = Logger.getLogger(GetNichDataImpl.class);
    private int sockerTimeout = 0;
    private int connectionTimeout = 0;
    private String userAgent = null;

    @Override
    public GetNichDataResult get(String url, String modifiedSince, long range) throws NagesenException {
        try {
            URL urlObj = new URL(url);
            String datUrl = null;
            if ("dat".equals(FilenameUtils.getExtension((String)urlObj.getPath()))) {
                datUrl = url;
            } else {
                String[] urlTokens = urlObj.getPath().split("/");
                datUrl = "http://" + urlObj.getHost() + "/" + urlTokens[3] + "/dat/" + urlTokens[4] + ".dat";
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectionTimeout()).setSocketTimeout(this.getSockerTimeout()).build();
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            headers.add(new BasicHeader("User-Agent", this.getUserAgent()));
            if (modifiedSince != null) {
                headers.add(new BasicHeader("If-Modified-Since", modifiedSince));
            }
            if (range > 0L) {
                headers.add(new BasicHeader("Accept-Encoding", "identify"));
                headers.add(new BasicHeader("Range", "bytes=" + range + "-"));
            } else {
                headers.add(new BasicHeader("Accept-Encoding", "gzip"));
            }
            log.debug((Object)("Request info: If-Modified-Since=" + modifiedSince + ", Range=" + range));
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultHeaders(headers).build();
            HttpGet httpGet = new HttpGet(datUrl);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            GetNichDataResult result = new GetNichDataResult();
            int statusCode = response.getStatusLine().getStatusCode();
            result.setStatusCode(statusCode);
            if (statusCode == 200 || statusCode == 206) {
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"MS932");
                result.setRange(body.getBytes("MS932").length);
                result.setLasyModified(response.getHeaders("Last-Modified")[0].getValue());
                log.info((Object)("Response info: status-code=" + result.getStatusCode() + ", Last-Modified=" + result.getLasyModified() + ", byte-size=" + result.getRange()));
                BufferedReader br = new BufferedReader(new StringReader(body));
                String line = null;
                ArrayList<NichData> nichDataList = new ArrayList<NichData>();
                while ((line = br.readLine()) != null) {
                    try {
                        log.debug((Object)line);
                        String[] tokens = line.split("<>");
                        NichData data = new NichData();
                        data.setName(tokens[0]);
                        data.setMail(tokens[1]);
                        data.setTimestamp(tokens[2]);
                        data.setMessage(tokens[3]);
                        nichDataList.add(data);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error line: " + line));
                        throw e;
                    }
                }
                result.setNichDataList(nichDataList);
            } else {
                log.info((Object)("Response info: status-code=" + result.getStatusCode()));
            }
            return result;
        }
        catch (Exception e) {
            throw new NagesenException(e);
        }
    }

    public int getSockerTimeout() {
        return this.sockerTimeout;
    }

    public void setSockerTimeout(int sockerTimeout) {
        this.sockerTimeout = sockerTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

