/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.nagesen.nich;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.curewallet.nagesen.AddressData;
import org.curewallet.nagesen.NagesenException;
import org.curewallet.nagesen.ececuter.AbstractExecuter;
import org.curewallet.nagesen.nich.GetNichData;
import org.curewallet.nagesen.nich.GetNichDataResult;
import org.curewallet.nagesen.nich.NichData;

public class NichExecuter
extends AbstractExecuter {
    private GetNichData getNichData = null;
    private String url = null;
    private String lasyModified = null;
    private long range = 0L;
    private int statusCode = 0;
    private String type = null;
    private int startResNo = 0;
    private int endResNo = 0;
    private boolean includeMessageAddress = false;
    private String nameAddressPattern = null;
    private int[] nameAddressIndex = null;
    private String messageAddressPattern = null;
    private int[] messageAddressIndex = null;
    private int lastResNo = 0;

    @Override
    protected List<AddressData> getData() throws NagesenException {
        GetNichDataResult result = this.getGetNichData().get(this.getUrl(), this.getLasyModified(), this.getRange());
        this.setStatusCode(result.getStatusCode());
        if (this.getStatusCode() == 416) {
            return null;
        }
        ArrayList<AddressData> ret = new ArrayList<AddressData>();
        if (this.getStatusCode() == 304) {
            return ret;
        }
        this.setLasyModified(result.getLasyModified());
        this.setRange(this.range + result.getRange());
        for (NichData data : result.getNichDataList()) {
            this.addLastResNo();
            if (this.getStartResNo() > this.getLastResNo() || this.getEndResNo() < this.getLastResNo()) continue;
            AddressData data2 = this.createAddressData(data);
            if (data2 != null) {
                ret.add(data2);
            }
            if (!this.isIncludeMessageAddress()) continue;
            ret.addAll(this.createMessageAddressData(data));
        }
        return ret;
    }

    protected AddressData createAddressData(NichData data) {
        AddressData data2 = new AddressData();
        if (this.getNameAddressPattern() == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(this.getNameAddressPattern());
        Matcher match = pattern.matcher(data.getName());
        if (!match.find()) {
            return null;
        }
        int[] index = this.getNameAddressIndex();
        data2.setAddress(match.group().substring(index[0], index[1]));
        data2.setCoin(this.getType());
        data2.setId(data.getTimestamp().substring(29));
        data2.setMessage(data.getMessage());
        return data2;
    }

    protected List<AddressData> createMessageAddressData(NichData data) {
        ArrayList<AddressData> ret = new ArrayList<AddressData>();
        if (this.getMessageAddressPattern() == null) {
            return ret;
        }
        Pattern pattern = Pattern.compile(this.getMessageAddressPattern());
        String message = data.getMessage();
        Matcher match = pattern.matcher(message);
        while (match.find()) {
            AddressData data2 = new AddressData();
            int[] index = this.getMessageAddressIndex();
            data2.setAddress(match.group().substring(index[0], index[1]));
            data2.setCoin(this.getType());
            data2.setId(data.getTimestamp().substring(29));
            data2.setMessage(data.getMessage());
            ret.add(data2);
            message = message.substring(match.end());
            match = pattern.matcher(message);
        }
        return ret;
    }

    @Override
    protected boolean isContinue(AddressData data) throws NagesenException {
        if (this.getStatusCode() == 416) {
            return false;
        }
        return this.getEndResNo() >= this.getLastResNo();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public GetNichData getGetNichData() {
        return this.getNichData;
    }

    public void setGetNichData(GetNichData getNichData) {
        this.getNichData = getNichData;
    }

    public String getLasyModified() {
        return this.lasyModified;
    }

    public void setLasyModified(String lasyModified) {
        this.lasyModified = lasyModified;
    }

    public long getRange() {
        return this.range;
    }

    public void setRange(long range) {
        this.range = range;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getLastResNo() {
        return this.lastResNo;
    }

    public void setLastResNo(int lastResNo) {
        this.lastResNo = lastResNo;
    }

    public void addLastResNo() {
        this.setLastResNo(this.getLastResNo() + 1);
    }

    public int getStartResNo() {
        return this.startResNo;
    }

    public void setStartResNo(int startResNo) {
        this.startResNo = startResNo;
    }

    public int getEndResNo() {
        return this.endResNo;
    }

    public void setEndResNo(int endResNo) {
        this.endResNo = endResNo;
    }

    public boolean isIncludeMessageAddress() {
        return this.includeMessageAddress;
    }

    public void setIncludeMessageAddress(boolean includeMessageAddress) {
        this.includeMessageAddress = includeMessageAddress;
    }

    public String getNameAddressPattern() {
        return this.nameAddressPattern;
    }

    public void setNameAddressPattern(String nameAddressPattern) {
        this.nameAddressPattern = nameAddressPattern;
    }

    public String getMessageAddressPattern() {
        return this.messageAddressPattern;
    }

    public void setMessageAddressPattern(String messageAddressPattern) {
        this.messageAddressPattern = messageAddressPattern;
    }

    public int[] getNameAddressIndex() {
        return this.nameAddressIndex;
    }

    public void setNameAddressIndex(int[] nameAddressIndex) {
        this.nameAddressIndex = nameAddressIndex;
    }

    public int[] getMessageAddressIndex() {
        return this.messageAddressIndex;
    }

    public void setMessageAddressIndex(int[] messageAddressIndex) {
        this.messageAddressIndex = messageAddressIndex;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

