/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import java.math.BigDecimal;
import org.curewallet.lib.api.AbstractCoinAPI;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.SendToAddress;
import org.curewallet.lib.api.response.SendToAddressResponseObject;
import org.curewallet.lib.api.result.SendToAddressResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class SendToAddressImpl
extends AbstractCoinAPI
implements SendToAddress {
    protected static final String METHOD = "sendtoaddress";

    @Override
    public SendToAddressResult call(JsonRPCClient jsonRPCClient, String toAddress, BigDecimal amount) throws CoinAPIException {
        return this.call(jsonRPCClient, toAddress, amount, null, null);
    }

    @Override
    public SendToAddressResult call(JsonRPCClient jsonRPCClient, String toAddress, BigDecimal amount, String comment, String commentTo) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (toAddress == null || toAddress.length() == 0) {
                throw new NullPointerException("toAddress is null or empty.");
            }
            if (amount == null) {
                throw new NullPointerException("amount is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (comment == null && commentTo == null) {
                requestObject.setParams(new Object[]{toAddress, amount});
            } else {
                if (comment == null) {
                    comment = "";
                }
                if (commentTo == null) {
                    commentTo = "";
                }
                requestObject.setParams(new Object[]{toAddress, amount, comment, commentTo});
            }
            return jsonRPCClient.call(requestObject, SendToAddressResponseObject.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

