/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.curewallet.lib.httpclient.AbstractPostParams;
import org.curewallet.lib.httpclient.HttpClient;
import org.curewallet.lib.httpclient.HttpClientException;
import org.curewallet.lib.httpclient.HttpClientResult;
import org.curewallet.lib.httpclient.JsonPostParams;

public abstract class ApacheHttpClient
implements HttpClient {
    private String host = null;
    private int port = 0;

    protected abstract org.apache.http.client.HttpClient getHttpClient() throws HttpClientException;

    @Override
    public HttpClientResult post(JsonPostParams postParams) throws HttpClientException {
        try {
            org.apache.http.client.HttpClient httpClient = this.getHttpClient();
            StringEntity entity = new StringEntity(postParams.getData());
            entity.setContentType("application/json");
            return this.postExecute(postParams, httpClient, (HttpEntity)entity);
        }
        catch (Exception e) {
            if (e instanceof HttpClientException) {
                throw (HttpClientException)e;
            }
            throw new HttpClientException("POST error: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpClientResult postExecute(AbstractPostParams postParams, org.apache.http.client.HttpClient httpClient, HttpEntity entity) throws HttpClientException {
        HttpClientResult httpClientResult;
        HttpEntity resEntity = null;
        try {
            HttpPost request = new HttpPost(postParams.getUri());
            HttpHost target = new HttpHost(this.getHost(), this.getPort(), postParams.getSchema());
            request.setEntity(entity);
            HttpResponse response = httpClient.execute(target, (HttpRequest)request);
            HttpClientResult result = new HttpClientResult();
            resEntity = response.getEntity();
            result.setContent(EntityUtils.toString((HttpEntity)resEntity, (Charset)postParams.getResponseCharset()));
            httpClientResult = result;
            if (resEntity == null) return httpClientResult;
        }
        catch (Exception e) {
            try {
                throw new HttpClientException("POST error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (resEntity == null) throw throwable;
                try {
                    EntityUtils.consume(resEntity);
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)resEntity);
            return httpClientResult;
        }
        catch (IOException e) {
            // empty catch block
        }
        return httpClientResult;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

