#!/bin/ksh
#
#	MR.KSH
#	All Rights Reserved 1992 (C)
#
#	MR(21)                   機能追加及びファイル修正時の記録
#
#
#	名前
#
#	　　mr.ksh
#
#	使用法
#
#	　　mr (MR-number) (user-name) (version-number)
#
#	概要
#
#	　　　mr  はＣＭＳにおけるアプリケーション開発時の機能追加毎に発行する、
#	　　修正記録です。
#	　　　ＣＭＳでは開発者が修正時に記述する記録を、このＭＲ番号で管理します。
#	　    mrは環境変数 EDITOR を参照して EDITOR の内容のエディタを呼び出しま
#	　　す。
#	　　　mrの呼び出すファイルにはあらかじめ問題処理の為のフォーマットが登録
#	　　されていますので、内容を記述するだけになっています。
#	　　統一して記述することが出来ます。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) listfile(21) get(21) report(21) verlock(21)
#
#	著作
#	    mr.ksh は Shigeki Ono によって開発されました。
#

export PATH=".:$PATH:${CMSPATH}/bin"

dialogmsg "$1 $2 $3"
case $# in
3) ;;
*) errmsg "Usage: mr MR-number(001 - 999) (user-name) Version(0 - 9)";exit ;;
esac

TMPDIR=${CMSPATH}/tmp
MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
MrFile=mr
EditCommand=${EDITOR}
CurentDir=`basename ${PWD}`
SysName=${SYSNAME}
MrNumber=$1
UserName=$2
Version=$3

if [ x"$EditCommand" = x"" ]
then
	EditCommand=vi
fi

trap 'rm -f ${TMPDIR}/mr_$$.tmp;exit 0' 1 2 3 4 5 6 7 8 9 15
if [ -f ${MrDir}/ver_${Version}/${SysName}/mrfiles ]
then
	dialogmsg "mrfiles が存在します"
else
	if [ ! -d ${MrDir}/ver_${Version}/${SysName} ]
	then
		mkdir2 ${MrDir}/ver_${Version}/${SysName}
	fi
	dialogmsg "mrfiles を作成しています"
	echo >> ${MrDir}/ver_${Version}/${SysName}/mrfiles
fi
grep -l "${MrNumber}" ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
if [ $? = 1 ]
then
	dialogmsg "ＭＲ番号を登録して終了します。"
	cat ${MrDir}/mrformat > ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber}
	OWD=${PWD}
	cd ${MrDir}
	/bin/stty onlcr
	${EditCommand} ver_${Version}/${SysName}/${MrFile}.${MrNumber}
	popmsg "本当に登録しますか？ (Y or N)"
	case $? in
	1) chmod 660 ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
		echo "${MrNumber}" >> ${MrDir}/ver_${Version}/${SysName}/mrfiles
	#	chmod 440 ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null 
		sort -u ${MrDir}/ver_${Version}/${SysName}/mrfiles > ${TMPDIR}/mr_$$.tmp
		mv ${TMPDIR}/mr_$$.tmp ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
		chmod 440 ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null 
		cd ${OWD}
	;;
	*)	rm -f ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber}
		cd ${OWD}
		exit ;;
	esac
else
	cls
	errmsg "ＭＲ番号が重複しています。確認してください。"
	if [ $? = 0 ]
	then
		exit
	fi
fi
