#!/bin/ksh
#
#	MKBASE.KSH
#	All Rights Reserved 1992 (C)
#
#    MRREPORT(21)             機能追加及びファイル修正時の記録
#    
#    
#    名前
#    
#    　　mrreport.ksh
#    
#    使用法
#    
#    　　mrreport [ -a -s ] (MR-number) (user-name) (version-number)
#    
#    概要
#    
#    　　mrreportは過去における修正記録の履歴を報告します。但し、ＭＲ記録をし
#    　　てあるリビジョンに限ります。これらの修正記録はプログラムの各開発者及
#    　　び、修正者が個々に記述したものなので、ＭＲ記録の修正を行ないたい時は
#    　　mreditコマンドを利用してください。
#    
#    関連項目
#    
#    　　make(1) Makefile(1)
#    　　put(21) listfile(21) get(21) (vget) report(21) verlock(21) mredit(21)
#
#
#	著作
#		 Shigeki Ono 1990/6/29
#

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
4) ;;
*) errmsg "$# Usage: mrreport [ -a -s ] MR-number(001 - 999) user-name Version(0 - 9)"
exit ;;
esac

MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
MrFile=mr
SysName=${SYSNAME}
EditCommand=${EDITOR}
CurentDir=`basename ${PWD}`

Opt=$1
MrNumber=$2
UserName=$3
Version=$4

case $Opt in
"-a"|"all") MrNumber="*" ;;
"-s") MrNumber=$2 ;;
no) ;;
esac

echo "[m"
case $Opt in
"-s")
	grep -l "${MrNumber}" ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
	if [ $? = 0 ]
	then
		less ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber}
	else
		errmsg "${MrNumber} 番のＭＲは見つかりません．"
		exit
	fi
	;;
"-a")
	#for i in `cat ${MrDir}/ver_${Version}/${SysName}/mrfiles`
	#do
		#pg ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${i}
	#done
	less ${MrDir}/ver_${Version}/${SysName}/${MrFile}.*
	;;
*) exit ;;
esac
