#!/bin/ksh
#
#	REJECTMR.KSH
#	All Rights Reserved 1992,99 (C)
#
export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: rejectmr MR-number(00 - 99) (username) Version(1 - 10)";exit ;;
esac


TMPDIR=${CMSPATH}/tmp
MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
MrFile=mr
SysName=${SYSNAME}
EditCommand=cmsmore
CurentDir=`basename ${PWD}`
MrNumber=$1
UserName=$2
Version=$3

trap 'rm -f ${TMPDIR}/mrnum_$$.tmp;exit 0' 1 2 3 4 5 6 7 8 9 15
grep -l "${MrNumber}" ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
if [ $? = 0 ]
then
	if [ ! -f ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber} ]
	then
		exit
	fi
#	echo "ＭＲ番号 ${MrNumber} の内容を表示します。"
#	${EditCommand} ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber} 29
	popmsg "本当に削除しますか？ (Y or N): \c"
	case $? in
	1) rm -f ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber}
	sed '/'${MrNumber}'/d' ${MrDir}/ver_${Version}/${SysName}/mrfiles > ${TMPDIR}/mrnum_$$.tmp 
		chmod 660 ${MrDir}/ver_${Version}/${SysName}/mrfiles  > /dev/null
		mv ${TMPDIR}/mrnum_$$.tmp ${MrDir}/ver_${Version}/${SysName}/mrfiles > /dev/null
		chmod 440 ${MrDir}/ver_${Version}/${SysName}/mrfiles  > /dev/null
		exit
	;; 
	0) exit ;;
	*) ;;
	esac
else
	errmsg "ＭＲ番号 ${MrNumber} はありません。確認してください。"
	exit
fi
