#!/bin/ksh
#
#	VERLOCK.KSH
#	All Rights Reserved 1990,91,92,99 (C)
#
#	VERLOCK(21)              ファイル重複アクセスの防止
#
#
#	名前
#
#	　　verlock.ksh
#
#	使用法
#
#	　　verlock [ -l -r ] (file-name) (version-number)
#
#	概要
#
#	　　verlock はＬＡＮ（ローカルエリアネットワーク）上での同一ファイルへの
#	　　アクセスの重複を防止します。
#	　　あるファイルのバージョンはユーザ任意の取りだしが可能ですが、get コマ
#	　　ンドを使用すると自動的にこの verlock コマンドを起動して、その取り出し
#	　　たファイルに他のユーザがアクセス出来ないようガードをかけます。そして
#	　　そのファイルは put  コマンドを使用してＣＭＳに戻し登録をしない限り、
#	　　他のユーザは get コマンドを使用して取り出すことが出来ません。
#
#	　　-l　引数で指定したファイルにロックをかけます。
#
#	　　-r　引数で指定したファイルのロックを解除します。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) listfile(21) get(21) report(21) mr(21) mredit(21) mkver(21)

export PATH=".:$PATH:${CMSPATH}/bin"

DiffDir=${CMSPATH}/diff
SysName=${SYSNAME}
case $# in
3) ;;
*) #errmsg "Usage: -l(lock) -r(relese) (file-name) (version number(1 - 10))";exit ;;
esac
File=$2
Ffile=`echo $2 | sed -f ${CMSPATH}/bin/suffixes.sed`
case $3 in
0) LockFile=lkfile0;;
1) LockFile=lkfile1;;
2) LockFile=lkfile2;;
3) LockFile=lkfile3;;
4) LockFile=lkfile4;;
5) LockFile=lkfile5;;
6) LockFile=lkfile6;;
7) LockFile=lkfile7;;
8) LockFile=lkfile8;;
9) LockFile=lkfile9;;
10) LockFile=lkfile10;;
*) #errmsg "Usage: -l(lock) -r(relese) -s(submit) (file-name) (version number(1 - 10))";exit ;;
esac
case $1 in
"-l") echo "lock" > ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};
	chmod 664 ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};;
"-r") echo "" > ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};;
"-s") echo "submit" > ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};
	chmod 664 ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};;
"-c") echo "commit" > ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};
	chmod 444 ${DiffDir}/lock/${SysName}/${Ffile}/${LockFile};;
*) #errmsg "Usage: -l(lock) -r(relese) (version number(1 - 10))";
;;
esac
