#pragma ident "@(#) ase.h 3.0.1 2010.04.01,12:21"
#ifndef ASE_H
#define ASE_H ASE_H
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <math.h>
#include <unistd.h>
#include <sys/stat.h>

#ifdef CYGWIN
#include <ncurses/curses.h>
#else
#include <curses.h>
#endif

#define MAX_FILES 20000
#define ON 1
#define OFF 0
#define MAX_WINDOW 1

#define	iskanjich(c)	((c >= 0x81 && c <= 0x9f || c >= 0xe0 && c<= 0xfc) ? (ON) : (OFF))	

class AseEditor {
private:
	struct cell {
		int no;
		int x;
		int y;
		int c;
		int len;
		int attr;
		int mode;
		int action;
		char s[256];
		char p[256];
		WINDOW * cell;
	} cp[256][80];

	char copybuff[256][80][256];

	char tmpbuff1[256];
	char tmpbuff2[256];

	struct ViewBox {
		WINDOW *vs;	//üɥ
		int col;	//ؼĹʥɥβ
		int line;	//ټĹʥɥνĤĹ
		int x;		//ɽ
		int y;		//ɽ԰
	} pt2[256][80];

	struct ecpg {
		int cell_length;
		char cell_fieldtype[15];
		char cell_title[138];
		int keyflg;
	} pgc[512];

public:
	AseEditor() {};
	int convlabel(WINDOW *vs,int xcol, int xrow, char *f);
	int convtextbox(WINDOW *vs,int xcol, int xrow, char *f);
	int convgrid(WINDOW *vs,int xcol, int xrow, char *f);
	int putecpg(WINDOW *vs,int xcol, int xrow, char *f);
	int putecpgINSERT(WINDOW *vs,int xcol, int xrow, char *f);
	int putecpgUPDATE(WINDOW *vs,int xcol, int xrow, char *f);
	int putecpgDELETE(WINDOW *vs,int xcol, int xrow, char *f);
	int putecpgInterFace(char *f);
	int putCreateSQL(WINDOW *vs,int xcol, int xrow, char *f, int nline);
	int rightcell(int xcol, int xrow);
	int freads(int xcol, int xrow, char *f);
	int fwrites(int xcol, int xrow, char *f);
	int ase(int xcol,int xrow,char *f,int command);
	~AseEditor() {};

	int convlabel2(WINDOW *vs,int xcol, int xrow, char *f);
	int convtextbox2(WINDOW *vs,int xcol, int xrow, char *f);
	int convgrid2(WINDOW *vs,int xcol, int xrow, char *f);
};

#endif

typedef struct stat Dir;
static Dir dptr;
static Dir *fptr = &dptr;

extern "C"	int popmsg(int x,int y,char *buff);
//extern "C"	void input_window(int x,int y,char *buff,char *msg);

extern "C" int jmvwgetnstr(WINDOW *win, int y, int x, unsigned char *str, int n, int wmode, int cmode);

extern "C" char *vs_ieee_c(WINDOW *vs,int x,int y,char *p,int N);

