#pragma ident "@(#) ase.cc 2.2.4 2012.12.10,14:54"
/*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*
名称
	オートマチック　サブフォーム　エディタ
	ASE(Automatic Subform Editor)

  概要
	本プログラムはサブフォーム画面を簡単に作成するために開発された画面設計ツール
	です。
	このツールを使用することで、矛盾のないサブフォーム定義ファイルを作成すること
	が出来ます。
	また、PostgreSQLでの開発をECPGプリプロセッサで行う場合、DBの構造に合わせて
	テーブルを設計することが出来ます。
	aseの画面ファイルから生成する定義ファイル(ファイル名の前にアンダースコアが付
	いている)は、テーブルの各列の型(文字列型、数値型、DATE型、通貨型)、や属性
	(文字列の長さ等)が定義出来、aseのECGPソース生成機能により、自動的にECPGソース
	ファイルを生成します。
	つまり、PstogreSQLのテーブル作成から、CGIプログラムを行うC言語のインターフェースまで
	を ase の画面設計で行うことが出来ます。

	画面ファイルは [source-file-name].def
	画面定義ファイルは _[source-file-name].def
	ECPGソースファイルは [source-file-name].pgc
	SQLファイルは create[source-file-name].sql

	サブフォームライブラリとECPGの混在したコンパイルは以下のコマンドラインで
	行うことが出来ます。makefile に記述します。

	ecpg yubin.pgc
	gcc -I/usr/local/pgsql/include -c yubin.c
	gcc -O2 -static -o yubin.fcgi yubin.o libsubformHTML.a -L/usr/local/pgsql/lib -lecpg -lpq -lpgtypes -lm
      
  構文
  	'a' 'a'　とダブルコマンドで新規作成を行います。
	cwファイラー画面で file-name.def 上でEnterキーで設計画面を開きます。
      
  説明
	s: ラベル、テキストボックス、グリッドの左上を指定します。
	e: グリッドの右下を指定します。
	E: テキストボックスの右下を指定します。
	^E: ラベルの右下を指定します。
	K_IC(Insert-key):DB_TITLE(テーブルの列名)を入力します。
	r: 実行時指定した画面設計ファイルを読み込みます。
	c: サブフォーム定義ファイルを書き込みます。(DB設計があれば.pgcを生成する)
	W: 画面設計ファイルを書き込みます。
	^W: 画面設計ファイルを変換して(_定義ファイル名.def.c)に書き込みます。
	S: コピーを開始する位置を決定します。
	C: コピーを終了する位置を決定します。
	P: ペーストを開始する位置を決定します。
	ESC: ECPキーで直前の開始コマンドのマークを元に戻します。
	.: . の文字で画面を戻します。
	-(L):(ｌ)左詰、(ｔ)テキスト型、(e）編集可能の属性を設定します。
	B: (r)右詰、(B）BOOL型、(e)編集可能の属性を設定します。
	D: (r)右詰、(d）DATE型、(e)編集可能の属性を設定します。
	F: (r)右詰、(F）DOUBLE型、(e)編集可能の属性を設定します。
	R: (r)右詰、($）通貨型、(e)編集可能の属性を設定します。
	^R: (r)右詰、(ｎ)Numeric型、（e)編集可能の属性を設定します
	T: (l)左詰、(t）TEXT型、(e)編集可能の属性を設定します。
	O: (l)左詰、(t）TEXT型、(o)編集不可の属性を設定します。
	K: (p)ステップの設定を行います
	^K: (k)スキップの設定を行います
	j: カーソルを下に移動します。矢印キーでも可能です。
	k: カーソルを上に移動します。矢印キーでも可能です。
	h: カーソルを左に移動します。矢印キーでも可能です。
	l: カーソルを右に移動します。矢印キーでも可能です。
    
	※基本的に編集属性が設定されます。編集属性をNONEにしたい場合は生成された定義
	  ファイルを手作業で修正してください。EDIT --> NONE
	※新しく追加されたDB_TITLEの項目は{}の中に入力用ウインドウで英数字記述します。
	  DB_TITLEは複数行に渡って記述することが出来ます。
	  例：{Schedule_name:16}{Cmd_line:256}{Update_date}
	  ：と右に数字が無い場合はセルの長さが既定値となります。
	※ECPGソースにおいて、DATE型は基本的にchar型として操作されます。

  多言語化対応
    日本語と英語

  診断
      

  例
	libsubformHTML/yubin.defを参考にしてください。

  参照
	ncurses(5),ecpg(1)
      
  バグ

      
  著者
	Shigeki Ono Copyright(c) 2010/05/24(versoin 2.1.4)

      
  標準準拠


  作者後書
	本プログラムはCMSによって管理されています。
	
*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*/

#include "../ftx/ftx.h"
#include "../ftx/filer.h"
//#include "ase.h"

AseEditor *aseeditor;
//AseLocalFiler *asefiler;

static char ehelpbuff[26][80] =
	{" s: appoint it on a label, textbox, the left of the grid.\n",
	" e: end pont of grid position.\n",
	" E: end pont of textbox position.\n",
	"^E: end pont of label position.\n",
	" K_IC(Insert-key):DB_TITLE(table-colume-name) input.\n",
	" r: read of screen-file.\n",
	" c: create to screen-define file.\n",
	" W: write to screen file.\n",
	"^W: write to _filename.def.c-source-file.\n",
	" S: start point of copy position.\n",
	" C: end point of copy position.\n",
	" P: end point of of paste position.\n",
	"ESC: return the mark of a start command just before that with an ESC key.\n",
	" .: return of (.) charcter for edit area.\n",
	" -(L): set of (l t e p)<--->attributes.\n",
	" B: set of (B d e p)attributes.\n",
	" D: set of (D r e p)attributes.\n",
	" F: set of (F r e p)attributes.\n",
	" R: set of (r $ e p)attributes.\n",
	"^R: set of (r n e p)attributes.\n",
	" K: set of (l t e k)attributes.\n",
	"^K: set of (r n e k)attributes.\n",
	"  ('r' - RIGHT 'l' - LEFT 'e' - EDIT 'p/k' - STEP/SKIP)\n",
	"  ('t' -> TEXT 'n' -> NUMERIC '$' -> CURRENCY)\n",
	" j:cursor down k:cursor up h:cursor left l:cursor right\n",
	" "
	};

static char jhelpbuff[29][128] =
	{" s: ラベル、テキストボックス、グリッドの左上を指定します。",
	" e: グリッドの右下を指定します。",
	" E: テキストボックスの右下を指定します。",
	" ^E: ラベルの右下を指定します。",
	" K_IC(Insert-key):DB_TITLE(テーブルの列名)を入力します。",
	" r: 実行時指定した画面設計ファイルを読み込みます。",
	" c: サブフォーム定義ファイルを書き込みます。(DB設計があれば.pgcを生成する)",
	" W: 画面設計ファイルを書き込みます。",
	" ^W: 画面設計ファイルを変換して(_定義ファイル名.def.c)に書き込みます。",
	" S: コピーを開始する位置を決定します。",
	" C: コピーを終了する位置を決定します。",
	" P: ペーストを開始する位置を決定します。",
	" ESC: ECPキーで直前の開始コマンドのマークを元に戻します。",
	" .: . の文字で画面を戻します。",
	" -:(l)左詰,(t)テキスト型,(e)編集可能の属性を設定します。",
	" B: (r)右詰、(B）BOOL型、(e)編集可能の属性を設定します。",
	" D: (r)右詰、(d）DATE型、(e)編集可能の属性を設定します。",
	" F: (r)右詰、(F）DOUBLE型、(e)編集可能の属性を設定します。",
	" R:(r)右詰,($)通貨型,(e)編集可能の属性を設定します。",
	" ^R:(r)右詰,(n)Numeric型,(e)編集可能の属性を設定します",
	" T: (l)左詰、(t）TEXT型、(o)編集可能の属性を設定します。",
	" O: (l)左詰、(t）TEXT型、(o)編集不可の属性を設定します。",
	" K: (p)ステップの設定を行います",
	" ^K: (k)スキップの設定を行います",
	" j: カーソルを下に移動します。矢印キーでも可能です。",
	" k: カーソルを上に移動します。矢印キーでも可能です。",
	" h: カーソルを左に移動します。矢印キーでも可能です。",
	" l: カーソルを右に移動します。矢印キーでも可能",
	" "
	};

	int fulldisplay;
	int readflg;
	int nonopt;
	int dbtitle;

	static int text_num = 0;

	static int NUMITEM = 0;
	static int KEYCOUNT = 0;
	static int up,ins,del;
	static int Menu = 0;

char tmpbuff[128];

/************************************************************************/
/* NAME      :void helpmsg()*/ 
/* FUNCTION  :ヘルプを表示する*/ 
/*            未使用*/ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
static void ehelpmsg(int x,int y)
{
	WINDOW *pvs;
//	int ch;
	int i;
	pvs = newwin(27,78,y,x);

	wattron(pvs,A_REVERSE);
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,78,"+");
	mvwprintw(pvs,27,0,"+");
	mvwprintw(pvs,27,78,"+");

	noecho();
	for(i=0;i<23;i++)
		mvwprintw(pvs,i,1,"%s",ehelpbuff[i]);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

/************************************************************************/
/* NAME      :void jhelpmsg()*/ 
/* FUNCTION  :ヘルプを表示する*/ 
/*            未使用*/ 
/*            */ 
/*            */ 
/* RETURN    :なし*/
/************************************************************************/
static void jhelpmsg(int x,int y)
{
	WINDOW *pvs;
//	int ch;
	int i;
	pvs = newwin(24,78,y,x);

	wattron(pvs,A_REVERSE);
	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,78,"+");
	mvwprintw(pvs,24,0,"+");
	mvwprintw(pvs,24,78,"+");

	noecho();
	for(i=0;i<24;i++)
		mvwprintw(pvs,i,1,"%s",jhelpbuff[i]);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

static void asehelp(void )
{
	printf("Usage: ase -c[1 - 256] -l[3 - 78] [MAX screen define file name]\n");
	printf("       ase -a [screen define file name] maximum display\n");
	printf("       ase -e -v -x -s for 80/24-EGA and 97/29-VGA 125/37XGA S-XGA\n");
	printf("Command Reference\n");
	printf("  s: starting position.\n");
	printf("  e: end of grid position.\n");
	printf("  E: end of textbox position.\n");
	printf(" ^E: end of label position.\n");
	printf("  K_IC(Insert-key):DB_TITLE(table-colume-name) input.\n");
	printf("  r: read of screen file.\n");
	printf("  c: create of define file.\n");
	printf("  i: input charactor.\n");
	printf("  W: wite of screen file.\n");
	printf(" ^W: wite of def.c-source file.\n");
	printf("  S: start of Copy position.\n");
	printf("  C: Copy ending position.\n");
	printf("  P: starting of Paste position.\n");
	printf("ESC: undo retuning start position.\n");
	printf("  .: set of ...... strings for edit area.\n");
	printf("  -(L): set of (l t e p)<--->attributes.\n");
	printf("  D: set of (r d e p)attributes.\n");
	printf("  R: set of (r $ e p)attributes.\n");
	printf(" ^R: set of (r n e p)attributes.\n");
	printf("  K: set of (l t e k)attributes.\n");
	printf(" ^K: set of (r n e k)attributes.\n");
	printf("   ('r' -> RIGHT 'l' -> LEFT 'e' -> EDIT 'p/k' -> STEP/SKIP)\n");
	printf("   ('t' -> TEXT 'n' -> NUMERIC '$' -> CURRENCY)\n");
	printf("  j: cursor down.\n");
	printf("  k: cursor up.\n");
	printf("  h: cursor left.\n");
	printf("  l: cursor right.\n");
}

static int popmsg(int x,int y,char *buff)
{
	WINDOW *pvs;
//	int i;
	int ch;
	pvs = newwin(6,48,y,x);
	box(pvs,ACS_VLINE,ACS_HLINE);
	noecho();
	for(;;)
	{
		wattron(pvs,A_REVERSE);
		mvwprintw(pvs,0,1,"============ Filer Window Message ============");
		wattroff(pvs,A_REVERSE);
		mvwprintw(pvs,0,0,"+");
		mvwprintw(pvs,0,47,"+");
		mvwprintw(pvs,5,0,"+");
		mvwprintw(pvs,5,47,"+");

		mvwprintw(pvs,2,4,"%s",buff);
		mvwprintw(pvs,4,30,"Y or N :");
		wrefresh(pvs);
		ch = wgetch(pvs);
		switch(ch)
		{
		case 'y': case 'Y':
			delwin(pvs);
			return(1);
		case 'n': case 'N':
			delwin(pvs);
			return(0);
		}
	}
}

void *input_window(int x,int y,char *buff,char *msg)
{
	WINDOW *mvs;
	mvs = newwin(5,64,y,x);
	wattroff(mvs,A_REVERSE);
	box(mvs,ACS_VLINE,ACS_HLINE);
	mvwprintw(mvs,4,0,"+");
	mvwprintw(mvs,4,63,"+");
	mvwprintw(mvs,1,4,msg);
	wattron(mvs,A_REVERSE);
	mvwprintw(mvs,0,0,"                     Input  Window                              ");

	mvwprintw(mvs,2,4,"                                                     ");
	wrefresh(mvs);

	mvwprintw(mvs,2,4,"                                                     ");
	echo();
	nocbreak();
	nl();

	mvwgetstr(mvs,2,4,buff);

	noecho();
	cbreak();

	wrefresh(mvs);

	wattroff(mvs,A_REVERSE);
	noecho();
	delwin(mvs);
	return(NULL);
}

/************************************************************************/
int AseEditor::convlabel(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
//	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_title[512][138];
//	char cell_fieldtype[512][15];
//	int tmp = 99;

	sprintf(tmpbuff1,"_%s",f);
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

//	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;

	fprintf(fp,"#Automatic Subform Editor v3.0.0\n");

	fprintf(fp,"COLS=%d\n",xcol);
	fprintf(fp,"ROWS=%d\n",xrow);

	memset(cell_length,'\n',sizeof(cell_length));
	fprintf(fp,"LABEL_LENGTH=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"LABEL_ALIGN=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				sprintf(cell_align[n],"%s","LEFT");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","LEFT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","RIGHT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","RIGHT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","LEFT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","CENTER");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","RIGHT");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				if(cell_align[n][0] != '-')
					sprintf(cell_align[n],"LEFT");
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
			//	sx = j;
			//	sy = i;
				goto skip;
			}
		}
	}
	skip:

	flg = 0;
	k = m = n = 0;
	memset(cell_title,' ',sizeof(cell_title));
	fprintf(fp,"LABEL_TEXT=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				sprintf(cell_title[n],"Label_%d",n+1);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				if(cell_title[n][0] != 'L')
					sprintf(cell_title[n],"%s%d","Label_",n+1);
				fprintf(fp,"%s,",cell_title[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"LABEL_X=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",j+1);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"LABEL_Y=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",i);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//2009.08.07 Bug
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	fclose(fp);
	return(0);
}

int AseEditor::convlabel2(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
//	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_title[512][138];
//	char cell_fieldtype[512][15];
//	int tmp = 99;

	sprintf(tmpbuff1,"_%s.c",f);
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

//	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;

	fprintf(fp,"//Automatic Subform Editor v3.0.0\n");
	fprintf(fp,"//以下の関数は定義ファイルを利用しないインターフェースで利用可能\n");
	fprintf(fp,"//他のソースファイルの initscr() 以下の行に挿入して利用可能\n");

	fprintf(fp,"int %s(void)\n",f);
	fprintf(fp,"{\n");

//	fprintf(fp,"COLS=%d\n",xcol);
//	fprintf(fp,"ROWS=%d\n",xrow);
	fprintf(fp,"	static int xcol = %d;\n",xcol);
	fprintf(fp,"	static int rows = %d;\n\n",xrow);

	memset(cell_length,'\n',sizeof(cell_length));
	fprintf(fp,"//for label\n");
	fprintf(fp,"	static int label_length[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	fprintf(fp,"	static int label_no[] = {");
	for(i=0;i<n;i++)
	{
		fprintf(fp,"%d,",i);
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"	static int label_align[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				sprintf(cell_align[n],"%s","2");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				if(cell_align[n][0] != '-')
					sprintf(cell_align[n],"2");
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
			//	sx = j;
			//	sy = i;
				goto skip;
			}
		}
	}
	skip:

	flg = 0;
	memset(cell_title,' ',sizeof(cell_title));
	fprintf(fp,"	static char *label_text[%d][128] = {",n+1);

	k = m = n = 0;
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				sprintf(cell_title[n],"Label_%d",n+1);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				if(cell_title[n][0] != 'L')
					sprintf(cell_title[n],"%s%d","Label_",n+1);
				fprintf(fp,"\"%s\",",cell_title[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"\"\"};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int label_x[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",j+1);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int label_y[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",i);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//2009.08.07 Bug
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");
	fclose(fp);
	return(0);
}

int AseEditor::convlabel3(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
//	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_title[512][138];
//	char cell_fieldtype[512][15];
//	int tmp = 99;

	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

//	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;

//	fprintf(fp,"COLS=%d\n",xcol);
//	fprintf(fp,"ROWS=%d\n",xrow);
	fprintf(fp,"	static int xcol = %d;\n",xcol);
	fprintf(fp,"	static int rows = %d;\n\n",xrow);

	memset(cell_length,'\n',sizeof(cell_length));
	fprintf(fp,"//for label\n");
	fprintf(fp,"	static int label_length[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	fprintf(fp,"	static int label_no[] = {");
	for(i=0;i<n;i++)
	{
		fprintf(fp,"%d,",i);
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"	static int label_align[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				sprintf(cell_align[n],"%s","2");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				if(cell_align[n][0] != '-')
					sprintf(cell_align[n],"2");
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
			//	sx = j;
			//	sy = i;
				goto skip;
			}
		}
	}
	skip:

	flg = 0;
	memset(cell_title,' ',sizeof(cell_title));
	fprintf(fp,"	static char *label_text[%d][128] = {",n+1);

	k = m = n = 0;
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				sprintf(cell_title[n],"Label_%d",n+1);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
				if(cell_title[n][0] != 'L')
					sprintf(cell_title[n],"%s%d","Label_",n+1);
				fprintf(fp,"\"%s\",",cell_title[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"\"\"};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int label_x[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",j+1);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int label_y[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"("))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",i);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//2009.08.07 Bug
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,")"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");
	fclose(fp);
	return(0);
}


int AseEditor::convtextbox(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
//	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_action[512][12];
//	char cell_fieldtype[512][15];
//	char cell_skipstep[512][12];
//	int tmp = 99;
	char *dot;
	
	if((dot = strchr(f,'.')) != (char *)NULL)
	{
		*dot = '\0';
	}

	sprintf(tmpbuff1,"%s.css",f);
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}
	fprintf(fp,"table.%s {\n",f);
	fprintf(fp,"border: solid 1px #000000;\n");
	fprintf(fp,"border-collapse: separate;\n");
	fprintf(fp,"}\n");
	fprintf(fp,"td.%s {border: solid 1px #000000; empty-cells: show;}\n",f);
	fclose(fp);

	sprintf(tmpbuff1,"%s_Fetch.css",f);
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

//	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;

	memset(cell_length,'\n',sizeof(cell_length));
	fprintf(fp,"/*	TEXTBOX_LENGTH=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d	*/\n",0);

	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"/*TEXTBOX_ALIGN*/\n");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:left}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:right}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:right}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:left}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:center}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:right}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:right}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:right}");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:right}");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				//2009.09.04
				if(strlen(cell_align[n]) == 0)
				{
					sprintf(cell_align[n],".field%02d %s\n",n,"{text-align:left}");
				}
				fprintf(fp,"%s",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
//	fprintf(fp,"%d\n",0);


	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
			//	sx = j;
			//	sy = i;
				goto skip;
			}
		}
	}
	skip:

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_action[i],' ',sizeof(cell_action[i]));

/*
	fprintf(fp,"TEXTBOX_ACTION=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				sprintf(cell_action[n],"%s","EDIT");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","EDIT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"e")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","EDIT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"o")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","NONE");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_action[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_skipstep[i],' ',sizeof(cell_skipstep[i]));
	fprintf(fp,"TEXTBOX_SKIP_STEP=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
			//Bug.2001/01/08
				sprintf(cell_skipstep[n],"%s","STEP");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","STEP");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","STEP");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","SKIP");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_skipstep[n]);
				k++;
				n++;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_fieldtype[i],' ',sizeof(cell_fieldtype[i]));
	fprintf(fp,"TEXTBOX_FIELD_TYPE=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				sprintf(cell_fieldtype[n],"%s","TEXT");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","TEXT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","TEXT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","DATE");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","NUMERIC");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","CURRENCY");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","BOOL");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","DOUBLE");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_fieldtype[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"TEXTBOX_X=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",j);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"TEXTBOX_Y=");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",i);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);
*/

	fclose(fp);
	return(0);
}

int AseEditor::convtextbox2(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
//	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_action[512][12];
	char cell_fieldtype[512][15];
	char cell_skipstep[512][12];
//	int tmp = 99;

	sprintf(tmpbuff1,"_%s.c",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

//	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;

	memset(cell_length,'\n',sizeof(cell_length));
	fprintf(fp,"\n");
	fprintf(fp,"//.def ファイルで画面上で定義不可能な長いカラムは実際のDBのカラム長に合わせてここで変更してください。\n");
	fprintf(fp,"//for textbox\n");
	fprintf(fp,"	static int textbox_length[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	fprintf(fp,"	static int textbox_no[] = {");
	for(i=0;i<n;i++)
	{
		fprintf(fp,"%d,",i);
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"	static int textbox_align[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				//2009.09.04
				if(strlen(cell_align[n]) == 0)
				{
					sprintf(cell_align[n],"%s","2");
				}
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");


	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
			//	sx = j;
			//	sy = i;
				goto skip;
			}
		}
	}
	skip:

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_action[i],' ',sizeof(cell_action[i]));
	fprintf(fp,"	static int textbox_action[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				sprintf(cell_action[n],"%s","0");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"e")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"o")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_action[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_skipstep[i],' ',sizeof(cell_skipstep[i]));
	fprintf(fp,"	static int textbox_skipstep[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
			//Bug.2001/01/08
				sprintf(cell_skipstep[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","0");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_skipstep[n]);
				k++;
				n++;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_fieldtype[i],' ',sizeof(cell_fieldtype[i]));
	fprintf(fp,"	static int textbox_field[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				sprintf(cell_fieldtype[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","5");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","4");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","7");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_fieldtype[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int textbox_x[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",j);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int textbox_y[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",i);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");
	fprintf(fp,"\n\n");
	//2010.03.14
	text_num = n;

	fclose(fp);
	return(0);
}

int AseEditor::convtextbox3(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
//	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_action[512][12];
	char cell_fieldtype[512][15];
	char cell_skipstep[512][12];
//	int tmp = 99;

	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

//	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;

	memset(cell_length,'\n',sizeof(cell_length));
	fprintf(fp,"\n");
	fprintf(fp,"//.def ファイルで画面上で定義不可能な長いカラムは実際のDBのカラム長に合わせてここで変更してください。\n");
	fprintf(fp,"//for textbox\n");
	fprintf(fp,"	static int textbox_length[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	fprintf(fp,"	static int textbox_no[] = {");
	for(i=0;i<n;i++)
	{
		fprintf(fp,"%d,",i);
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"	static int textbox_align[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				//2009.09.04
				if(strlen(cell_align[n]) == 0)
				{
					sprintf(cell_align[n],"%s","2");
				}
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");


	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
			//	sx = j;
			//	sy = i;
				goto skip;
			}
		}
	}
	skip:

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_action[i],' ',sizeof(cell_action[i]));
	fprintf(fp,"	static int textbox_action[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				sprintf(cell_action[n],"%s","0");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"e")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"o")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_action[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_skipstep[i],' ',sizeof(cell_skipstep[i]));
	fprintf(fp,"	static int textbox_skipstep[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
			//Bug.2001/01/08
				sprintf(cell_skipstep[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","0");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_skipstep[n]);
				k++;
				n++;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_fieldtype[i],' ',sizeof(cell_fieldtype[i]));
	fprintf(fp,"	static int textbox_field[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				sprintf(cell_fieldtype[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","5");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","4");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","7");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
				fprintf(fp,"%s,",cell_fieldtype[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int textbox_x[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",j);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	fprintf(fp,"	static int textbox_y[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"<"))
			{
				flg = 1;
				k++;
				fprintf(fp,"%d,",i);
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,">"))
			{
			//	ex = j;
			//	ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");
	fprintf(fp,"\n\n");
	//2010.03.14
	text_num = n;

	fclose(fp);
	return(0);
}

int AseEditor::convgrid(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_action[512][12];
	char cell_fieldtype[512][15];
	char cell_skipstep[512][12];
	char cell_title[512][138];
	char *coln;
	int tmp = 99;

	sprintf(tmpbuff1,"_%s",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	for(i=0;i<512;i++)
		pgc[i].keyflg = 0;

	KEYCOUNT = 0;

	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = 0;
	l = 0;


	memset(cell_length,0,sizeof(cell_length));
	fprintf(fp,"CELL_LENGTH=");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"CELL_ALIGN=");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_align[n],"%s","LEFT");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","LEFT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","RIGHT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","RIGHT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","LEFT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","CENTER");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","RIGHT");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"%d\n",0);


	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sx = j;
				sy = i;
				goto skip;
			}
		}
	}
	skip:

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_action[i],' ',sizeof(cell_action[i]));
	fprintf(fp,"CELL_ACTION=");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_action[n],"%s","EDIT");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","EDIT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"e")) && flg == 1)
			{
			//2009.08.07 Bug?
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				sprintf(cell_action[n],"%s","EDIT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"o")) && flg == 1)
			{
			//2009.08.07 Bug?
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				sprintf(cell_action[n],"%s","NONE");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_action[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_fieldtype[i],' ',sizeof(cell_fieldtype[i]));
	fprintf(fp,"GRID_FIELD_TYPE=");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(cell_fieldtype[n],"%s","NUMERIC");
				else
					sprintf(cell_fieldtype[n],"%s","TEXT");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","TEXT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","TEXT");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","DATE");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","NUMERIC");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","CURRENCY");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","BOOL");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","DOUBLE");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_fieldtype[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_skipstep[i],' ',sizeof(cell_skipstep[i]));
	fprintf(fp,"GRID_SKIP_STEP=");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_skipstep[n],"%s","STEP");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","STEP");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","STEP");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","SKIP");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_skipstep[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_title[i],' ',sizeof(cell_title[i]));
	fprintf(fp,"GRID_TITLES=");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				sprintf(cell_title[n],"Grid_%d",n+1);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(cell_title[n][0] != 'G')
					sprintf(cell_title[n],"%s%d","Grid_",n+1);
				fprintf(fp,"%s,",cell_title[n]);
				sprintf(pgc[n].cell_title,"%s",cell_title[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"%d\n",0);

	dbtitle = 0;
	flg = 0;
	k = n = 0;
	for(i=0;i<512;i++)
		memset(cell_title[i],' ',sizeof(cell_title[i]));
	fprintf(fp,"DB_TITLES=");
	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"{"))
			{
				flg = 1;
				continue;
			}
			if((cp[j][i].s[0] >= 0x30 && cp[j][i].s[0] <= 0x7a) && flg == 1)
			{
				cell_title[n][k] = cp[j][i].s[0];
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"}"))
			{
				dbtitle = 1;
				cell_title[n][k] = '\0';
				if((coln = strchr(cell_title[n],':')) != (char *)NULL)
				{
					coln++;
					cell_length[n] = atoi(coln);
					*(coln-1) = '\0';
					fprintf(fp,"%s,",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
				}
				else if((coln = strchr(cell_title[n],'@')) != (char *)NULL)
				{
					coln++;
					cell_length[n] = atoi(coln);
					*(coln-1) = '\0';
					fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
					pgc[n].keyflg = 1;
					KEYCOUNT += 1;
				}
				else
				{
					fprintf(fp,"%s,",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
				}
				sprintf(pgc[n].cell_title,"%s",cell_title[n]);
				k = 0;
				n++;
				flg = 0;
			}
		}
	}
	fprintf(fp,"%d\n",0);
	NUMITEM = n - 1;

	flg = 0;
	k = m = n = 0;
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				ex = j;
				ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"GRID_SX=%d\n",sx);
	fprintf(fp,"GRID_EX=%d\n",ex-1);
	fprintf(fp,"GRID_SY=%d\n",sy);
	fprintf(fp,"GRID_EY=%d\n",ey);

	fclose(fp);
	return(0);
}

int AseEditor::convgrid2(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_action[512][12];
	char cell_fieldtype[512][15];
	char cell_skipstep[512][12];
	char cell_title[512][138];
	char *coln;
	int tmp = 99;

	int nn;	//for def.c

/*
	sprintf(tmpbuff1,"_%s.c",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}
*/

	for(i=0;i<512;i++)
		pgc[i].keyflg = 0;

	KEYCOUNT = 0;

	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = nn = 0;
	l = 0;


	memset(cell_length,0,sizeof(cell_length));
//	fprintf(fp,"//for grid\n");
//	fprintf(fp,"	static int cell_length[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				cell_length[n] = l;
			//	fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				nn++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
//	fprintf(fp,"0};\n");

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
//	fprintf(fp,"	static int cell_align[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_align[n],"%s","2");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
			//	fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
//	fprintf(fp,"0};\n");


	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sx = j;
				sy = i;
				goto skip;
			}
		}
	}
	skip:

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_action[i],' ',sizeof(cell_action[i]));
//	fprintf(fp,"	static int cell_action[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_action[n],"%s","0");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"e")) && flg == 1)
			{
			//2009.08.07 Bug?
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"o")) && flg == 1)
			{
			//2009.08.07
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				sprintf(cell_action[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
			//	fprintf(fp,"%s,",cell_action[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
//	fprintf(fp,"0};\n");

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_fieldtype[i],' ',sizeof(cell_fieldtype[i]));
//	fprintf(fp,"	static int grid_field[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(cell_fieldtype[n],"%s","2");
				else
					sprintf(cell_fieldtype[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","5");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","4");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","7");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
			//	fprintf(fp,"%s,",cell_fieldtype[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
//	fprintf(fp,"0};\n");

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_skipstep[i],' ',sizeof(cell_skipstep[i]));
//	fprintf(fp,"	static int grid_skipstep[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_skipstep[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","0");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
			//	fprintf(fp,"%s,",cell_skipstep[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
//	fprintf(fp,"0};\n");

//	fprintf(fp,"	char *grid_titles[%d][128] = {", n+1);

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_title[i],' ',sizeof(cell_title[i]));

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				sprintf(cell_title[n],"Grid_%d",n+1);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(cell_title[n][0] != 'G')
					sprintf(cell_title[n],"%s%d","Grid_",n+1);
			//	fprintf(fp,"\"%s\",",cell_title[n]);
				sprintf(pgc[n].cell_title,"%s",cell_title[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
//	fprintf(fp,"\"\"};\n");

//	fprintf(fp,"//	static char *db_titles[%d][128] = {", n+1);

	dbtitle = 0;
	flg = 0;
	k = n = 0;
	for(i=0;i<512;i++)
		memset(cell_title[i],' ',sizeof(cell_title[i]));
	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"{"))
			{
				flg = 1;
				continue;
			}
			if((cp[j][i].s[0] >= 0x30 && cp[j][i].s[0] <= 0x7a) && flg == 1)
			{
				cell_title[n][k] = cp[j][i].s[0];
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"}"))
			{
				dbtitle = 1;
				cell_title[n][k] = '\0';
				if((coln = strchr(cell_title[n],':')) != (char *)NULL)
				{
					coln++;
					cell_length[n] = atoi(coln);
					*(coln-1) = '\0';
				//	fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
				}
				else if((coln = strchr(cell_title[n],'@')) != (char *)NULL)
				{
					coln++;
					cell_length[n] = atoi(coln);
					*(coln-1) = '\0';
				//	fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
					pgc[n].keyflg = 1;
					KEYCOUNT += 1;
				}
				else
				{
				//	fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
				}
				sprintf(pgc[n].cell_title,"%s",cell_title[n]);
				k = 0;
				n++;
				flg = 0;
			}
		}
	}
//	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				ex = j;
				ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
/*
	fprintf(fp,"	static int grid_sx = %d;\n",sx);
	fprintf(fp,"	static int grid_ex = %d;\n",ex-1);
	fprintf(fp,"	static int grid_sy = %d;\n",sy);
	fprintf(fp,"	static int grid_ey = %d;\n",ey);

	fprintf(fp,"\n");
	fprintf(fp,"	static int maxtext;\n");
	fprintf(fp,"	static int no = 0;\n\n");

	fprintf(fp,"	char **gt;\n");
	fprintf(fp,"	char **lt;\n\n");


	fprintf(fp,"	gt = (char **)&grid_titles;\n\n");
	fprintf(fp,"	xcol = MakeWsubForm(no,xcol,rows,0,2,grid_sx,grid_sy,grid_ex,grid_ey,cell_length,cell_align,cell_action,grid_field,grid_skipstep,gt,%d);\n",nn);

	fprintf(fp,"\n");
	fprintf(fp,"	lt = (char **)&label_text;\n\n");


	fprintf(fp,"	maxtext = MakeTextBox(no,0,2,xcol,rows,label_no,lt,label_x,label_y,label_length,textbox_no,textbox_x,textbox_y,textbox_length,textbox_align,textbox_action,textbox_field,textbox_skipstep, %d);\n", text_num);
	fprintf(fp,"\n}\n");

	fclose(fp);
*/
	return(0);
}

//HTMLを生成するフォーム設計を含んだ関数を生成する。(MakeWsubFormHTML及び MakeTextBoxHTML)
int AseEditor::convgrid3(WINDOW *vs,int xcol, int xrow, char *f,char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int sx,sy,ex,ey;
	int flg;
	int cell_length[512];
	char cell_align[512][12];
	char cell_action[512][12];
	char cell_fieldtype[512][15];
	char cell_skipstep[512][12];
	char cell_title[512][138];
	char *coln;
	int tmp = 99;

	int nn;	//for HTML

	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	for(i=0;i<512;i++)
		pgc[i].keyflg = 0;

	KEYCOUNT = 0;

	sx = sy = ex = ey = 0;

	flg = 0;
	k = m = n = nn = 0;
	l = 0;

	memset(cell_length,0,sizeof(cell_length));
	fprintf(fp,"//for grid\n");
	fprintf(fp,"	static int cell_length[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				cell_length[n] = l;
				l++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				cell_length[n] = l;
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				cell_length[n] = l;
				fprintf(fp,"%d,",cell_length[n]);
				k++;
				n++;
				nn++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"0};\n");

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	memset(cell_align,0,sizeof(cell_align));
	fprintf(fp,"	static int cell_align[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_align[n],"%s","2");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				wrefresh(pt2[j][i].vs);
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"r")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"l")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"c")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_align[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_align[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"0};\n");


	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sx = j;
				sy = i;
				goto skip;
			}
		}
	}
	skip:

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_action[i],' ',sizeof(cell_action[i]));
	fprintf(fp,"	static int cell_action[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_action[n],"%s","0");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"e")) && flg == 1)
			{
			//2009.08.07 Bug?
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				sprintf(cell_action[n],"%s","0");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"o")) && flg == 1)
			{
			//2009.08.07
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				sprintf(cell_action[n],"%s","1");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_action[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"0};\n");

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_fieldtype[i],' ',sizeof(cell_fieldtype[i]));
	fprintf(fp,"	static int grid_field[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(cell_fieldtype[n],"%s","2");
				else
					sprintf(cell_fieldtype[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","5");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","2");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","4");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","3");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(cell_fieldtype[n],"%s","7");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_fieldtype[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"0};\n");

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_skipstep[i],' ',sizeof(cell_skipstep[i]));
	fprintf(fp,"	static int grid_skipstep[] = {");
	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				sprintf(cell_skipstep[n],"%s","1");
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","1");
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(cell_skipstep[n],"%s","0");
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				fprintf(fp,"%s,",cell_skipstep[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"0};\n");

	fprintf(fp,"	char *grid_titles[%d][128] = {", n+1);

	tmp = 99;
	flg = 0;
	k = m = n = 0;
	for(i=0;i<512;i++)
		memset(cell_title[i],' ',sizeof(cell_title[i]));

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
				sprintf(cell_title[n],"Grid_%d",n+1);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(cell_title[n][0] != 'G')
					sprintf(cell_title[n],"%s%d","Grid_",n+1);
				fprintf(fp,"\"%s\",",cell_title[n]);
				sprintf(pgc[n].cell_title,"%s",cell_title[n]);
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"\"\"};\n");

	fprintf(fp,"	static char *db_titles[%d][128] = {", n+1);

	dbtitle = 0;
	flg = 0;
	k = n = 0;
	for(i=0;i<512;i++)
		memset(cell_title[i],' ',sizeof(cell_title[i]));
	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"{"))
			{
				flg = 1;
				continue;
			}
			if((cp[j][i].s[0] >= 0x30 && cp[j][i].s[0] <= 0x7a) && flg == 1)
			{
				cell_title[n][k] = cp[j][i].s[0];
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"}"))
			{
				dbtitle = 1;
				cell_title[n][k] = '\0';
				if((coln = strchr(cell_title[n],':')) != (char *)NULL)
				{
					coln++;
					cell_length[n] = atoi(coln);
					*(coln-1) = '\0';
					fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
				}
				else if((coln = strchr(cell_title[n],'@')) != (char *)NULL)
				{
					coln++;
					cell_length[n] = atoi(coln);
					*(coln-1) = '\0';
					fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
					pgc[n].keyflg = 1;
					KEYCOUNT += 1;
				}
				else
				{
					fprintf(fp,"\"%s\",",cell_title[n]);
					pgc[n].cell_length = cell_length[n];
				}
				sprintf(pgc[n].cell_title,"%s",cell_title[n]);
				k = 0;
				n++;
				flg = 0;
			}
		}
	}
	fprintf(fp,"0};\n");

	flg = 0;
	k = m = n = 0;
	for(i=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if(((!strcmp(cp[j][i].s,"-")) || 
				(!strcmp(cp[j][i].s,"e")) ||
				(!strcmp(cp[j][i].s,"o")) ||
				(!strcmp(cp[j][i].s,"r")) ||
				(!strcmp(cp[j][i].s,"l")) ||
				(!strcmp(cp[j][i].s,"t")) ||
				(!strcmp(cp[j][i].s,"d")) ||
				(!strcmp(cp[j][i].s,"p")) ||
				(!strcmp(cp[j][i].s,"k")) ||
				(!strcmp(cp[j][i].s,"$")) ||
				(!strcmp(cp[j][i].s,"B")) ||
				(!strcmp(cp[j][i].s,"F")) ||
				(!strcmp(cp[j][i].s,"n"))) 
				&& flg == 1)
			{
			//	sprintf(cp[j][i].s," ");
				mvwprintw(pt2[j][i].vs,0,0,"%s"," ");
				wrefresh(pt2[j][i].vs);
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				ex = j;
				ey = i;
				k++;
				n++;
				l = 0;
				flg = 0;
			}
		}
	}
	fprintf(fp,"	static int grid_sx = %d;\n",sx);
	fprintf(fp,"	static int grid_ex = %d;\n",ex-1);
	fprintf(fp,"	static int grid_sy = %d;\n",sy);
	fprintf(fp,"	static int grid_ey = %d;\n",ey);

	fprintf(fp,"\n");
	fprintf(fp,"	static int maxtext;\n");
	fprintf(fp,"	static int no = 0;\n\n");

	fprintf(fp,"	char **gt;\n");
	fprintf(fp,"	char **lt;\n\n");


	fprintf(fp,"	gt = (char **)&grid_titles;\n\n");
	fprintf(fp,"	xcol = MakeWsubFormHTML(no,xcol,rows,0,2,grid_sx,grid_sy,grid_ex,grid_ey,cell_length,cell_align,cell_action,grid_field,grid_skipstep,gt,%d);\n",nn);

	fprintf(fp,"\n");
	fprintf(fp,"	lt = (char **)&label_text;\n\n");


	fprintf(fp,"//	以下の関数は<SELECT>でコンボボックスを作成する場合、一つのCGIで重複して利用出来ませんのでどちらかを削除してください。\n");
	fprintf(fp,"	maxtext = MakeTextBoxHTML(no,0,2,xcol,rows,label_no,lt,label_x,label_y,label_length,textbox_no,textbox_x,textbox_y,textbox_length,textbox_align,textbox_action,textbox_field,textbox_skipstep, %d);\n", text_num);
	fprintf(fp,"\n");

	fclose(fp);
	return(0);
}

int AseEditor::putecpg(WINDOW *vs,int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int flg;
	int tmp = 99;

	sprintf(tmpbuff1,"%s.pgc",f);
	if(stat(tmpbuff1,fptr) == 0)
	{
		sprintf(tmpbuff2,"%s が存在します。上書きしますがよろしいですか？",tmpbuff1);
		if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff2) == 0)
		{
			return(0);
		}
	}
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

	fprintf(fp,"#include \"wsubformHTML.h\"	//サブフォーム専用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"#include \"fcgi_stdio.h\"	//FastCGI用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"\n");
	fprintf(fp,"extern char gridtitles[MAX_POS][MAX_LEN];	//wsubformHTMLが利用するgridのタイトル。\n");
	fprintf(fp,"\n");
	fprintf(fp,"extern TextBox	 *begin;	//textboxで使用する連鎖ポインタの開始位置\n");
	fprintf(fp,"extern TextBox	 *tp;	//textboxで使用する連鎖ポインタ\n");
	fprintf(fp,"\n");
	fprintf(fp,"typedef struct stat Dir;	//ファイル操作用\n");
	fprintf(fp,"static Dir dirptr;\n");
	fprintf(fp,"static Dir  *fptr = &dirptr;\n");
	fprintf(fp,"\n");
	fprintf(fp,"char tmp[MAX_STR];\n");
	fprintf(fp,"char COMMANDNAME[256];	//実行するCGI自身の名前\n");
	fprintf(fp,"static int sqlcode = 0;	//PostgreSQLの返すコード\n\n");
	fprintf(fp,"int DBcount[MAX_FORM];	//wsubformHTMLで利用するDBの現在の最大行数\n");
	fprintf(fp,"extern char KEY[256][MAX_STR];	//INSERTとUPDATEが使用する更新項目\n");
	fprintf(fp,"extern int IKEY[256];	//INSERTとUPDATEが使用する更新項目(数値用)\n");
	fprintf(fp,"\n");

	fprintf(fp,"int DBConnect(void)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	// DB接続用変数宣言です。DB名、ユーザ名、パスワードを設定してください。\n");
	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		char dbname[12];\n");
	fprintf(fp,"		char user[12];\n");
	fprintf(fp,"		char passwd[12];\n");
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	strcpy(dbname,\"apsch\");\n");
	fprintf(fp,"	strcpy(user,\"cms\");\n");
	fprintf(fp,"	strcpy(passwd,\"cms\");\n");
	fprintf(fp,"\n");
	fprintf(fp,"#ifdef DEBUG\n");
	fprintf(fp,"	// ECPGデバッグ文出力\n");
	fprintf(fp,"	ECPGdebug (0, stderr);\n");
	fprintf(fp,"#endif\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 接続\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"	EXEC SQL CONNECT TO :dbname AS dbConnection user :user USING :passwd;\n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->CONNECT エラー。終了します。:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		exit (EXIT_FAILURE);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");


	fprintf(fp,"int Fetch_%s(int no, int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		char key[256][MAX_STR];\n");
	fprintf(fp,"		int	 ikey[256];\n");

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(pgc[n].cell_skipstep,"%s","SKIP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(!strcmp(pgc[n].cell_fieldtype,"char"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"date"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"int"))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"unsigned char"))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"double"))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
    fprintf(fp,"	DBcount[no] = 0;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	rec_count = 0;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// DBの行数を取得\n");
	fprintf(fp,"	EXEC SQL \n");
  	fprintf(fp,"	SELECT \n");
	fprintf(fp,"	COUNT(*)\n");
	fprintf(fp,"	INTO :rec_count\n");
	fprintf(fp,"	FROM	%s;\n",f);
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->SELECT COUNTエラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1) ;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
fprintf(fp,"	if(rec_count == 0)\n");
fprintf(fp,"	{\n");
fprintf(fp,"		printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
fprintf(fp,"		printf(\"<html lang=\\\"ja\\\">\\n\");\n");
fprintf(fp,"		printf(\"<head>\\n\");\n");
fprintf(fp,"		printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
fprintf(fp,"		printf(\"<title>DB-ERROR</title>\\n\");\n");
fprintf(fp,"		printf(\"</head>\\n\");\n");
fprintf(fp,"		printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
fprintf(fp,"		printf(\"<br>\\n\");\n");
fprintf(fp,"		printf(\"<table border=0>\\n\");\n");
fprintf(fp,"		printf(\"<tr>\\n\");\n");
fprintf(fp,"		printf(\"みつかりませんでした。<br>\\n\");\n");
fprintf(fp,"		printf(\"<form name=\\\"error\\\" method=\\\"post\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",f);
fprintf(fp,"		printf(\"<input accesskey=\\\"A\\\" tabindex=0 type=\\\"submit\\\" value=\\\"戻る\\\">\\n\");\n");
fprintf(fp,"		printf(\"</form>\\n\");\n");
fprintf(fp,"		printf(\"</tr>\\n\");\n");
fprintf(fp,"		printf(\"</body>\\n\");\n");
fprintf(fp,"		printf(\"</html>\\n\");\n");
fprintf(fp,"	}\n");
fprintf(fp,"\n");

	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	EXEC SQL DECLARE %s_CURSOR CURSOR FOR \n",f);
  	fprintf(fp,"	SELECT \n");

	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"		coalesce(%s,\' \',\'0\')",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
		//	fprintf(fp,"		TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title);
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}

	fprintf(fp,"	FROM	%s\n",f);
	for(i=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
		//	fprintf(fp,"%s = :key[%d]\n",pgc[i].cell_title,i);
			fprintf(fp,"	ORDER BY %s;\n",pgc[i].cell_title);
			break;
		}
	}

//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// カーソルオープン\n");
	fprintf(fp,"	EXEC SQL OPEN %s_CURSOR;\n",f);
	fprintf(fp,"\n");
	fprintf(fp,"	// CURSOR OPENエラー \n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%s->CURSOR OPENエラー:%%d - %%s\",sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n",tmpbuff1);
	fprintf(fp,"		fprintf(stderr,\"%%s\\n\",tmp);\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"	printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<head>\\n\");\n");
	fprintf(fp,"	printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
fprintf(fp,"		printf(\"<link rel=\\\"stylesheet\\\" href=\\\"/%s.css\\\" type=\\\"text/css\\\">\\n\");\n",f);
	fprintf(fp,"	printf(\"<title>Wsubform-HTML-DBgrid</title>\\n\");\n");
	fprintf(fp,"	printf(\"</head>\\n\");\n");
	fprintf(fp,"	printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");

	fprintf(fp,"	printf(\"<table class=\\\"%s\\\" border=1>\\n\");\n",f);
	fprintf(fp,"	printf(\"<tr>\\n\");\n");

	fprintf(fp,"	for(i=0;i<DBcount[no];i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		EXEC SQL FETCH %s_CURSOR INTO\n",f);
	for(j=0;j<n-1;j++)
	{
		fprintf(fp,"			:%s,\n",pgc[j].cell_title);
	}
	fprintf(fp,"			:%s;\n",pgc[j].cell_title);
	fprintf(fp,"\n");

	fprintf(fp,"			//送信はGETを使用します。\n");
	fprintf(fp,"		//	printf(\"<form method=\\\"get\\\" action=\\\"/cgi-bin/%s_Menu.fcgi\\\">\\n\");	//メニュー用\n",f);
	fprintf(fp,"			printf(\"<form method=\\\"get\\\" action=\\\"/cgi-bin/%s_Fetch.fcgi\\\">\\n\");\n",f);
	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			if(j == 0)
			{
				if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
					fprintf(fp,"//	");
				fprintf(fp,"			printf(\"<th>%%s</th>\", %s);\n",pgc[j].cell_title);
			}
			else
			{
				if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
					fprintf(fp,"//	");
				fprintf(fp,"			printf(\"<td class=\\\"%s\\\">%%s</td>\", %s);\n",f,pgc[j].cell_title);
			}
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"			printf(\"<td class=\\\"%s\\\">%%s</td>\", %s);\n",f,pgc[j].cell_title);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"			printf(\"<td class=\\\"%s\\\">%%d</td>\", %s);\n",f,pgc[j].cell_title);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"			if(%s == 'f')\n",pgc[j].cell_title);
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"				printf(\"<td><input type=\\\"checkbox\\\" value=\\\"t\\\"></td>\");\n");
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"			else\n");
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"				printf(\"<td><input type=\\\"checkbox\\\" value=\\\"t\\\" checked></td>\");\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"			printf(\"<td class=\\\"%s\\\">%%f</td>\", %s);\n",f,pgc[j].cell_title);
		}
	}
	for(i=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
			if(!strcmp(pgc[j].cell_skipstep,"SKIP"))
				fprintf(fp,"//	");
			fprintf(fp,"			printf(\"<td><input type=\\\"submit\\\" name=\\\"field\\\" value=\\\"%%s\\\"></td>\", %s);\n",pgc[i].cell_title);
			break;
		}
	}

	fprintf(fp,"			printf(\"</tr>\\n\");\n");

	fprintf(fp,"\n");
	fprintf(fp,"		if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			sprintf(tmp,\"%%s->FETCH完了:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"		//	logmsg(tmp);\n");
	fprintf(fp,"			EXEC SQL CLOSE %s_CURSOR;\n",f);
//	fprintf(fp,"			EXEC SQL END;\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");

	fprintf(fp,"	printf(\"</table>\\n\");\n");
	fprintf(fp,"	printf(\"</body>\\n\");\n");
	fprintf(fp,"	printf(\"</html>\\n\\n\");\n");

	fprintf(fp,"	// カーソルクローズ \n");
	fprintf(fp,"	EXEC SQL CLOSE %s_CURSOR;\n",f);
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%ss->FETCH結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(n);
}

//各機能（UPDATE,INSERT,DELETE)のための分岐を行う
int AseEditor::putecpgKey(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int flg;
	int tmp = 99;
	char *dot;
//	char cell_title[512][138];
//	int cell_length[512];
//	char *coln;

	
	if((dot = strchr(f,'.')) != (char *)NULL)
	{
		*dot = '\0';
	}
	sprintf(tmpbuff1,"%s.pgc",f);
	if(stat(tmpbuff1,fptr) == 0)
	{
		sprintf(tmpbuff2,"%s が存在します。上書きしますがよろしいですか？",tmpbuff1);
		if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff2) == 0)
		{
			return(0);
		}
	}
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

	fprintf(fp,"#include \"wsubformHTML.h\"	//サブフォーム専用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"#include \"fcgi_stdio.h\"	//FastCGI用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"\n");

	fprintf(fp,"extern char gridtitles[MAX_POS][MAX_LEN];	//wsubformHTMLが利用するgridのタイトル。\n");
	fprintf(fp,"\n");
	fprintf(fp,"extern TextBox	 *begin;	//textboxで使用する連鎖ポインタの開始位置\n");
	fprintf(fp,"extern TextBox	 *tp;	//textboxで使用する連鎖ポインタ\n");
	fprintf(fp,"\n");
	fprintf(fp,"typedef struct stat Dir;	//ファイル操作用\n");
	fprintf(fp,"static Dir dirptr;\n");
	fprintf(fp,"static Dir  *fptr = &dirptr;\n");
	fprintf(fp,"\n");
	fprintf(fp,"char tmp[MAX_STR];\n");
	fprintf(fp,"char COMMANDNAME[256];	//実行するCGI自身の名前\n");
	fprintf(fp,"//autono[][]の最初の配列[0]にはjohoIDの数値が入り、次の配列[1]に配列番号が入る\n");
	fprintf(fp,"int autono[10000][2];\n");
	fprintf(fp,"int autoindex;\n\n");
	fprintf(fp,"static int sqlcode = 0;	//PostgreSQLの返すコード\n\n");
	fprintf(fp,"int DBcount[MAX_FORM];	//wsubformHTMLで利用するDBの現在の最大行数\n");
	fprintf(fp,"extern char KEY[256][MAX_STR];	//INSERTとUPDATEが使用する更新項目\n");
fprintf(fp,"static char prefecture[47][15] = {\"北海道\",\"青森県\",\"岩手県\",\"秋田県\",\"山形県\",\"宮城県\",\"福島県\",\"茨城県\",\"栃木県\",\"群馬県\",\"埼玉県\",\"千葉県\",\"東京都\",\"神奈川県\",\"新潟県\",\"富山県\",\"石川県\",\"福井県\",\"山梨県\",\"長野県\",\"岐阜県\",\"静岡県\",\"愛知県\",\"三重県\",\"滋賀県\",\"京都府\",\"大阪府\",\"兵庫県\",\"奈良県\",\"和歌山県\",\"鳥取県\",\"島根県\",\"岡山県\",\"広島県\",\"山口県\",\"徳島県\",\"香川県\",\"愛媛県\",\"高知県\",\"福岡県\",\"佐賀県\",\"長崎県\",\"熊本県\",\"大分県\",\"宮崎県\",\"鹿児島県\",\"沖縄県\"};\n");
	fprintf(fp,"\n");

	fprintf(fp,"int DBConnect(void)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	// DB接続用変数宣言です。DB名、ユーザ名、パスワードを設定してください。\n");
	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		char dbname[12];\n");
	fprintf(fp,"		char user[12];\n");
	fprintf(fp,"		char passwd[12];\n");
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	strcpy(dbname,\"apsch\");\n");
	fprintf(fp,"	strcpy(user,\"cms\");\n");
	fprintf(fp,"	strcpy(passwd,\"cms\");\n");
	fprintf(fp,"\n");
	fprintf(fp,"#ifdef DEBUG\n");
	fprintf(fp,"	// ECPGデバッグ文出力\n");
	fprintf(fp,"	ECPGdebug (0, stderr);\n");
	fprintf(fp,"#endif\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 接続\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"	EXEC SQL CONNECT TO :dbname AS dbConnection user :user USING :passwd;\n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->CONNECT エラー。終了します。:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		exit (EXIT_FAILURE);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fprintf(fp,"int Fetch_%s_all(int no)\n",sf);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");

fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, '0', 5);\n");

fprintf(fp,"\n");
	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		char	 key[256][MAX_STR];\n");
	fprintf(fp,"		int		johoID;		//NUMERIC\n");
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");

fprintf(fp,"\n");
	fprintf(fp,"	sqlcode = 0;\n");
	fprintf(fp,"	DBcount[no] = 0;\n");

fprintf(fp,"\n");
	fprintf(fp,"	rec_count = 0;\n");

fprintf(fp,"\n");
	fprintf(fp,"	// DBの行数を取得\n");
	fprintf(fp,"	EXEC SQL \n");
	fprintf(fp,"	SELECT \n");
	fprintf(fp,"	COUNT(*)\n");
	fprintf(fp,"	INTO :rec_count\n");
	fprintf(fp,"	FROM	%s;\n",sf);

fprintf(fp,"\n");
	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"SELECT COUNTエラー:%%d - %%s\",sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"		//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1) ;\n");
	fprintf(fp,"	}\n");

fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");

fprintf(fp,"\n");
	fprintf(fp,"	EXEC SQL DECLARE %s_Fetch_all_CURSOR CURSOR FOR \n",sf);
	fprintf(fp,"	SELECT \n");
	fprintf(fp,"	johoID\n");
	fprintf(fp,"	FROM	%s\n",sf);
	fprintf(fp,"	ORDER BY johoID;\n");
fprintf(fp,"\n");

	fprintf(fp,"	// カーソルオープン\n");
	fprintf(fp,"	EXEC SQL OPEN %s_Fetch_all_CURSOR;\n",sf);

fprintf(fp,"\n");
	fprintf(fp,"	// CURSOR OPENエラー \n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"CURSOR OPENエラー:%%d - %%s\",sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");

fprintf(fp,"\n");
	fprintf(fp,"	//以下に続くjohoIDというのは仮のレコード項目なので正しい名前に変更して下さい。\n");
	fprintf(fp,"	// johoID項目をautono[]にセットする\n");
	fprintf(fp,"	for(i=0;i<DBcount[no];i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		EXEC SQL FETCH %s_Fetch_all_CURSOR INTO\n",sf);
	fprintf(fp,"			:johoID;\n");

fprintf(fp,"\n");
	fprintf(fp,"		if(johoID == atoi(KEY[0]))\n");
	fprintf(fp,"			autoindex = i;\n");

fprintf(fp,"\n");
	fprintf(fp,"		autono[i][0] = johoID;\n");
	fprintf(fp,"		autono[i][1] = i;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// カーソルクローズ \n");
	fprintf(fp,"	EXEC SQL CLOSE %s_Fetch_all_CURSOR;\n",sf);
fprintf(fp,"\n");

	fprintf(fp,"	DBcount[no] = rec_count;\n");
fprintf(fp,"\n");

	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"FETCH結果チェック:%%d - %%s\",sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"		//	logmsg(tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
fprintf(fp,"\n");


	fprintf(fp,"int Fetch_%s(int no, int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		int rec_max;\n");
	fprintf(fp,"		char	 key[256][MAX_STR];\n");
	fprintf(fp,"		int	 ikey[256];\n");

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(!strcmp(pgc[n].cell_fieldtype,"char"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"date"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"int"))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"unsigned char"))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"double"))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}

	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
    fprintf(fp,"	DBcount[no] = 0;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	rec_count = 0;\n");

	if(Menu == 0)
	{
	fprintf(fp,"\n");
	fprintf(fp,"	if((qs = getenv(\"QUERY_STRING\")) != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		qcount = query_getHTML(qs,'&');\n");
	fprintf(fp,"		for(i=0;i < qcount;i++)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			sprintf(key[i],\"%%s\",qt.get[i]);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(key[0],\"NONE\");\n");
	fprintf(fp,"		printf(\"%%s<br>\\n\",key[0]);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"//	以下の部分はリレーションテーブルを利用する場合にコメントを外して使用可能にして利用してください。\n");
	fprintf(fp,"	sprintf(KEY[0],\"%%s\",key[0]);\n");
	fprintf(fp,"\n");
	fprintf(fp,"//	テーブルを連結して検索する対象は外部変数の場合splitDbbuffからホスト変数にコピーして利用出来ます。\n");
	fprintf(fp,"//	sprintf(key[0],\"%%s\",ft[1].splitDBbuff[line][13]);\n");
	fprintf(fp,"//	sprintf(key[1],\"%%s\",ft[1].splitDBbuff[line][10]);\n");
	fprintf(fp,"//	ikey[0] = atoi(key[1]);\n");
	}

	fprintf(fp,"\n");
	fprintf(fp,"	// 検索するレコードの行数を取得\n");
	fprintf(fp,"	EXEC SQL \n");
  	fprintf(fp,"	SELECT \n");
	fprintf(fp,"	COUNT(*)\n");
	fprintf(fp,"	INTO :rec_count\n");
	fprintf(fp,"	FROM	%s\n",sf);
	fprintf(fp,"	WHERE ");

	if(up == 1 && ins == 1 && del == 1)
	{
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"%s = :key[0];\n",pgc[i].cell_title);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"%s = :key[0];\n",pgc[0].cell_title);
		}
	}
	else
	{
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"%s = :key[%d];\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"%s = :key[0];\n",pgc[0].cell_title);
		}
	}

	fprintf(fp,"\n");
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->SELECT COUNTエラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1) ;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
fprintf(fp,"	if(rec_count == 0)\n");
fprintf(fp,"	{\n");
fprintf(fp,"		printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
fprintf(fp,"		printf(\"<html lang=\\\"ja\\\">\\n\");\n");
fprintf(fp,"		printf(\"<head>\\n\");\n");
fprintf(fp,"		printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
fprintf(fp,"		printf(\"<title>DB-ERROR</title>\\n\");\n");
fprintf(fp,"		printf(\"</head>\\n\");\n");
fprintf(fp,"		printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
fprintf(fp,"		printf(\"<br>\\n\");\n");
fprintf(fp,"		printf(\"<table border=0>\\n\");\n");
fprintf(fp,"		printf(\"<tr>\\n\");\n");
fprintf(fp,"		printf(\"みつかりませんでした。<br>\\n\");\n");
fprintf(fp,"		printf(\"<form name=\\\"error\\\" method=\\\"post\\\" action=\\\"/cgi-bin/yubin/yubin.fcgi\\\">\\n\");\n");
fprintf(fp,"		printf(\"<input accesskey=\\\"A\\\" tabindex=0 type=\\\"submit\\\" value=\\\"戻る\\\">\\n\");\n");
fprintf(fp,"		printf(\"</form>\\n\");\n");
fprintf(fp,"		printf(\"</tr>\\n\");\n");
fprintf(fp,"		printf(\"</body>\\n\");\n");
fprintf(fp,"		printf(\"</html>\\n\");\n");
fprintf(fp,"	}\n");
fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// 以下の項目はユニークな項目を利用してインサート時の項目番号等を増加するために利用します\n");
	fprintf(fp,"	// 利用する場合はコメントを外して下さい。\n");

	fprintf(fp,"	// あるDB項目の最大数を取得\n");
	fprintf(fp,"//	if(rec_count == 0)\n");
	fprintf(fp,"//	{\n");
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"//		sprintf(%s,\"%%s\",key[%d]);\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"//		sprintf(%s,\"%%s\",key[0]);\n",pgc[0].cell_title);
		}
	fprintf(fp,"//		rec_max = 0;\n");
	fprintf(fp,"//		DBcount[no] = 1;\n");
	fprintf(fp,"//	}\n");
	fprintf(fp,"//	else\n");
	fprintf(fp,"//	{\n");
	fprintf(fp,"//		EXEC SQL \n");
  	fprintf(fp,"//		SELECT \n");
	fprintf(fp,"//		MAX(No)\n");
	fprintf(fp,"//		INTO :rec_max\n");
	fprintf(fp,"//		FROM	%s;\n",sf);
//	fprintf(fp,"//		EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"//	// SELECTエラー \n");
	fprintf(fp,"//		if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"//		{\n");
	fprintf(fp,"//			sprintf(tmp,\"%%s->SELECT MAX()エラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"//		//	logmsg(tmp);\n");
	fprintf(fp,"//			return(-1) ;\n");
	fprintf(fp,"//		}\n");
	fprintf(fp,"//	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	EXEC SQL DECLARE %s_CURSOR CURSOR FOR \n",f);
  	fprintf(fp,"	SELECT \n");

	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"		coalesce(%s,\' \',\'0\')",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
		//	fprintf(fp,"		TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title);
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}

	fprintf(fp,"	FROM	%s\n",sf);
	fprintf(fp,"	WHERE ");

	if(up == 1 && ins == 1 && del == 1)
		fprintf(fp,"%s = :key[0]\n",pgc[i].cell_title);
	else
	{
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"%s = :key[%d]\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"%s = :key[0];\n",pgc[0].cell_title);
		}
	}

	fprintf(fp,"	ORDER BY %s;\n",pgc[i].cell_title);
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// カーソルオープン\n");
	fprintf(fp,"	EXEC SQL OPEN %s_CURSOR;\n",f);
	fprintf(fp,"\n");
	fprintf(fp,"	// CURSOR OPENエラー \n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->CURSOR OPENエラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	for(i=0;i<DBcount[no];i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		EXEC SQL FETCH %s_CURSOR INTO\n",f);
	for(j=0;j<n-1;j++)
	{
		fprintf(fp,"			:%s,\n",pgc[j].cell_title);
	}
	fprintf(fp,"			:%s;\n",pgc[j].cell_title);
	fprintf(fp,"\n");

	fprintf(fp,"	// テーブル項目をsplitbDBbuff[][]にセットする\n");
	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"		sf_assgetDB(no,i,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			fprintf(fp,"		sf_assgetDB(no,i,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"		sf_to_text(%s,DBbuff);	//NUMERIC型(int)を文字に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"		sf_assgetDB(no,i,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
		//	fprintf(fp,"		sf_to_text(%s,DBbuff);	//BOOL型(unsigned char)を文字に変換する。\n",pgc[j].cell_title);
	//	sprintf(DBbuff,"%c",insatu);
			fprintf(fp,"		sprintf(DBbuff,\"%%c\",%s);	//BOOL型(unsigned char)を文字に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"		sf_assgetDB(no,i,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"		sf_to_text4F(%s,DBbuff);	//DOUBLE型(double)を文字に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"		sf_assgetDB(no,i,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		}
	}

	fprintf(fp,"\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// カーソルクローズ \n");
	fprintf(fp,"	EXEC SQL CLOSE %s_CURSOR;\n",f);
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->FETCH結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(n);
}

//UPDATEのための分岐を行う。cell_skipstepが適用されるためUPDATEのみ使用可能。
//保存されるファイル名は テーブル名_Fetch2.pgc になる。
int AseEditor::putecpgKey2(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int flg;
	int tmp = 99;
	char *dot;
//	char cell_title[512][138];
//	int cell_length[512];
//	char *coln;
	
	if((dot = strchr(f,'.')) != (char *)NULL)
	{
		*dot = '\0';
	}
	sprintf(tmpbuff1,"%s.pgc",f);
	if(stat(tmpbuff1,fptr) == 0)
	{
		sprintf(tmpbuff2,"%s が存在します。上書きしますがよろしいですか？",tmpbuff1);
		if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff2) == 0)
		{
			return(0);
		}
	}
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

	fprintf(fp,"#include \"wsubformHTML.h\"	//サブフォーム専用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"#include \"fcgi_stdio.h\"	//FastCGI用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"\n");

	fprintf(fp,"extern char gridtitles[MAX_POS][MAX_LEN];	//wsubformHTMLが利用するgridのタイトル。\n");
	fprintf(fp,"\n");
	fprintf(fp,"extern TextBox	 *begin;	//textboxで使用する連鎖ポインタの開始位置\n");
	fprintf(fp,"extern TextBox	 *tp;	//textboxで使用する連鎖ポインタ\n");
	fprintf(fp,"\n");
	fprintf(fp,"typedef struct stat Dir;	//ファイル操作用\n");
	fprintf(fp,"static Dir dirptr;\n");
	fprintf(fp,"static Dir  *fptr = &dirptr;\n");
	fprintf(fp,"\n");
	fprintf(fp,"char tmp[MAX_STR];\n");
	fprintf(fp,"char COMMANDNAME[256];	//実行するCGI自身の名前\n");
	fprintf(fp,"//autono[][]の最初の配列[0]にはjohoIDの数値が入り、次の配列[1]に配列番号が入る\n");
	fprintf(fp,"int autono[10000][2];\n");
	fprintf(fp,"int autoindex;\n\n");
	fprintf(fp,"static int sqlcode = 0;	//PostgreSQLの返すコード\n\n");
	fprintf(fp,"int DBcount[MAX_FORM];	//wsubformHTMLで利用するDBの現在の最大行数\n");
	fprintf(fp,"extern char KEY[256][MAX_STR];	//INSERTとUPDATEが使用する更新項目\n");
	fprintf(fp,"\n");

	fprintf(fp,"int DBConnect(void)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	// DB接続用変数宣言です。DB名、ユーザ名、パスワードを設定してください。\n");
	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		char dbname[12];\n");
	fprintf(fp,"		char user[12];\n");
	fprintf(fp,"		char passwd[12];\n");
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	strcpy(dbname,\"apsch\");\n");
	fprintf(fp,"	strcpy(user,\"cms\");\n");
	fprintf(fp,"	strcpy(passwd,\"cms\");\n");
	fprintf(fp,"\n");
	fprintf(fp,"#ifdef DEBUG\n");
	fprintf(fp,"	// ECPGデバッグ文出力\n");
	fprintf(fp,"	ECPGdebug (0, stderr);\n");
	fprintf(fp,"#endif\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 接続\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"	EXEC SQL CONNECT TO :dbname AS dbConnection user :user USING :passwd;\n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->CONNECT エラー。終了します。:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		exit (EXIT_FAILURE);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fprintf(fp,"int Fetch_%s(int no, int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		char	 key[256][MAX_STR];\n");
	fprintf(fp,"		int	 ikey[256];\n");

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(pgc[n].cell_skipstep,"%s","SKIP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if((!strcmp(pgc[n].cell_fieldtype,"char")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"date")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"int")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"double")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}

	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
    fprintf(fp,"	DBcount[no] = 0;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	rec_count = 0;\n");

	fprintf(fp,"\n");
	fprintf(fp,"	if((qs = getenv(\"QUERY_STRING\")) != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		qcount = query_getHTML(qs,'&');\n");
	fprintf(fp,"		for(i=0;i < qcount;i++)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			sprintf(key[i],\"%%s\",qt.get[i]);\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(key[0],\"NONE\");\n");
	fprintf(fp,"		printf(\"%%s<br>\\n\",key[0]);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"//	以下の部分はリレーションテーブルを利用する場合にコメントを外して使用可能にして利用してください。\n");
	fprintf(fp,"//	sprintf(KEY[0],\"%%s\",key[0]);\n");
	fprintf(fp,"\n");
	fprintf(fp,"//	検索する対象は外部変数の場合splitDbbuffからホスト変数にコピーして利用しなければならない。\n");
	fprintf(fp,"//	sprintf(key[0],\"%%s\",ft[1].splitDBbuff[0][13]);\n");

	fprintf(fp,"\n");
	fprintf(fp,"	// 検索するレコードの行数を取得\n");
	fprintf(fp,"	EXEC SQL \n");
  	fprintf(fp,"	SELECT \n");
	fprintf(fp,"	COUNT(*)\n");
	fprintf(fp,"	INTO :rec_count\n");
	fprintf(fp,"	FROM	%s\n",sf);
	fprintf(fp,"	WHERE ");

	if(up == 1 && ins == 1 && del == 1)
	{
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"%s = :key[0];\n",pgc[i].cell_title);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"%s = :key[0];\n",pgc[0].cell_title);
		}
	}
	else
	{
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"%s = :key[%d];\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"%s = :key[0];\n",pgc[0].cell_title);
		}
	}

	fprintf(fp,"\n");
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->SELECT COUNTエラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1) ;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	EXEC SQL DECLARE %s_CURSOR CURSOR FOR \n",f);
  	fprintf(fp,"	SELECT \n");

	for(j=0;j<xcol;j++)
	{
		if((!strcmp(pgc[j].cell_fieldtype,"char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		coalesce(%s,\' \',\'0\')",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"date")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
		//	fprintf(fp,"		TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title);
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"int")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"double")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}

	fprintf(fp,"	FROM	%s\n",sf);
	fprintf(fp,"	WHERE ");

	if(up == 1 && ins == 1 && del == 1)
		fprintf(fp,"%s = :key[0]\n",pgc[i].cell_title);
	else
	{
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"%s = :key[%d]\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"%s = :key[0];\n",pgc[0].cell_title);
		}
	}

	fprintf(fp,"	ORDER BY %s;\n",pgc[i].cell_title);
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// カーソルオープン\n");
	fprintf(fp,"	EXEC SQL OPEN %s_CURSOR;\n",f);
	fprintf(fp,"\n");
	fprintf(fp,"	// CURSOR OPENエラー \n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->CURSOR OPENエラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	for(i=0;i<DBcount[no];i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		EXEC SQL FETCH %s_CURSOR INTO\n",f);
	for(j=0;j<n-1;j++)
	{
		if(!strcmp(pgc[j].cell_skipstep,"STEP"))
			fprintf(fp,"			:%s,\n",pgc[j].cell_title);
	}
	if(!strcmp(pgc[j].cell_skipstep,"STEP"))
		fprintf(fp,"			:%s;\n",pgc[j].cell_title);
	fprintf(fp,"\n");

	fprintf(fp,"	// テーブル項目をsplitbDBbuff[][]にセットする\n");
	for(j=0;j<xcol;j++)
	{
		if((!strcmp(pgc[j].cell_fieldtype,"char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		sf_assgetDB(no,i,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if((!strcmp(pgc[j].cell_fieldtype,"date")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		sf_assgetDB(no,i,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if((!strcmp(pgc[j].cell_fieldtype,"int")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		sf_to_text(%s,DBbuff);	//NUMERIC型(int)を文字に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"		sf_assgetDB(no,i,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		}
		if((!strcmp(pgc[j].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
		//	fprintf(fp,"		sf_to_text(%s,DBbuff);	//BOOL型(unsigned char)を文字に変換する。\n",pgc[j].cell_title);
	//	sprintf(DBbuff,"%c",insatu);
			fprintf(fp,"		sprintf(DBbuff,\"%%c\",%s);	//BOOL型(unsigned char)を文字に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"		sf_assgetDB(no,i,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		}
		if((!strcmp(pgc[j].cell_fieldtype,"double")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		sf_to_text4F(%s,DBbuff);	//DOUBLE型(double)を文字に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"		sf_assgetDB(no,i,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		}
	}

	fprintf(fp,"\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// カーソルクローズ \n");
	fprintf(fp,"	EXEC SQL CLOSE %s_CURSOR;\n",f);
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->FETCH結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(n);
}

int AseEditor::putecpgHeader(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
//	int i,j,k,l,m,n;
	int i;
//	int flg;
//	int tmp = 99;
	char *dot;

	
	if((dot = strchr(f,'.')) != (char *)NULL)
	{
		*dot = '\0';
	}
	sprintf(tmpbuff1,"%s.pgc",f);
	if(stat(tmpbuff1,fptr) == 0)
	{
		sprintf(tmpbuff2,"%s が存在します。上書きしますがよろしいですか？",tmpbuff1);
		if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff2) == 0)
		{
			return(0);
		}
	}
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

//	flg = 0;
//	k = m = n = 0;
//	l = 0;
//	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

	fprintf(fp,"#include \"wsubformHTML.h\"	//サブフォーム専用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"#include \"fcgi_stdio.h\"	//FastCGI用ヘッダファイルをインクルードする。\n");
	fprintf(fp,"\n");

	fprintf(fp,"extern char gridtitles[MAX_POS][MAX_LEN];	//wsubformHTMLが利用するgridのタイトル。\n");
	fprintf(fp,"\n");
	fprintf(fp,"extern TextBox	 *begin;	//textboxで使用する連鎖ポインタの開始位置\n");
	fprintf(fp,"extern TextBox	 *tp;	//textboxで使用する連鎖ポインタ\n");
	fprintf(fp,"\n");
	fprintf(fp,"typedef struct stat Dir;	//ファイル操作用\n");
	fprintf(fp,"static Dir dirptr;\n");
	fprintf(fp,"static Dir  *fptr = &dirptr;\n");
	fprintf(fp,"\n");
	fprintf(fp,"char tmp[MAX_STR];\n");
	fprintf(fp,"char COMMANDNAME[256];	//実行するCGI自身の名前\n");
	fprintf(fp,"static int sqlcode = 0;	//PostgreSQLの返すコード\n\n");
	fprintf(fp,"int DBcount[MAX_FORM];	//wsubformHTMLで利用するDBの現在の最大行数\n");
	fprintf(fp,"extern char KEY[256][MAX_STR];	//INSERTとUPDATEが使用する更新項目\n");
	fprintf(fp,"\n");

	fprintf(fp,"int DBConnect(void)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	// DB接続用変数宣言です。DB名、ユーザ名、パスワードを設定してください。\n");
	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		char dbname[12];\n");
	fprintf(fp,"		char user[12];\n");
	fprintf(fp,"		char passwd[12];\n");
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	strcpy(dbname,\"apsch\");\n");
	fprintf(fp,"	strcpy(user,\"cms\");\n");
	fprintf(fp,"	strcpy(passwd,\"cms\");\n");
	fprintf(fp,"\n");
	fprintf(fp,"#ifdef DEBUG\n");
	fprintf(fp,"	// ECPGデバッグ文出力\n");
	fprintf(fp,"	ECPGdebug (0, stderr);\n");
	fprintf(fp,"#endif\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 接続\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"	EXEC SQL CONNECT TO :dbname AS dbConnection user :user USING :passwd;\n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->CONNECT エラー。終了します。:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		exit (EXIT_FAILURE);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(1);
}

int AseEditor::putecpgINSERT(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int flg;
	int tmp = 99;
//	char *dot;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

//	fprintf(fp,"int Insert_%s(int no)\n",f);
	fprintf(fp,"int %s(int no)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
	fprintf(fp,"	char *poststr;	//POSTメソッド用のポインタ\n");
	fprintf(fp,"	char *ps;\n");
	fprintf(fp,"	int len;\n");
	fprintf(fp,"	int n;\n");
	fprintf(fp,"	char *env1,*env2;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		int rec_max;\n");
	fprintf(fp,"		char	 key[256][MAX_STR];\n");
	fprintf(fp,"		int	 ikey[256];\n");

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(!strcmp(pgc[n].cell_fieldtype,"char"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"date"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"int"))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"unsigned char"))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"double"))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
	fprintf(fp,"\n");

	fprintf(fp,"\n");
	fprintf(fp,"	if((qs = getenv(\"REQUEST_METHOD\")) != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		if(!strcmp(qs,\"GET\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((qs = getenv(\"QUERY_STRING\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			//	デバッグの場合必要に応じて以下の関数をコメントを外して使用して下さい。\n");
	fprintf(fp,"				len = strlen(qs);\n");
	fprintf(fp,"				qcount = query_postHTML(qs,'&',len);\n");
	fprintf(fp,"			//	qcount = query_getHTML(qs,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else if(!strcmp(qs,\"POST\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((ps = getenv(\"CONTENT_LENGTH\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				len = atoi(ps);\n");
	fprintf(fp,"				poststr = malloc(len+1);\n");
	fprintf(fp,"				n = fread(poststr,1,len,stdin);\n");
	fprintf(fp,"				qcount = query_postHTML(poststr,'&',len);\n");
	fprintf(fp,"			//	qcount = query_getHTML(poststr,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(key[0],\"NONE\");\n");
	fprintf(fp,"		printf(\"%%s<br>\\n\",key[0]);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	for(i=0;i<qcount;i++)\n");
	fprintf(fp,"		sprintf(KEY[i],\"%%s\",key[i]);\n");
	fprintf(fp,"	sf_tgetDBallHTML(0);\n");
	fprintf(fp,"\n");

	fprintf(fp,"\n");
	fprintf(fp,"	// 以下の項目はユニークな項目を利用してインサート時の項目番号等を増加するために利用します\n");
	fprintf(fp,"	// 利用する場合はコメントを外して下さい。\n");
	fprintf(fp,"	// ユニークな項目の最大数を取得\n");
	fprintf(fp,"//	EXEC SQL \n");
  	fprintf(fp,"//	SELECT \n");
	fprintf(fp,"//	COUNT(*)\n");
	fprintf(fp,"//	INTO :rec_count\n");
	fprintf(fp,"//	FROM	%s\n",sf);
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"//	WHERE %s= :key[%d];\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"//	WHERE %s= :key[0];\n",pgc[i].cell_title);
		}
	fprintf(fp,"\n");
	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"//	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"//	{\n");
	fprintf(fp,"//		sprintf(tmp,\"%%s->SELECT MAX()エラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"//	//	logmsg(tmp);\n");
	fprintf(fp,"//		return(-1) ;\n");
	fprintf(fp,"//	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// あるDB項目の最大数を取得\n");
	fprintf(fp,"//	if(rec_count == 0)\n");
	fprintf(fp,"//	{\n");
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"//		sprintf(%s,\"%%s\",key[%d]);\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"//		sprintf(%s,\"%%s\",key[0]);\n",pgc[0].cell_title);
		}
	fprintf(fp,"//		rec_max = 0;\n");
	fprintf(fp,"//	}\n");
	fprintf(fp,"//	else\n");
	fprintf(fp,"//	{\n");
	fprintf(fp,"//		EXEC SQL \n");
  	fprintf(fp,"//		SELECT \n");
	fprintf(fp,"//		MAX(No)\n");
	fprintf(fp,"//		INTO :rec_max\n");
	fprintf(fp,"//		FROM	%s;\n",sf);
	fprintf(fp,"\n");
	fprintf(fp,"//	 // SELECTエラー \n");
	fprintf(fp,"//		if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"//		{\n");
	fprintf(fp,"//			sprintf(tmp,\"%%s->SELECT MAX()エラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"//		//	logmsg(tmp);\n");
	fprintf(fp,"//			return(-1) ;\n");
	fprintf(fp,"//		}\n");
	fprintf(fp,"//	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// インサート\n");
	fprintf(fp,"	// テーブル項目をsplitbDBbuff[]からDB配列にセットする\n");
	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"	sf_assputDB(no,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			fprintf(fp,"	sf_assputDB(no,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
			fprintf(fp,"	%s = sf_to_integer(DBbuff);	//文字(char)をNUMERIC型(int)に変換する。\n",pgc[j].cell_title);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		//	fprintf(fp,"	%s = sf_to_integer(DBbuff);	//文字(char)をBOOL型(unsigned char)に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"	%s = (unsigned char)DBbuff[0];	//文字(char)をBOOL型(unsigned char)に入れ替える。\n",pgc[j].cell_title);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
			fprintf(fp,"	%s = sf_to_double(DBbuff);	//文字(char)をDOUBLE型(double)に変換する。\n",pgc[j].cell_title);
		}
	}
	fprintf(fp,"\n");

	fprintf(fp,"	// 以下の項目はユニークな項目を利用してインサート時の項目番号等を増加するために利用します\n");
	fprintf(fp,"	// 利用する場合はコメントを外して下さい。\n");
	fprintf(fp,"//	No = rec_max+1;\n\n");
  	fprintf(fp,"	// 対象レコードをADD\n");
	fprintf(fp,"	EXEC SQL INSERT INTO %s\n",sf);
	fprintf(fp,"	(\n");
	for(j=0;j<n-1;j++)
	{
		fprintf(fp,"		%s,\n",pgc[j].cell_title);
	}
	fprintf(fp,"		%s\n",pgc[j].cell_title);
	fprintf(fp,"	)\n");
	fprintf(fp,"	VALUES\n");
	fprintf(fp,"	(\n");
	for(j=0;j<n-1;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"		coalesce(:%s,\' \',\'0\')",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			fprintf(fp,"		TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"		:%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			fprintf(fp,"		:%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"		:%s",pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}
	if(!strcmp(pgc[j].cell_fieldtype,"char"))
	{
		fprintf(fp,"		coalesce(:%s,\' \',\'0\')",pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"date"))
	{
		fprintf(fp,"		TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"int"))
	{
		fprintf(fp,"		:%s",pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
	{
		fprintf(fp,"		:%s",pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"double"))
	{
		fprintf(fp,"		:%s",pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}

	fprintf(fp,"	);\n");
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// 登録エラー\n");
	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
  	fprintf(fp,"		// ロールバック\n");
	fprintf(fp,"		env1 = getenv(\"REMOTE_ADDR\");\n");
	fprintf(fp,"		env2 = getenv(\"HTTP_USER_AGENT\");\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->INSERTエラー:%%d - %%s:%%s:%%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc,env1,env2);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		EXEC SQL ROLLBACK WORK;\n");
	fprintf(fp,"		EXEC SQL END;\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// コミット\n");
	fprintf(fp,"	EXEC SQL COMMIT;\n");
	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->INSERT結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// ユニークな項目の最大数を取得\n");
	fprintf(fp,"//	EXEC SQL \n");
  	fprintf(fp,"//	SELECT \n");
	fprintf(fp,"//	COUNT(*)\n");
	fprintf(fp,"//	INTO :rec_count\n");
	fprintf(fp,"//	FROM	%s\n",f);
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"//	WHERE %s= :key[%d];\n",pgc[i].cell_title,i);
				break;
			}
		}
		if(i == NUMITEM)
		{
			fprintf(fp,"//	WHERE %s= :key[0];\n",pgc[i].cell_title);
		}
	fprintf(fp,"\n");
	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"//	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"//	{\n");
	fprintf(fp,"//		sprintf(tmp,\"%%s->SELECT MAX()エラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"//		return(-1) ;\n");
	fprintf(fp,"//	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBcount[no] = rec_count;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(1);
}

int AseEditor::putecpgUPDATE(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int flg;
	int tmp = 99;
//	char *dot;

	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

//	fprintf(fp,"int	Update_%s(int no)\n",f);
	fprintf(fp,"int	%s(int no)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
	fprintf(fp,"	char *poststr;	//POSTメソッド用のポインタ\n");
	fprintf(fp,"	char *ps;\n");
	fprintf(fp,"	int len;\n");
	fprintf(fp,"	int n;\n");
	fprintf(fp,"	char *env1,*env2;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		char	key[256][MAX_STR];\n");
	fprintf(fp,"		int	 ikey[256];\n");

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(!strcmp(pgc[n].cell_fieldtype,"char"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"date"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"int"))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"unsigned char"))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"double"))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	if((qs = getenv(\"REQUEST_METHOD\")) != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		if(!strcmp(qs,\"GET\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((qs = getenv(\"QUERY_STRING\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				len = strlen(qs);\n");
	fprintf(fp,"				qcount = query_postHTML(qs,'&',len);\n");
	fprintf(fp,"			//	qcount = query_getHTML(qs,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else if(!strcmp(qs,\"POST\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((ps = getenv(\"CONTENT_LENGTH\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				len = atoi(ps);\n");
	fprintf(fp,"				poststr = malloc(len+1);\n");
	fprintf(fp,"				n = fread(poststr,1,len,stdin);\n");
	fprintf(fp,"				qcount = query_postHTML(poststr,'&',len);\n");
	fprintf(fp,"			//	qcount = query_getHTML(poststr,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(key[0],\"NONE\");\n");
	fprintf(fp,"		printf(\"%%s<br>\\n\",key[0]);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	for(i=0;i<qcount;i++)\n");
	fprintf(fp,"		sprintf(KEY[i],\"%%s\",key[i]);\n");
	fprintf(fp,"	sf_tgetDBallHTML(0);\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// アップデート\n");
	fprintf(fp,"	// テーブル項目をsplitbDBbuff[]からDB配列にセットする\n");
	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"	sprintf(%s, \"%%s\",key[%d]);\n",pgc[j].cell_title,j);
			fprintf(fp,"	sf_assputDB(no,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			fprintf(fp,"	sprintf(%s, \"%%s\",key[%d]);\n",pgc[j].cell_title,j);
			fprintf(fp,"	sf_assputDB(no,%d,%s,%d + 1);\n",j,pgc[j].cell_title,pgc[j].cell_length);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"	sprintf(DBbuff, \"%%s\",key[%d]);\n",j);
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
			fprintf(fp,"	%s = sf_to_integer(DBbuff);	//文字(char)をNUMERIC型(int)に変換する。\n",pgc[j].cell_title);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			fprintf(fp,"	sprintf(DBbuff, \"%%s\",key[%d]);\n",j);
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
		//	fprintf(fp,"	%s = sf_to_integer(DBbuff);	//文字(char)をBOOL型(unsigned char)に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"	%s = (unsigned char)DBbuff[0];	//文字(char)をBOOL型(unsigned char)に入れ替える。\n",pgc[j].cell_title);
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"	sprintf(DBbuff, \"%%s\",key[%d]);\n",j);
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",j,pgc[j].cell_length);
			fprintf(fp,"	%s = sf_to_double(DBbuff);	//文字(char)をDOUBLE型(double)に変換する。\n",pgc[j].cell_title);
		}
	}
	fprintf(fp,"\n");

  	fprintf(fp,"	// 対象レコードをUPDATE\n");
	fprintf(fp,"	EXEC SQL UPDATE %s\n",sf);
	fprintf(fp,"	SET\n");

	for(j=0;j<n-1;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			fprintf(fp,"		%s =	coalesce(:%s,\' \',\'0\')",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			fprintf(fp,"		%s = 	TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}
	if(!strcmp(pgc[j].cell_fieldtype,"char"))
	{
		fprintf(fp,"		%s =	coalesce(:%s,\' \',\'0\')",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"date"))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"int"))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if(!strcmp(pgc[j].cell_fieldtype,"double"))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
//	fprintf(fp,"	WHERE %s = :%s AND %s = :%s;\n",pgc[0].cell_title,pgc[0].cell_title,pgc[1].cell_title,pgc[1].cell_title);
	fprintf(fp,"	WHERE ");
	for(i=0,j=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
			fprintf(fp,"%s = :key[%d]",pgc[i].cell_title,i);
			if(j < KEYCOUNT - 1)
				fprintf(fp," AND ");
			j++;
		}
	}
	if(pgc[i].keyflg == 1)
		fprintf(fp," %s = :key[%d];\n",pgc[i].cell_title,i);
	else
		fprintf(fp,";\n");

	fprintf(fp,"\n");
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"	// 更新エラー\n");
  	fprintf(fp,"		// ロールバック\n");
	fprintf(fp,"		env1 = getenv(\"REMOTE_ADDR\");\n");
	fprintf(fp,"		env2 = getenv(\"HTTP_USER_AGENT\");\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->UPDATEエラー:%%d - %%s:%%s:%%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc,env1,env2);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		printf(\"<br>%%s\\n\",tmp);\n");
  	fprintf(fp,"		EXEC SQL ROLLBACK WORK;\n");
	fprintf(fp,"		EXEC SQL END;\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

  	fprintf(fp,"	//コミットする\n");
	fprintf(fp,"	EXEC SQL COMMIT;\n");
	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"\n");
	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->UPDATE結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		printf(\"<br>%%s\\n\",tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(1);
}

int AseEditor::putecpgUPDATE2(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n,p;
	int flg;
	int tmp = 99;
//	char *dot;

	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	flg = 0;
	k = m = n = 0;
	l = 0;
	p = 0;
	tmp = 99;

	for(i=0;i<512;i++)
	{
		memset(pgc[i].cell_fieldtype,' ',sizeof(pgc[i].cell_fieldtype));
	}

//	fprintf(fp,"int	Update_%s(int no)\n",f);
	fprintf(fp,"int	%s(int no)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
	fprintf(fp,"	char *poststr;	//POSTメソッド用のポインタ\n");
	fprintf(fp,"	char *ps;\n");
	fprintf(fp,"	int len;\n");
	fprintf(fp,"	int n;\n");
	fprintf(fp,"	char *env1,*env2;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"		int rec_count;\n");
	fprintf(fp,"		char	key[256][MAX_STR];\n");
	fprintf(fp,"		int	 ikey[256];\n");

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"p")) && flg == 1)
			{
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"k")) && flg == 1)
			{
				sprintf(pgc[n].cell_skipstep,"%s","SKIP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				sprintf(pgc[n].cell_skipstep,"%s","STEP");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if((!strcmp(pgc[n].cell_fieldtype,"char")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"date")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"int")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if((!strcmp(pgc[n].cell_fieldtype,"double")) && (!strcmp(pgc[n].cell_skipstep,"STEP")))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	if((qs = getenv(\"REQUEST_METHOD\")) != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		if(!strcmp(qs,\"GET\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((qs = getenv(\"QUERY_STRING\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				len = strlen(qs);\n");
	fprintf(fp,"				qcount = query_postHTML(qs,'&',len);\n");
	fprintf(fp,"			//	qcount = query_getHTML(qs,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					while(tp->stype == 0 && tp->next != (TextBox *)NULL && i < %d)\n",NUMITEM);
	fprintf(fp,"					{\n");
	fprintf(fp,"						sf_tnext();\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else if(!strcmp(qs,\"POST\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((ps = getenv(\"CONTENT_LENGTH\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				len = atoi(ps);\n");
	fprintf(fp,"				poststr = malloc(len+1);\n");
	fprintf(fp,"				n = fread(poststr,1,len,stdin);\n");
fprintf(fp,"				sprintf(KEY[%d],\"%%c%%c%%c%%c%%c\",poststr[len-5],poststr[len-4],poststr[len-3],poststr[len-2],poststr[len-1]);\n",NUMITEM+1);
fprintf(fp,"				KEY[%d][5] = '\\0';\n",NUMITEM+1);
fprintf(fp,"				poststr[len - 10] = '\\0';\n");
fprintf(fp,"				len = len -  10;\n");
	fprintf(fp,"				qcount = query_postHTML(poststr,'&',len);\n");
	fprintf(fp,"			//	qcount = query_getHTML(poststr,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					while(tp->stype == 0 && tp->next != (TextBox *)NULL && i < %d)\n",NUMITEM);
	fprintf(fp,"					{\n");
	fprintf(fp,"						sf_tnext();\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(key[0],\"NONE\");\n");
	fprintf(fp,"		printf(\"%%s<br>\\n\",key[0]);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"	for(i=0;i<qcount;i++)\n");
	fprintf(fp,"		sprintf(KEY[i],\"%%s\",key[i]);\n");
	fprintf(fp,"	sf_tgetDBallHTML(0);\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// アップデート\n");
	fprintf(fp,"	// テーブル項目をsplitbDBbuff[]からDB配列にセットする\n");
	for(j=0;j<xcol;j++)
	{
		if((!strcmp(pgc[j].cell_fieldtype,"char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"	sprintf(%s, \"%%s\",key[%d]);\n",pgc[j].cell_title,p);
			fprintf(fp,"	sf_assputDB(no,%d,%s,%d + 1);\n",p,pgc[j].cell_title,pgc[j].cell_length);
			p++;
		}
		if((!strcmp(pgc[j].cell_fieldtype,"date")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"	sprintf(%s, \"%%s\",key[%d]);\n",pgc[j].cell_title,p);
			fprintf(fp,"	sf_assputDB(no,%d,%s,%d + 1);\n",p,pgc[j].cell_title,pgc[j].cell_length);
			p++;
		}
		if((!strcmp(pgc[j].cell_fieldtype,"int")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"	sprintf(DBbuff, \"%%s\",key[%d]);\n",p);
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",p,pgc[j].cell_length);
			fprintf(fp,"	%s = sf_to_integer(DBbuff);	//文字(char)をNUMERIC型(int)に変換する。\n",pgc[j].cell_title);
			p++;
		}
		if((!strcmp(pgc[j].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"	sprintf(DBbuff, \"%%s\",key[%d]);\n",p);
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",p,pgc[j].cell_length);
		//	fprintf(fp,"	%s = sf_to_integer(DBbuff);	//文字(char)をBOOL型(unsigned char)に変換する。\n",pgc[j].cell_title);
			fprintf(fp,"	%s = (unsigned char)DBbuff[0];	//文字(char)をBOOL型(unsigned char)に入れ替える。\n",pgc[j].cell_title);
			p++;
		}
		if((!strcmp(pgc[j].cell_fieldtype,"double")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"	sprintf(DBbuff, \"%%s\",key[%d]);\n",p);
			fprintf(fp,"	sf_assputDB(no,%d,DBbuff,%d + 1);\n",p,pgc[j].cell_length);
			fprintf(fp,"	%s = sf_to_double(DBbuff);	//文字(char)をDOUBLE型(double)に変換する。\n",pgc[j].cell_title);
			p++;
		}
	}
	fprintf(fp,"\n");

  	fprintf(fp,"	// 対象レコードをUPDATE\n");
	fprintf(fp,"	EXEC SQL UPDATE %s\n",sf);
	fprintf(fp,"	SET\n");

	for(j=0;j<n-1;j++)
	{
		if((!strcmp(pgc[j].cell_fieldtype,"char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s =	coalesce(:%s,\' \',\'0\')",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"date")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s = 	TO_TIMESTAMP(:%s, \'YYYY/MM/DD HH24:MI:SS\')",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"int")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if((!strcmp(pgc[j].cell_fieldtype,"double")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
		{
			fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
			if(j == n-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}
	if((!strcmp(pgc[j].cell_fieldtype,"char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
	{
		fprintf(fp,"		%s =	coalesce(:%s,\' \',\'0\')",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if((!strcmp(pgc[j].cell_fieldtype,"date")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if((!strcmp(pgc[j].cell_fieldtype,"int")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if((!strcmp(pgc[j].cell_fieldtype,"unsigned char")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
	if((!strcmp(pgc[j].cell_fieldtype,"double")) && (!strcmp(pgc[j].cell_skipstep,"STEP")))
	{
		fprintf(fp,"		%s = 	:%s",pgc[j].cell_title,pgc[j].cell_title);
		if(j == n-1)
			fprintf(fp,"\n");
		else
			fprintf(fp,",\n");
	}
//	fprintf(fp,"	WHERE %s = :%s AND %s = :%s;\n",pgc[0].cell_title,pgc[0].cell_title,pgc[1].cell_title,pgc[1].cell_title);
	fprintf(fp,"	WHERE ");
	p = 0;
	for(i=0,j=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
			fprintf(fp,"%s = :key[%d]",pgc[i].cell_title,p);
			if(j < KEYCOUNT - 1)
				fprintf(fp," AND ");
			j++;
		}
		if(!strcmp(pgc[i].cell_skipstep,"STEP"))
			p++;
	}
	if(pgc[i].keyflg == 1)
		fprintf(fp," %s = :key[%d];\n",pgc[i].cell_title,p);
	else
		fprintf(fp,";\n");

	fprintf(fp,"\n");
//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"	// 更新エラー\n");
  	fprintf(fp,"		// ロールバック\n");
	fprintf(fp,"		env1 = getenv(\"REMOTE_ADDR\");\n");
	fprintf(fp,"		env2 = getenv(\"HTTP_USER_AGENT\");\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->UPDATEエラー:%%d - %%s:%%s:%%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc,env1,env2);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		printf(\"<br>%%s\\n\",tmp);\n");
  	fprintf(fp,"		EXEC SQL ROLLBACK WORK;\n");
	fprintf(fp,"		EXEC SQL END;\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

  	fprintf(fp,"	//コミットする\n");
	fprintf(fp,"	EXEC SQL COMMIT;\n");
	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"\n");
	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->UPDATE結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		printf(\"<br>%%s\\n\",tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(1);
}

int AseEditor::putecpgDELETE(WINDOW *vs,int xcol, int xrow, char *f, char *sf)
{
	FILE *fp;
	int i,j,k,l,m,n;
	int flg;
	int tmp = 99;
//	char *dot;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

//	fprintf(fp,"int	Delete_%s(void)\n",f);
	fprintf(fp,"int	%s(void)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	static char DBbuff[MAX_STR];\n");
	fprintf(fp,"	int i = 0;\n");
	fprintf(fp,"	char *qs;\n");
	fprintf(fp,"	int qcount;\n");
	fprintf(fp,"	char *poststr;	//POSTメソッド用のポインタ\n");
	fprintf(fp,"	char *ps;\n");
	fprintf(fp,"	int len;\n");
	fprintf(fp,"	int n;\n");
	fprintf(fp,"	char *env1,*env2;\n");
	fprintf(fp,"\n");
	fprintf(fp,"	DBConnect();\n");
	fprintf(fp,"\n");
	fprintf(fp,"	memset (sqlca.sqlstate, \'0\', 5);\n");
	fprintf(fp,"\n");
  	fprintf(fp,"	EXEC SQL BEGIN DECLARE SECTION;\n");
	fprintf(fp,"	int rec_count;\n");
	fprintf(fp,"	char key[256][MAX_STR];\n");

	flg = 0;
	k = m = n = 0;
	l = 0;
	tmp = 99;

	for(i=0;i<xrow;i++,m++)
	{
		if(i > tmp)
			break;

		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				if(strlen(cp[j][i].s) < 2)
					sprintf(pgc[n].cell_fieldtype,"%s","int");
				else
					sprintf(pgc[n].cell_fieldtype,"%s","char");
				flg = 1;
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"t")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"d")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","date");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"n")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"$")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","int");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"B")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","unsigned char");
				l++;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"F")) && flg == 1)
			{
				sprintf(pgc[n].cell_fieldtype,"%s","double");
				l++;
				k++;
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				if(!strcmp(pgc[n].cell_fieldtype,"char"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//TEXT\n",pgc[n].cell_fieldtype,pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"date"))
				{
					fprintf(fp,"		%s	%s[%d + 1];	//DATE\n","char",pgc[n].cell_title,pgc[n].cell_length);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"int"))
				{
					fprintf(fp,"		%s		%s;		//NUMERIC\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"unsigned char"))
				{
					fprintf(fp,"		%s		%s;		//BOOL\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				if(!strcmp(pgc[n].cell_fieldtype,"double"))
				{
					fprintf(fp,"		%s		%s;		//DOUBLE\n",pgc[n].cell_fieldtype,pgc[n].cell_title);
				}
				k++;
				n++;
				l = 0;
				flg = 0;
				tmp = i;
			}
		}
	}
	fprintf(fp,"	EXEC SQL END DECLARE SECTION;\n");
	fprintf(fp,"\n");
    fprintf(fp,"	sqlcode = 0;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	// キー項目設定\n");
	fprintf(fp,"	if((qs = getenv(\"REQUEST_METHOD\")) != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		if(!strcmp(qs,\"GET\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((qs = getenv(\"QUERY_STRING\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				qcount = query_getHTML(qs,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else if(!strcmp(qs,\"POST\"))\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			if((ps = getenv(\"CONTENT_LENGTH\")) != (char *)NULL)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				len = atoi(ps);\n");
	fprintf(fp,"				poststr = malloc(len+1);\n");
	fprintf(fp,"				n = fread(poststr,1,len,stdin);\n");
	fprintf(fp,"				qcount = query_getHTML(poststr,'&');\n");
	fprintf(fp,"				sf_tbegin();\n");
	fprintf(fp,"				for(i=0;i < qcount;i++)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(strlen(decodeUTF(qt.get[i])) > tp->len)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						//文字の数がtp->len(定義したTEXT_BOXのカラム長)を超えた場合（例えば備考やメモのカラムの場合２００～２０４８桁の場合））\n");
	fprintf(fp,"						len = strlen(decodeUTF(qt.get[i]));\n");
	fprintf(fp,"						strncpy(key[i],decodeUTF(qt.get[i]),len);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						sprintf(key[i],\"%%s\",decodeUTF(qt.get[i]));\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					sf_tnext();\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(key[0],\"NONE\");\n");
	fprintf(fp,"		printf(\"%%s<br>\\n\",key[0]);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

	fprintf(fp,"\n");
	fprintf(fp,"	// 一致するレコードの行数を取得\n");
	fprintf(fp,"	EXEC SQL \n");
  	fprintf(fp,"	SELECT \n");
	fprintf(fp,"	COUNT(*)\n");
	fprintf(fp,"	INTO :rec_count\n");
	fprintf(fp,"	FROM	%s\n",f);
	fprintf(fp,"	WHERE ");
	for(i=0,j=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
			fprintf(fp,"%s = :key[%d]",pgc[i].cell_title,i);
			if(j < KEYCOUNT - 1)
				fprintf(fp," AND ");
			j++;
		}
	}
	if(pgc[i].keyflg == 1)
		fprintf(fp," %s = :key[%d];\n",pgc[i].cell_title,i);
	else
		fprintf(fp,";\n");

	fprintf(fp,"\n");

	fprintf(fp,"	// SELECTエラー \n");
	fprintf(fp,"	if(memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->SELECT COUNTエラー:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		return(-1) ;\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	if(rec_count == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		// 切断\n");
	fprintf(fp,"		sqlca.sqlcode = 0;\n");
	fprintf(fp,"		EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"		return(0);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

  	fprintf(fp,"	// 削除対象レコードをDELETE\n");
	fprintf(fp,"	EXEC SQL DELETE FROM %s\n",sf);
//	fprintf(fp,"	WHERE %s = :%s AND %s = :%s;\n",pgc[0].cell_title,pgc[0].cell_title,pgc[1].cell_title,pgc[1].cell_title);
	fprintf(fp,"	WHERE ");
	for(i=0,j=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
			fprintf(fp,"%s = :key[%d]",pgc[i].cell_title,i);
			if(j < KEYCOUNT - 1)
				fprintf(fp," AND ");
			j++;
		}
	}
	if(pgc[i].keyflg == 1)
		fprintf(fp," %s = :key[%d];\n",pgc[i].cell_title,i);
	else
		fprintf(fp,";\n");

//	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"	if (memcmp (sqlca.sqlstate, \"00000\", 5) != 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"	// 削除エラー\n");
  	fprintf(fp,"		// ロールバック\n");
	fprintf(fp,"		env1 = getenv(\"REMOTE_ADDR\");\n");
	fprintf(fp,"		env2 = getenv(\"HTTP_USER_AGENT\");\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->DELETEエラー:%%d - %%s:%%s:%%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc,env1,env2);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"		printf(\"<br>%%s\\n\",tmp);\n");
  	fprintf(fp,"		EXEC SQL ROLLBACK WORK;\n");
	fprintf(fp,"		EXEC SQL END;\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");

  	fprintf(fp,"	//コミットする\n");
	fprintf(fp,"	EXEC SQL COMMIT;\n");
	fprintf(fp,"	EXEC SQL END;\n");
	fprintf(fp,"\n");

	fprintf(fp,"\n");
	fprintf(fp,"	// 結果チェック\n");
	fprintf(fp,"	if (sqlca.sqlcode == 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		sprintf(tmp,\"%%s->DELETE結果チェック:%%d - %%s\",COMMANDNAME,sqlca.sqlcode,sqlca.sqlerrm.sqlerrmc);\n");
	fprintf(fp,"	//	logmsg(tmp);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"\n");
	fprintf(fp,"	// 切断\n");
	fprintf(fp,"	sqlca.sqlcode = 0;\n");
	fprintf(fp,"	EXEC SQL DISCONNECT dbConnection;\n");
	fprintf(fp,"	return(0);\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fclose(fp);
	return(0);
}

//テキストボックスの表示を列型にする
int AseEditor::putecpgInterFace(char *f, char *sf)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	fprintf(fp,"// ★DBから入出力(画面)ウインドウに書き込みます。\n");
	fprintf(fp,"void %s_text_writeHTML(int no, int post, int line,int maxcol, char **db_titles)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i;\n");
	fprintf(fp,"	int j;\n");
	fprintf(fp,"	char s[MAX_TMP];\n\n");
	
	fprintf(fp,"	printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"	printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<head>\\n\");\n");
	fprintf(fp,"	printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"	printf(\"<title>form text_writeHTML page</title>\\n\");\n");
	fprintf(fp,"	printf(\"<link rel=stylesheet type=\\\"text/css\\\" href=\\\"http://codoo2hk.corede.net/%s_Fetch.css\\\">\\n\");\n\n",sf);
	fprintf(fp,"	printf(\"</head>\\n\");\n");
	fprintf(fp,"	printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<br>\\n\");\n");
//	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");
//	fprintf(fp,"	printf(\"<tr>\\n\");\n");

	fprintf(fp,"// レコード移動にはDBcountのform番号10を利用する。\n");
	fprintf(fp,"// NEXT\n");
	fprintf(fp,"	if(autono[autoindex][1] < DBcount[10]-1)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi?field00=%%05d\\\">\\n\",autono[autono[autoindex][1]+1][0]);\n",f);
	fprintf(fp,"		printf(\"<input tabindex=7 type=\\\"submit\\\" value=\\\" ＞ \\\">\\n\");\n");
	fprintf(fp,"		printf(\"</form>\\n\");\n");
	fprintf(fp,"	}\n");

	fprintf(fp,"// PREV\n");
fprintf(fp,"	if(autono[autoindex][1] > 0)\n");
fprintf(fp,"	{\n");
fprintf(fp,"		printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi?field00=%%05d\\\">\\n\",autono[autono[autoindex][1]-1][0]);\n",f);
fprintf(fp,"		printf(\"<input tabindex=8 type=\\\"submit\\\" value=\\\" ＜ \\\">\\n\");\n");
fprintf(fp,"		printf(\"</form>\\n\");\n");
fprintf(fp,"	}\n");

	fprintf(fp,"// REWIND\n");
fprintf(fp,"	if(autono[autoindex][1] > 0)\n");
fprintf(fp,"	{\n");
fprintf(fp,"		printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi?field00=%%05d\\\">\\n\",autono[0][0]);\n",f);
fprintf(fp,"		printf(\"<input tabindex=9 type=\\\"submit\\\" value=\\\" |＜ \\\">\\n\");\n");
fprintf(fp,"		printf(\"</form>\\n\");\n");
fprintf(fp,"	}\n");

	fprintf(fp,"// FOERD\n");
fprintf(fp,"	if(autono[autoindex][1] < DBcount[10]-1)\n");
fprintf(fp,"	{\n");
fprintf(fp,"		printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi?field00=%%05d\\\">\\n\",autono[DBcount[10]-1][0]);\n",f);
fprintf(fp,"		printf(\"<input tabindex=10 type=\\\"submit\\\" value=\\\" ＞| \\\">\\n\");\n");
fprintf(fp,"		printf(\"</form>\\n\");\n");
fprintf(fp,"	}\n");

fprintf(fp,"	printf(\"<p>\\n\");\n");

	fprintf(fp,"	printf(\"<a href=\\\"http://codoo2hk.corede.net/index.html\\\" target=\\\"_parent\\\">[TOPへ]</a>\\n\");\n");
	fprintf(fp,"	printf(\"<a href=\\\"#\\\" onClick=\\\"history.back(); return false;\\\">[前に戻る]</a>\\n\");\n");
	fprintf(fp,"	//送信はPOSTを使用します。\n");

	fprintf(fp,"//テーブル名_Menu.pgc のコードを利用する場合、デバッグ時の送信試験はGETを使用すると便利です。\n");
	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form name=\\\"normal\\\" method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<form name=\\\"form%%06d\\\" method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s_Update.fcgi\\\">\\n\",999999);\n",sf);
	if(up ==1 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form name=\\\"update\\\" method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==0 && ins ==1 && del ==0)
		fprintf(fp,"	printf(\"<form name=\\\"insert\\\" method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==0 && ins ==0 && del ==1)
		fprintf(fp,"	printf(\"<form name=\\\"delete\\\" method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);

fprintf(fp,"// 以下のサンプルは削除するかどうかの警告を行うダイアログを表示するサンプルです。\n");
fprintf(fp,"//	printf(\"<form name=\\\"%s_Delete_all\\\" method=\\\"post\\\" action=\\\"/cgi-bin/%s_Delete.fcgi?field00=%%s\\\">\\n\",KEY[0]);\n",sf,sf);
fprintf(fp,"printf(\"<script type=\\\"text/javascript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function %s_Delete(n)\\n\");\n",sf);
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	if(window.confirm(\\\"削除されます。よろしいですか？\\\") == true)\\n\");\n");
fprintf(fp,"printf(\"	{\\n\");\n");
fprintf(fp,"printf(\"		alert(\\\"この顧客に関連する全てを削除します。\\\")\\n\");\n");
fprintf(fp,"printf(\"		document.%s_Delete_all.submit();\\n\");\n",sf);
fprintf(fp,"printf(\"	}\\n\");\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");
fprintf(fp,"//	printf(\"<input tabindex=1 accesskey=\\\"A\\\" type=\\\"button\\\" value=\\\"顧客削除\\\" onclick=\\\"%s_Delete()\\\">\\n\");\n",sf);

	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<td><input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"戻る\\\"></td>\\n\");\n");
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<td><input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"実行\\\"></td>\\n\");\n");
	if(up == 1 && ins == 0 && del == 0)
		fprintf(fp,"	printf(\"<td><input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"UPDATEが完了しました。戻ります\\\"></td>\\n\");\n");
	if(up == 0 && ins == 1 && del == 0)
		fprintf(fp,"	printf(\"<td><input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"INSERTが完了しました。戻ります\\\"></td>\\n\");\n");
	if(up == 0 && ins == 0 && del == 1)
		fprintf(fp,"	printf(\"<td><input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"DELETEが完了しました。戻ります\\\"></td>\\n\");\n");
//	fprintf(fp,"	printf(\"<tr>\");\n");
	fprintf(fp,"\n");

	fprintf(fp,"	printf(\"<p>\\n\");\n");

	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");

	fprintf(fp,"	sf_tbegin();\n");
	fprintf(fp,"	for(i=0;tp->next !=(TextBox *)NULL;i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"<tr>\");\n");
	fprintf(fp,"		if(ft[no].splitDBbuff[line][i] != (char *)NULL)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			printf(\"<td>\");\n");
	fprintf(fp,"			printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			printf(\"</td>\");\n");
	fprintf(fp,"			printf(\"<td>\");\n");

	fprintf(fp,"			switch(tp->ftype)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			case TEXT:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					switch(i)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"					case 0:\n");
	fprintf(fp,"						break;\n");

	fprintf(fp,"					case 4:\n");
	fprintf(fp,"				//	郵便番号\n");
//fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"printf(\"<script type=\\\"text/javascript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function yubin_search%%06d()\\n\",999999);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	var zipcode%%06d = document.getElementById('zipcode%%06d').value;\\n\",999999,999999);\n");
//fprintf(fp,"//printf(\"alert(zipcode%%05d);\\n\",line);\n");
//printf("	window.open('http://codoo2hk.corede.net/cgi-bin/yubin_Fetch.cgi?field='+zipcode%%06d+'&amp;field=%%06d' , \\\"width=800,height=500,location=no,menubar=no,toolbar=no,resizable=yes,scrollbars=yes\\\" );\\n\",999999,999999);\n");
fprintf(fp,"printf(\"	window.open('http://codoo2hk.corede.net/cgi-bin/yubin_Fetch.cgi?field='+zipcode%%06d+'&amp;field=%%06d'+'&amp;field=5'+'&amp;field=6');\\n\",999999,999999);\n");
fprintf(fp,"printf(\"}\\n\");\n");
 
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");
 
	fprintf(fp,"						printf(\"<input type=\\\"text\\\" id=\\\"zipcode%%06d\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" placeholder=\\\"郵便番号を入力の後TABキーで決定して下さい\\\" onchange=\\\"yubin_search%%06d()\\\">\\n\",999999,i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len,999999);\n");
	fprintf(fp,"						break;\n");

	fprintf(fp,"					case 5:\n");
	fprintf(fp,"				//	都道府県\n");
//	fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"						printf(\"<select name=\\\"field%%02d\\\" id=\\\"todofuken%%05d\\\" size=\\\"1\\\">\\n\",i,99999);\n");
	fprintf(fp,"						printf(\"<option value=\\\"\\\">選択なし</option>\\n\");\n");
	fprintf(fp,"						for(j=0;j<26;j++)\n");
	fprintf(fp,"						{\n");
	fprintf(fp,"							if(!strcmp(ft[no].splitDBbuff[line][i],prefecture[j]))\n");
	fprintf(fp,"							{\n");
	fprintf(fp,"								printf(\"<option value=\\\"%%s\\\" selected>%%s</option>\\n\",prefecture[j],prefecture[j]);\n");
	fprintf(fp,"							}\n");
	fprintf(fp,"							else\n");
	fprintf(fp,"							{\n");
	fprintf(fp,"								printf(\"<option value=\\\"%%s\\\">%%s</option>\\n\",prefecture[j],prefecture[j]);\n");
	fprintf(fp,"							}\n");
	fprintf(fp,"						}\n");
	fprintf(fp,"						printf(\"</select>\\n\");\n");
	fprintf(fp,"						break;\n");
	
	fprintf(fp,"					case 6:\n");
	fprintf(fp,"				//	住所１\n");
//	fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"						printf(\"<input type=\\\"text\\\" id=\\\"address%%05d\\\" name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\">\\n\",99999,i,i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"						break;\n");

	fprintf(fp,"					default:\n");
	fprintf(fp,"						if(tp->len > 256)\n");
	fprintf(fp,"							printf(\"<textarea name=\\\"field%%02d\\\" rows=\\\"8\\\" cols=\\\"%%d\\\">%%s</textarea>\\n\",i,tp->len/16,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"						else\n");
	fprintf(fp,"							printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\">\\n\",i,i,tp->len,ft[no].splitDBbuff[line][i],tp->len);\n");
								//		printf("<input type=\"text\" class=\"field%02d\" name=\"field%02d\" size=\"%d\" value=\"%s\" maxlength=\"%d\">\n",i,i,tp->len,ft[no].splitDBbuff[line][i],tp->len);
	fprintf(fp,"						break;\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
							//		printf("<input type=\"text\" name=\"field%02d\" size=\"%d\" value=\"%s\" maxlength=\"%d\" readonly>\n",i,tp->len,ft[no].splitDBbuff[line][i],tp->len);
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",i,tp->len,ft[no].splitDBbuff[line][i],tp->len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"		//	case TEXT:\n");
	fprintf(fp,"		//		if(tp->action == 0)\n");
	fprintf(fp,"		//		{\n");
	fprintf(fp,"		//			printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"		//		}\n");
	fprintf(fp,"		//		else\n");
	fprintf(fp,"		//		{\n");
	fprintf(fp,"		//			printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"		//		}\n");
	fprintf(fp,"		//		break;\n");
	fprintf(fp,"			case DATE:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case NUMERIC:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case BOOL:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"				//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\"> <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"					if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"t\\\"><br>\\n\",i);\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"				//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\" readonly> <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				//この部分はチェックボックスに使用出来ますが更新や追加には使用出来ません。表示のみに利用可能です。\n");
	fprintf(fp,"					if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" readonly><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked readonly><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");

	fprintf(fp,"				break;\n");
	fprintf(fp,"			case CURRENCY:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case DOUBLE:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			default:\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			}\n");

	fprintf(fp,"			sprintf(s,\"%%s\",ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			sf_tput(no,i,s);\n");
	fprintf(fp,"			sf_tnext();\n");
	fprintf(fp,"			printf(\"</td>\");\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			sf_tnext();\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		printf(\"</tr>\");\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	printf(\"<tr>\");\n");
	fprintf(fp,"	if(ft[no].splitDBbuff[line][i] != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"<td>\");\n");
	fprintf(fp,"		printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"		printf(\"</td>\");\n");
	fprintf(fp,"		printf(\"<td>\");\n");
	fprintf(fp,"		switch(tp->ftype)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"		case TEXT:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				if(tp->len > 256)\n");
	fprintf(fp,"					printf(\"<textarea name=\\\"field%%02d\\\" rows=\\\"8\\\" cols=\\\"%%d\\\">%%s</textarea>\\n\",i,tp->len/16,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\">\\n\",i,i,tp->len,ft[no].splitDBbuff[line][i],tp->len);\n");
	fprintf(fp,"			//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case DATE:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case NUMERIC:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case BOOL:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\"> <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"t\\\"><br>\\n\",i);\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\" readonly> <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			//この部分はチェックボックスに使用出来ますが更新や追加には使用出来ません。表示のみに利用可能です。\n");
	fprintf(fp,"				if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" readonly><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked readonly><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case CURRENCY:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case DOUBLE:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		default:\n");
	fprintf(fp,"			printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" <br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		}\n");

	fprintf(fp,"		sprintf(s,\"%%s\",ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"		sf_tput(no,i,s);\n");
	fprintf(fp,"		printf(\"</td>\");\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	printf(\"</tr>\\n\");\n");
	fprintf(fp,"	printf(\"</table>\\n\");\n");
	fprintf(fp,"	printf(\"</form>\\n\");\n");
	fprintf(fp,"	printf(\"</body>\\n\");\n");
	fprintf(fp,"	printf(\"</html>\\n\");\n");
	fprintf(fp,"}\n");

	fprintf(fp,"// FETCHした後にHTMLのテーブルにDBの行列を書き込みます。\n");
	fprintf(fp,"int %s_grid_dispHTML(int no, int startline, int maxcol, int grid_ey, int grid_sy,int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i, j;\n");
	fprintf(fp,"	char s[MAX_TMP];\n");
	fprintf(fp,"	char hs[MAX_TMP];\n");
	fprintf(fp,"\n");
	fprintf(fp,"	if((Fetch_%s(no,line)) == 0)\n",f);
	fprintf(fp,"	{\n");
//2010.04.21
//	fprintf(fp,"		for(i=startline;i<(grid_ey-grid_sy)+1;i++)\n");
	fprintf(fp,"		for(i=startline;i<DBcount[no];i++)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			for(j=0;j<maxcol;j++)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				sf_gputDBHTML(no,i,j,startline,s);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"\n");
	fprintf(fp,"		return(0);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");


	fclose(fp);
	return(0);
}

//テキストボックスの表示をカード型にする
int AseEditor::putecpgInterFace2(char *f, char *sf)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	fprintf(fp,"// ★★DBから入出力(画面)ウインドウに書き込みます。\n");
	fprintf(fp,"void %s_text_writeHTML(int no, int post, int line,int maxcol, char **db_titles)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i;\n");
	fprintf(fp,"	int j;\n");
	fprintf(fp,"	int k;\n");
	fprintf(fp,"	int x;\n");
	fprintf(fp,"	char s[MAX_TMP];\n\n");
	
	fprintf(fp,"	printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"	printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<head>\\n\");\n");
	fprintf(fp,"	printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"	printf(\"<title>form text_writeHTML page</title>\\n\");\n");
	fprintf(fp,"	printf(\"<link rel=stylesheet type=\\\"text/css\\\" href=\\\"http://codoo2hk.corede.net/%s_Fetch.css\\\">\\n\");\n\n",sf);

	//MkArray()は共通関数
	fprintf(fp,"printf(\"<script language=\\\"JavaScript\\\">\\n\\n\");\n");
	fprintf(fp,"printf(\"<!--\\n\");\n");
	fprintf(fp,"printf(\"function MkArray(n)\\n\");\n");
	fprintf(fp,"printf(\"{\\n\");\n");
	fprintf(fp,"printf(\"	this.length = n;\\n\");\n");
	fprintf(fp,"printf(\"	for (var i=1;i<=n;i++)\\n\");\n");
	fprintf(fp,"printf(\"	{\\n\");\n");
	fprintf(fp,"printf(\"		this[i] = 0\\n\");\n");
	fprintf(fp,"printf(\"		return this\\n\");\n");
	fprintf(fp,"printf(\"	}\\n\");\n");
	fprintf(fp,"printf(\"}\\n\");\n");
	fprintf(fp,"printf(\"//-->\\n\");\n");
	fprintf(fp,"printf(\"</script>\\n\\n\");\n");

	fprintf(fp,"	printf(\"</head>\\n\");\n");
	fprintf(fp,"	printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<br>\\n\");\n");

//	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");
//	fprintf(fp,"	printf(\"<td>%%05d</td>\\n\",line+1);\n");
//	fprintf(fp,"	printf(\"<hr size=\\\"3\\\" color=\\\"#000000\\\">\");\n");
//	fprintf(fp,"	printf(\"<a name=\\\"form%%05d\\\"></a>\\n\",line);\n");
//	fprintf(fp,"	printf(\"</table>\\n\");\n");

	fprintf(fp,"	printf(\"<hr size=\\\"3\\\" color=\\\"#000000\\\">\");\n");
	fprintf(fp,"	printf(\"<a name=\\\"form%%05d\\\"></a>\\n\",line);\n");
	fprintf(fp,"	printf(\"%%05d\\n\",line+1);\n");

	fprintf(fp,"	printf(\"<form name=\\\"menu\\\" action=\\\"\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<a href=\\\"http://codoo2hk.corede.net/index.html\\\" target=\\\"_parent\\\">[TOPへ]</a>\\n\");\n");
	fprintf(fp,"	printf(\"<a href=\\\"#\\\" onClick=\\\"history.back(); return false;\\\">[前に戻る]</a>\\n\");\n");
	fprintf(fp,"	printf(\"<form>\\n\");\n");
	fprintf(fp,"// この下に実行するCGIへのPOSTメソッドを記述してください。以下がサンプルです。\n");
	fprintf(fp,"	//	printf(\"<form name=\\\"Fetch\\\" method=\\\"post\\\" action=\\\"/cgi-bin/otodoke_Fetch.fcgi?field=%%s\\\">\\n\",KEY[0]);\n");
	fprintf(fp,"	//	printf(\"<input type=\\\"submit\\\" value=\\\"新規追加画面へ\\\"><br>\\n\");\n");
	fprintf(fp,"\n");
	fprintf(fp,"	//送信はPOSTを使用します。\n");

	fprintf(fp,"//テーブル名_Menu.pgc のコードを利用する場合、デバッグ時の送信試験はGETを使用すると便利です。\n");
	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<form name=\\\"form%%05d\\\" style=\\\"float:left\\\" method=\\\"post\\\" action=\\\"/cgi-bin/%s_Update2.fcgi\\\">\\n\",line);\n",sf);
	if(up ==1 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==0 && ins ==1 && del ==0)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==0 && ins ==0 && del ==1)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);

fprintf(fp,"// 以下のサンプルは削除するかどうかの警告を行うダイアログを表示するサンプルです。\n");
fprintf(fp,"//	printf(\"<form name=\\\"%s_Delete_all\\\" method=\\\"post\\\" action=\\\"/cgi-bin/%s_Delete.fcgi?field00=%%s\\\">\\n\",KEY[0]);\n",sf,sf);
fprintf(fp,"printf(\"<script type=\\\"text/javascript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function %s_Delete(n)\\n\");\n",sf);
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	if(window.confirm(\\\"削除されます。よろしいですか？\\\") == true)\\n\");\n");
fprintf(fp,"printf(\"	{\\n\");\n");
fprintf(fp,"printf(\"		alert(\\\"この顧客に関連する全てを削除します。\\\")\\n\");\n");
fprintf(fp,"printf(\"		document.%s_Delete_all.submit();\\n\");\n",sf);
fprintf(fp,"printf(\"	}\\n\");\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");
fprintf(fp,"//	printf(\"<input tabindex=1 accesskey=\\\"A\\\" type=\\\"button\\\" value=\\\"顧客削除\\\" onclick=\\\"%s_Delete()\\\">\\n\");\n",sf);

	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"B\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"戻る\\\">\\n\");\n");
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<input accesskey=\\\"C\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"実行\\\" onclick=\\\"submit%%d()\\\">\\n\",line);\n");
	if(up == 1 && ins == 0 && del == 0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"U\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"UPDATEが完了しました。戻ります\\\">\\n\");\n");
	if(up == 0 && ins == 1 && del == 0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"I\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"INSERTが完了しました。戻ります\\\">\\n\");\n");
	if(up == 0 && ins == 0 && del == 1)
		fprintf(fp,"	printf(\"<input accesskey=\\\"D\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"DELETEが完了しました。戻ります\\\">\\n\");\n");
	fprintf(fp,"\n");

	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");
	fprintf(fp,"	printf(\"<tr>\\n\");\n");

	fprintf(fp,"	k = 0;\n");
	fprintf(fp,"	sf_tbegin();\n");
	fprintf(fp,"	for(i=0;tp->next !=(TextBox *)NULL;i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		if(ft[no].splitDBbuff[line][i] != (char *)NULL)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			switch(ft[no].pos[i].ftype)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			case TEXT:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"//以下の部分はコンボボックスを定義する場合に利用して下さい。その場合 テーブル名_Menu.pgc のコードを利用します。\n");
	fprintf(fp,"//テーブル名_Menu.pgc のコードはMakeTextBox()の関数呼び出しを省いて利用してください。\n");
	fprintf(fp,"//連結先のDBcount[フォーム番号]は必ず確認してください。\n");
	fprintf(fp,"#ifdef COMBOBOX\n");
	fprintf(fp,"					switch(i)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"					case 0:\n");
//ここにフォーム毎に実行するJavaScriptを記述します。
fprintf(fp,"//この下に記述されているJavaScriptを実行することで更新後の表示行を元に戻ることが出来ます。\n");
fprintf(fp,"printf(\"<script language=\\\"JavaScript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function submit%%d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	document.form%%05d.tmp.value = \\\"%%05d\\\";\\n\",line,line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"\\n\");\n");

fprintf(fp,"printf(\"function select_1st%%d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	var index1 = 0;\\n\");\n");
fprintf(fp,"printf(\"//	var index2 = 0;\\n\");\n");
fprintf(fp,"printf(\"	s1 = new MkArray(%%d);\\n\",DBcount[3]);\n");
fprintf(fp,"printf(\"//	s2 = new MkArray(%%d);\\n\",DBcount[3]);\n");
			fprintf(fp,"for(x=0;x<DBcount[3];x++)\n");
			fprintf(fp,"{\n");
				fprintf(fp,"printf(\"		s1[%%d] = \\\"%%s\\\";\\n\",x,ft[3].splitDBbuff[x][1]);\n");
				fprintf(fp,"printf(\"	//	s2[%%d] = \\\"%%s\\\";\\n\",x,ft[3].splitDBbuff[x][0]);\n");
			fprintf(fp,"}\n");
fprintf(fp,"printf(\"	index1 = document.form%%05d.field%%02d.selectedIndex;\\n\",line,k);\n");
fprintf(fp,"printf(\"	index2 = document.form%%05d.field%%02d.selectedIndex;\\n\",line,k);\n");
fprintf(fp,"//printf(\"	alert(document.form%%05d.field%%02d.selectedIndex);\\n\",line,k);\n");
fprintf(fp,"printf(\"	document.form%%05d.field%%02d.value = s1[index1-1];\\n\",line,k+1);\n");
fprintf(fp,"printf(\"//	document.form%%05d.field%%02d.value = s2[index2-1];\\n\",line,k+3);\n");
fprintf(fp,"printf(\"	submit%%d();\\n\",line);\n");
fprintf(fp,"printf(\"	document.form%%05d.submit();\\n\",line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"function select_2nd%%d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	submit%%d();\\n\",line);\n");
fprintf(fp,"printf(\"	document.form%%05d.submit();\\n\",line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"\\n\");\n");
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");

	fprintf(fp,"						printf(\"<select name=\\\"field%%02d\\\" size=\\\"1\\\" maxlength=\\\"64\\\" onchange=\\\"select_1st%%d()\\\">\\n\",k,line);\n");
	fprintf(fp,"						for(j=0;j<DBcount[連結先のフォーム番号を入れます];j++)\n");
	fprintf(fp,"						{\n");
	fprintf(fp,"							if(!strcmp(ft[no].splitDBbuff[line][i],ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます]))\n");
	fprintf(fp,"								printf(\"<option value=\\\"%%s\\\" selected> %%s</option>\\n\",ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます],ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます]);\n");
	fprintf(fp,"							else\n");
	fprintf(fp,"								printf(\"<option value=\\\"%%s\\\"> %%s</option>\\n\",ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます],ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます]);\n");
	fprintf(fp,"						}\n");
	fprintf(fp,"						break;\n");
fprintf(fp,"					case 1:\n");
fprintf(fp,"				//	郵便番号\n");
fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"printf(\"<script type=\\\"text/javascript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function yubin_search%%05d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	var zipcode%%05d = document.getElementById('zipcode%%05d').value;\\n\",line,line);\n");
//fprintf(fp,"//printf(\"alert(zipcode%%05d);\\n\",line);\n");
//printf("	window.open('http://codoo2hk.corede.net/cgi-bin/yubin_Fetch.cgi?field='+zipcode%%05d+'&amp;field=%%05d' , \\\"width=800,height=500,location=no,menubar=no,toolbar=no,resizable=yes,scrollbars=yes\\\" );\\n\",line,line);\n");
fprintf(fp,"printf(\"	window.open('http://codoo2hk.corede.net/cgi-bin/yubin_Fetch.cgi?field='+zipcode%%05d+'&amp;field=%%05d'+'&amp;field=2'+'&amp;field=3');\\n\",line,line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
 
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");
 
fprintf(fp,"						printf(\"<input type=\\\"text\\\" id=\\\"zipcode%%05d\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" onchange=\\\"yubin_search%%05d()\\\">\\n\",line,k,ft[no].pos[i].len/2,ft[no].splitDBbuff[line][i],ft[no].pos[i].len,line);\n");
fprintf(fp,"						break;\n");

fprintf(fp,"					case 2:\n");
fprintf(fp,"				//	都道府県\n");
fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"						printf(\"<select name=\\\"field%%02d\\\" id=\\\"todofuken\\\" size=\\\"1\\\">\\n\",k);\n");
fprintf(fp,"						printf(\"<option value=\\\"\\\">選択なし</option>\\n\");\n");
fprintf(fp,"						for(j=0;j<26;j++)\n");
fprintf(fp,"						{\n");
fprintf(fp,"							if(!strcmp(ft[no].splitDBbuff[line][i],prefecture[j]))\n");
fprintf(fp,"							{\n");
fprintf(fp,"								printf(\"<option value=\\\"%%s\\\" selected>%%s</option>\\n\",prefecture[j],prefecture[j]);\n");
fprintf(fp,"							}\n");
fprintf(fp,"							else\n");
fprintf(fp,"							{\n");
fprintf(fp,"								printf(\"<option value=\\\"%%s\\\">%%s</option>\\n\",prefecture[j],prefecture[j]);\n");
fprintf(fp,"							}\n");
fprintf(fp,"						}\n");
fprintf(fp,"						printf(\"</select>\\n\");\n");
fprintf(fp,"						break;\n");

fprintf(fp,"					case 3:\n");
fprintf(fp,"				//	住所１\n");
fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"						printf(\"<input type=\\\"text\\\" id=\\\"address\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\">\\n\",k,k,k,ft[no].pos[i].len/2,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
fprintf(fp,"						break;\n");

	fprintf(fp,"						break;\n");
	fprintf(fp,"					default:\n");
	fprintf(fp,"						printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"						printf(\"</select>\\n\");\n");
	fprintf(fp,"						break;\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"#else\n");

	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"#endif\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case DATE:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"date\\\" tabindex=%%d name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"date\\\" tabindex=%%d name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case NUMERIC:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case BOOL:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"t\\\">\\n\",k,k);\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked>\\n\",k,k,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\">\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"				//この部分はチェックボックスに使用出来ますが更新や追加には使用出来ません。表示のみに利用可能です。\n");
	fprintf(fp,"					if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"%%s\\\" readonly>\\n\",k,k,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"					else\n");
	fprintf(fp,"						printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked readonly>\\n\",k,k,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly>\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");

	fprintf(fp,"				break;\n");
	fprintf(fp,"			case CURRENCY:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case DOUBLE:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			default:\n");
	fprintf(fp,"				if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"					k++;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			}\n");

	fprintf(fp,"			sprintf(s,\"%%s\",ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			sf_tput(no,k,s);\n");
	fprintf(fp,"			sf_tnext();\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			sf_tnext();\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	if(ft[no].splitDBbuff[line][i] != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		switch(ft[no].pos[i].ftype)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"		case TEXT:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"//以下の部分はコンボボックスを定義する場合に利用して下さい。その場合 テーブル名_Menu.pgc のコードを利用します。\n");
	fprintf(fp,"//テーブル名_Menu.pgc のコードはMakeTextBox()の関数呼び出しを省いて利用してください。\n");
	fprintf(fp,"//連結先のDBcount[フォーム番号]は必ず確認してください。\n");
	fprintf(fp,"#ifdef COMBOBOX\n");
	fprintf(fp,"				switch(i)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"				case 0:\n");
//ここにフォーム毎に実行するJavaScriptを記述します。
fprintf(fp,"//この下に記述されているJavaScriptを実行することで更新後の表示行を元に戻ることが出来ます。\n");
fprintf(fp,"printf(\"<script language=\\\"JavaScript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function submit%%d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	document.form%%05d.tmp.value = \\\"%%05d\\\";\\n\",line,line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"\\n\");\n");

fprintf(fp,"printf(\"function select_1st%%d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	var index1 = 0;\\n\");\n");
fprintf(fp,"printf(\"//	var index2 = 0;\\n\");\n");
fprintf(fp,"printf(\"	s1 = new MkArray(%%d);\\n\",DBcount[3]);\n");
fprintf(fp,"printf(\"//	s2 = new MkArray(%%d);\\n\",DBcount[3]);\n");
			fprintf(fp,"for(x=0;x<DBcount[3];x++)\n");
			fprintf(fp,"{\n");
				fprintf(fp,"printf(\"		s1[%%d] = \\\"%%s\\\";\\n\",x,ft[3].splitDBbuff[x][1]);\n");
				fprintf(fp,"printf(\"	//	s2[%%d] = \\\"%%s\\\";\\n\",x,ft[3].splitDBbuff[x][0]);\n");
			fprintf(fp,"}\n");
fprintf(fp,"printf(\"	index1 = document.form%%05d.field%%02d.selectedIndex;\\n\",line,k);\n");
fprintf(fp,"printf(\"//	index2 = document.form%%05d.field%%02d.selectedIndex;\\n\",line,k);\n");
fprintf(fp,"//printf(\"	alert(document.form%%05d.field%%02d.selectedIndex);\\n\",line,k);\n");
fprintf(fp,"printf(\"	document.form%%05d.field%%02d.value = s1[index1-1];\\n\",line,k+1);\n");
fprintf(fp,"printf(\"//	document.form%%05d.field%%02d.value = s2[index2-1];\\n\",line,k+3);\n");
fprintf(fp,"printf(\"	submit%%d();\\n\",line);\n");
fprintf(fp,"printf(\"	document.form%%05d.submit();\\n\",line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"function select_2nd%%d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	submit%%d();\\n\",line);\n");
fprintf(fp,"printf(\"	document.form%%05d.submit();\\n\",line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
fprintf(fp,"printf(\"\\n\");\n");
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");
//ここにフォーム毎に実行するJavaScriptを記述します。
	fprintf(fp,"					printf(\"<select name=\\\"field%%02d\\\" tabindex=%%d size=\\\"1\\\" maxlength=\\\"64\\\" onchange=\\\"select_1st%%d()\\\">\\n\",k,k,line);\n");
	fprintf(fp,"					for(j=0;j<DBcount[連結先のフォーム番号を入れます];j++)\n");
	fprintf(fp,"					{\n");
	fprintf(fp,"						if(!strcmp(ft[no].splitDBbuff[line][i],ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます]))\n");
	fprintf(fp,"							printf(\"<option value=\\\"%%s\\\" selected> %%s</option>\\n\",ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます],ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます]);\n");
	fprintf(fp,"						else\n");
	fprintf(fp,"							printf(\"<option value=\\\"%%s\\\"> %%s</option>\\n\",ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます],ft[連結先のフォーム番号を入れます].splitDBbuff[j][連結先の項目番号を入れます]);\n");
	fprintf(fp,"					}\n");
	fprintf(fp,"					printf(\"</select>\\n\");\n");
	fprintf(fp,"					break;\n");
fprintf(fp,"					case 1:\n");
fprintf(fp,"				//	郵便番号\n");
fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"printf(\"<script type=\\\"text/javascript\\\">\\n\\n\");\n");
fprintf(fp,"printf(\"<!--\\n\");\n");
fprintf(fp,"printf(\"function yubin_search%%05d()\\n\",line);\n");
fprintf(fp,"printf(\"{\\n\");\n");
fprintf(fp,"printf(\"	var zipcode%%05d = document.getElementById('zipcode%%05d').value;\\n\",line,line);\n");
//fprintf(fp,"//printf(\"alert(zipcode%%05d);\\n\",line);\n");
//printf("	window.open('http://codoo2hk.corede.net/cgi-bin/yubin_Fetch.cgi?field='+zipcode%%05d+'&amp;field=%%05d' , \\\"width=800,height=500,location=no,menubar=no,toolbar=no,resizable=yes,scrollbars=yes\\\" );\\n\",line,line);\n");
fprintf(fp,"printf(\"	window.open('http://codoo2hk.corede.net/cgi-bin/yubin_Fetch.cgi?field='+zipcode%%05d+'&amp;field=%%05d'+'&amp;field=2'+'&amp;field=3');\\n\",line,line);\n");
fprintf(fp,"printf(\"}\\n\");\n");
 
fprintf(fp,"printf(\"//-->\\n\");\n");
fprintf(fp,"printf(\"</script>\\n\\n\");\n");
 
fprintf(fp,"						printf(\"<input type=\\\"text\\\" id=\\\"zipcode%%05d\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" onchange=\\\"yubin_search%%05d()\\\">\\n\",line,k,ft[no].pos[i].len/2,ft[no].splitDBbuff[line][i],ft[no].pos[i].len,line);\n");
fprintf(fp,"						break;\n");

fprintf(fp,"					case 2:\n");
fprintf(fp,"				//	都道府県\n");
fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"						printf(\"<select name=\\\"field%%02d\\\" id=\\\"todofuken\\\" size=\\\"1\\\">\\n\",k);\n");
fprintf(fp,"						printf(\"<option value=\\\"\\\">選択なし</option>\\n\");\n");
fprintf(fp,"						for(j=0;j<26;j++)\n");
fprintf(fp,"						{\n");
fprintf(fp,"							if(!strcmp(ft[no].splitDBbuff[line][i],prefecture[j]))\n");
fprintf(fp,"							{\n");
fprintf(fp,"								printf(\"<option value=\\\"%%s\\\" selected>%%s</option>\\n\",prefecture[j],prefecture[j]);\n");
fprintf(fp,"							}\n");
fprintf(fp,"							else\n");
fprintf(fp,"							{\n");
fprintf(fp,"								printf(\"<option value=\\\"%%s\\\">%%s</option>\\n\",prefecture[j],prefecture[j]);\n");
fprintf(fp,"							}\n");
fprintf(fp,"						}\n");
fprintf(fp,"						printf(\"</select>\\n\");\n");
fprintf(fp,"						break;\n");

fprintf(fp,"					case 3:\n");
fprintf(fp,"				//	住所１\n");
fprintf(fp,"						printf(\"%%s:\",*(db_titles+i));\n");
fprintf(fp,"						printf(\"<input type=\\\"text\\\" id=\\\"address\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\">\\n\",k,k,k,ft[no].pos[i].len/2,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
fprintf(fp,"						break;\n");
	fprintf(fp,"				default:\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"					break;\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"#else\n");

	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"#endif\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case DATE:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"date\\\" tabindex=%%d name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"date\\\" tabindex=%%d name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case NUMERIC:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case BOOL:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"t\\\">\\n\",k,k);\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked>\\n\",k,k,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\">\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			//この部分はチェックボックスに使用出来ますが更新や追加には使用出来ません。表示のみに利用可能です。\n");
	fprintf(fp,"				if(ft[no].splitDBbuff[line][i][0] == 'f')\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"%%s\\\" readonly>\\n\",k,k,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" tabindex=%%d name=\\\"field%%02d\\\" value=\\\"%%s\\\" checked readonly>\\n\",k,k,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			//	printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\" readonly>\\n\",k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case CURRENCY:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"15\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case DOUBLE:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			if(ft[no].pos[i].action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" maxlength=\\\"%%d\\\" readonly >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		default:\n");
	fprintf(fp,"			if(ft[no].pos[i].stype == 1)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" tabindex=%%d name=\\\"field%%02d\\\" class=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"%%s\\\" >\\n\",k,k,k,ft[no].pos[i].len,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		}\n");

	fprintf(fp,"		sprintf(s,\"%%s\",ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"		sf_tput(no,k,s);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	printf(\"<input type=\\\"hidden\\\" tabindex=%%d name=\\\"tmp\\\" size=\\\"4\\\" value=\\\"\\\" >\\n\");\n");
	fprintf(fp,"	printf(\"</tr>\\n\");\n");
	fprintf(fp,"	printf(\"</table>\\n\");\n");
	fprintf(fp,"	printf(\"</form>\\n\");\n");
//	fprintf(fp,"	printf(\"</body>\\n\");\n");
//	fprintf(fp,"	printf(\"</html>\\n\");\n");
	fprintf(fp,"}\n");

	fprintf(fp,"// FETCHした後にHTMLのテーブルにDBの行列を書き込みます。\n");
	fprintf(fp,"int %s_grid_dispHTML(int no, int startline, int maxcol, int grid_ey, int grid_sy, int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i, j;\n");
	fprintf(fp,"	char s[MAX_TMP];\n");
	fprintf(fp,"	char hs[MAX_TMP];\n");
	fprintf(fp,"\n");
	fprintf(fp,"	if((Fetch_%s(no,line)) == 0)\n",f);
	fprintf(fp,"	{\n");
//2010.04.21
//	fprintf(fp,"		for(i=startline;i<(grid_ey-grid_sy)+1;i++)\n");
	fprintf(fp,"		for(i=startline;i<DBcount[no];i++)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			for(j=0;j<maxcol;j++)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				if(ft[no].cp[0][j].stype == 1)\n");
	fprintf(fp,"					sf_gputDBHTML(no,i,j,startline,s);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"\n");
	fprintf(fp,"		return(0);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");


	fclose(fp);
	return(0);
}

//新規追加の場合このソースを利用する。（列型）
int AseEditor::putecpgInterFace_New(char *f, char *sf)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	fprintf(fp,"// DBから入出力(画面)ウインドウに書き込みます。\n");
	fprintf(fp,"void %s_text_writeHTML(int no, int post, int line,int maxcol, char **db_titles)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i;\n");
	fprintf(fp,"	int j;\n");
	fprintf(fp,"	char s[MAX_TMP];\n\n");
	
	fprintf(fp,"	printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"	printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<head>\\n\");\n");
	fprintf(fp,"	printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"	printf(\"<title>form text_writeHTML page</title>\\n\");\n");
	fprintf(fp,"	printf(\"</head>\\n\");\n");
	fprintf(fp,"	printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<br>\\n\");\n");

	fprintf(fp,"	printf(\"<a href=\\\"http://codoo2hk.corede.net/index.html\\\" target=\\\"_parent\\\">[TOPへ]</a>\\n\");\n");
	fprintf(fp,"	printf(\"<a href=\\\"#\\\" onClick=\\\"history.back(); return false;\\\">[前に戻る]</a>\\n\");\n");
	fprintf(fp,"	//送信はPOSTを使用します。\n");

	fprintf(fp,"//テーブル名_Menu.pgc のコードを利用する場合、デバッグ時の送信試験はGETを使用すると便利です。\n");
	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form name=\\\"normal\\\" method=\\\"post\\\"  style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<form name=\\\"form%%02d\\\" method=\\\"post\\\" style=\\\"float:left\\\"  action=\\\"/cgi-bin/%s_Update.fcgi\\\">\\n\",line);\n",sf);
	if(up ==1 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form name=\\\"update\\\" method=\\\"post\\\" style=\\\"float:left\\\"  action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==0 && ins ==1 && del ==0)
		fprintf(fp,"	printf(\"<form name=\\\"insert\\\" method=\\\"post\\\" style=\\\"float:left\\\"  action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==0 && ins ==0 && del ==1)
		fprintf(fp,"	printf(\"<form name=\\\"delete\\\" method=\\\"post\\\" style=\\\"float:left\\\"  action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);

	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"戻る\\\">\\n\");\n");
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"実行\\\">\\n\");\n");
	if(up == 1 && ins == 0 && del == 0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"UPDATEが完了しました。戻ります\\\">\\n\");\n");
	if(up == 0 && ins == 1 && del == 0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"INSERTが完了しました。戻ります\\\">\\n\");\n");
	if(up == 0 && ins == 0 && del == 1)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"DELETEが完了しました。戻ります\\\">\\n\");\n");
	fprintf(fp,"\n");

	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");
	fprintf(fp,"	printf(\"<tr>\\n\");\n");

	fprintf(fp,"	sf_tbegin();\n");
	fprintf(fp,"	for(i=0;tp->next !=(TextBox *)NULL;i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"<tr>\");\n");
	fprintf(fp,"		if(ft[no].splitDBbuff[line][i] != (char *)NULL)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			printf(\"<td>\");\n");
	fprintf(fp,"			printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"			printf(\"</td>\");\n");
	fprintf(fp,"			printf(\"<td>\");\n");

	fprintf(fp,"			switch(tp->ftype)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"			case TEXT:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case DATE:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case NUMERIC:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case BOOL:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"t\\\"><br>\\n\",i);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" readonly><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"				}\n");

	fprintf(fp,"				break;\n");
	fprintf(fp,"			case CURRENCY:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"15\\\" ><br>\\n\",i,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"15\\\" readonly ><br>\\n\",i,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			case DOUBLE:\n");
	fprintf(fp,"				if(tp->action == 0)\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				else\n");
	fprintf(fp,"				{\n");
	fprintf(fp,"					printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"				}\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			default:\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" ><br>\\n\",i,ft[no].pos[i].len);\n");
	fprintf(fp,"				break;\n");
	fprintf(fp,"			}\n");

	fprintf(fp,"			sprintf(s,\"\");\n");
	fprintf(fp,"			sf_tput(no,i,s);\n");
	fprintf(fp,"			sf_tnext();\n");
	fprintf(fp,"			printf(\"</td>\");\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"		else\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			sf_tnext();\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	printf(\"</tr>\");\n");
	fprintf(fp,"	printf(\"<tr>\");\n");
	fprintf(fp,"	if(ft[no].splitDBbuff[line][i] != (char *)NULL)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"<td>\");\n");
	fprintf(fp,"		printf(\"%%s:\",*(db_titles+i));\n");
	fprintf(fp,"		printf(\"</td>\");\n");
	fprintf(fp,"		printf(\"<td>\");\n");
	fprintf(fp,"		switch(tp->ftype)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"		case TEXT:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].splitDBbuff[line][i],ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case DATE:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"date\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case NUMERIC:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case BOOL:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"t\\\"><br>\\n\",i);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"checkbox\\\" name=\\\"field%%02d\\\" value=\\\"%%s\\\" readonly><br>\\n\",i,ft[no].splitDBbuff[line][i]);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case CURRENCY:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"15\\\" ><br>\\n\",i,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"15\\\" readonly ><br>\\n\",i,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		case DOUBLE:\n");
	fprintf(fp,"			if(tp->action == 0)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			else\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" maxlength=\\\"%%d\\\" readonly ><br>\\n\",i,ft[no].pos[i].len,ft[no].pos[i].len);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		default:\n");
	fprintf(fp,"			printf(\"<input type=\\\"text\\\" name=\\\"field%%02d\\\" size=\\\"%%d\\\" value=\\\"\\\" ><br>\\n\",i,ft[no].pos[i].len);\n");
	fprintf(fp,"			break;\n");
	fprintf(fp,"		}\n");

	fprintf(fp,"		sprintf(s,\"\");\n");
	fprintf(fp,"		sf_tput(no,i,s);\n");
	fprintf(fp,"		printf(\"</td>\");\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	printf(\"</tr>\\n\");\n");
	fprintf(fp,"	printf(\"</table>\\n\");\n");
	fprintf(fp,"	printf(\"</form>\\n\");\n");
	fprintf(fp,"	printf(\"</body>\\n\");\n");
	fprintf(fp,"	printf(\"</html>\\n\");\n");
	fprintf(fp,"}\n");

	fprintf(fp,"// FETCHした後にHTMLのテーブルにDBの行列を書き込みます。\n");
	fprintf(fp,"int %s_grid_dispHTML(int no, int startline, int maxcol, int grid_ey, int grid_sy,int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i, j;\n");
	fprintf(fp,"	char s[MAX_TMP];\n");
	fprintf(fp,"	char hs[MAX_TMP];\n");
	fprintf(fp,"\n");
	fprintf(fp,"	if((Fetch_%s(no,line)) == 0)\n",f);
	fprintf(fp,"	{\n");
	fprintf(fp,"		for(i=startline;i<DBcount[no];i++)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			for(j=0;j<maxcol;j++)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				sf_gputDBHTML(no,i,j,startline,s);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"\n");
	fprintf(fp,"		return(0);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");


	fclose(fp);
	return(0);
}

int AseEditor::putecpgInterFaceMenu(char *f, char *sf)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	fprintf(fp,"// DBから入出力(画面)ウインドウに書き込みます。\n");
	fprintf(fp,"void %s_text_writeHTML(int no, int post, int line,int maxcol, char **db_titles)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i;\n");
	fprintf(fp,"	char s[MAX_TMP];\n\n");
	
	fprintf(fp,"	printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"	printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<head>\\n\");\n");
	fprintf(fp,"	printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"	printf(\"<title>form Menu_text_writeHTML page</title>\\n\");\n");
	fprintf(fp,"	printf(\"</head>\\n\");\n");
	fprintf(fp,"	printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<br>\\n\");\n");

//	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");
//	fprintf(fp,"	printf(\"<tr>\\n\");\n");

	fprintf(fp,"	printf(\"<a href=\\\"http://codoo2hk.corede.net/index.html\\\" target=\\\"_parent\\\">[TOPへ]</a>\\n\");\n");
	fprintf(fp,"	printf(\"<a href=\\\"#\\\" onClick=\\\"history.back(); return false;\\\">[前に戻る]</a>\\n\");\n");
	fprintf(fp,"// この下に実行するCGIへのGETメソッドを記述してください。以下がサンプルです。\n");
	fprintf(fp,"	//	printf(\"<form method=\\\"get\\\" action=\\\"/cgi-bin/otodoke_Fetch.fcgi?field=%%s\\\">\\n\",KEY[0]);\n");
	fprintf(fp,"	//	printf(\"<input tabindex=0 type=\\\"submit\\\" value=\\\"更新画面へ\\\"><br>\\n\");\n");
	fprintf(fp,"\n");
	fprintf(fp,"	//送信はGETを使用します。\n");

	fprintf(fp,"	printf(\"<form method=\\\"get\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	fprintf(fp,"	printf(\"<select name=\\\"field0\\\" size=\\\"8\\\" maxlength=\\\"64\\\"><br>\\n\");\n");
	fprintf(fp,"	for(i=0;i<DBcount[no];i++)\n");
	fprintf(fp,"	{\n");

	fprintf(fp,"		printf(\"<option value=\\\"%%s\\\"> %%s</option>\\n\",ft[no].splitDBbuff[i][1],ft[no].splitDBbuff[i][1]);\n");
	fprintf(fp,"	}\n");

	fprintf(fp,"	printf(\"</select>\\n\");\n");
	fprintf(fp,"	printf(\"<input tabindex=1 type=\\\"submit\\\" name=\\\"field\\\" value=\\\"%%s\\\">\",KEY[1]);\n");
//	fprintf(fp,"	printf(\"<input tabindex=1 type=\\\"submit\\\" value=\\\"実行\\\">\\n\");\n");

	fprintf(fp,"	printf(\"</form>\\n\");\n");
//	fprintf(fp,"	printf(\"<tr>\");\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");

	fprintf(fp,"// FETCHした後にHTMLのテーブルにDBの行列を書き込みます。\n");
	fprintf(fp,"int %s_grid_dispHTML(int no, int startline, int maxcol, int grid_ey, int grid_sy, int line)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i, j;\n");
	fprintf(fp,"	char s[MAX_TMP];\n");
	fprintf(fp,"	char hs[MAX_TMP];\n");
	fprintf(fp,"\n");
	fprintf(fp,"	if((Fetch_%s(no,line)) == 0)\n",f);
	fprintf(fp,"	{\n");
//2010.04.21
//	fprintf(fp,"		for(i=startline;i<(grid_ey-grid_sy)+1;i++)\n");
	fprintf(fp,"		for(i=startline;i<DBcount[no];i++)\n");
	fprintf(fp,"		{\n");
	fprintf(fp,"			for(j=0;j<maxcol;j++)\n");
	fprintf(fp,"			{\n");
	fprintf(fp,"				sf_gputDBHTML(no,i,j,startline,s);\n");
	fprintf(fp,"			}\n");
	fprintf(fp,"		}\n");
	fprintf(fp,"\n");
	fprintf(fp,"		return(0);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		return(-1);\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n");
	fprintf(fp,"\n");


	fclose(fp);
	return(0);
}

int AseEditor::putecpgResult(char *f, char *sf)
{
	FILE *fp;
	int i;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}

	fprintf(fp,"// DBから入出力(画面)ウインドウに書き込みます。\n");
	fprintf(fp,"void %s_text_writeHTML(int no, int post, int line,int maxcol, char **db_titles)\n",f);
	fprintf(fp,"{\n");
	fprintf(fp,"	int i;\n");
	fprintf(fp,"	char s[MAX_TMP];\n\n");
	
	fprintf(fp,"	printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"	printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<head>\\n\");\n");
	fprintf(fp,"	printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"	printf(\"<title>form text_writeHTML page</title>\\n\");\n");
	fprintf(fp,"	printf(\"</head>\\n\");\n");
	fprintf(fp,"	printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"	printf(\"<br>\\n\");\n");

//	fprintf(fp,"	printf(\"<table border=0>\\n\");\n");
//	fprintf(fp,"	printf(\"<tr>\\n\");\n");

	fprintf(fp,"	printf(\"<a href=\\\"http://codoo2hk.corede.net/index.html\\\" target=\\\"_parent\\\">[TOPへ]</a>\\n\");\n");
	fprintf(fp,"	printf(\"<a href=\\\"#\\\" onClick=\\\"history.back(); return false;\\\">[前に戻る]</a>\\n\");\n");

	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s.fcgi\\\">\\n\");\n",sf);
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s_Fetch.fcgi\\\">\\n\");\n",sf);
	if(up ==1 && ins ==0 && del ==0)
	{
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" style=\\\"float:left\\\" action=\\\"/cgi-bin/%s_Fetch.fcgi?field00=%%s&amp;field01=#form%%s\\\">\\n\",KEY[0],KEY[255]);\n",sf);
	//	fprintf(fp,"	printf(\"<form method=\\\"post\\\" action=\\\"/cgi-bin/%s.fcgi?field=%%s\\\">\\n\",KEY[0]);\n",sf);
	}
	if(up ==0 && ins ==1 && del ==0)
	{
	//	fprintf(fp,"	printf(\"<form method=\\\"post\\\" action=\\\"/cgi-bin/%s.fcgi?field=%%s\\\">\\n\",KEY[0]);\n",sf);
		for(i=0;i < NUMITEM;i++)
		{
			if(pgc[i].keyflg == 1)
			{
				fprintf(fp,"	printf(\"<form method=\\\"post\\\" action=\\\"/cgi-bin/%s.fcgi?field00=%%s&amp;field01=#form%%05d\\\">\\n\",KEY[%d],DBcount[no]-1);\n",sf,i);
				break;
			}
		}
	}
	if(up ==0 && ins ==0 && del ==1)
		fprintf(fp,"	printf(\"<form method=\\\"post\\\" action=\\\"/cgi-bin/%s.fcgi?field=%%s\\\">\\n\",KEY[0]);\n",sf);

	if(up ==0 && ins ==0 && del ==0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"戻る\\\">\\n\");\n");
	if(up ==1 && ins ==1 && del ==1)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"実行\\\">\\n\");\n");
	if(up == 1 && ins == 0 && del == 0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"UPDATEが完了しました。戻ります\\\">\\n\");\n");
	if(up == 0 && ins == 1 && del == 0)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"INSERTが完了しました。戻ります\\\">\\n\");\n");
	if(up == 0 && ins == 0 && del == 1)
		fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"submit\\\" style=\\\"float:left\\\" value=\\\"DELETEが完了しました。戻ります\\\">\\n\");\n");

	fprintf(fp,"// 以下は別の _Fetch.fcgi を呼び出す場合の転送文字列を指定します。KEY[]の文字列はユニークが必要です。\n");
	for(i=0;i < NUMITEM;i++)
	{
		if(pgc[i].keyflg == 1)
		{
			fprintf(fp,"	printf(\"<input accesskey=\\\"A\\\" tabindex=1 type=\\\"hidden\\\" name=\\\"field00\\\" size=\\\"1\\\" value=\\\"%%s\\\" maxlength=\\\"1\\\" ><br>\\n\",KEY[%d]);\n",i);
			break;
		}
	}
//	fprintf(fp,"	printf(\"</tr>\");\n");
	fprintf(fp,"	printf(\"</form>\\n\");\n");
	fprintf(fp,"	printf(\"</body>\\n\");\n");
	fprintf(fp,"	printf(\"</html>\\n\");\n");
	fprintf(fp,"}\n");

	fclose(fp);
	return(0);
}

//最初のメイン画面を実行する
int AseEditor::putecpgMain1(char *f)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}
	fprintf(fp,"\n");
	fprintf(fp,"int subformHTML(void)\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	int i;\n");
	fprintf(fp,"	char s[MAX_STR];\n\n");

	fprintf(fp,"	int startline;\n\n");
	
	fprintf(fp,"	int line;\n");

	fprintf(fp,"	setlocale(LC_ALL,\"\");\n\n");

	fprintf(fp,"//----------------------------------------------------------------------------------\n");
	fprintf(fp,"//下ののハイフンのラインまでの以下の関数はDBと画面の設計を実際のフォームに適用します。\n");
	fprintf(fp,"//これらの関数が無い場合は設計情報はDB設計以外は反映されません。\n\n");

	fclose(fp);
	return(0);
}

//FETCH用の画面を実行する
int AseEditor::putecpgMain2(char *f,char *sf)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}


	fprintf(fp,"//----------------------------------------------------------------------------------\n\n");

	fprintf(fp,"	for(i=0;i<MAX_POS;i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		memset(gridtitles[i],\'\\0\',MAX_LEN);\n");
	fprintf(fp,"	}\n\n");

	fprintf(fp,"	sf_startcell(0);\n\n");

	fprintf(fp,"	startline = 0;	//画面初期行\n\n");

	fprintf(fp,"	//Fetchした結果をsplitDBbuffに格納して表示に備える\n");
	fprintf(fp,"	if(%s_grid_dispHTML(no,startline,maxtext,grid_sy,grid_ey,line) == -1)\n",f);
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"grid_dispHTML():error\\n\");\n");
	fprintf(fp,"	}\n\n");
	fprintf(fp,"	//全ての顧客のjohoIDを取得\n");
	fprintf(fp,"	 Fetch_%s_all(10);\n\n",sf);
	fprintf(fp,"	//DBへの入力用フォームの作成\n");
	fprintf(fp,"	for(i=startline;i<DBcount[no];i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		%s_text_writeHTML(no,0,i,maxtext,*db_titles);\n",f);
	fprintf(fp,"	}\n\n");

	fprintf(fp,"}\n\n");

	fprintf(fp,"int main(int argc, char *argv[])\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	sprintf(COMMANDNAME,\"%%s\",argv[0]);\n");
	fprintf(fp,"	while (FCGI_Accept() >= 0)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		subformHTML();\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n\n");

	fclose(fp);
	return(0);

}

//Menu用の画面を実行する
int AseEditor::putecpgMenu(char *f)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}


	fprintf(fp,"//----------------------------------------------------------------------------------\n\n");

	fprintf(fp,"	for(i=0;i<MAX_POS;i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		memset(gridtitles[i],\'\\0\',MAX_LEN);\n");
	fprintf(fp,"	}\n\n");

	fprintf(fp,"	sf_startcell(0);\n\n");

	fprintf(fp,"	startline = 0;	//初期行\n\n");

	fprintf(fp,"	if(%s_grid_dispHTML(no,startline,maxtext,grid_sy,grid_ey,line) == -1)	//	*splitDBbuff[][]を表示する。\n",f);
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"grid_dispHTML():error\\n\");\n");
	fprintf(fp,"	}\n\n");
	fprintf(fp,"	//DBへのメニュー用フォームの作成（selectタグでコンボボックス連結時この行は削除して利用してください。）\n");
	fprintf(fp,"	%s_text_writeHTML(no,0,i,maxtext,*db_titles);\n",f);

	fprintf(fp,"}\n\n");

	fprintf(fp,"int main(int argc, char *argv[])\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	sprintf(COMMANDNAME,\"%%s\",argv[0]);\n");
	fprintf(fp,"	subformHTML();\n");
	fprintf(fp,"}\n\n");

	fclose(fp);
	return(0);

}

int AseEditor::putecpgMain2_INSERT(char *f)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}


	fprintf(fp,"//----------------------------------------------------------------------------------\n\n");

	fprintf(fp,"\n");
//	fprintf(fp,"	if(Insert_%s(0) != -1)\n",f);
	fprintf(fp,"	if(%s(0) != -1)\n",f);
	fprintf(fp,"	{\n");
	fprintf(fp,"		%s_text_writeHTML(no,0,0,maxtext,*db_titles);\n",f);
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"		printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"		printf(\"<head>\\n\");\n");
	fprintf(fp,"		printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"		printf(\"<title>DB-INSERT-ERROR</title>\\n\");\n");
	fprintf(fp,"		printf(\"</head>\\n\");\n");
	fprintf(fp,"		printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"		printf(\"<br>\\n\");\n");
	fprintf(fp,"		printf(\"<table border=0>\\n\");\n");
	fprintf(fp,"		printf(\"<tr>\\n\");\n");
	fprintf(fp,"		printf(\"INSERTが失敗しました。<br>\\n\");\n");
	fprintf(fp,"		printf(\"</tr>\\n\");\n");
	fprintf(fp,"		printf(\"</body>\\n\");\n");
	fprintf(fp,"		printf(\"</html>\\n\");\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n\n");

	fprintf(fp,"int main(int argc, char *argv[])\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	sprintf(COMMANDNAME,\"%%s\",argv[0]);\n");
	fprintf(fp,"	subformHTML();\n");
	fprintf(fp,"}\n\n");

	fclose(fp);
	return(0);

}

int AseEditor::putecpgMain2_UPDATE(char *f)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}


	fprintf(fp,"//----------------------------------------------------------------------------------\n\n");

	fprintf(fp,"\n");
//	fprintf(fp,"	if(Update_%s(0) != -1)\n",f);
	fprintf(fp,"	if(%s(0) != -1)\n",f);
	fprintf(fp,"	{\n");
	fprintf(fp,"		%s_text_writeHTML(no,0,0,maxtext,*db_titles);\n",f);
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"		printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"		printf(\"<head>\\n\");\n");
	fprintf(fp,"		printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"		printf(\"<title>DB-UPDATE-ERROR</title>\\n\");\n");
	fprintf(fp,"		printf(\"</head>\\n\");\n");
	fprintf(fp,"		printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"		printf(\"<br>\\n\");\n");
	fprintf(fp,"		printf(\"<table border=0>\\n\");\n");
	fprintf(fp,"		printf(\"<tr>\\n\");\n");
	fprintf(fp,"		printf(\"UPDATEが失敗しました。<br>\\n\");\n");
	fprintf(fp,"		printf(\"</form>\\n\");\n");
	fprintf(fp,"		printf(\"</tr>\\n\");\n");
	fprintf(fp,"		printf(\"</form>\\n\");\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n\n");

	fprintf(fp,"int main(int argc, char *argv[])\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	sprintf(COMMANDNAME,\"%%s\",argv[0]);\n");
	fprintf(fp,"	subformHTML();\n");
	fprintf(fp,"}\n\n");

	fclose(fp);
	return(0);

}

int AseEditor::putecpgMain2_DELETE(char *f)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}


	fprintf(fp,"//----------------------------------------------------------------------------------\n\n");

	fprintf(fp,"\n");
//	fprintf(fp,"	if(Delete_%s() != -1)\n",f);
	fprintf(fp,"	if(%s() != -1)\n",f);
	fprintf(fp,"	{\n");
	fprintf(fp,"		%s_text_writeHTML(no,0,0,maxtext,*db_titles);\n",f);
	fprintf(fp,"	}\n");
	fprintf(fp,"	else\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		printf(\"Content-type: text/html; charset=utf-8\\n\\n\");\n");
	fprintf(fp,"		printf(\"<html lang=\\\"ja\\\">\\n\");\n");
	fprintf(fp,"		printf(\"<head>\\n\");\n");
	fprintf(fp,"		printf(\"<meta http-equiv=\\\"content-type\\\" content=\\\"text/html;charset=utf-8\\\">\\n\"); \n");
	fprintf(fp,"		printf(\"<title>DB-DELETE-ERROR</title>\\n\");\n");
	fprintf(fp,"		printf(\"</head>\\n\");\n");
	fprintf(fp,"		printf(\"<body bgcolor=\\\"#ffffff\\\">\\n\");\n");
	fprintf(fp,"		printf(\"<br>\\n\");\n");
	fprintf(fp,"		printf(\"<table border=0>\\n\");\n");
	fprintf(fp,"		printf(\"<tr>\\n\");\n");
	fprintf(fp,"		printf(\"DELETEが失敗しました。<br>\\n\");\n");
	fprintf(fp,"		printf(\"</form>\\n\");\n");
	fprintf(fp,"		printf(\"</tr>\\n\");\n");
	fprintf(fp,"		printf(\"</form>\\n\");\n");
	fprintf(fp,"	}\n");
	fprintf(fp,"}\n\n");

	fprintf(fp,"int main(int argc, char *argv[])\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	sprintf(COMMANDNAME,\"%%s\",argv[0]);\n");
	fprintf(fp,"	subformHTML();\n");
	fprintf(fp,"}\n\n");

	fclose(fp);
	return(0);

}

int AseEditor::putecpgMain3(char *f)
{
	FILE *fp;
	
	sprintf(tmpbuff1,"%s.pgc",f);
	if((fp = fopen(tmpbuff1,"a")) == (FILE *)NULL)
	{
		return(-1);
	}


	fprintf(fp,"//----------------------------------------------------------------------------------\n\n");

	fprintf(fp,"	for(i=0;i<MAX_POS;i++)\n");
	fprintf(fp,"	{\n");
	fprintf(fp,"		memset(gridtitles[i],\'\\0\',MAX_LEN);\n");
	fprintf(fp,"	}\n\n");

	fprintf(fp,"	sf_startcell(0);\n\n");

	fprintf(fp,"	startline = 0;	//画面初期行\n\n");

	fprintf(fp,"	Fetch_%s(0,line);	//*標準出力する。\n\n",f);

	fprintf(fp,"}\n\n");

	fprintf(fp,"int main(int argc, char *argv[])\n");
	fprintf(fp,"{\n");
	fprintf(fp,"	sprintf(COMMANDNAME,\"%%s\",argv[0]);\n");
	fprintf(fp,"	subformHTML();\n");
	fprintf(fp,"}\n\n");

	fclose(fp);
	return(0);

}


int AseEditor::putCreateSQL(WINDOW *vs,int xcol, int xrow, char *f, int nline)
{
	FILE *fp;
//	int i,j,k,l,m;
	int j,k,l;
//	int flg;
//	int tmp = 99;
//	char *dot;

	
//	dot = strchr(f,'.');
//	*dot = '\0';
	sprintf(tmpbuff1,"create_%s.sql",f);
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}

	fprintf(fp,"create table %s\n",f);
	fprintf(fp,"(\n");

	for(j=0;j<xcol;j++)
	{
		if(!strcmp(pgc[j].cell_fieldtype,"char"))
		{
			if(pgc[j].keyflg == 1)
				fprintf(fp,"	%s	VARCHAR(%d) NOT NULL",pgc[j].cell_title,pgc[j].cell_length);
			else
				fprintf(fp,"	%s	VARCHAR(%d)",pgc[j].cell_title,pgc[j].cell_length);
			if(j == nline-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"date"))
		{
			if(pgc[j].keyflg == 1)
				fprintf(fp,"	%s	DATE NOT NULL",pgc[j].cell_title);
			else
				fprintf(fp,"	%s	DATE",pgc[j].cell_title);
			if(j == nline-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"int"))
		{
			if(pgc[j].keyflg == 1)
				fprintf(fp,"	%s	INTEGER NOT NULL",pgc[j].cell_title);
			else
				fprintf(fp,"	%s	INTEGER",pgc[j].cell_title);
			if(j == nline-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"unsigned char"))
		{
			if(pgc[j].keyflg == 1)
				fprintf(fp,"	%s	BOOL NOT NULL",pgc[j].cell_title);
			else
				fprintf(fp,"	%s	BOOL",pgc[j].cell_title);
			if(j == nline-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
		if(!strcmp(pgc[j].cell_fieldtype,"double"))
		{
			if(pgc[j].keyflg == 1)
				fprintf(fp,"	%s	DOUBLE PRECISION NOT NULL",pgc[j].cell_title);
			else
				fprintf(fp,"	%s	DOUBLE PRECISION",pgc[j].cell_title);
			if(j == nline-1)
				fprintf(fp,"\n");
			else
				fprintf(fp,",\n");
		}
	}
	fprintf(fp,");\n");

	k = 0;
	for(j=0;j<xcol;j++)
	{
		if(pgc[j].keyflg == 1)
			k++;
	}
	l = 0;
	fprintf(fp,"CREATE INDEX %s_index ON %s(",f,f);
	for(j=0;j<xcol;j++)
	{
		if(pgc[j].keyflg == 1)
		{
			l++;
			if(j == nline-1)
				fprintf(fp,"%s",pgc[j].cell_title);
			else
				if(k > l)
					fprintf(fp,"%s,",pgc[j].cell_title);
				else
					fprintf(fp,"%s",pgc[j].cell_title);
		}
	}
	fprintf(fp,");\n");

	fclose(fp);
	return(0);
}

int AseEditor::rightcell(int xcol, int xrow)
{
	int i,j,k,m;
	int flg = 0;
	for(i=0,k=0,m=0;i<xrow;i++,m++)
	{
		for(j=0;j<xcol;j++)
		{
			if(!strcmp(cp[j][i].s,"["))
			{
				flg = 1;
				k++;
				continue;
			}
			if((!strcmp(cp[j][i].s,"-")) && flg == 1)
			{
				if(j%2)
				{
					sprintf(cp[j][i].s,"r");
					mvwprintw(pt2[j][i].vs,0,0,"%s","r");
					wrefresh(pt2[j][i].vs);
					k++;
				}
				else
				{
					sprintf(cp[j][i].s,"e");
					mvwprintw(pt2[j][i].vs,0,0,"%s","r");
					wrefresh(pt2[j][i].vs);
					k++;
				}
				continue;
			}
			if(!strcmp(cp[j][i].s,"]"))
			{
				k++;
				flg = 0;
			}
		}
	}
	return(0);
}

int AseEditor::freads(int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j;
	unsigned int c;
	if((fp = fopen(f,"r")) == (FILE *)NULL)
	{
		return(-1);
	}
	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol+1;j++)
		{
			if((c = fgetc(fp)) == EOF)
				goto end;
			if(c == '\n')
			{
				break;
			}
			cp[j][i].s[0] = c;
			cp[j][i].s[1] = '\0';
			mvwprintw(pt2[j][i].vs,0,0,"%c",cp[j][i].s[0]);
			wrefresh(pt2[j][i].vs);
		}
	}
	end:
	fclose(fp);
	return(0);
}

int AseEditor::fwrites(int xcol, int xrow, char *f)
{
	FILE *fp;
	int i,j;
	sprintf(tmpbuff1,"%s",f);
	if((fp = fopen(tmpbuff1,"w")) == (FILE *)NULL)
	{
		return(-1);
	}
	for(i=0;i<xrow;i++)
	{
		for(j=0;j<xcol;j++)
		{
			fprintf(fp,"%s",cp[j][i].s);
		}
		fprintf(fp,"\n");
	}
	fclose(fp);
	return(0);
}

int AseEditor::ase(int xcol,int xrow,char *f,int command)
{
	WINDOW *vs;
	int ch;
	int i,j,k,l,m,n,o,p;
//	int maxcell;
//	char *nl;
//	char st[256][256];
//	int basewin_width;
//	int basewin_Hight;
//	int subwin_cols;
//	int subwin_rows;
//	int cell_len;
	char attr[5];
	char field[5];
	char action[5];
	char skipstep[5];
	char tmp[5];
	int tmpi, tmpj;
	int ret;
	int len;
	char ecpgfname[64];
	
	up = ins = del = 0;

	if(command == 1)
	{
		if(xcol > 256 || xrow > 78)
		{
			fprintf(stderr,"Check LINES or COLS this terminal - %d/%d\n",xrow,xcol);
			exit(1);
		}
		setlocale(LC_ALL,"");
		initscr();
		cbreak();
		noecho();

		if(xcol > COLS || xrow > (LINES - 1))
		{
			echo();
			endwin();
			if(xcol > COLS)
				fprintf(stderr,"COLS=%d/%d\n",COLS,xcol);
			if(xrow > (LINES - 1))
				fprintf(stderr,"LINES=%d/%d\n",LINES,xrow);
			exit(1);
		}
		if(fulldisplay  == 1)
		{
			xcol = COLS - 2;
			xrow = LINES - 1;
		}
	}
	else
	{
		if(xcol > COLS-1 || xrow > (LINES - 1))
		{
			popmsg((80/2)-24,(LINES/2)-4,"Over Colums or Rows");
			return(-1);
		}
	}

	vs = newwin(xrow,xcol,1,1);
	keypad(vs,TRUE);
	meta(vs, TRUE);
	refresh();

	i = 0;
	for(k=0;k<xcol;k++)
	{
		for(j=0;j<xrow;j++)
		{
			pt2[k][j].vs = subwin(vs,1,1,j+1,k+1);
			keypad(pt2[k][j].vs,TRUE);
			meta(pt2[k][j].vs, TRUE);
			cp[k][j].no = i;
			cp[k][j].x = k+1;
			cp[k][j].y = j+1;
			cp[k][j].c = k;
			memset(cp[k][j].s,' ',1);
			sprintf(tmpbuff1,".");
			sprintf(cp[k][j].s,"%s",tmpbuff1);
			i++;
		}
	}
	i--;

//	maxcell = i;

	for(i=0;i<(xrow+0);i++)
	{
	//	mvwprintw(stdscr,i+1,xcol+1,"%d",i+1);
		mvprintw(i+1,xcol+1,"%d",i+1);
	}
	for(i=1;i<(xcol+1);i++)
	{
		if(!(i%10))
		{
			if(i>99)
			{
				sprintf(tmpbuff1,"%d",i-100);
			}
			else
			{
				sprintf(tmpbuff1,"%-2d",i);
			}
			mvwprintw(stdscr,0,i,tmpbuff1);
		}
		else
		{
			sprintf(tmpbuff1,"_");
			mvwprintw(stdscr,0,i,tmpbuff1);
		}
	}
	refresh();

	for(k=0;k<xcol;k++)
	{
		for(j=0;j<xrow;j++)
		{
			mvwprintw(pt2[k][j].vs,0,0,"%s",cp[k][j].s);
			wrefresh(pt2[k][j].vs);
		}
	}

	wrefresh(vs);
	i = 0;
	j = 0;
	l = 0;
	m = 0;
	sprintf(attr,"%s","-");
	sprintf(field,"%s","-");
	sprintf(action,"%s","-");
	sprintf(skipstep,"%s","-");
	memset(tmp,'\0',sizeof(tmp));
	tmpi = tmpj = 0;

	if(readflg == 1)
	{
		if(stat(f,fptr) == 0)
			freads(xcol,xrow,f);
	}

	while(1)
	{
		wattron(pt2[i][j].vs, A_BOLD | A_DIM | A_REVERSE | A_PROTECT);
		mvwprintw(pt2[i][j].vs,1,1,"%s",cp[i][j].s);
		wattroff(pt2[i][j].vs, A_BOLD | A_DIM | A_REVERSE | A_PROTECT);
		wrefresh(pt2[i][j].vs);

		mvwprintw(stdscr,0,COLS-25,"(%s%s%s%s)[%4d %3d %3d %3d]",attr,field,action,skipstep,cp[i][j].no,cp[i][j].x,cp[i][j].y,cp[i][j].c);
		refresh();
		wrefresh(vs);
		wrefresh(pt2[i][j].vs);

		ch = wgetch(vs);
		mvwprintw(pt2[i][j].vs,0,0,"%s",cp[i][j].s);
		wrefresh(pt2[i][j].vs);
		wrefresh(vs);

		switch(ch)
		{
		case KEY_F(1):
			break;
		case KEY_IC:
			k = 0;
			n = 0;
			l = j;
			m = i;
			memset(tmp,'\0',sizeof(tmp));
			sprintf(tmp,"%s",cp[i][j].s);
			tmpi = i;
			tmpj = j;

			input_window(4,2,tmpbuff1,"作成する列名を入力してください。(英数字のみ)");
			len = strlen(tmpbuff1);
			if(len < 1)
			{
				touchwin(vs);
				break;
			}
			mvwprintw(pt2[m][l].vs,0,0,"{");
			sprintf(cp[m][l].s,"%s","{");
			wrefresh(pt2[m][l].vs);
			for (n=m+1;n<(len+m+1);n++)
			{
				mvwaddch(pt2[n][l].vs,0,0,tmpbuff1[k]);
				wrefresh(pt2[n][l].vs);
				tmpbuff2[0] = tmpbuff1[k];
				tmpbuff2[1] = '\0';
				sprintf(cp[n][l].s,"%s",tmpbuff2);
				k++;
			}
			mvwprintw(pt2[n][l].vs,0,0,"}");
			sprintf(cp[n][l].s,"%s","}");
			wrefresh(pt2[n][l].vs);
			touchwin(vs);
			break;
		case '?':
			ehelpmsg(1,1);
			touchwin(vs);
			break;
		case 'H':
			jhelpmsg(1,1);
			touchwin(vs);
			break;
		case '.':
			sprintf(attr,"%s",".");
			sprintf(field,"%s",".");
			sprintf(action,"%s",".");
			sprintf(skipstep,"%s",".");
			break;
		case '-': case 'L':
			sprintf(attr,"%s","-");
			sprintf(field,"%s","-");
			sprintf(action,"%s","-");
			sprintf(skipstep,"%s","-");
			break;
		case 'B':
			sprintf(attr,"%s","B");
			sprintf(field,"%s","r");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","p");
			break;
		case 'D':
			sprintf(attr,"%s","r");
			sprintf(field,"%s","d");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","p");
			break;
		case 'F':
			sprintf(attr,"%s","F");
			sprintf(field,"%s","r");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","p");
			break;
		case 'R':
			sprintf(attr,"%s","r");
			sprintf(field,"%s","$");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","p");
			break;
		case 'T':
			sprintf(attr,"%s","l");
			sprintf(field,"%s","t");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","p");
			break;
		case 'O':
			sprintf(attr,"%s","l");
			sprintf(field,"%s","t");
			sprintf(action,"%s","o");
			sprintf(skipstep,"%s","p");
			break;
		case 'K':
			sprintf(attr,"%s","l");
			sprintf(field,"%s","t");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","k");
			break;
		case '':
			sprintf(attr,"%s","r");
			sprintf(field,"%s","n");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","k");
			break;
		case '':
			sprintf(attr,"%s","r");
			sprintf(field,"%s","n");
			sprintf(action,"%s","e");
			sprintf(skipstep,"%s","p");
			break;
		case 'i':
			vs_ieee_c(pt2[i][j].vs,0,0,tmpbuff1,0);
			sprintf(cp[i][j].s,"%s",tmpbuff1);
			mvwprintw(pt2[i][j].vs,1,1,"%s",cp[i][j].s);
			wrefresh(pt2[i][j].vs);
			break;
		case '':
		/*
			sprintf(tmpbuff1,"画面定義ソースファイルを作成します。 [_%s.c] Ok?",f);
			if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff1) == 0)
			{
				touchwin(vs);
				break;
			}
		//	mvwprintw(stdscr,LINES-1,1,"%s",tmpbuff1);
			convlabel2(vs,xcol,xrow,f);
			convtextbox2(vs,xcol,xrow,f);
			convgrid2(vs,xcol,xrow,f);
			if(!dbtitle)
			{
				wrefresh(vs);
				touchwin(vs);
				break;
			}
		*/
			break;
		case 'c':
			char *dot;
	
			if((dot = strchr(f,'.')) != (char *)NULL)
			{
				*dot = '\0';
			}
			sprintf(tmpbuff1,"コード生成を開始します。まずCSSファイルを作成します。 [%s.css] Ok?",f);
			if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff1) == 0)
			{
				touchwin(vs);
				break;
			}
		//	mvwprintw(stdscr,LINES-1,1,"%s",tmpbuff1);
			convlabel(vs,xcol,xrow,f);
			convtextbox(vs,xcol,xrow,f);
			convgrid(vs,xcol,xrow,f);
		//	if(!dbtitle)
		//	{
		//		wrefresh(vs);
		//		touchwin(vs);
		//		break;
		//	}
			sprintf(tmpbuff2,"%s:ECPG ソースを作成します。よろしいですか？",tmpbuff1);
			if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff2) == 0)
			{
				wrefresh(vs);
				touchwin(vs);
				break;
			}
			//まず全てを含んだECPGソースファイルを作成する。
			ret = putecpg(vs,xcol,xrow,f);
			if(ret != 0)
			{
				for(k=0;k<xcol;k++)
				{
					for(m=0;m<xrow;m++)
					{
						mvwprintw(pt2[k][m].vs,0,0,"%s",cp[k][m].s);
						wrefresh(pt2[k][m].vs);
					}
				}
				wrefresh(vs);
				touchwin(vs);
			//	break;
			}
			else
			{
				goto skip01;
			}

			up = del = ins = 0;
			//メインページを表示する。
			putecpgMain1(f);
			putecpgMain3(f);
			putCreateSQL(vs,xcol,xrow,f,ret);

skip01:
			//セレクトメニュー用のソースファイルを作成する。
			up = del = ins = 1;
			Menu = 1;
			sprintf(ecpgfname,"%s_Menu",f);
			ret = putecpgKey(vs,xcol,xrow,ecpgfname,f);
			if(ret != 0)
			{
				putecpgInterFaceMenu(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMenu(ecpgfname);
				Menu = 0;
			}
			else
			{
				Menu = 0;
				goto skip02;
			}

skip02:
			//ファイル毎にFetchを実行するファイルを作成する。（列型の表示を行う）
			up = del = ins = 1;
			sprintf(ecpgfname,"%s_Fetch",f);
			ret = putecpgKey(vs,xcol,xrow,ecpgfname,f);
			if(ret != 0)
			{
				putecpgInterFace(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2(ecpgfname,f);
			}
			else
			{
				goto skip03;
			}

skip03:

			//ファイル毎にFetchを実行するファイルを作成する。（列型の表示を行う。新規追加のみ）
			up = del = ins = 1;
			sprintf(ecpgfname,"%s_Fetch_New",f);
			ret = putecpgKey(vs,xcol,xrow,ecpgfname,f);
			if(ret != 0)
			{
				putecpgInterFace_New(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2(ecpgfname,f);
			}
			else
			{
				goto skip04;
			}

skip04:

			//ファイル毎にFetchを実行するファイルを作成する。（SKIP_STEP機能を利用したカード型の表示を行う）
			up = del = ins = 1;
			sprintf(ecpgfname,"%s_Fetch2",f);
			ret = putecpgKey2(vs,xcol,xrow,ecpgfname,f);
//sprintf(tmpbuff,"ret=%d",ret);
//popmsg(1,1,tmpbuff);
			if(ret != 0)
			{
				putecpgInterFace2(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2(ecpgfname,f);
			}
			else
			{
				goto skip05;
			}

skip05:

			//データベースへのレコード追加を実行し結果を表示するページを表示する
			up = del = 0;
			ins = 1;
			sprintf(ecpgfname,"%s_Insert",f);
			ret = putecpgHeader(vs,xcol,xrow,ecpgfname,f);
//sprintf(tmpbuff,"ret=%d",ret);
//popmsg(1,1,tmpbuff);
			if(ret != 0)
			{
				putecpgINSERT(vs,xcol,xrow,ecpgfname,f);
				putecpgResult(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2_INSERT(ecpgfname);
			}
			else
			{
				goto skip06;
			}

skip06:

			//データベースのレコード更新を実行し結果を表示するページを表示する
			ins = del = 0;
			up = 1;
			sprintf(ecpgfname,"%s_Update",f);
			ret = putecpgHeader(vs,xcol,xrow,ecpgfname,f);
//sprintf(tmpbuff,"ret=%d",ret);
//popmsg(1,1,tmpbuff);
			if(ret != 0)
			{
				putecpgUPDATE(vs,xcol,xrow,ecpgfname,f);
				putecpgResult(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2_UPDATE(ecpgfname);
			}
			else
			{
				goto skip07;
			}

skip07:

			//データベースのレコード更新を実行し結果を表示するページを表示する（SKIP_STEP機能を利用したカード型の更新を行う）
			ins = del = 0;
			up = 1;
			sprintf(ecpgfname,"%s_Update2",f);
			ret = putecpgHeader(vs,xcol,xrow,ecpgfname,f);
//sprintf(tmpbuff,"ret=%d",ret);
//popmsg(1,1,tmpbuff);
			if(ret != 0)
			{
				putecpgUPDATE2(vs,xcol,xrow,ecpgfname,f);
				putecpgResult(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2_UPDATE(ecpgfname);
			}
			else
			{
				goto skip08;
			}

skip08:

			//データベースのレコード削除を実行し結果を表示するページを表示する
			ins = up = 0;
			del = 1;
			sprintf(ecpgfname,"%s_Delete",f);
			ret = putecpgHeader(vs,xcol,xrow,ecpgfname,f);
//sprintf(tmpbuff,"ret=%d",ret);
//popmsg(1,1,tmpbuff);
			if(ret != 0)
			{
				putecpgDELETE(vs,xcol,xrow,ecpgfname,f);
				putecpgResult(ecpgfname,f);
				putecpgMain1(ecpgfname);
				convlabel3(vs,xcol,xrow,ecpgfname);
				convtextbox3(vs,xcol,xrow,ecpgfname);
				convgrid3(vs,xcol,xrow,ecpgfname,f);
				putecpgMain2_DELETE(ecpgfname);
			}
			else
			{
				goto skip09;
			}

skip09:

			ins = up = del = 0;

			touchwin(vs);
			break;
		case 'r':
			sprintf(tmpbuff1,"ファイルから再読み込みますか[_%s]?",f);
			if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff1) == 0)
			{
				wrefresh(vs);
				touchwin(vs);
				break;
			}
			wrefresh(vs);
			touchwin(vs);
			if(stat(f,fptr) == 0)
				freads(xcol,xrow,f);
			break;
		case 'W':
			if(f[0] == '-')
			{
				input_window(4,2,tmpbuff1,"作成するファイル名を入力してください。");
				sprintf(f,"%s.def",tmpbuff1);
			}
			sprintf(tmpbuff1,"Over Write? %s",f);
			if(popmsg((80/2)-24,(LINES/2)-4,tmpbuff1) == 0)
			{
				touchwin(vs);
				break;
			}
		//	mvwprintw(stdscr,LINES-1,1,"%s",tmpbuff1);
			fwrites(xcol,xrow,f);
			touchwin(vs);
			break;
		case 0x1b:
			sprintf(cp[tmpi][tmpj].s,"%s",tmp);
			mvwprintw(pt2[tmpi][tmpj].vs,0,0,tmp);
			wrefresh(pt2[tmpi][tmpj].vs);
			memset(tmp,'\0',sizeof(tmp));
			break;
		case 's':
			k = 0;
			n = 0;
			l = j;
			m = i;
			memset(tmp,'\0',sizeof(tmp));
			sprintf(tmp,"%s",cp[i][j].s);
			tmpi = i;
			tmpj = j;
			mvwprintw(pt2[i][j].vs,0,0,attr);
			sprintf(cp[i][j].s,"%s",attr);
			break;
		case 'S':
			k = 0;
			n = 0;
			l = j;
			m = i;
			break;
		case 'C':
			sprintf(tmpbuff1,"Copy End.");
		//	mvwprintw(stdscr,LINES-1,1,"%s",tmpbuff1);
			for (o=0;o<256;o++)
				for (p=0;p<78;p++)
					memset(copybuff[o][p],'\0',256);
			for (k=l,o=0;k<j;k++)
			{
				for (n=m,p=0;n<i;n++)
				{
					sprintf(copybuff[p][o],"%s",cp[n][k].s);
					p++;
				}
				o++;
			}
			l = o;
			m = p;
			break;
		case 'P':
			for (k=j,o=0;k<j+l;k++)
			{
				for (n=i,p=0;n<i+m;n++)
				{
					sprintf(cp[n][k].s,"%s",copybuff[p][o]);
					mvwprintw(pt2[n][k].vs,0,0,copybuff[p][o]);
					wrefresh(pt2[n][k].vs);
					p++;
				}
				o++;
			}
			break;
		case 'e':
			if(strcmp(attr,".") == 0)
			{
				for (k=l;k<j;k++)
				{
					for (n=m;n<i;n++)
					{
						mvwprintw(pt2[n][k].vs,0,0,attr);
						sprintf(cp[n][k].s,"%s",attr);
						wrefresh(pt2[n][k].vs);
					}
				}
			}
			else
			for (k=l;k<j;k++)
			{
				mvwprintw(pt2[m][k].vs,0,0,"[");
				sprintf(cp[m][k].s,"%s","[");
				wrefresh(pt2[m][k].vs);
				for (n=m+1;n<i-1;n++)
				{
					if(!((n-m)%2))
					{
						mvwprintw(pt2[n][k].vs,0,0,field);
						sprintf(cp[n][k].s,"%s",field);
						wrefresh(pt2[n][k].vs);
						if(!((n-m)%4))
						{
							mvwprintw(pt2[n][k].vs,0,0,action);
							sprintf(cp[n][k].s,"%s",action);
							wrefresh(pt2[n][k].vs);
						}
					}
					else
					{
						if(!((n-m)%3))
						{
							mvwprintw(pt2[n][k].vs,0,0,skipstep);
							sprintf(cp[n][k].s,"%s",skipstep);
							wrefresh(pt2[n][k].vs);
						}
						else
						{
							mvwprintw(pt2[n][k].vs,0,0,attr);
							sprintf(cp[n][k].s,"%s",attr);
							wrefresh(pt2[n][k].vs);
						}
					}
					if((n-m) > 4)
					{
						mvwprintw(pt2[n][k].vs,0,0,field);
						sprintf(cp[n][k].s,"%s",field);
						wrefresh(pt2[n][k].vs);
					}
				}
				mvwprintw(pt2[n][k].vs,0,0,"]");
				sprintf(cp[n][k].s,"%s","]");
				wrefresh(pt2[n][k].vs);
			}
			memset(tmp,'\0',sizeof(tmp));
			break;
		case 'E':
			for (k=l;k<j;k++)
			{
				mvwprintw(pt2[m][k].vs,0,0,"<");
				sprintf(cp[m][k].s,"%s","<");
				wrefresh(pt2[m][k].vs);
				for (n=m+1;n<i-1;n++)
				{
					if(!((n-m)%2))
					{
						mvwprintw(pt2[n][k].vs,0,0,field);
						sprintf(cp[n][k].s,"%s",field);
						wrefresh(pt2[n][k].vs);
						if(!((n-m)%4))
						{
							mvwprintw(pt2[n][k].vs,0,0,action);
							sprintf(cp[n][k].s,"%s",action);
							wrefresh(pt2[n][k].vs);
						}
					}
					else
					{
						if(!((n-m)%3))
						{
							mvwprintw(pt2[n][k].vs,0,0,skipstep);
							sprintf(cp[n][k].s,"%s",skipstep);
							wrefresh(pt2[n][k].vs);
						}
						else
						{
							mvwprintw(pt2[n][k].vs,0,0,attr);
							sprintf(cp[n][k].s,"%s",attr);
							wrefresh(pt2[n][k].vs);
						}
					}
					if((n-m) > 4)
					{
						mvwprintw(pt2[n][k].vs,0,0,field);
						sprintf(cp[n][k].s,"%s",field);
						wrefresh(pt2[n][k].vs);
					}
				}
				mvwprintw(pt2[n][k].vs,0,0,">");
				sprintf(cp[n][k].s,"%s",">");
				wrefresh(pt2[n][k].vs);
			}
			memset(tmp,'\0',sizeof(tmp));
			break;
		case '':
			for (k=l;k<j;k++)
			{
				mvwprintw(pt2[m][k].vs,0,0,"(");
				sprintf(cp[m][k].s,"%s","(");
				wrefresh(pt2[m][k].vs);
				for (n=m+1;n<i-1;n++)
				{
					if(!((n-m)%2))
					{
						mvwprintw(pt2[n][k].vs,0,0,field);
						sprintf(cp[n][k].s,"%s",field);
						wrefresh(pt2[n][k].vs);
						if(!((n-m)%4))
						{
							mvwprintw(pt2[n][k].vs,0,0,action);
							sprintf(cp[n][k].s,"%s",action);
							wrefresh(pt2[n][k].vs);
						}
					}
					else
					{
						if(!((n-m)%3))
						{
							mvwprintw(pt2[n][k].vs,0,0,skipstep);
							sprintf(cp[n][k].s,"%s",skipstep);
							wrefresh(pt2[n][k].vs);
						}
						else
						{
							mvwprintw(pt2[n][k].vs,0,0,attr);
							sprintf(cp[n][k].s,"%s",attr);
							wrefresh(pt2[n][k].vs);
						}
					}
					if((n-m) > 4)
					{
						mvwprintw(pt2[n][k].vs,0,0,field);
						sprintf(cp[n][k].s,"%s",field);
						wrefresh(pt2[n][k].vs);
					}
				}
				mvwprintw(pt2[n][k].vs,0,0,")");
				sprintf(cp[n][k].s,"%s",")");
				wrefresh(pt2[n][k].vs);
			}
			memset(tmp,'\0',sizeof(tmp));
			break;
		case 'x':
			break;
		case 'y':
			break;
		case 'q':
			if(popmsg((80/2)-24,(LINES/2)-4,"Exit ase ok?") == 1)
			{
				if(nonopt == 1)
				{
					return(0);
				}
				endwin();
				return(0);
			//	exit(0);
			}
			touchwin(vs);
			break;
		case 'j': case KEY_DOWN:
			if(j < (xrow-1))
			{
				j++;
			}
			break;
		case 'k': case KEY_UP:
			if(j > 0)
			{
				j--;
			}
			break;
		case 'l': case KEY_RIGHT:
			if(i < xcol-1)
			{
				i++;
			}
			break;
		case 'h': case KEY_LEFT:
			if(i > 0)
			{
				i--;
			}
			break;
		case 't':
			j = 0;
			break;
		case 'G':
			j = xrow-1;
			break;
		case '':
			i = 0;
			break;
		case '':
			i = xcol-1;
			break;
		case 'm':
			j = (xrow-1)/2;
			break;
		case 'M':
			i = (xcol-1)/2;
			break;
		case '0':
			sprintf(tmpbuff1,"%d/%d",cp[i][j].x,cp[i][j].y);
			break;
		}
	}
	echo();
	endwin();
}

/*
int main(int argc, char *argv[])
{
	FILE *fp;
	int i,j,k;
	char *f;
	static char *nl;
	char buff[256 + 1];
	char opt[24];
	int colsel;
	int apinit;
	int xcol,xrow;
	int resp;
	char *vp;

	setlocale(LC_ALL,"");

	aseeditor = new AseEditor();
//	asefiler = new AseLocalFiler();

	if(argc == 1)
	{
		if((vp = getenv("HOME")) == (char *)NULL)
		{
		
			aseeditor->sys_errmsg(4,10,"環境変数 HOME が設定されていません /home を使用します");
			sprintf(aseeditor->homedirname,"/home");
		}
		else
		{
			sprintf(aseeditor->homedirname,"%s",vp);
		}
		getcwd(aseeditor->startdirname,256 + 1);
		aseeditor->readowner();
		aseeditor->readgroup();

		initscr();
		cbreak();
		noecho();

		colsel = 0;
		apinit = 1;
		readflg = 1;
		nonopt = 1;
		aseeditor->filer(1,54);
		echo();
		endwin();
		exit(0);
	}
	if(argc < 2 || argc > 4)
	{
		printf("Usage: ase -c[1 - 256] -l[3 - 78] file-name\n");
		printf("       ase -[ e v x a] file-name (3type display and full)\n");
		printf("Help : ase -?\n");
		exit(0);
	}

	f = (char *)malloc(256);
	xcol = 1;
	strcpy(f,argv[argc-1]);
	if(argc < 5 && argc > 2)
	{
		for(i=0;i<argc;i++)
		{
			switch(argv[i][0])
			{
			case '?':
				aseeditor->asehelp();
				exit(0);
				break;
			case '-': case '/':
				if(argv[i][1] == '\0')
					exit(2);
				for(j=1;j < strlen(argv[i]);j++)
				{
					switch(argv[i][j])
					{
					case 'a':
						fulldisplay = 1;
						colsel = 0;
						apinit = 1;
						readflg = 1;
						strcpy(f,argv[argc-1]);
						break;
					case '?':
						aseeditor->asehelp();
						exit(0);
					case 'c':
						if(argv[i][2] == '\0')
							exit(2);
						colsel = 0;
						apinit = 1;
						for(k=2;argv[i][k] != 0;k++)
						{
							if(argv[i][k] >= '0' && argv[i][k] <= '9')
							{
								opt[k-2] = argv[i][k];
							}
							else
							{
								break;
							}
						}
						opt[k-2] = '\0';
						xcol = atoi(opt);
						if(xcol < 1)
							xcol = 1;
						if(xcol > 256)
							xcol = 256;
						strcpy(f,argv[argc-1]);
						break;
					case 'l':
						if(argv[i][2] == '\0')
							exit(2);
						colsel = 0;
						apinit = 1;
						for(k=2;argv[i][k] != 0;k++)
						{
							if(argv[i][k] >= '0' && argv[i][k] <= '9')
							{
								opt[k-2] = argv[i][k];
							}
							else
							{
								break;
							}
						}
						opt[k-2] = '\0';
						xrow = atoi(opt);
						if(xrow < 1)
							xrow = 1;
						if(xrow > 78)
							xrow = 78;
						strcpy(f,argv[argc-1]);
						break;
					case 'e':
						apinit = 0;
						xcol = 78;
						xrow = 23;
						colsel = 0;
						apinit = 1;
						readflg = 1;
						strcpy(f,argv[argc-1]);
						break;
					case 'v':
						apinit = 0;
						xcol = 98;
						xrow = 29;
						colsel = 0;
						apinit = 1;
						readflg = 1;
						strcpy(f,argv[argc-1]);
						break;
					case 'x':
						apinit = 0;
						xcol = 126;
						xrow = 37;
						colsel = 0;
						apinit = 1;
						readflg = 1;
						strcpy(f,argv[argc-1]);
						break;
					case 's':
						apinit = 0;
						xcol = 256;
						xrow = 99;
						colsel = 0;
						apinit = 1;
						readflg = 1;
						strcpy(f,argv[argc-1]);
						break;
					default:
						break;
					}
				}
				break;
			default:
				break;
			}
		}
	}
	else
	{
		i=0;
		if((fp =fopen(f,"r")) == (FILE *)NULL)
		{
			exit(1);
		}
		while(fgets(buff,256,fp) != (char *)NULL)
		{
			if((nl = strchr(buff,'\n')) != (char *)NULL)
			{
				*nl = '\0';
				i++;
			}
		}
		fclose(fp);
		xcol = strlen(buff);
		xrow = i;
		if(xcol > 256)
		{
			fprintf(stderr,"Over colums 256\n");
			exit(1);
		}
		if(xrow > 78)
		{
			fprintf(stderr,"Over rows 78\n");
			exit(1);
		}
		if(xrow < 3)
		{
			fprintf(stderr,"div rows 3\n");
			exit(1);
		}
		colsel = 0;
		apinit = 1;
		readflg = 1;
	}

	if((stat(f,fptr) == 0) && readflg == 0)
	{
		printf("%s is exist. over write? Y or N: ",f);
		while((resp = getchar()))
		{
			switch(resp)
			{
			case 'y': case 'Y':
				readflg = 1;
				goto exec;
			default:
				goto exec;
			}
		}
	}
exec:
	aseeditor->ase(xcol,xrow,f,1);
err_exit:
	exit(0);
}
*/
