#pragma ident "@(#) filercommand.cc 1.1.0 2012.12.10,14:58"
#include "ftx.h"
#include "filer.h"

#define ON 1
#define OFF 0
#define MAX_WINDOW 1

extern ListBox *pFilerListBox;	//ファイラーのためのリストボックスクラス

static int deep = 0;	//ファイラーごとの個別変数

//ウインドウ１と２のカラム位置
static int line1[] = {0,33,44,56,68,79,89};
//ウインドウ３と４のカラム位置*/
static int line2[] = {0,12,24,36,48,52,54,54,54,54};

/*
static char helpbuff[22][128] =
	{" H  このヘルプを表示                i  ひとつ上へ",
	" v  ファイルを表示                  ",
	" e  ファイルを編集                  S  画面の更新",
	" f  EUC -> SHIFT-JIS                 vi の実行",
	" TABキーでファイルを選択            ",
	" p  ファイルを送信                  t  画面の先頭へ",
	"  選択ファイルの送信              g  最後尾に",
	" m  ディレクトリを作成              !  シェルモードに",
	" r  ディレクトリを削除              2  アクセス時刻表示",
	"  ファイルを削除                  9  作成年月表示",
	" c  ディレクトリを移動              0  作成時刻表示",
	"  移動ディレクトリ入力            1  メニュー表示切替",
	" F  SHIFT-JIS -> EUC                u  半画面上に",
	" M  ファイル移動/名前変更           d  半画面下に",
	"                                    j  一行下に",
	"  属性を変更                      k  一行上に",
	"  MiniFiler を起動した場所に      G  画面最後尾に",
	"  $HOME に戻る                    :  .ファイルの非表示",
	" -  以前に移動した場所に移動         ブックマークに位置を保存",
	" +  以前に移動した場所から移動      ~ ブックマークメニューを開く",
	" n  検索を開始。入力は '/' で        でtar.gz 圧縮 T で解凍"
	};
*/

void LocalFiler::command00(int no)
{
	/*
	ＣＭＳの起動
	*/
	//	case '@':
	noraw();
	echo();
	nl();
	nocbreak();
	int ret = system("/bin/stty echo onlcr icrnl;cmsmenu");
	raw();
	noecho();
	nonl();
	cbreak();

	cls_all(no);
	rectang(no);
	initbuff();
	wclear(pt[no].vs);
	set_screen(no);
	return;
}

void LocalFiler::command01(int no, int y, int yy)
{
	//	case '^':
	/*
	Hiddenファイル・ディレクトリを表示／非表示の切替え（デフォルト）
	*/
	switch(dmode)
	{
	case 'v':
		dmode = 'h';
		dirlocateofset('h');
		break;
	case 'h':
		dmode = 'v';
		dirlocateofset('v');
		break;
	default :
		dmode = 'h';
		break;
	}
	cls_all(no);
	initbuff();
	return;
}

int LocalFiler::command02(int no,int y, int yy)
{
	//	case '~':
	/*
	ブックマークのディレクトリに移動する。
	*/
	int j;
	char *vp;
	char *dp[1];
	char buff[256];
	char docbuff[256];
	int ret;

	if((vp = getenv("HOME")) == NULL)
	{
		sprintf(buff,"環境変数 HOME が設定されていません");
		sys_errmsg(4,10,buff);
		return(0);
	}

	sprintf(buff,"%s",fs[y+(yy-5)].buff1);
	if((dp[0] = bookmarkmenu(2,2,buff)) == NULL)
	{
		return(0);
	}
	sprintf(docbuff,"%s",dp[0]);

	tabselectclear();

	ret = chdir(docbuff);
	cls_all(no);
	initbuff();
	return(1);
}

void LocalFiler::command03(int no)
{
	//	case '0':
	/*
	ファイル・ディレクトリを作成した日付と時間で表示（デフォルト）
	*/
	fmode = 'm';
	cls_all(no);
	initbuff();
	return;
}
void LocalFiler::command04(int no)
{
	//	case '2':
	/*
	ファイル・ディレクトリを最新アクセスした日付で表示
	*/
	fmode = 'u';
	cls_all(no);
	initbuff();
	return;
}
void LocalFiler::command05(int no)
{
	//	case '9':
	/*
	ファイル・ディレクトリを作成した日付で表示
	*/
	fmode = 'y';
	cls_all(no);
	initbuff();
	return;
}

void LocalFiler::command06(int no, int y, int yy)
{
	/*
	ファイルの選択（マーク）
	*/
	//	case '\t':
	char buff[256];

	if(dmode == 'v')
	{
		if (intCPnum < 256)
		{
			sprintf(selcp[intCPnum],"%s",fs[y+(yy-5)].buff1);
			stat(fs[y+(yy-5)].buff1,fptr);
			if(!(fptr->st_mode & S_IFDIR) != 0)
			{
				if (regline[y+(yy-5)] == 1)
				{
					vs_print(" ",pt[no].vs,line1[no]+1,yy);
					regline[y+(yy-5)] = 0;
					cpflag[intCPnum] = 0;
					intCPnum--;
				}
				else
				{
					vs_print("*",pt[no].vs,line1[0]+1,yy);
					regline[y+(yy-5)] = 1;
					cpflag[intCPnum] = y+(yy-5);
					intCPnum++;
				}
			}
		}
		else
		{
			intCPnum = 0;
		}
	}
	else
	{
		sprintf(buff,"TAB キーでの選択は '~' キーで全ファイル表示で行っ>てください");
		sys_errmsg(4,10,buff);

	}
	return;
}

int LocalFiler::command07(int no)
{
	//	case '':
	/*
	複数選択表示（less）
	*/
	int i,j;
	char buff[256];

	sprintf(buff,"less で選択したファイルを順番に表示します。");
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		int ret = system("clear");
		noraw();
		echo();
		nl();
		nocbreak();

		wattroff(pt[no].vs,A_REVERSE);
		wrefresh(pt[no].vs);
		for (j=0;j<file_num;j++)
		{
			if(regline[j] == 1)
			{
				sprintf(buff,"less %s",fs[j].buff1);
				dialogmsg(33,6,buff);
				ret = system(buff);
			}
		}
		wclear(pt[no].vs);
		set_screen(no);
		noecho();
		cbreak();
	}
	cls_all(no);
	initbuff();

	wattron(pt[no].vs,A_REVERSE);
	box(pt[no].vs,' ',' ');
	wattron(pt[no].vs,A_REVERSE);
	rectang(no);
}

int LocalFiler::command08(int no)
{
	//	case '':
	/*
	複数ファイルの削除
	*/
	int i,j;
	char buff[256];
	char ftmp[256];
	char *cret;

	cret = getcwd(ftmp,255);
	sprintf(buff,"以下を削除 rm -f %s/%3d - files",ftmp,intCPnum);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		for (j=0;j<file_num;j++)
		{
			if(regline[j] == 1)
			{
				stat(selcp[j],fptr);
				if((fptr->st_mode & S_IFMT) != 0)
				{
					sprintf(buff,"rm -f %s > /dev/null 2>&1",fs[j].buff1);
					dialogmsg(33,6,buff);
					int ret = system(buff);
				}
				else
				{
					sprintf(buff,"%s が見つかりません",selcp[j]);
					sys_errmsg(4,10,buff);
					return(0);
				}
			}
		}
	}
	tabselectclear();
	cls_all(no);
	initbuff();
	return(1);

}

int LocalFiler::command09(int no, int y, int yy)
{
	//	case 'T':
	/*
	tar -xzf fine-name を実行
	*/
	char buff[256];
	int cret;

	sprintf(buff,"%s を tar -xzf で解凍します。",fs[y+(yy-5)].buff1);
	if(popmsg(2+8,(LINES/2)-4,buff) == 0)
	{
		return(0);
	}
	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
		return(0);

	sprintf(buff,"tar -xzf %s 2>&1 > /dev/null",fs[y+(yy-5)].buff1);
	int ret = system(buff);

	cret = chdir(buff);

	cls_all(no);
	set_screen(no);
	initbuff();
	return(1);
}

int LocalFiler::command10(int no, int y, int yy)
{
	//	case '':
	/*
	tar -czf fine-name を実行
	*/
	char buff[256];
	char tmpbuff[256];

	sprintf(buff,"%s を tar -czf で圧縮します。",fs[y+(yy-5)].buff1);
	if(popmsg(2+8,(LINES/2)-4,buff) == 0)
	{
		return(0);
	}

	sprintf(buff,"tar -czf %s.tar.gz %s 2>&1 > /dev/null",fs[y+(yy-5)].buff1,fs[y+(yy-5)].buff1);
	int ret = system(buff);

	cls_all(no);
	set_screen(no);
	return(1);
}

int LocalFiler::command11(int no, int y, int yy)
{
	//	case '':
	/*
	ファイルの属性（モード）を変更
	*/
	char buff[256];
	char execbuff[256];

	input_window(4,2,buff, "ファイル／ディレクトリの属性を変更します");
	if(strlen(buff) < (size_t)1 || (size_t)4 < strlen(buff))
		return(0);
	if(atoi(buff) > 778 || 1 > atoi(buff))
		return(0);
	sprintf(execbuff,"chmod %s %s > /dev/null 2>&1",buff,fs[y+(yy-5)].buff1);
	if(popmsg(6,(LINES/2)-4,execbuff) == 0)
	{
		return(0);
	}
	int ret = system(execbuff);
	cls_all(no);
	initbuff();
	return(1);
}

int LocalFiler::command12(int no)
{
	//	case '':
	/*
	ファイラーを起動したディレクトリに戻る
	*/
	int i,j;

	if(strlen(startdirname) < (size_t)1)
		return(0);
	stat(startdirname,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		if(chdir(startdirname) == -1)
			return(0);

		char *cret = getcwd(dirstack[pathcnt],512);
		if(pathcnt < 128)
			pathcnt++;
		if(pathisto < 128)
			pathisto++;
		checkhisto();

		tabselectclear();

		cls_all(no);
		initbuff();
		dirlocateclear();
	}
	return(1);
}

int LocalFiler::command13(int no)
{
	//	case '':
	/*
	環境変数 HOME に定義されたディレクトリに移動する
	*/
	int i,j;

	if(strlen(homedirname) < (size_t)1)
		return(0);
	stat(homedirname,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		if(chdir(homedirname) == -1)
			return(0);

		tabselectclear();

		cls_all(no);
		initbuff();
	}
	return(1);
}

int LocalFiler::command14(int y, int yy)
{
	//	case 'f':
	/*
	ファイルのコードをＥＵＣコードに変換する
	*/
	char buff[256];
	char tmpbuff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	sprintf(tmpbuff,"%s",fs[y+(yy-5)].buff1);
	if(filemode(fptr->st_uid,fptr->st_mode,tmpbuff) != 0)
	{
		sprintf(buff,"%s は変換出来ません。",fs[y+(yy-5)].buff1);
		sys_errmsg(4,10,buff);
		return(0);
	}

	sprintf(buff," -> EUC %s",fs[y+(yy-5)].buff1);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		sprintf(buff,"fconv.ksh -e %s > /dev/null 2>&1",fs[y+(yy-5)].buff1);
		/*
		sprintf(buff,"/opt/bin/stoe.sh %s",fs[y+(yy-5)].buff1);
		sprintf(buff,"ack -Ae %s",fs[y+(yy-5)].buff1);
		*/
		int ret = system(buff);
	}
	return(1);
}

int LocalFiler::command15(int y, int yy)
{
	//	case 'F':
	/*
	ファイルのコードをUTF-8コードに変換する
	*/
	char buff[256];
	char tmpbuff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	sprintf(tmpbuff,"%s",fs[y+(yy-5)].buff1);
	if(filemode(fptr->st_uid,fptr->st_mode,tmpbuff) != 0)
	{
		sprintf(buff,"%s は変換出来ません。",fs[y+(yy-5)].buff1);
		sys_errmsg(4,10,buff);
		return(0);
	}

	sprintf(buff," -> UTF-8 %s",fs[y+(yy-5)].buff1);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		sprintf(buff,"fconv.ksh -u %s > /dev/null 2>&1",fs[y+(yy-5)].buff1);
		int ret = system(buff);
	}
	return(1);
}

int LocalFiler::command16(int y, int yy)
{
	//	case '':
		/*
		ファイルのコードをシフトJISコードに変換する
		*/
	char buff[256];
	char tmpbuff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	sprintf(tmpbuff,"%s",fs[y+(yy-5)].buff1);
	if(filemode(fptr->st_uid,fptr->st_mode,tmpbuff) != 0)
	{
		sprintf(buff,"%s は変換出来ません。",fs[y+(yy-5)].buff1);
		sys_errmsg(4,10,buff);
		return(0);
	}

	sprintf(buff," -> Shift-JIS %s",fs[y+(yy-5)].buff1);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		sprintf(buff,"fconv.ksh -s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1);
		int ret = system(buff);
	}
	return(1);
}

int LocalFiler::command17(int no, int y, int yy)
{
	//	case 'r':
	/*
	ディレクトリの削除
	*/
	char buff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		sprintf(buff,"rmdir %s > /dev/null 2>&1",fs[y+(yy-5)].buff1);
		if(popmsg(2+8,(LINES/2)-4,buff) == 1)
		{
			rmdir(fs[y+(yy-5)].buff1);
			cls_all(no);
			initbuff();
		}
		else
		{
			return(0);
		}
	}
	return(1);
}

void LocalFiler::command18(int no)
{
	//	case '':
	/*
	ファイル指定なしでｖｉエディタを起動する。
	*/
	char buff[256];

	int ret = system("clear");
	noraw();
	echo();
	nl();
	nocbreak();

	sprintf(buff,"/bin/stty echo onlcr icrnl;vi");
	wattroff(pt[no].vs,A_REVERSE);
	wrefresh(pt[no].vs);
	ret = system(buff);

	wclear(pt[no].vs);
	set_screen(no);
	noecho();
	cbreak();
	return;
}
 
int LocalFiler::command19(int no, int y, int yy)
{
	//	case 'e':
	/*
	ファイル指定でｖｉエディタを起動する。
	*/
	char buff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
		return(0);
	int ret = system("clear");
	noraw();
	echo();
	nl();
	nocbreak();

	sprintf(buff,"/bin/stty echo onlcr icrnl;vi \"%s\"",fs[y+(yy-5)].buff1);
	wattroff(pt[no].vs,A_REVERSE);
	wrefresh(pt[no].vs);
	ret = system(buff);

	wclear(pt[no].vs);
	set_screen(no);
	noecho();
	cbreak();
	return(1);
}

int LocalFiler::command20(int no, int y, int yy)
{
#ifdef CYGWIN

//	case 'E':
	/*
	ファイル指定でWindows版 vimエディタを起動する。
	*/
	char buff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
		return(0);
	int ret = system("clear");
	noraw();
	echo();
	nl();
	nocbreak();

	sprintf(buff,"/cygdrive/c/vim/VIM32 %s",fs[y+(yy-5)].buff1);
	wattroff(pt[no].vs,A_REVERSE);
	wrefresh(pt[no].vs);
	ret = system(buff);

	wclear(pt[no].vs);
	set_screen(no);
	noecho();
	cbreak();
	wattron(pt[no].vs,A_REVERSE);
	box(pt[no].vs,ACS_VLINE,ACS_HLINE);
	wattroff(pt[no].vs,A_REVERSE);
	rectang(no);
	return(1);
#endif
}

int LocalFiler::command21(int no, int y, int yy)
{
	//	case '-':
	/*
	ディレクトリ移動の履歴を遡る
	*/
	int i,j;

	if(pathisto > 0)
		pathisto--;
	else
		return(0);
	if(chdir(dirstack[pathisto]) == -1)
	{
		sys_errmsg(4,10,"chdir error");
		return(0);
	}
	tabselectclear();
	cls_all(no);
	initbuff();
	return(1);
}

int LocalFiler::command22(int no, int y, int yy)
{
	//	case '+':
	/*
	ディレクトリ移動の履歴を戻る
	*/
	int i,j;

	if(pathisto < pathcnt)
		pathisto++;
	else
		return(0);
	if(chdir(dirstack[pathisto]) == -1)
		return(0);
	tabselectclear();
	cls_all(no);
	initbuff();
	return(1);
}

//これは不可
int LocalFiler::command23(int no, int y, int yy)
{
	//	case 'c':
	/*
	ディレクトリを移動する。
	*/
	char ftmp[256];

	set_screen_line1(no);
	set_screen(no);


	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		char *cret = getcwd(ftmp,256);
		if(1 == 1)
		{
			memset(ftmp,'\0',256);
			
			if(deep < 0 || (readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
			{
				deep = 0;
				goto skipdir;
			}
		}
		skipdir:

		if(chdir(fs[y+(yy-5)].buff1) == -1)
			return(0);
		sprintf(dirlocate[dirlocateyy[deep]], "%s",fs[y+(yy-5)].buff1);
		dirlocatey[deep] = y;
		dirlocateyy[deep] = yy;
		deep++;
		cret = getcwd(dirstack[pathcnt],512);
		if(pathcnt < 128)
			pathcnt++;
		if(pathisto < 128)
			pathisto++;
		checkhisto();

		cls_all(no);
		initbuff();
		dirprint_all(".",fmode);
		y = 0;
		yy = 5;
	}
	return(1);
}

//これは不可
int LocalFiler::command24(int no, int y, int yy)
{
	//	case 'i':
	/*
	ディレクトリを上に移動する。
	*/
	int i,j;

	set_screen(no);

	stat("..",fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		if(chdir("..") == -1)
			return(0);
		char *cret = getcwd(dirstack[pathcnt],512);
		if(pathcnt < 128)
			pathcnt++;
		if(pathisto < 128)
			pathisto++;
		checkhisto();

		tabselectclear();

		cls_all(no);
		initbuff();
		dirprint_all(".",fmode);

		if(deep > 0)
		{
			deep--;
			y = dirlocatey[deep];
			yy = dirlocateyy[deep];
		}
		else
		{
			y = 0;
			yy = 5;
		}
	}
	return(1);
}

int LocalFiler::command25(int no, int y, int yy)
{
	//	case 'v':
	/*
	ファイルビューアを起動する。
	*/
	char *vp;
	char buff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		return(0);
	}
	if((vp = getenv("PAGER")) == NULL)
	{
		sprintf(buff,"環境変数 PAGER が設定されていません");
		sys_errmsg(4,10,buff);
		sprintf(buff,"/bin/stty echo onlcr icrnl;less %s",fs[y+(yy-5)].buff1);
	}
	else
	{
		sprintf(docbuff,"%s",vp);
		sprintf(buff,"/bin/stty echo onlcr icrnl;%s %s",docbuff,fs[y+(yy-5)].buff1);
	}
	echo();
	nocbreak();
	nl();
	int ret = system(buff);
	noecho();
	cbreak();
	wclear(pt[no].vs);
	set_screen(no);
	cbreak();
	wattron(pt[no].vs,A_REVERSE);
	box(pt[no].vs,ACS_VLINE,ACS_HLINE);
	wattroff(pt[no].vs,A_REVERSE);
	rectang(no);
	wrefresh(pt[no].vs);
	return(1);
}

int LocalFiler::command26(int no, int y, int yy)
{
	//	case '':
	/*
	ファイルを削除する。
	*/
	char buff[256];

	if(intCPnum > 0)
	{
		if(popmsg(2+8,(LINES/2)-4,"単独のファイルを削除すると、選択が無効になります。") == 0)
			return(0);
	}
	stat(fs[y+(yy-5)].buff1,fptr);
	if((fptr->st_mode & S_IFDIR) == 0 || (fptr->st_mode & S_IFLNK) == 0)
	{
		sprintf(buff,"rm %s",fs[y+(yy-5)].buff1);
		if(popmsg(2+8,(LINES/2)-4,buff) == 1)
		{
			unlink(fs[y+(yy-5)].buff1);
			all_cls(no);
			initbuff();
		}
	}
	else
	{
		return(0);
	}
	return(1);
}

int LocalFiler::command27(int no, int y, int yy)
{
	//	case 'M':
	/*
	ファイルを移動または名前を変更する。
	*/
	char buff[256];
	char copybuff[256];

	sprintf(buff,"%s",fs[y+(yy-5)].buff1);
	input_window(4,2,copybuff,fs[y+(yy-5)].buff1,"ファイル名の変更か移動先を入力して下さい");
	if(strlen(copybuff) < (size_t)0)
		return(0);
	sprintf(buff,"move %s -> %s",fs[y+(yy-5)].buff1,copybuff);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		stat(copybuff,fptr);
		if((fptr->st_mode & S_IFDIR) != 0)
		{
			sprintf(buff,"mv -f %s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1,copybuff);
			int ret = system(buff);

			cls_all(no);
			initbuff();
		}
		else
		{
			sprintf(buff,"ディレクトリ %s が見つかりません。ファイル名を変更します。",copybuff);
			if(popmsg2(2,(LINES/2)-4,buff) == 1)
			{
				sprintf(buff,"mv -f %s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1,copybuff);
				int ret = system(buff);
				cls_all(no);
				initbuff();
			}
			else
			{
				sprintf(buff," %s ファイル名変更を行いませんでした",copybuff);
				sys_errmsg(4,10,buff);
				return(0);
			}
		}
	}
	return(1);
}

int LocalFiler::command28(int y, int yy)
{
	//	case 'p':
	/*
	ファイルをコピーする。
	*/
	char buff[256];
	char copybuff[256];
	char tmpbuff[256];

	loop1:

	stat(fs[y+(yy-5)].buff1,fptr);
	if((S_ISDIR(fptr->st_mode)) != 0)
	{
		sprintf(buff,"%s はディレクトリです。",fs[y+(yy-5)].buff1);
		sys_errmsg(4,10,buff);
		return(0);
	}
	input_window(4,2,copybuff,"コピー先を入力してください");
	if(strlen(copybuff) < (size_t)1)
		return(0);
	sprintf(buff,"cp -p %s -> %s",fs[y+(yy-5)].buff1,copybuff);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		stat(copybuff,fptr);
		if((fptr->st_mode & S_IFDIR) != 0)
		{
			stat(copybuff,fptr);
			if((fptr->st_mode & (S_IWOTH | S_IWGRP | S_IWUSR)) != 0)
			{
				sprintf(tmpbuff,"%s/%s",copybuff,fs[y+(yy-5)].buff1);
				stat(tmpbuff,fptr);
				if((fptr->st_mode & S_IFREG) != 0)
				{
					if(popmsg(2+8,(LINES/2)-4,"同名のファイルが存在します。上書きしますか？") == 1)
					{
						sprintf(buff,"cp -p %s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1,copybuff);
						dialogmsg(33,6,buff);
						int ret = system(buff);
					}
					return(0);
				}
				sprintf(buff,"cp -p %s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1,copybuff);
				dialogmsg(33,6,buff);
				int ret = system(buff);

			}
			else
			{
				sprintf(buff,"%s に書き込み権限がありません。",copybuff);
				sys_errmsg(4,10,buff);
			}
		}
		else
		{
			sprintf(buff,"%s が見つかりません",copybuff);
			sys_errmsg(4,10,buff);
			goto loop1;
		}
	}
	return(1);
}

int LocalFiler::command29(int no, int y, int yy)
{
	//	case '':
	/*
	複数選択移動
	*/
	int i,j;
	char buff[256];
	char copybuff[256];
	char ftmp[256];

	input_window(8,4,copybuff,"移動先を入力して下さい");
	if(strlen(copybuff) < (size_t)1)
		return(0);
	char *cret = getcwd(ftmp,255);
	sprintf(buff,"%3d: Move %s -> %s",intCPnum,ftmp,copybuff);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		for (j=0;j<file_num;j++)
		{
			if(regline[j] == 1)
			{
				stat(copybuff,fptr);
				if((fptr->st_mode & S_IFDIR) != 0)
				{
					sprintf(buff,"mv -f %s %s > /dev/null 2>&1",fs[j].buff1,copybuff);
					dialogmsg(33,6,buff);
					int ret = system(buff);
				}
				else
				{
					sprintf(buff,"%s が見つかりません",copybuff);
					sys_errmsg(4,10,buff);
				}
			}
		}
	}
	tabselectclear();
	cls_all(no);
	initbuff();
}

int LocalFiler::command30(int no, int y, int yy)
{
	//	case '':
	/*
	複数選択コピー
	*/
	int i,j;
	char buff[256];
	char copybuff[256];
	char ftmp[256];

	input_window(8,4,copybuff,"コピー先を入力して下さい");
	if(strlen(copybuff) < (size_t)1)
		return(0);
	char *cret = getcwd(ftmp,255);
	sprintf(buff,"%3d: cp -p %s -> %s",intCPnum,ftmp,copybuff);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		for (j=0;j<file_num;j++)
		{
			if(regline[j] == 1)
			{
				stat(copybuff,fptr);
				if((fptr->st_mode & S_IFDIR) != 0)
				{
					stat(copybuff,fptr);
					if((fptr->st_mode & (S_IWOTH | S_IWGRP | S_IWUSR)) != 0)
					{
						sprintf(buff,"cp -p %s %s > /dev/null 2>&1",fs[j].buff1,copybuff);
						dialogmsg(33,6,buff);
						int ret = system(buff);
					}
					else
					{
						sprintf(buff,"%s に書き込み権限がありません。",copybuff);
						sys_errmsg(4,10,buff);
						return(0);
					}
				}
				else
				{
					sprintf(buff,"%s が見つかりません",copybuff);
					sys_errmsg(4,10,buff);
					return(0);
				}
			}
		}
	}
	tabselectclear();
	cls_all(no);
	initbuff();
	return(1);
}

int LocalFiler::command31(int no, int y, int yy)
{
	//	case '':
	/*
	複数選択の tar -czf tar-fine-name を実行
	*/
	int i,j;
	char buff[2048];
	char copybuff[2048];
	char tmpbuff[256];

	input_window(4,2,tmpbuff,"tar -czf の圧縮ファイル名を入力して下さい。");
	if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 0)
	{
		return(0);
	}

	memset(copybuff,'\0',sizeof(copybuff));
	memset(buff,'\0',sizeof(buff));
	for (j=0;j<file_num;j++)
	{
		if(regline[j] == 1)
		{
			strcat(copybuff," ");
			strcat(copybuff,fs[j].buff1);
		}
	}

	if(strlen(copybuff) < (size_t)2)
		return(0);
	sprintf(buff,"tar -czf %s.tar.gz %s",tmpbuff,copybuff);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		int ret = system(buff);
	}

	tabselectclear();
	cls_all(no);
	initbuff();
	set_screen(no);
	return(1);
}

void LocalFiler::command32(int no)
{
	//	case '!':
	/*
	シェルモードへ移行
	*/
	char *vp;
	char buff[256];

	int ret = system("clear");
	if((vp = (char *)getenv("SHELL")) == NULL)
	{
		sprintf(buff,"/bin/stty echo onlcr;/bin/ksh");
	}
	else
	{
		sprintf(buff,"/bin/stty echo onlcr eof ;%s",vp);
	}
	echo();
	nocbreak();
	nl();
	ret = system("echo [m");
	ret = system(buff);
	wclear(pt[no].vs);
	set_screen(no);
	noecho();
	cbreak();

	wattron(pt[no].vs,A_REVERSE);
	box(pt[no].vs,ACS_VLINE,ACS_HLINE);
	wattroff(pt[no].vs,A_REVERSE);
	rectang(no);

	cls_all(no);
	initbuff();
	return;
}

int LocalFiler::command33(int no)
{
	//	case 'm':
	/*
	ディレクトリを作成する
	*/
	char buff[256];

	input_window(4,2,buff,"作成するディレクトリ名を入力");
	if(strlen(buff) < (size_t)1)
		return(0);
	if(popmsg(6,(LINES/2)-4,buff) == 0)
	{
		return(0);
	}
	if(strlen(buff) < (size_t)1)
		return(0);
	if(mkdir(buff,S_IRUSR|S_IRGRP|S_IROTH|S_IWUSR|S_IWOTH|S_IWGRP|S_IXUSR|S_IXGRP|S_IXOTH) == -1)
		return(0);
	stat(buff,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		cls_all(no);
		initbuff();
	}
	return(1);
}

int LocalFiler::command34(int no)
{
	//	case 'O':
	/*
	入力でディレクトリを移動する
	*/
	char buff[256];

	input_window(4,2,buff,"移動するディレクトリ名を入力");
	if(strlen(buff) < (size_t)1)
		return(0);
	stat(buff,fptr);
	if((fptr->st_mode & S_IFDIR) != 0)
	{
		if(chdir(buff) == -1)
			return(0);

		char *cret = getcwd(dirstack[pathcnt],512);
		if(pathcnt < 128)
			pathcnt++;
		if(pathisto < 128)
			pathisto++;
		checkhisto();

		cls_all(no);
		initbuff();
	}
	return(1);
}

void LocalFiler::command35(int no)
{
	//	case '^X':
	/*
	ファイルをプログラムとして実行
	*/
	char buff[256];
	char execbuff[256];

	input_window(4,2,buff,"コマンド入力でプログラムを実行します");
	noraw();
	echo();
	nl();
	nocbreak();
	int ret = system("clear;/bin/stty echo onlcr icrnl");
	sprintf(execbuff,"%s 2>&1 | less",buff);
	ret = system(execbuff);
	raw();
	noecho();
	nonl();
	cbreak();
	cls_all(no);
	initbuff();
	wclear(pt[no].vs);
	set_screen(no);
	return;
}

int LocalFiler::command36(int no, int y, int yy)
{
	//	case 'x':
	/*
	ファイルを実行する（コマンド実行）。
	*/
	pid_t pid;
	int ret;
	char buff[256];
	char tmpbuff[256];

	stat(fs[y+(yy-5)].buff1,fptr);
	if(fptr->st_mode & S_IFDIR)
		return(0);
	if(!(fptr->st_mode & 0000111))
		return(0);
	sprintf(buff,"%s",fs[y+(yy-5)].buff1);
	sprintf(tmpbuff,"Execute %s",fs[y+(yy-5)].buff1);
	if(popmsg(2+8,(LINES/2)-4,tmpbuff) == 1)
	{
		int ret = system("clear");
		noraw();
		echo();
		nl();
		nocbreak();

		pid = fork();
		switch(pid)
		{
		case -1: 
			break;
		case 0:
			ret = execlp(buff,buff,NULL);
			if(ret < 0)
				exit(0);
			break;
		default:
			break;
		}
		wait(&ret);

		wattroff(pt[no].vs,A_REVERSE);
		wrefresh(pt[no].vs);

		wclear(pt[no].vs);
		set_screen(no);

		wclear(pt[no].vs);
		set_screen(no);
		noecho();
		cbreak();
		box(pt[no].vs,ACS_VLINE,ACS_HLINE);
		rectang(no);
		initbuff();
		wclear(pt[no].vs);
		set_screen(no);
	}
	else
	{
		return(0);
	}
	return(1);
}

int LocalFiler::command37(int no, int y, int yy)
{
	//	case 's':
	/*
	シンボリックリンクの作成
	*/
	char buff[256];
	char copybuff[256];

	input_window(4,2,copybuff,buff,"シンボリックリンク先を入力して下さい");
	if(strlen(copybuff) < (size_t)0)
		return(0);
	sprintf(buff,"ln -s %s %s",fs[y+(yy-5)].buff1,copybuff);
	if(popmsg(2+8,(LINES/2)-4,buff) == 1)
	{
		stat(copybuff,fptr);
		if((fptr->st_mode & S_IFDIR) != 0)
		{
			sprintf(buff,"ln -s %s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1,copybuff);
			int ret = system(buff);

			cls_all(no);
			initbuff();
		}
		else
		{
			sprintf(buff,"ディレクトリ %s が見つかりません。ファイルをリンクします。",copybuff);
			if(popmsg2(2,(LINES/2)-4,buff) == 1)
			{
				sprintf(buff,"ln -s %s %s > /dev/null 2>&1",fs[y+(yy-5)].buff1,copybuff);
				int ret = system(buff);
				cls_all(no);
				initbuff();
			}
			else
			{
				sprintf(buff," %s シンボリックリンクを行いませんでした",copybuff);
				sys_errmsg(4,10,buff);
				return(0);
			}
		}
	}
	return(1);
}

void LocalFiler::command38(int no, int y, int yy)
{
	//	case '':
	/*
	MAKE コマンドの実行
	*/
	char buff[256];

	dialogmsg(12,7,"ＭＡＫＥコマンドを実行中です");
	noraw();
	echo();
	nl();
	nocbreak();
	int ret = system("/bin/stty onlcr;make | less");
	raw();
	noecho();
	nonl();
	cbreak();

	cls_all(no);
	initbuff();

	return;
}

void LocalFiler::command39(int no, int y, int yy)
{
	//	case '':
	/*
	MAKE コマンドの実行
	*/
	char buff[256];
	char ftmp[256];
	char *nln;

	dialogmsg(12,7,"ＭＡＫＥコマンドを実行中です");
	noraw();
	echo();
	nl();
	nocbreak();
	sprintf(ftmp,"%s",fs[y+(yy-5)].buff1);
	if((nln = strchr(ftmp,'.')) != NULL)
		*nln = '\0';
	sprintf(buff,"/bin/stty onlcr;make %s 2>&1 | less",ftmp);
	int ret = system(buff);
	raw();
	noecho();
	nonl();
	cbreak();

	cls_all(no);
	initbuff();

	return;
}


