#include "wsubform.h"	//サブフォーム専用ヘッダファイルをインクルードする。

#define Textbox	1
#define Grid	2
#define Panel	3

#define Tret	199
#define Gret	299
#define Pret	399

extern int wmode;
extern char gridtitles[MAX_POS][MAX_LEN];

extern TextBox	 *begin;
extern TextBox	 *tp;

typedef struct stat Dir;
static Dir dirptr;
static Dir  *fileptr = &dirptr;

char tmp[256];

int subform(void)
{
	int i,j,k;
	int ret;
	char f[128];
//	int xcol,rows;
//	int maxtext;
	char s[256];

#ifdef PANELS
	strcpy(f,"_subpanels.def");
#else
	strcpy(f,"_ega_subform.def");
#endif

	initscr();

//	xcol = COLS;
//	rows = LINES;

	cbreak();
	noecho();
	keypad(stdscr, TRUE);
	meta(stdscr, TRUE);

	if(stat(f,fileptr) != 0)
	{
		echo();
		endwin();
		printf("canot find %s\n",f);
		exit(0);
	}



#ifdef PANELS
	maxtext = sf_panels(0,xcol,rows,0,2,f);
#else
//	maxtext = sf_textbox(0,0,2,f);

//Automatic Subform Editor v3.0.0

	static int xcol = 79;
	static int rows = 19;

	static int label_length[] = {14,14,14,14,14,14,14,0};
	static int label_no[] = {0,1,2,3,4,5,6,0};
	static int label_align[] = {1,1,1,1,1,1,1,0};
	static char *label_text[8][128] = {"Label_1","Label_2","Label_3","Label_4","Label_5","Label_6","Label_7",""};
	static int label_x[] = {1,1,1,1,1,1,1,0};
	static int label_y[] = {1,2,3,4,5,6,7,0};
	static int textbox_length[] = {3,7,14,10,11,11,14,0};
	static int textbox_no[] = {0,1,2,3,4,5,6,0};
	static int textbox_align[] = {1,1,1,1,1,1,1,0};
	static int textbox_action[] = {0,0,0,0,0,0,0,0};
	static int textbox_skipstep[] = {1,1,1,1,1,1,1,0};
	static int textbox_field[] = {1,1,1,1,1,1,1,0};
	static int textbox_x[] = {15,15,15,15,15,15,15,0};
	static int textbox_y[] = {1,2,3,4,5,6,7,0};


	static int cell_length[] = {3,7,16,10,10,10,15,0};
	static int cell_align[] = {1,1,1,1,2,2,2,0};
	static int cell_action[] = {0,0,0,0,0,0,0,0};
	static int grid_field[] = {1,1,1,1,2,4,4,0};
	static int grid_skipstep[] = {1,1,1,1,1,1,1,0};
	char *grid_titles[8][128] = {"1","2","3","4","5","6","7",""};
//	static char *db_titles[8][128] = {0};
	static int grid_sx = 0;
	static int grid_ex = 76;
	static int grid_sy = 10;
	static int grid_ey = 18;

	static int maxtext;
	static int no = 0;

	char **gt;
	char **lt;

	gt = (char **)&grid_titles;

	xcol = MakeWsubForm(no,xcol,rows,0,2,grid_sx,grid_sy,grid_ex,grid_ey,cell_length,cell_align,cell_action,grid_field,grid_skipstep,gt,7);

	lt = (char **)&label_text;

	maxtext = MakeTextBox(no,0,2,xcol,rows,label_no,lt,label_x,label_y,label_length,textbox_no,textbox_x,textbox_y,textbox_length,textbox_align,textbox_action,textbox_field,textbox_skipstep, 7);

#endif

	wrefresh(xt[0].form);

	for(i=0;i<MAX_POS;i++)
		memset(gridtitles[i],'\0',MAX_LEN);

#ifdef PANELS
	xcol = sf_wsubform(2,xcol,rows,0,43,"_panel_footer.def");
#else
	xcol = sf_wsubform(2,xcol,rows,0,21,"_ega_footer.def");
#endif
	sf_gput(2,11,0,"切替");
	wrefresh(xt[2].form);

	sf_tbegin();		//テキストボックスセルを最初の位置に設定する。
	for(i=0;i<maxtext;i++)
	{
		sprintf(s,"%d",i+1);
		sf_tput(0,i,s);
		wrefresh(ft[0].pt[i].panel);
		wrefresh(ft[0].pos[i].vs);
		sf_tnext();
	}

	for(i=0,k=1;i<ft[0].lcol;i++)
	{
		for(j=0;j<(ft[0].ey-ft[0].sy)+1;j++)
		{
			sprintf(s,"%d",k);
			sf_gput(0,i,j,s);
			k++;
		}
	}
	xcol = sf_wsubform(1,xcol,rows,0,0,"_ega_header.def");
	sprintf(tmp,"%s","Sample screen for Subform Library v.3.0");
	sf_gput(1,0,0,tmp);
	wrefresh(xt[1].form);

	sf_startcell(0);

	ret = Gret;
	sf_tbegin();
	while(TRUE)
	{
		if(ret == Tret || ret == Pret)//リターンコードでグリッドかテキストボックスを切り替える。
			ret = sf_grid(0,maxtext,xcol);
		else
#ifdef PANELS
			ret = sf_paneltext(0,maxtext, xcol);
#else
			ret = sf_formtext(0,maxtext, xcol);
#endif
	//	ret = sf_grid(0,maxtext,xcol);
		switch(ret)
		{
		case -1:
			echo();
			endwin();
			exit(0);
			break;

	//for textbox
		case 100: //ESC　キーでプログラムを終了することにする。
			if(popmsg(2+8,(LINES/2)-4,"Exit textbox area in Subform?") == 1)
				goto end;
			ret = Gret;  //２つのウインドウ関数を同時に利用するためリターンコードをセットしておく。
			break;
		case 101: //F1
			ret = Gret;
			break;
		case 102: //F2
			ret = Gret;
			break;
		case 103: //F3　テキストボックス内の文字を左詰にする。
			i = sf_status(0,Textbox,'n');
			sprintf(tmp,"%s",tp->s);
			sf_tcep(0,i,2,tmp);
			ret = Gret;
			break;
		case 104: //F4　999999という数字を999,999としてテキストボックスに書き込む。
			i = sf_status(0,Textbox,'n');
			sf_tvarprint(0,i,"999999");
			ret = Gret;
			break;
		case 105: //F5　テキストボックスに"Put"と文字を書き込む。
			i = sf_status(0,Textbox,'n');
			wrefresh(ft[0].pos[i].vs);
			sf_tput(0,i,"Put");
			ret = Gret;
			break;
		case 106: //F6　テキストボックス内の文字を読み込み、メッセージウインドウに表示する。
			i = sf_status(0,Textbox,'n');
			sf_tget(0,i,tmp);
			errmsg(2+8,(LINES/2)-4,tmp);
			ret = Gret;
			break;
		case 107: //F7　テキストボックスを移動する。
			sf_tlocate(0,7);
			ret = Gret;
			break;
		case 108: //F8　テキストボックスセルの属性をメッセージウインドウに表示。
			sprintf(tmp,"w=%d,x=%d,y=%d,X=%d,n=%d,l=%d,c=%d,a=%d,A=%d,f=%d,s=%d",
					sf_status(0,Textbox,'w'),sf_status(0,Textbox,'x'),sf_status(0,Textbox,'y'),sf_status(0,Textbox,'X'),
					sf_status(0,Textbox,'n'),sf_status(0,Textbox,'l'),sf_status(0,Textbox,'c'),sf_status(0,Textbox,'a'),
					sf_status(0,Textbox,'a'),sf_status(0,Textbox,'f'),sf_status(0,Textbox,'s'));
			errmsg(2+8,(LINES/2)-4,tmp);
			ret = Gret;
			break;
		case 109: //F9　全てのテキストボックス内文字を右に寄せる。
			i = sf_status(0,Textbox,'n');
			sprintf(tmp,"%s",tp->s);
			sf_tcep(0,i,1,tmp);
			wrefresh(ft[0].pos[i].vs);
			sf_tbegin();
			for(i=0;i<maxtext;i++)
			{
				wrefresh(ft[0].pos[i].vs);
				sf_tnext();
			}
			ret = Gret;
			break;
		case 110: //F10　全てのテキストボックスに番号を書き込みセンター寄せする。
			sf_tbegin();
			for(i=0;i<maxtext;i++)
			{
				sprintf(s,"%d",i+1);
				sf_tcep(0,i,3,s);
				wrefresh(ft[0].pos[i].vs);
				sf_tnext();
			}
			ret = Gret;
			break;
		case 111: //F11　全てのテキストボックスに番号を書き込む。
			sf_tbegin();
			for(i=0;i<maxtext;i++)
			{
				sprintf(s,"%d",i+1);
				sf_tput(0,i,s);
				wrefresh(ft[0].pos[i].vs);
				sf_tnext();
			}
			ret = Gret;
			break;

	//for grid
		case 200: //ESC　キーでプログラムを終了する。
			if(popmsg(2+8,(LINES/2)-4,"Exit grid area in Subform?") == 1)
				goto end;
			ret = Pret;
			break;
		case 201: //F1
			ret = Pret;
			break;
		case 202: //F2
			ret = Pret;
			break;
		case 203: //F3　現在のセルの位置を調べた後、セル内文字を読みとりセンター詰めで書き込む。
			i = sf_status(0,Grid,'X');
			j = sf_status(0,Grid,'Y');
			sf_gget(0,i,j,tmp);
			sf_gcep(0,i,j,2,tmp);
			ret = Pret;
			break;
		case 204: //F4　現在のセルの位置を調べた後、数値"999999"を"999,999"で書き込む。
			i = sf_status(0,Grid,'c');
			j = sf_status(0,Grid,'Y');
			sf_gvarprint(0,i,j,"999999");
			ret = Pret;
			break;
		case 205: //F5
			ret = Pret;
			break;
		case 206: //F6　セル内文字を読みとりメッセージウインドウに表示する。
			i = sf_status(0,Grid,'X');
			j = sf_status(0,Grid,'Y');
			sf_gget(0,i,j,tmp);
			errmsg(2+8,(LINES/2)-4,tmp);
			ret = Pret;
			break;
		case 207: //F7　現在のセルの位置を調べた後、セルカーソルの移動場所を選択する。最後にNUMERIC型のセルに移動
			i = sf_status(0,Grid,'X');
			j = sf_status(0,Grid,'Y');
			sprintf(tmp,"i=%d/j=%d",i,j);
			if(popmsg(2+8,(LINES/2)-4,tmp)== 1)
				sf_glocate(0,8,32);
			i = sf_status(0,Grid,'f');
			sprintf(tmp,"f=%d",i);
			errmsg(2+8,(LINES/2)-4,tmp);
			if(sf_status(0,Grid,'f') == 4)
			{
				sf_glocate(0,8,1);
			}
			ret = Pret;
			break;
		case 208: //F8　テキストボックスセルの属性をメッセージウインドウに表示。
			sprintf(tmp,"w=%d,x=%d,y=%d,X=%d,n=%d,l=%d,c=%d,a=%d,A=%d,f=%d,s=%d",
					sf_status(0,Grid,'w'),sf_status(0,Grid,'x'),sf_status(0,Grid,'y'),sf_status(0,Grid,'X'),
					sf_status(0,Grid,'n'),sf_status(0,Grid,'l'),sf_status(0,Grid,'c'),sf_status(0,Grid,'a'),
					sf_status(0,Grid,'a'),sf_status(0,Grid,'f'),sf_status(0,Grid,'s'));
			errmsg(2+8,(LINES/2)-4,tmp);
			ret = Pret;
			break;
		case 209: //F9　カンマ付き１１桁数値を全てのセルに書き込む。
			for(i=0,k=1;i<ft[0].lcol;i++)
			{
				for(j=0;j<(ft[0].ey-ft[0].sy)+1;j++)
				{
					sprintf(s,"%ld",33335 * 60000);
					sf_gvarprint(0,i,j,s);
				}
			}
			ret = Pret;
			break;
		case 210: //F10　全てのセルに番号を書き込む。
			for(i=0,k=1;i<ft[0].lcol;i++)
			{
				for(j=0;j<(ft[0].ey-ft[0].sy)+1;j++)
				{
					sprintf(s,"%d",k);
					sf_gput(0,i,j,s);
					k++;
				}
			}
			ret = Pret;
			break;
		case 211: //F11　セルに番号を書き込む。
			for(j=0,k=1;j<(ft[0].ey-ft[0].sy)+1;j++)
			{
				for(i=0;i<ft[0].lcol;i++)
				{
					sprintf(s,"%d",k);
					sf_gput(0,i,j,s);
					k++;
				}
			}
			ret = Pret;
			break;

	//for panels
		case 300: //ESC　キーでプログラムを終了する。
			if(popmsg(2+8,(LINES/2)-4,"Exit panels area in Subform?") == 1)
				goto end;
			ret = Gret;
			break;
		case 301: //F1
			ret = Gret;
			break;
		case 302: //F2
			ret = Gret;
			break;
		case 303: //F3
			ret = Gret;
			break;
		case 304: //F4
			ret = Gret;
			break;
		case 305: //F5
			ret = Gret;
			break;
		case 306: //F6
			ret = Gret;
			break;
		case 307: //F7
			sf_tlocate(0,12);
			ret = Gret;
			break;
		case 308: //F8
			ret = Gret;
			break;
		case 309: //F9　パネル内テキストボックスを調査し、文字を右寄せする。
			i = sf_status(0,Panel,'n');
			sprintf(tmp,"%s",tp->s);
			sf_tcep(0,i,1,tmp);
			ret = Gret;
			break;
		case 310: //F10　パネル内テキストボックスに番号をふり、センター寄せする。
			sf_tbegin();
			for(i=0;i<maxtext;i++)
			{
				sprintf(s,"%d",i+1);
				sf_tcep(0,i,3,s);
				wrefresh(ft[0].pos[i].vs);
				sf_tnext();
			}
			ret = Gret;
			break;
		case 311: //F11　パネル内テキストボックスに番号を書き込む。
			sf_tbegin();
			for(i=0;i<maxtext;i++)
			{
				sprintf(s,"%d",i+1);
				sf_tput(0,i,s);
				wrefresh(ft[0].pos[i].vs);
				sf_tnext();
			}
			ret = Gret;
			break;

		default:
			break;
		}
	}

end:
	echo();
	endwin();
}

int main(void)
{
	subform();
}

