#pragma ident "@(#) wsubformHTML.h 0.0.2 2010.05.24,16:25"
#ifndef _WSUBFORMHTML_H 
#define _WSUBFORMHTML_H _WSUBFORMHTML_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <math.h>
#include <time.h>
#include <sys/stat.h>

#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/unistd.h>
#include <sys/wait.h>

#define RIGHT		"RIGHT"		//右詰め文字列(数値等)
#define LEFT		"LEFT"		//左詰め文字列
#define CENTER		"CENTER"	//中央寄せ文字列

#define FLD_TEXT		"TEXT"		//フィールドタイプ=text,char,varchar(現在 varchar)
#define FLD_NUMERIC		"NUMERIC"	//フィールドタイプ=integer,decimal,number(現在 integer)
#define FLD_BOOL		"BOOL"		//C言語側ではunsigned int を適用する
#define FLD_CURRENCY	"CURRENCY"	//フィールドタイプ=money(999,999,999,999,999)
#define FLD_DATE		"DATE"		//フィールドタイプ=(YYYY/MM/DD)C言語側ではtimestamp を使用
#define FLD_SINGLE		"SINGLE"	//未使用(not use)
#define FLD_DOUBLE		"DOUBLE"	//double precision
#define FLD_BYTE		"BYTE"		//未使用(not use)
#define TEXT			1
#define NUMERIC			2
#define BOOL			3
#define CURRENCY		4
#define DATE			5
#define SINGLE			6
#define DOUBLE			7
#define BYTE			8

#define	ACT_EDIT	"EDIT"	//編集可能
#define	ACT_NONE	"NONE"	//編集不可

#define	SKIP		"SKIP"	//そのセルには到達しない
#define	STEP		"STEP"	//そのセルには到達出来る

#define MAX_COL		1024		//グリッド内セルの最大数
#define MAX_ROW		68		//グリッド内セルの最大行数
#define MAX_LEN		256		//グリッド内セルの最大桁数
#define MAX_POS		1024		//セルの最大数
#define MAX_DEF		2048	//利用可能な最大定義数
#define MAX_TMP		2048	//利用可能な最大文字数
#define MAX_STR		2048	//利用可能な最大文字数
#define MAX_DB_LINE	10000	//FETCH時にDBから読み取れる最大行数

#define MAX_FORM	10		//同時に表示可能なサブフォームの数
//#define MAX_PANEL	5		//１つのサブフォームに配置可能なパネルの最大行数

/*for textbox*/
typedef struct textbox
{
	struct textbox *next;		//テキストボックスセルの連鎖ポインタ。先を指す。
	struct textbox *prev;		//テキストボックスセルの連鎖ポインタ。前を指す。
	char *s;					//
	unsigned long n;			//
	int no;						//テキストボックスの番号
	int x;						//テキストボックスの位置X軸
	int y;						//テキストボックスの位置Y軸
	int c;						//テキストボックスのポジション番号
	int col;					//テキストボックスのカラム番号
	int len;					//テキストボックスの長さ
	int attr;					//
	int ftype;					//テキストボックスのフィールドタイプ
	int action;					//テキストボックスのアクション(EDIT or NONE)
	int align;					//テキストボックスのアライメント(RIGHT or LEFT or CENTER)
	int stype;					//テキストボックスのスキップとステップ設定(SKIP or STEP)
} TextBox;

/*for grid*/
struct cell {
	int no;						//グリッドセルの番号
	int x;						//グリッドセルの位置X軸
	int y;						//グリッドセルの位置Y軸
	int c;						//グリッドセルの絶対位置(1-384)
	int len;					//セルの長さ
	int attr;					//Now not use
	int ftype;					//セルのフィールドタイプ
	int action;					//セルのアクション(EDIT or NONE
	int align;					//セルのアライメント(RIGHT or LEFT or CENTER)
	int stype;					//セルのスキップステップ(SKIP or STEP)
	char s[MAX_STR];			//未使用
};

struct SubForm {
	int col;		//save column
	int line;		//save line
	int no;			//Textbox number
	int n;			//Textbox number
	int x;			//x col
	int y;			//y line
	int c;			//Cell position of numeric
	int len;		//Cell length
	int ftype;		//Filed type
	int action;		//Cell action
	int align;		//Cell aligment
	int stype;		//Cell skip or step.
};

/*for form*/
struct FormBox {
	int sx;						//フォームウインドウの開始位置X軸
	int ex;						//フォームウインドウの終端位置X軸
	int sy;						//フォームウインドウの開始位置Y軸
	int ey;						//フォームウインドウの終端位置Y軸
	int lcol;					//フォームウインドウの最後のカラム
	int width;					//not use
	int height;					//not use
	int attr;					//not use
	struct SubForm pos[MAX_COL];			//テキストボックスのポジション
	struct SubForm st[MAX_COL][MAX_ROW];	//グリッド内セルのポジション
	struct cell cp[MAX_COL][MAX_ROW];		//グリッド内セルの属性情報を保持する。
	char *splitDBbuff[MAX_DB_LINE][MAX_COL];//DBgrid()用。DBからの項目を行毎に管理するポインタ配列。assget()が使用する。
	char LabelName[MAX_COL][MAX_LEN];	//HTMLが利用するラベルタイトル（テキストボックス用）
} ft[MAX_FORM];

	char *splitDBbuff[MAX_COL];//textbox()用。DBからの項目を管理するポインタ配列。UPDATE INSERT用の一時的な配列。assset()が使用する。

struct query {
	char get[256][8192];
	char post[256][8192];
} qt;
char KEY[256][MAX_STR];

/*for grid*/
static char gridprpty[][MAX_DEF] = {
	"COLS=",					//From window width
	"ROWS=",					//From window heigit
	"GRID_SX=",					//Start of x line for grid area
	"GRID_SY=",					//Start of y line for grid area
	"GRID_EX=",					//End of x line for grid area
	"GRID_EY=",					//End of y line for grid area
	"CELL_LENGTH=",				//Cell length
	"CELL_ALIGN=",				//Cell aligment
	"CELL_ACTION=",				//Cell action
	"GRID_TITLES=",				//Cell titles
	"GRID_FIELD_TYPE=",			//Cell field type
	"GRID_SKIP_STEP=",			//Cell skip or step
	"" };

/*for textbox*/
static char textboxprpty[][MAX_DEF] = {
	"COLS=",					//Form window width
	"ROWS=",					//Form window height
	"LABEL_X=",					//Start of x line for label
	"LABEL_Y=",					//Start of x line for label
	"LABEL_LENGTH=",			//Label length
	"LABEL_TEXT=",				//Label text
	"TEXTBOX_NO=",				//Textbox cell number(1 - end)
	"TEXTBOX_X=",				//Textbox x line
	"TEXTBOX_Y=",				//Textbox y line
	"TEXTBOX_LENGTH=",			//Text length
	"TEXTBOX_ALIGN=",			//Textbox alignment
	"TEXTBOX_ACTION=",			//Textbox cell action (edit or none)
	"TEXTBOX_FIELD_TYPE=",		//Cell field type(1 - 9)
	"TEXTBOX_SKIP_STEP=",		//Cell skip or step
	"" };

/*補助関数*/
extern char *addspace(int len, char *s);
extern int compare(int c, char *p,char *s);
extern char *cutspace(char *s);
extern char *cutspace_right(char *s);
extern int ifspace(int len,char *s);
extern int logmsg(char *logmsg);
extern char *create_session_id(void);
extern char *sccep(char *buff);
extern char *slcep(char *buff);
extern char *srcep(char *buff);
extern char *varprint(char *buff);
extern int query_getHTML(char *query, char c);
extern int query_postHTML(char *query, char c, int len);

/*HTMLアクセス関数*/
extern void sf_tbegin(void);
extern int sf_tprev(void);
extern int sf_tnext(void);
extern int sf_tput(int no, int col, char *s);
extern int sf_gputHTML(int no, int col, int line, char *s);
extern int sf_gget(int no, int col, int line,char *s);
extern void sf_startcell(int no);
extern void sf_to_text(int in,char *out);
extern void sf_to_text4F(double in,char *out);
extern void sf_to_text8F(double in,char *out);
extern long sf_to_numeric(char *in);
extern int sf_to_integer(char *in);
extern double sf_to_double(char *in);
extern int sf_textboxfree(int maxtext);
extern void sf_freeDB(int no, int DBcount, int maxcol);
extern int sf_ggetDB(int no, int line, int col, int startline,char *s);
extern int sf_gputDB(int no, int line, int col, int startline,char *s);
extern int sf_gputDBHTML(int no, int line, int col, int startline,char *s);
extern int sf_tputDB(int no, int col, char *s);
extern int sf_tgetDBallHTML(int no);
extern void sf_assgetDB(int no,int line,int col, char *buff, int size);
extern void sf_assputDB(int no,int col, char *buff, int size);

extern int MakeTextBoxHTML(int no,int fx,int fy,int xcol,int xrow,int *label_no,char **label_text,int *label_x,int *label_y,int *label_length,int *textbox_no,int *textbox_x,int *textbox_y,int *textbox_length,int *textbox_align,int *textbox_action,int *textbox_field,int *textbox_skipstep, int m);

extern int MakeWsubFormHTML(int no, int xcol,int rows,int fx ,int fy,int grid_sx,int grid_sy,int grid_ex,int grid_ey,int *cell_length,int *cell_align,int *cell_action,int *grid_field,int *grid_skipstep,char **grId_titles,int m);

extern char *decodeUTF(char *query);

#endif
