# Send Japanese mail using Gmail SMTP server. You need tlsmail.
# $ sudo gem install tlsmail

require "rubygems"
require "tlsmail"
require "nkf"
require "net/smtp"

def sendmail(from, to, subject, body, user, pass, host = "smtp.gmail.com", port = 587)
  body = <<EOT
From: #{from}
To: #{to.to_a.join(",\n ")}
Subject: #{NKF.nkf("-WMm0", subject)}
Date: #{Time::now.strftime("%a, %d %b %Y %X %z")}
Mime-Version: 1.0
Content-Type: text/plain; charset=ISO-2022-JP
Content-Transfer-Encoding: 7bit

#{NKF.nkf("-Wjm0", body)}
EOT

  Net::SMTP.enable_tls(OpenSSL::SSL::VERIFY_NONE)
  Net::SMTP.start(host, port, "localhost.localdomain", user, pass, "plain") do |smtp|
    smtp.send_mail body, from, to
  end
end
