#!/bin/ksh
#
#	GET.KSH
#	All Rights Reserved 1991,92,99 (C)
#
#	GET(21)                  ソースファイルの呼出
#
#
#	名前
#	　　get.ksh
#
#	使用法
#	　　get (source-file-name) (user-name) (version-number)
#
#	概要
#	　　　get はソースコードに修正を加えるときに限って使用します。getを使用す
#	　　るときは、細心の注意を払って行なってください。
#	　　　get が使用するパラメータには、呼び出すソースファイル名、修正者名、
#	　　バージョン番号があります。どれかが抜けていても  get は動作を行ないま
#	　　せん。
#	　　　呼び出すソースファイル名は listfile コマンドで調べます。修正者名は
#	　　ＣＭＳ管理者から与えられた、英語小文字８文字以内の名前となります。 　
#	　　　現在ＣＭＳではバージョンを10バージョンまで、リビジョンを０〜９９ま
#	　　で登録可能になっていますので、それを念頭に使用してください。
#		また、この get.ksh コマンドのみ外部ユーザ /home/user-name から利用可能
#		となっています。但し、/cms/musr への登録ユーザのみになります。
#		外部から CMS 内部ファイルへのアクセス時必要な環境変数は以下になります。
#
#		CMS_SYSNAME=system-name
#
#		CMS_TABFILE=table-file-name
#
#		CMS_USERNAME=user-name
#
#		CMS_VERSION=version-number
#
#
#	関連項目
#	　　make(1) Makefile(1)
#	　　put(21) vget(21) mr(21) report(21) listfile(21) verlock(21)

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: get (source-file) (user) (version(0 - 9))";exit ;;
esac


File=$1
User=$2
Version=$3
Source=${CMSPATH}/src/${SYSNAME}
GetLog=${CMSPATH}/diff/log/getlog
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Userfile=${CMSPATH}/diff/userfile
Target=`grep "^${File}" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`

LockDir=`echo "${File}" | sed -f ${CMSPATH}/bin/suffixes.sed`
VerTail=`tail -1 ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} 2>/dev/null`
GET_UPDATE=`date '+%Y.%m.%d,%H:%M'` 

if [ x$SYSNAME = x"" ]
then
	exit
fi

grep -l "^$1" ${Tabfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$1 は見つかりませんでした"
	exit
fi
grep -l "$2" ${Userfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$2 はＣＭＳにユーザ登録されていません"
	exit
fi

if [ ! -d ${DiffDir}/lock/${SYSNAME}/${LockDir} ]
then
	errmsg "CMS がディレクトリ lock/ を作成してありません"
	exit
fi

Mdir=`basename ${PWD}`
trap 'chmod 660 ${Source}/${TABFILE}/${file};exit 0' 1 2 3 4 5 6 7 8 9 15
if [ -f $File ]
then
	errmsg "$File が存在します"
	exit
fi

#dialogmsg "最新版の ${File} を呼び出し中"

if [ ! -f ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} ]
then
echo "${Version}.00" > ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version}
fi
grep -l "${Version}.00" ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} > /dev/null
if [ x"$?" = x"1" ]
then
	echo "${Version}.00" >> ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version}
fi

if [ -f ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version} ]
then
	grep -l "lock" ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version} > /dev/null
	if [ $? = 0 ]
	then
		op=`grep ${File} ${DiffDir}/log/getlog.${Version} | tail -1 | awk 'BEGIN {FS=";"}{print $1,"が",$5}'`
		errmsg "${File} は ${op} に get しています"
		exit
	fi

	grep -l "^submit" ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version} > /dev/null
	if [ $? = 0 ]
	then
		op=`grep ${File} ${DiffDir}/log/getlog.${Version} | tail -1 | awk 'BEGIN {FS=";"}{print $1,"が",$5}'`
		errmsg "${File} は ${op} に SUBMIT（修正完了通知） しています"
		exit
	fi

	grep -l "^commit" ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version} > /dev/null
	if [ $? = 0 ]
	then
		op=`grep ${File} ${DiffDir}/log/getlog.${Version} | tail -1 | awk 'BEGIN {FS=";"}{print $1,"が",$5}'`
		errmsg "${File} は ${op} に COMMIT（バージョン終了） しています"
		exit
	fi
fi

echo ${HOME} | grep "/home/cms" > /dev/null
if [ $? = 0 ]
then

GetFile=`grep "^${File}$" ${Tabfile}`
BaseDir=`basename ${PWD}`
${CMSPATH}/bin/verlock.ksh -l ${File} ${Version}
cp -p ${Source}/${GetFile} ${GetFile}
chmod 440 ${Source}/${GetFile} > /dev/null
${CMSPATH}/bin/verlock.ksh -l ${File} ${Version}
chmod 660 ${File} > /dev/null

GET_TMP=get_tmp$$.tmp

X=$Version
Y=`echo ${VerTail} | sed 's/\.[0-9].*$//'`
Z=`echo ${VerTail} | sed -e 's/^[0-9]\.//' -e 's/[0-9]/&./'`

grep -l "^#pragma ident \"@(#)" ${File} > /dev/null
if [ $? = 1 ]
then
	HEADER="#pragma ident \"@(#) ${File} ${Y}.${Z} ${GET_UPDATE}\""
	echo  ${HEADER} > ${GET_TMP}
	cat ${File} >> ${GET_TMP}
	mv -f ${GET_TMP} ${File}
else
sFile=`basename ${File}`
	sed 's/^#pragma ident \"\@(#).*\".*/#pragma ident \"\@(#) '${sFile}' '${Y}'\.'${Z}' '${GET_UPDATE}'\"/g' ${File} > ${GET_TMP} 
	mv -f ${GET_TMP} ${File}
fi

echo "${CMS_LOGNAME};${User};${File};${Version};${GET_UPDATE};GET" >> ${GetLog}.${Version}
#${CMSPATH}/bin/mkver.ksh -p ${File} ${Version}

else
	if [ ${User} != ${USER} ]
	then
		errmsg "${User} が違っています。"
		exit
	fi

	GetLog=${CMSPATH}/diff/log/external-getlog

	GetFile=`grep "^${File}$" ${Tabfile}`
	BaseDir=`basename ${PWD}`
	cp -p ${Source}/${GetFile} . 2> /dev/null
	
	if [ ! -f ${Getfile} ]
	then
		GET_TMP=get_tmp$$.tmp
	
		X=$Version
		Y=`echo ${VerTail} | sed 's/\.[0-9].*$//'`
		Z=`echo ${VerTail} | sed -e 's/^[0-9]\.//' -e 's/[0-9]/&./'`
	
		grep -l "^#pragma ident \"@(#)" ${File} > /dev/null
		if [ $? = 1 ]
		then
			HEADER="#pragma ident \"@(#) ${File} ${Y}.${Z} ${GET_UPDATE}\""
			echo  ${HEADER} > ${GET_TMP}
			cat ${File} >> ${GET_TMP}
			mv -f ${GET_TMP} ${File}
		else
		sFile=`basename ${File}`
			sed 's/^#pragma ident \"\@(#).*\".*/#pragma ident \"\@(#) '${sFile}' '${Y}'\.'${Z}' '${GET_UPDATE}'\"/g' ${File} > ${GET_TMP} 
			mv -f ${GET_TMP} ${File}
		fi
		echo "${CMS_LOGNAME};${User};${File};${Version};${GET_UPDATE};GET" >> ${GetLog}.${Version}
	fi

fi
