#!/bin/ksh
#
#	MKVER.KSH
#	All Rights Reserved 1992,99 (C)
#

export PATH=".:$PATH:${CMSPATH}/bin"

DiffDir=${CMSPATH}/diff
LockFile=${CMSPATH}/diff/lockfile
SysName=${SYSNAME}

case $# in
3) ;;
*) errmsg "Usage: -a -p file-name [ 0 - 9]";exit ;;
esac

case $1 in
-a) flag=apend;;
-p) flag=print;;
*) errmsg "Usage: -a -p file-name [ 0 - 9 ]"; exit;;
esac

File=$2
Ffile=`echo $2 | sed -f ${CMSPATH}/bin/suffixes.sed`

case $3 in
0) Version=0 ;;
1) Version=1 ;;
2) Version=2 ;;
3) Version=3 ;;
4) Version=4 ;;
5) Version=5 ;;
6) Version=6 ;;
7) Version=7 ;;
8) Version=8 ;;
9) Version=9 ;;
*) exit ;;
esac

case $Version in
0) Fver=0; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile0;;
1) Fver=1; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile1;;
2) Fver=2; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile2;;
3) Fver=3; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile3;;
4) Fver=4; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile4;;
5) Fver=5; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile5;;
6) Fver=6; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile6;;
7) Fver=7; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile7;;
8) Fver=8; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile8;;
9) Fver=9; LockFile=${CMSPATH}/diff/lock/${SysName}/${Ffile}/lkfile9;;
*) Fver="";exit ;;
esac

if [ x"${flag}" = x"apend" ]
then
	grep -l lock ${LockFile} > /dev/null
	if [ $? = 0 ]
	then
		errmsg "${File} Version ${Fver} は差分をとるためロックされてます．"
		exit
	else
		dialogmsg "mkver.ksh 実行中"
		sleep 1
	fi
fi

if [ ! -f ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Fver} ]
then
	echo "${Version}.00" > ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Fver}
fi

verno=`tail -1 ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Fver}`

typeset -i i j
for i in 0 1 2 3 4 5 6 7 8 9
do
	for j in 0 1 2 3 4 5 6 7 8 9
	do
		if [ x${Fver}.${i}${j} = x"$verno" -a x${flag} = x"apend" ]
		then
			dialogmsg "${File}: Old Version - ${Fver}.${i}${j}"
			sleep 1
			case $j in
			9) let i=i+1;j=0 ;;
			*) let j=j+1 ;; 
			esac
			echo "${Fver}.${i}${j}" >> ${DiffDir}/lock/${SysName}/${Ffile}/verfile.${Fver}
			dialogmsg "${File}: New Version - ${Fver}.${i}${j}"
			sleep 1
			#echo "\033[2J"
			exit
		fi
		if [ x${Fver}.${i}${j} = x"$verno" -a x${flag} = x"print" ]
		then
			dialogmsg "${File}: Current Version - ${Fver}.${i}${j}"
			sleep 1
			exit
		fi
	done
done
