#!/bin/ksh
#
#	MREDIT.KSH
#	All Rights Reserved 1992 (C)
#
#	MREDIT(21)               ＭＲファイルの編集
#
#
#	名前
#
#	　　mredit.ksh
#
#	使用法
#
#	　　mredit (MR-number) (user-name) (version-number)
#
#
#	概要
#
#	　　　mredit　は環境変数 EDITOR を参照して EDITOR の内容のエディタを呼び
#	　　出します。
#	　　　エディタには vi か ed を選ぶことが出来ます。mrの呼び出すファ
#	　　イルにはあらかじめ問題処理用のフォーマットが組んであり、統一して記述
#	　　することが出来ます。
#
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) listfile(21) get(21) report(21) verlock(21) mr(21)

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: mr MR-number(001 - 999) (user-name) Version(0 - 9)";exit;;
esac 
MainDir=${CMSPATH}
DiffDir=${CMSPATH}/diff
MrDir=${CMSPATH}/diff/mr
MrFile=mr
SysName=${SYSNAME}
EditCommand=$EDITOR
CurentDir=`basename ${PWD}`
MrNumber=$1
UserName=$2
Version=$3

if [ ! -f ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber} ]
then
	errmsg "MR Number: ${Version}.${MrNumber} は見つかりませんでした"
	exit
fi

if [ x"$EditCommand" = x"" ]
then
	EditCommand=vi
fi
OWD=${PWD}
#cd ${MrDir}

${EditCommand} ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber}


#inpmsg2 "２５５文字以内で入力してください" op
#echo $op > ${MrDir}/ver_${Version}/${SysName}/${MrFile}.${MrNumber}

#cd ${OWD}
