#!/bin/ksh
#
#	PUT.KSH
#	All Rights Reserved 1990,91,92,99 (C)
#
#	PUT(21)                  ソースファイルの登録
#
#
#	名前
#
#	　　put.ksh
#
#	使用法
#
#	　　put (source-file-name) (user-name) (version-number)
#
#	概要
#
#	　　　put は getによって呼ばれたファイルのソースコードに修正を加え、コン
#	　　パイルを行なう前に使用します。put を使用することによってｍａｋｅは、
#	　　オブジェクトファイルとソースファイルの依存関係を調査します。
#	　　ソースファイルに修正が加えられなくても putを使用することによって、そ
#	　　のファイル自身へのコンパイルは必ず行なわれます。put によって登録した
#	　　ソースファイルへの修正を中止するとき、または差分の削除を行なうには、
#	　　rejectコマンドのみを使用してください。
#	　　　put が使用するパラメータには、修正したソースファイル名、修正者名、
#	　　バージョン番号があります。どれかが抜けていても  put は正しい動作を行
#	　　ないません。
#	　　　呼び出したソースファイル名は勝手に変更してはいけません。変更する場
#	　　合及び、新規にファイルを登録する時は、newfile コマンドを使用し、ｍａ
#	    ｋｅｆｉｌｅの修正も行なわなければなりません。又、修正登録するとき、
#	    登録修正者名はＣＭＳ管理者から与えられた、英語小文字８文字以内の名前
#	    となります。
#	　　　ＭＲ番号の登録を行なっていない場合でも、put は使用可能です。Ｍａｋ
#	　　ｅｆｉｌｅは putによる修正登録をすると、ソースファイルはカレントディ
#	　　レクトリに存在しなくなる為、コンパイルが出来なくなるので、 putによる
#	　　登録は最も最後にすることを勧めます。
#	　　　put はファイルの修正登録時同時にバージョン毎にリビジョン、及び修正
#	　　者の情報を記録します。それぞれのバージョン及び、リビジョンの記録は
#	　　reportコマンドによって確認することが出来ます。各バージョン及びリビジョ
#	　　ンの取り出しには、vgetコマンドを使用します。
#	　　　現在ＣＭＳではバージョンを10バージョンまで、リビジョンを０〜９９ま
#	　　で登録可能になっていますので、それを念頭に使用してください。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　get(21) vget(21) mr(21) report(21) reject(21) regist(21)

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: put (source-file) (user) (version(0 - 9))";exit;;
esac
case ${SYSNAME} in
"") errmsg "canot find system name form CMS environment."; exit ;;
esac

BaseDir=`basename ${PWD}`
File=$1
User=$2
Version=$3
MainSource=${CMSPATH}/siten
Source=${CMSPATH}/src/${SYSNAME}
PutLog=${CMSPATH}/diff/log/putlog
Pmake=${CMSPATH}/fusr/${SYSNAME}
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Okyatab=${CMSPATH}/diff/okyatab
Userfile=${CMSPATH}/diff/userfile
Target=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed 2> /dev/null`
LockDir=`echo "${File}" | sed -f ${CMSPATH}/bin/suffixes.sed 2> /dev/null`
VerTail=`tail -1 ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} 2>/dev/null`
PUT_UPDATE=`date '+%Y/%m/%d,%H:%M'` 

if [ x$SYSNAME = x"" ]
then
	errmsg "システム名が決定していません"
	exit
fi
grep -l "^$1$" ${Tabfile} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$1 はテーブルに登録されていません"
	exit
fi
if [ x${Target} = x"" ]
then
	errmsg "ターゲットのファイルが見つかりません"
	exit
fi
grep -l "$2" ${Userfile} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$2 は登録されたユーザではありません"
	exit
fi
if [ ! -d ${DiffDir}/lock/${SYSNAME}/${LockDir} ]
then
	errmsg "排他制御用のディレクトリがありません。"
	exit
fi
if [ x${BaseDir} = x${SYSNAME} ]
then
	popmsg "PUT を実行します (Y or N)"
	if [ $? = 0 ]
	then
		exit
	fi
fi

if [ ! -d ${DiffDir}/ver_${KEIVER}/${SYSNAME}/${Target} ]
then
	mkdir2 ${DiffDir}/ver_${KEIVER}/${SYSNAME}/${Target}
fi

Tree=`grep "^${File}$" ${Tabfile}`
Ftree=`grep "^${File}$" ${Tabfile}`
trap 'chmod 440 ${Source}/${Tree};exit'1 2 3 4 5 6 7 8 9 15
if [ ! -f $File ]
then
	errmsg "$File は存在しません"
	exit
fi
diff -I "^#pragma ident" $File ${Source}/${Tree} 2> /dev/null 1> /dev/null
if [ $? = 0 ]
then
	errmsg "$File は変更されていません。PUT は行いません"
	exit 2
fi

dialogmsg "put 実行中"
sleep 1

${CMSPATH}/bin/verlock.ksh -r ${File} ${Version}
${CMSPATH}/bin/mkver.ksh -a ${File} ${Version}

VerTail=`tail -1 ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} 2>/dev/null`
if [ x${VerTail} = x"1.01" ]
then
comment.ksh "1" ${File} ${Version}
chmod 660 ${MainSource}/${SYSNAME}/${Tree} 2> /dev/null
ed ${MainSource}/${SYSNAME}/${Tree} <<!
.
w
!
chmod 440 ${MainSource}/${SYSNAME}/${Tree} 2> /dev/null
fi

chmod 660 ${Source}/${Tree} 2> /dev/null
CurentDir=`basename ${PWD}`
if [ x${CurentDir} = x${SYSNAME} ]
then
	cp -p ${Pmake}/${Tree} ${Source}/${Ftree}
else
	errmsg "システム正規のディレクトリではありません。"
	cp -p ${File} ${Source}/${Ftree}

fi
echo  "New-changes	${PUT_UPDATE}	${File}	${User}	${CMS_LOGNAME}" \
> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}
cat ${DiffDir}/catlog >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}
errmsg 修正内容を記録してください。
vi ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}

diff -e -I "^#pragma ident" ${MainSource}/${SYSNAME}/${Tree} ${File} \
> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/${VerTail}
echo "." >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/${VerTail}
echo "w" >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/${VerTail}
rm -f ${File}
${CMSPATH}/bin/mkver.ksh -p ${File} ${Version}
echo "" > ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version}
${CMSPATH}/bin/verlock.ksh -r ${File} ${Version}

echo "${CMS_LOGNAME};${User};${File};${Version}.${VerTail};${PUT_UPDATE};PUT" >> ${PutLog}.${Version}
