#!/bin/ksh
#
#	VGET.KSH
#	All Rights Reserved 1999 (C)
#
#	PUTLOG(21)     　          ログファイルの編集
#
#
#	名前
#	　　putlog.ksh
#
#	使用法
#	　　putlog (file-name) (user-name) (version-number) (revision-number)
#
#	概要
#	　　putlog は過去の put 実行時の修正記録を編集します。
#
#
#	関連項目
#	　　make(1) Makefile(1)
#	　　put(21) get(21) mr(21)

#echo $TABFILE
export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
4) ;;
*) errmsg "Usage: putlog (source-file) (user) version(0 - 9) revision(00-99)";exit;;
esac


File=$1
User=$2
Version=$3
Revision=$4
Source=${CMSPATH}/src
BaseSource=${CMSPATH}/siten
Make=${CMSPATH}
GetLog=${CMSPATH}/diff/log/getlog
DiffDir=${CMSPATH}/diff
Pmake=${CMSPATH}/${SYSNAME}
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Userfile=${CMSPATH}/diff/userfile
Ffile=`echo ${File} | sed -f ${CMSPATH}/bin/suffixes.sed`
Tree=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`
Endfile=`grep "^${File}$" ${Tabfile}`

dialogmsg  "file=$1 user=$2 version=$3 revison=$4"
if [ x${SYSNAME} = x"" ]
then
	exit
fi

if [ x${Endfile} = x"" ]
then
	errmsg "テーブルファイルを見つけられません"
	exit
fi

grep -l "^$1$" ${Tabfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$1 がテーブルファイルの中にありません"
	exit
fi
grep -l "$2" ${Userfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$2 ＣＭＳユーザではありません"
	exit
fi

if [ ! -f ${DiffDir}/lock/${SYSNAME}/${Ffile}/verfile.${Version} ]
then
	errmsg "リビジョン番号ファイルがありません．"
	exit
fi
grep -l "${Version}.00" ${DiffDir}/lock/${SYSNAME}/${Ffile}/verfile.${Version} > /dev/null
if [ x"$?" = x"1" ]
then
	errmsg "${File}: に  ${Version}.${Revision} の差分の記録がありません．"
	exit
fi
echo ""

#chmod 660 ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree}/log_${Version}.${Revision} > /dev/null
if [ ! -f ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree}/log_${Version}.${Revision} ]
then
	errmsg "ログファイル log_${Version}.${Revision} がありません"
	exit
else
	vi +/^$/ ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree}/log_${Version}.${Revision}
fi

