#!/bin/ksh
#
#	SUBMIT.KSH
#	All Rights Reserved 1999 (C)
#
#	SUBMIT(21)             ソースファイルの修正完了登録
#
#
#	名前
#
#	　　submit.ksh
#
#	使用法
#
#	　　submit (source-file-name) (user-name) (version-number)
#
#	概要
#
#		submit は getによって呼ばれたファイルのソースコードに修正が完了し
#		た場合だけ使用します。
#		このときソースコードは最後の修正版だけが ~/cms/sub/ver_[ 1 -10 ] 
#		にコピーされます。
#		これ以降 get vget put コマンドは submit されたファイルに対して使用
#		不可になります。
#
#	関連項目
#
#	　　make(1) Makefile(1)
#	　　put(21) get(21) vget(21) mr(21) report(21) reject(21) regist(21)

export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
3) ;;
*) errmsg "Usage: submit (source-file) (user) (version(1 - 10))";exit;;
esac
case ${SYSNAME} in
"") errmsg "canot find system name form FMS environment."; exit ;;
esac

popmsg "SUBMIT を実行するとこれ以降 GET は出来なくなります (Y or N)"
case $? in
1) ;;
*) exit ;;
esac

BaseDir=`basename ${PWD}`
File=$1
User=$2
Version=$3
SubmitSource=${CMSPATH}/sub/ver_${Version}
MainSource=${CMSPATH}/siten
Source=${CMSPATH}/src/${SYSNAME}
Object=${CMSPATH}/obj/${SYSNAME}
SubmitLog=${CMSPATH}/diff/log/submitlog
Pmake=${CMSPATH}/fusr/${SYSNAME}
DiffDir=${CMSPATH}/diff
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Okyatab=${CMSPATH}/diff/okyatab
Userfile=${CMSPATH}/diff/userfile
Target=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed 2> /dev/null`
LockDir=`echo "${File}" | sed -f ${CMSPATH}/bin/suffixes.sed 2> /dev/null`
VerTail=`tail -1 ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} 2>/dev/null`
SUBMIT_UPDATE=`date '+%Y/%m/%d,%H:%M'` 

if [ x$SYSNAME = x"" ]
then
	exit
fi
grep -l "^$1$" ${Tabfile} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$1 はテーブルに登録されていません"
	exit
fi
if [ x${Target} = x"" ]
then
	errmsg "ターゲットのファイルが見つかりません"
	exit
fi
grep -l "$2" ${Userfile} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$2 は登録されたユーザではありません"
	exit
fi
if [ ! -d ${DiffDir}/lock/${SYSNAME}/${LockDir} ]
then
	errmsg "このファイルは CMS でロックされています"
	exit
fi

Tree=`grep "^${File}$" ${Tabfile}`
Ftree=`grep "^${File}$" ${Tabfile}`
trap 'chmod 440 ${Source}/${Tree};exit'1 2 3 4 5 6 7 8 9 15
if [ ! -f $File ]
then
	errmsg "$File は存在しません"
	exit
fi
diff -I "^#pragma ident" $File ${Source}/${Tree} 2> /dev/null 1> /dev/null
if [ $? = 1 ]
then
	errmsg "$File は変更されています。SUBMIT は行いません"
	exit 2
fi

if [ x${BaseDir} = x${SYSNAME} ]
then
	popmsg "SUBMIT を実行します (Y or N)"
	if [ $? = 0 ]
	then
		exit
	fi
else
	errmsg "SUBMIT を実行するディレクトリが正規ではありません"
	exit
fi

dialogmsg "SUBMIT 実行中"

${CMSPATH}/bin/verlock.ksh -r ${File} ${Version}
${CMSPATH}/bin/mkver.ksh -a ${File} ${Version}

VerTail=`tail -1 ${DiffDir}/lock/${SYSNAME}/${LockDir}/verfile.${Version} 2>/dev/null`
if [ x${VerTail} = x"1.01" ]
then
comment.ksh "1" ${File} ${Version}
chmod 640 ${MainSource}/${SYSNAME}/${Tree} 2> /dev/null
ed ${MainSource}/${SYSNAME}/${Tree} <<!
.
w
!
chmod 440 ${MainSource}/${SYSNAME}/${Tree} 2> /dev/null
fi

CurentDir=`basename ${PWD}`
chmod 640 ${Source}/${Tree} 2> /dev/null
if [ x${CurentDir} = x${SYSNAME} ]
then
	cp -p ${Pmake}/${Tree} ${Source}/${Ftree}
else
	cp -p ${Pmake}/${Tree} ${Source}/${Ftree}
fi
echo  "SUBMIT	${SUBMIT_UPDATE}	${File}	${User}	${CMS_LOGNAME}" \
> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}
cat ${DiffDir}/catlog >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}
errmsg 今回の変更概要を記録してください。
vi ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/log_${VerTail}

diff -e -I "^#pragma ident" ${MainSource}/${SYSNAME}/${Tree} ${File} \
> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/${VerTail}
echo "." >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/${VerTail}
echo "w" >> ${DiffDir}/ver_${Version}/${SYSNAME}/${Target}/${VerTail}
if [ -d ${SubmitSource}/${SYSNAME} ]
then
	cp -p ${File} ${SubmitSource}/${SYSNAME}
	chmod 640 ${SubmitSource}/${SYSNAME}/${File}
else
	mkdir ${SubmitSource}/${SYSNAME}
	cp -p ${File} ${SubmitSource}/${SYSNAME}
	chmod 640 ${SubmitSource}/${SYSNAME}/${File}
fi
rm -f ${File}
${CMSPATH}/bin/mkver.ksh -p ${File} ${Version}
echo "" > ${DiffDir}/lock/${SYSNAME}/${Target}/lkfile${Version}
${CMSPATH}/bin/verlock.ksh -s ${File} ${Version}

echo "${CMS_LOGNAME};${User};${File};${Version};${SUBMIT_UPDATE}SUBMIT" >> ${SubmitLog}.${Version}
