#!/bin/ksh
#
#	TABCHG.KSH
#

trap 'rm -f CMS.tabchg.1.$$ CMS.tabchg.2.$$;exit 0' 1 2 3 4 5 6 7 8 9 15

export PATH=".:$PATH:${CMSPATH}/bin"

Tabdir=${CMSPATH}/diff/tabs
Userdir=${CMSPATH}/fusr
File=$TABFILE
CurrentDir=`basename ${PWD}`
if [ ${Userdir}/${SYSNAME} != ${Userdir}/${CurrentDir} ]
then
	errmsg "${PWD} - カレントディレクトリが違います"
	exit
fi
if [ -f ${File} ]
then
	if [ -f ${Tabdir}/${File} ] 
	then
		sort $File > CMS.tabchg.1.$$
		sort ${Tabdir}/${File} > CMS.tabchg.2.$$
		cmp CMS.tabchg.1.$$ CMS.tabchg.2.$$ 2> /dev/null 1> /dev/null
		#cmp $File ${Tabdir}/${File} 2> /dev/null 1> /dev/null
		if [ $? = 0 ]
		then
			errmsg "${File} は変更されていません"
		else
			popmsg "コピーを実行します"
			if [ $? = 1 ]
			then
				cp -p ${File} ${CMSPATH}/diff/tabs
			fi
		fi
	else
		errmsg "${Tabdir}/${File} が見つかりません"
	fi
else
	errmsg "${File} が見つかりません"
fi

rm -f CMS.tabchg.1.$$ CMS.tabchg.2.$$
