#!/bin/ksh
#
#	VGET.KSH
#	All Rights Reserved 1992,99 (C)
#
#	VGET(21)     　          バージョン及びリビジョンの呼出
#
#
#	名前
#	　　vget.ksh
#
#	使用法
#	　　vget (file-name) (user-name) (version-number) (revision-number)
#
#	概要
#	　　vget は過去のバージョン及び、リビジョンを復活させる時に使用します。
#	　　vgetで呼び出したファイルはバージョンの基点 Ver1.0とvgetによって指定し
#	　　たバージョンとの差分を元に作成されています。vgetによって呼び出したファ
#	　　イルは rm コマンドによって削除してもかまいません。
#	　　　vgetはバージョン毎に何度でもファイルを呼び出すことが出来ます。
#
#
#	関連項目
#	　　make(1) Makefile(1)
#	　　put(21) get(21) mr(21) report(21) listfile(21) verlock(21)

#echo $TABFILE
export PATH=".:$PATH:${CMSPATH}/bin"

case $# in
4) ;;
*) errmsg "Usage: vget (source-file) (user) version(1 - 10) revision(00-99)";exit;;
esac


File=$1
User=$2
Version=$3
Revision=$4
Source=${CMSPATH}/src
BaseSource=${CMSPATH}/siten
Make=${CMSPATH}
GetLog=${CMSPATH}/diff/log/getlog
DiffDir=${CMSPATH}/diff
Pmake=${CMSPATH}/${SYSNAME}
Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
Userfile=${CMSPATH}/diff/userfile
Ffile=`echo ${File} | sed -f ${CMSPATH}/bin/suffixes.sed`
Tree=`grep "^${File}$" ${Tabfile} | sed -f ${CMSPATH}/bin/suffixes.sed`
Endfile=`grep "^${File}$" ${Tabfile}`
VGET_UPDATE=`date '+%Y/%m/%d,%H:%M'` 

#dialogmsg  "file=$1 user=$2 version=$3 revison=$4"
if [ x${SYSNAME} = x"" ]
then
	exit
fi

if [ x${Endfile} = x"" ]
then
	errmsg "テーブルファイルを見つけられません"
	exit
fi

grep -l "^$1$" ${Tabfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$1 がテーブルファイルの中にありません"
	exit
fi
grep -l "$2" ${Userfile} > /dev/null
if [ $? = 1 ]
then
	errmsg "$2 ＣＭＳユーザではありません"
	exit
fi
grep -l "submit" ${DiffDir}/lock/${SYSNAME}/${Tree}/lkfile${Version} > /dev/null
if [ $? = 0 ]
then
	op=`grep ${File} ${DiffDir}/log/getlog.${Version} | tail -1 | awk 'BEGIN {FS=";"}{print $1,"が",$4}'`
	errmsg "${File} は ${op} が submit（修正完了） しています"
	exit
fi

trap 'chmod 660 ${Source}/kei1/${file};exit 0' 1 2 3 4 5 6 7 8 9 15
if [ -f ${File} ]
then
	errmsg "${File} がカレントディレクトリにあります"
	exit
fi

if [ ! -f ${DiffDir}/lock/${SYSNAME}/${Ffile}/verfile.${Version} ]
then
	errmsg "差分を記録したファイルがありません．"
	exit
fi
grep -l "${Version}.00" ${DiffDir}/lock/${SYSNAME}/${Ffile}/verfile.${Version} > /dev/null
if [ x"$?" = x"1" ]
then
	errmsg "${File}: Version  ${Version}.${Revision} の差分の記録がありません．"
	exit
fi
echo ""

${CMSPATH}/bin/verlock.ksh -r ${File} ${Version}
cp -p ${BaseSource}/${SYSNAME}/${Endfile} ${Endfile}
chmod 660 ${File} > /dev/null
if [ ! -f ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree}/${Version}.${Revision} ]
then
	errmsg "リビジョンファイル ${Version}.${Revision} がありません"
	rm -i ${File}
	exit
fi
if [ -f "${File}_${Version}.${Revision}" ]
then
	errmsg "カレントディレクトリに ${Version}.${Revision} が存在します。"
	exit
fi
trap 'rm -f ${Version}.${Revision};exit 0' 1 2 3 4 5 6 7 8 9 15

dialogmsg  "VGET $1 - $3.$4 呼び出し中"

cp -p ${DiffDir}/ver_${Version}/${SYSNAME}/${Tree}/${Version}.${Revision} .
ed ${File} < ${Version}.${Revision} > /dev/null
echo "${CMS_LOGNAME};${User};${File};${Version}.${Revision};${VGET_UPDATE};VGET;${PWD}" >> ${GetLog}.${Version}
popmsg "修正差分ファイルを呼び出しますか？ (Y or N)"
case $? in
1)
	mv -f ${Version}.${Revision} "${File}_${Version}.${Revision}"
	;;
*)
	rm -f ${Version}.${Revision}
;;
esac

