#pragma ident "@(#) minifiler.cc 1.0.9 2010.05.24,10:34"
#include "ftx.h"
#include "filer.h"

#define ON 1
#define OFF 0
#define MAX_WINDOW 1

extern ListBox *pFilerListBox;	//ファイラーのためのリストボックスクラス

//ウインドウ１と２のカラム位置
static int line1[] = {0,33,44,56,68,79,89};
//ウインドウ３と４のカラム位置*/
static int line2[] = {0,12,24,36,48,52,54,54,54,54};

static char helpbuff[22][128] =
	{" H  このヘルプを表示                i  ひとつ上へ",
	" v  ファイルを表示                  ",
	" e  ファイルを編集                  S  画面の更新",
	" f  EUC -> SHIFT-JIS                 vi の実行",
	" TABキーでファイルを選択            ",
	" p  ファイルを送信                  t  画面の先頭へ",
	"  選択ファイルの送信              g  最後尾に",
	" m  ディレクトリを作成              !  シェルモードに",
	" r  ディレクトリを削除              2  アクセス時刻表示",
	"  ファイルを削除                  9  作成年月表示",
	" c  ディレクトリを移動              0  作成時刻表示",
	"  移動ディレクトリ入力            1  メニュー表示切替",
	" F  SHIFT-JIS -> EUC                u  半画面上に",
	" M  ファイル移動/名前変更           d  半画面下に",
	"                                    j  一行下に",
	"  属性を変更                      k  一行上に",
	"  MiniFiler を起動した場所に      G  画面最後尾に",
	"^H  $HOME に戻る                    :  .ファイルの非表示",
	" -  以前に移動した場所に移動         ブックマークに位置を保存",
	" +  以前に移動した場所から移動      ~ ブックマークメニューを開く",
	" n  検索を開始。入力は '/' で        でtar.gz 圧縮 T で解凍"
	};

static void helpmsg(int x,int y)
{
	WINDOW *pvs;
	int ch;
	int i;
	pvs = newwin(23,78,y,x);
	wattron(pvs,A_REVERSE);
	box(pvs,' ',' ');
	wattroff(pvs,A_REVERSE);

//	wattron(pvs,A_REVERSE);
//	wattroff(pvs,A_REVERSE);
	mvwprintw(pvs,0,0,"+");
	mvwprintw(pvs,0,71,"+");
	mvwprintw(pvs,22,0,"+");
	mvwprintw(pvs,22,71,"+");

	noecho();
	for(i=0;i<22;i++)
		mvwprintw(pvs,i+1,1,"%-78s",helpbuff[i]);
	wrefresh(pvs);
	wgetch(pvs);
	delwin(pvs);
}

int LocalFiler::minifiler(int start,int end)
{
	int i,j;
	int ch,ch2;
	int x,y;
	int yy = 5;
	char buff[512],cwdpath[512],cwdpath2[512];
	char tmpbuff[512];
	WINDOW *evs;
	char *vp,*sp;
	char filebuff[512];
	char findstr[512];
	int findf = 0;
	int fcount = 0;
	int dflag = 1;

	char ftmp[256];
	char ftmp2[256];

	char *cret;

	static int deep = 0;

	//FTXのためのコマンド用
	char strCommand[256];
	char attrbuff[256];

	signal(SIGINT,SIG_IGN);

	if((vp = getenv("HOME")) == NULL)
	{
		sys_errmsg(4,10,"環境変数 HOME が設定されていません /home を使用します");
		sprintf(homedirname,"/home");
	}
	else
	{
		sprintf(homedirname,"%s",vp);
	}
	max_lines = LINES;

	bookmark();
	readowner();
	readgroup();
	cret = getcwd(startdirname,256);

	fmode = 'm';
	dmode = 'v';	/* 'v'と 'h' .の付いたファイルの表示非表示を切替える */
	pathisto = 0;
	pathcnt = 0;
	botom = 2;

	tabselectclear();

	noecho();
	cbreak();

	evs = newwin(1,COLS,LINES-1,0);

	max_lines = LINES;
	pt[0].vs = newwin(max_lines - (botom),80,1,0);

	set_screen(0);
	displaymenu1(evs,dflag);

	x = 1;
	y = 0;

	y = 0;
	yy = 5;

	dirlocateclear();

	cret = getcwd(cwdpath,512);
	sprintf(dirstack[0],"%s",cwdpath);
	pathisto++;
	pathcnt++;
	if (COLS > 89)
	{
		if(strlen(cwdpath) > (size_t)72)
		{
			sprintf(cwdpath2,"Path=...%-69s%4d files",right2(cwdpath,69),file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
		}
	}
	else
	{
		if(strlen(cwdpath) > (size_t)62)
		{
			sprintf(cwdpath2,"Path=...%-59s%4d files",right2(cwdpath,59),file_num);
			sprintf(tmpbuff,"%s",cwdpath2);
		}
		else
		{
			sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
		}
	}
	vs_print(tmpbuff,pt[0].vs,line1[0]+1,1);
	initbuff();

	dirprint_all(".",fmode);
	while(1)
	{
		set_screen_line2(0);

		datadisp(0,x,y,5);

		/*
		ウインドウの枠を表示する
		*/
		wattron(pt[0].vs,A_REVERSE);
		box(pt[0].vs,' ',' ');
		wattroff(pt[0].vs,A_REVERSE);
		if((vp = getenv("CMS_USERNAME")) == NULL)
		{
			sprintf(tmpbuff,"%-50sMiniFiler v1.02 (c)S.Ono#",getenv("LOGNAME"));
		}
		else
		{
			if((sp = getenv("LOGNAME")) == NULL)
				sprintf(tmpbuff,"%-16s- %-35sMiniFiler v1.02 (c)S.Ono#",vp,"no-login");
			else
				sprintf(tmpbuff,"%-16s- %-35sMiniFiler v1.02 (c)S.Ono#",vp,sp);
		}
		wattron(pt[0].vs,A_REVERSE);
		mvwprintw(pt[0].vs,0,1,tmpbuff);
		wattroff(pt[0].vs,A_REVERSE);

		rectang(0);
		cret = getcwd(cwdpath,512);

		if (COLS > 89)
		{
			if(strlen(cwdpath) > (size_t)72)
			{
				sprintf(cwdpath2,"Path=...%-59s%4d files",right2(cwdpath,59),file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
				sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
			}
		}
		else
		{
			if(strlen(cwdpath) > (size_t)62)
			{
				sprintf(cwdpath2,"Path=...%-59s%4d files",right2(cwdpath,59),file_num);
				sprintf(tmpbuff,"%s",cwdpath2);
			}
			else
			{
				sprintf(tmpbuff,"Path=%-62s%4d files",cwdpath,file_num);
			}
		}
		vs_print(tmpbuff,pt[0].vs,line1[0]+1,1);

		wmove(pt[0].vs,y,1);
		wattron(pt[0].vs,A_REVERSE);
		sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
		vs_print(filebuff,pt[0].vs,line1[0]+2,yy);

		sprintf(filebuff,"-30s"," ");
		wattroff(pt[0].vs,A_REVERSE);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[0].vs,line1[0]+1,yy);

		wrefresh(pt[0].vs);

		/*
		シンボリックリンクを表示
		*/
		memset(ftmp,'\0',256);
		if((readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
		{
			sprintf(ftmp2,"%s->%s",fs[y+(yy-5)].buff1,ftmp);
			if(yy < 10)
				dialogmsg2(30, yy + 2,ftmp2,"シンボリックリンクされています。");
			else
				dialogmsg2(30, yy - 4,ftmp2,"シンボリックリンクされています。");
		}

		/*
		コマンド操作
		*/
		ch = wgetch(pt[0].vs);

		wattron(pt[0].vs,A_REVERSE);
		sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
		vs_print(filebuff,pt[1].vs,line1[0]+2,yy);
		wattroff(pt[0].vs,A_REVERSE);
		cls_all(0);

		if (regline[y+(yy-5)] == 1)
			vs_print("*",pt[0].vs,line1[0]+1,yy);

		/*
		選択したファイルのマークを表示する
		*/
		displaymenu1(evs,dflag);

		switch(ch)
		{
		/*
		カレントファイルのサーバー送信
		*/
		case 'p':
			memset(buff,'\0',sizeof(buff));
			sprintf(strCommand,"%s",fs[y+(yy-5)].buff1);
			sprintf(buff,"%s %s ",strCommand,"をサーバーに送信します。");
			if(popmsg(2+8,(LINES/2)-4,buff) == 1)
			{
				if(access(strCommand,R_OK))
				{
					pFilerListBox->MsgBox("送信するファイルがありません。");
					break;
				}
				pFilerListBox->intDoSTORCommand(strCommand, 1);

				memset(buff,'\0',sizeof(buff));
				stat(strCommand,fptr);
				pFilerListBox->attrview(fptr->st_mode,attrbuff);
				sprintf(buff,"%s",pFilerListBox->setChmod(attrbuff));
				pFilerListBox->strDoSITECommand("chmod",buff,strCommand);
			}
			cls_all(0);
			initbuff();
			dirprint_all(".",fmode);
				return(0);

		/*
		複数選択でのサーバー送信
		*/
		case '':
			sprintf(buff,"%s","選択したファイルをサーバーに送信します。");
			if(popmsg(2+8,(LINES/2)-4,buff) == 1)
			{
				for (j=0;j<file_num;j++)
				{
					if(regline[j] == 1)
					{
						memset(buff,'\0',sizeof(buff));
						sprintf(strCommand,"%s",fs[j].buff1);
						if(access(strCommand,R_OK))
						{
							pFilerListBox->MsgBox("送信するファイルがありません。");
							break;
						}
#ifdef SENDANS
						sprintf(buff,"%s をサーバーに送信します",strCommand);
						if(pFilerListBox->popmsg(0,0,buff) == 1)
						{
#endif
							pFilerListBox->intDoSTORCommand(strCommand, 1);
	
							stat(strCommand,fptr);
							pFilerListBox->attrview(fptr->st_mode,attrbuff);
							sprintf(buff,"%s",pFilerListBox->setChmod(attrbuff));
							pFilerListBox->strDoSITECommand("chmod",buff,strCommand);
#ifdef SENDANS
						}
#endif
					}
				}
			}
			tabselectclear();
			cls_all(0);
			initbuff();
			dirprint_all(".",fmode);
			return(0);

		case 'H':
		/*
		ミニファラーのヘルプメッセージを表示
		*/
			helpmsg(1,1);
			displaymenu1(evs,dflag);
			break;

		case '?':
		/*
		ヘルプメッセージを表示する
		*/
			helpmsg(1,1);
			displaymenu1(evs,dflag);
			break;

		/*
		現在のパスをブックマークとして保存
		*/
		case '':
			if(popmsg2(2+8,(LINES/2)-4,"カレントディレクトリをブックマークに保存しますか？") == 1)
			{
				sprintf(bookmarks[bookline],"%s",cwdpath);
				if(bookmarksave() == -1)
				{
					popmsg(2+8,(LINES/2)-4,"ブックマークを保存出来ません。");
				}
			}
			break;

		case '^':
		/*
		Hiddenファイル・ディレクトリを表示／非表示の切替え（デフォルト）
		*/
			command01(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case '~':
		/*
		ブックマークのディレクトリに移動する。
		*/
			command02(0,y,yy);
			dirprint_all(".", fmode);
			dirlocateclear();
			y = 0;
			yy = 5;
			break;

		case '0':
		/*
		ファイル・ディレクトリを作成した日付と時間で表示（デフォルト）
		*/
			command03(0);
			dirprint_all(".", fmode);
			break;

		case '2':
		/*
		ファイル・ディレクトリを最新アクセスした日付で表示
		*/
			command04(0);
			dirprint_all(".", fmode);
			break;

		case '9':
		/*
		ファイル・ディレクトリを作成した日付で表示
		*/
			command05(0);
			dirprint_all(".", fmode);
			break;

		/*
		ファイルの選択（マーク）
		*/
		case '\t':
			command06(0, y, yy);
			break;

		/*
		複数選択表示（less）
		*/
		case '':
			command07(0);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			box(pt[0].vs,ACS_VLINE,ACS_HLINE);
			rectang(0);
			goto allCLS2;

		/*
		複数選択移動
		*/
		case '':
			command29(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			goto allCLS2;

		/*
		複数選択削除（ファイルのみ）
		*/
		case '':
			ch2 = wgetch(pt[0].vs);
			switch(ch2)
			{
			case '':
				command08(0);
				dirprint_all(".", fmode);
				y = 0;
				yy = 5;
				goto allCLS2;

			default:
				break;
			}
			break;

		case 'T':
		/*
		tar -xzf fine-name を実行
		*/
			command09(0, y, yy);
			dirprint_all(".", fmode);
			break;

		case '':
		/*
		tar -czf fine-name を実行
		*/
			command10(0, y, yy);
			dirprint_all(".", fmode);
			break;

		case '':
		/*
		複数選択の tar -czf fine-name を実行
		*/
			command31(0, y, yy);
			dirprint_all(".", fmode);
			goto allCLS;

		case '/':
		/*
		ファイルを文字列で検索
		*/
			input_window(4,2,findstr,"検索名を入力");
			if(strlen(findstr) < (size_t)0)
				strcpy(findstr," ");

		case 'n':
		/*
		ファイルを文字列で再び検索
		*/
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y++;
			for(;y+(yy-5)<file_num;y++)
			{
				if(fcount > MAX_FILES)
					break;
				if((findf = findex(fs[y+(yy-5)].buff1, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました",findstr);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
				if(y+(yy-5) < file_num)
				{
					if(y >= MAX_FILES - max_lines)
					{
						y = MAX_FILES - max_lines;
					}
				}
				else
				{
					break;
				}
			}
			cls_all(0);

			//見つからなければ前にいた位置に戻る
			if(y > MAX_FILES || y >= file_num || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				dialogmsg(2,(LINES/2),"見つかりません");

				y = 0;
				yy = 5;
				cls_all(0);
				datadisp(0,x,y,5);
			//	wattroff(pt[0].vs,A_REVERSE);
				sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
				vs_print(filebuff,pt[0].vs,line1[0]+2,yy);
				break;
			}
			break;

		 case 'N':
			fcount = 0;
			if(strlen(findstr) < (size_t)1)
				break;
			y--;
			for(;y+(yy-5)>0;y--)
			{
				if(fcount > MAX_FILES)
					break;
				if((findf = findex(fs[y+(yy-5)].buff1, findstr)) != -1)
				{
					fcount = 0;
					sprintf(buff,"[%s] が見つかりました。y = %d,yy= %d",findstr,y,yy);
					dialogmsg(33,6,buff);
					break;
				}
				fcount++;
			}
			datadisp(0,x,y,5);
			cls_all(0);
			set_screen(0);

			if(y < 1 || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				y = 0;
				yy = 5;
				cls_all(0);
				set_screen(0);
				datadisp(0,x,y,5);
			//	wattroff(pt[0].vs,A_REVERSE);
				sprintf(filebuff,"%-42s",fs[y+(yy-5)].buff1);
				vs_print(filebuff,pt[0].vs,line1[0]+2,yy);
				break;
			}
			break;

		case '':
		/*
		ファイルの属性（モード）を変更
		*/
			command11(0, y, yy);
			dirprint_all(".", fmode);
			break;

		case '':
		/*
		CWを起動したディレクトリに戻る
		*/
			command12(0);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case '':
		/*
		環境変数 HOME に定義されたディレクトリに移動する
		*/
			command13(0);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			dirlocateclear();
			break;

		case 'f':
		/*
		ファイルのコードをＥＵＣコードに変換する
		*/
			command14(y, yy);
			break;

		case 'F':
		/*
		ファイルのコードをUTF-8コードに変換する
		*/
			command15(y, yy);
			break;

		case '':
		/*
		ファイルのコードをシフトJISコードに変換する
		*/
			command16(y, yy);
			break;

		case 'r':
		/*
		ディレクトリの削除
		*/
			if(command17(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case '':
		/*
		ファイル指定なしでｖｉエディタを起動する。
		*/
			command18(0);
			dirprint_all(".",fmode);
			wattron(pt[0].vs,A_REVERSE);
			box(pt[0].vs,' ',' ');
			wattroff(pt[0].vs,A_REVERSE);
			rectang(0);
			break;

		case 'e':
		/*
		ファイル指定でｖｉエディタを起動する。
		*/
			command19(0, y, yy);
			dirprint_all(".",fmode);
			wattron(pt[0].vs,A_REVERSE);
			box(pt[0].vs,' ',' ');
			wattroff(pt[0].vs,A_REVERSE);
			rectang(0);
			break;

#ifdef CYGWIN
		/*
		ファイル指定でWindows版 vimエディタを起動する。
		*/
		//	command20(0, y ,yy);
		case 'E':
			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
				break;
			system("clear");
			noraw();
			echo();
			nl();
			nocbreak();
			//2010.04.01 hosts.ftxの最初の行、つまりlocalhostのエディタに指定されたプログラムを起動する。(ファイル指定)
			sprintf(buff, "%s",pFilerListBox->pf[0].editor);
		//	sprintf(buff,"/cygdrive/c/vim/VIM32 %s",fs[y+(yy-5)].buff1);
			wrefresh(pt[0].vs);
			system(buff);

			wclear(pt[0].vs);
			set_screen(0);
			noecho();
			cbreak();
			dirprint_all(".",fmode);
			box(pt[0].vs,ACS_VLINE,ACS_HLINE);
			rectang(0);
			break;
#endif

		case '-':
		/*
		ディレクトリ移動の履歴を遡る
		*/
			command21(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case '+':
		/*
		ディレクトリ移動の履歴を戻る
		*/
			command22(0, y, yy);
			dirprint_all(".", fmode);
			y = 0;
			yy = 5;
			break;

		case 'c':
		/*
		ディレクトリを移動する。
		*/
			set_screen_line1(0);
			set_screen(0);


			stat(fs[y+(yy-5)].buff1,fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				cret = getcwd(ftmp,256);
				if(1 == 1)
				{
					memset(ftmp,'\0',256);
					
					if(deep < 0 || (readlink(fs[y+(yy-5)].buff1, ftmp, 256)) != -1)
					{
						deep = 0;
						goto skipdir;
					}
				}
				skipdir:

				if(chdir(fs[y+(yy-5)].buff1) == -1)
					break;
				sprintf(dirlocate[dirlocateyy[deep]], "%s",fs[y+(yy-5)].buff1);
				dirlocatey[deep] = y;
				dirlocateyy[deep] = yy;
				deep++;
				cret = getcwd(dirstack[pathcnt],512);
				if(pathcnt < 128)
					pathcnt++;
				if(pathisto < 128)
					pathisto++;
				checkhisto();

				tabselectclear();

				cls_all(0);
				initbuff();
				dirprint_all(".",fmode);
				y = 0;
				yy = 5;
			}
			break;
		case 'i':
		/*
		ディレクトリを上に移動する。
		*/
			set_screen(0);

			stat("..",fptr);
			if((fptr->st_mode & S_IFDIR) != 0)
			{
				if(chdir("..") == -1)
					break;
				cret = getcwd(dirstack[pathcnt],512);
				if(pathcnt < 128)
					pathcnt++;
				if(pathisto < 128)
					pathisto++;
				checkhisto();

				tabselectclear();

				cls_all(0);
				initbuff();
				dirprint_all(".",fmode);

				if(deep > 0)
				{
					deep--;
					y = dirlocatey[deep];
					yy = dirlocateyy[deep];
				}
				else
				{
					y = 0;
					yy = 5;
				}
			}
			break;

		case 'v':
		/*
		ファイルビューアを起動する。
		*/
			command25(0, y, yy);
			break;

		case '':
		/*
		ファイルを削除する。
		*/
			if(command26(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case 'M':
		/*
		ファイルを移動または名前を変更する。
		*/
			if(command27(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}

			break;

		case '!':
		/*
		シェルモードへ移行
		*/
			command32(0);
			dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			break;

		case 'm':
		/*
		ディレクトリを作成する
		*/
			if(command33(0) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case 'O':
		/*
		入力でディレクトリを移動する
		*/
			if(command34(0) != 0)
			{
				dirprint_all(".",fmode);
				y = 0;
				yy = 0;
			}
			break;

		case '':
		/*
		コマンド入力でプログラムの実行
		*/
			command35(0);
			dirprint_all(".",fmode);
			break;

		case 'x':
		/*
		ファイルを実行する（コマンド実行 fork()使用）。
		*/
			if(command36(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		case 's':
		/*
		シンボリックリンクの作成
		*/
			if(command37(0, y, yy) != 0)
			{
				dirprint_all(".",fmode);
			}
			break;

		/*
		ＭＡＫＥコマンドを実行
		*/
		case '':
			command38(0, y, yy);
			dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			wclear(pt[0].vs);
			set_screen(0);
			break;

		/*
		ＭＡＫＥコマンド（引数付き）を実行
		*/
		case ']':
			command39(0, y, yy);
			dirprint_all(".",fmode);
			y = 0;
			yy = 5;
			wclear(pt[0].vs);
			set_screen(0);
			break;

		case '1':
		/*
		メニューバーを切り替える
		*/
			if(dflag == 1)
				dflag = 0;
			else
				dflag = 1;
			displaymenu1(evs,dflag);
			break;

		case 'g':
		/*
		ファイル列の最後を表示
		*/
			if(y > (file_num - (max_lines - 7)))
			{
				yy = max_lines - ((max_lines - 4) - (file_num));
			}
			if(file_num > (max_lines - 8))
			{
				y = file_num - (max_lines - 8);
				yy = max_lines - 4;
			}
			cls_all(0);
			break;

		case 'G':
		/*
		ファイル列の最後を表示
		*/
			if(y > (file_num - (max_lines - 7)))
				break;
			if(file_num > (max_lines - 7))
				y = file_num - (max_lines - 8);
			cls_all(0);
			break;
		/*
		ファイル画面トップに
		*/
		case 't':
			y = 0;
			yy = 5;
			cls_all(0);

			datadisp(0,x,y,5);
		//	wattroff(pt[0].vs,A_REVERSE);
			sprintf(filebuff,"%-30s",fs[y+(yy-5)].buff1);
			vs_print(filebuff,pt[0].vs,line1[0]+2,yy);
			break;

		case 'U':
			if(yy > 5)
			{
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				yy--;
				if (yy == 5)
					break;
				break;
			}

			y -= 5;
			if(y < 1)
				y = 0;
			cls_all(0);
			break;
		case '': case 'u':
		/*
		半ページ上へ
		*/
			for(i=0;i<(LINES/2) - botom;i++)
			{
				y -= 1;
				if(y < 1)
				{
					y = 0;
					break;
				}
			}
			cls_all(0);
			break;
 
		case 'D':
		/*
		５行ダウン
		*/
			if(y+yy > MAX_FILES || y+yy > file_num + 3 || strlen(fs[y+(yy-5)].buff1) < (size_t)1)
			{
				break;
			}
			if(yy < max_lines - (botom + 2))
			{
				if(yy >  max_lines - (botom + 7))
				{
					yy = max_lines - (botom + 7);
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				yy++;
				if(yy >= file_num + 5)
				{
					yy = file_num + 4;
					break;
				}
				break;
			}

			y += 5;
			if(y >= MAX_FILES - max_lines)
				y = MAX_FILES - max_lines;
			
			if(yy < (max_lines - (botom + 2)))
				yy = file_num - 5;

			cls_all(0);
			break;

		case '': case 'd':
		/*
		半ページ下へ
		*/
			if(y > (file_num - (max_lines - 7)))
				break;
			if(y > MAX_FILES || y+(yy-5) > (file_num + 4) - (max_lines - botom) + 7)
				break;
			for(i=0;i<(LINES/2)-3;i++)
			{
				y += 1;
				if(y >= MAX_FILES - max_lines)
				{
					y = MAX_FILES - max_lines;
					break;
				}
			}
			if(y > file_num - max_lines)
				y = file_num - (max_lines - 8);
			cls_all(0);
			break;

			case 'k': case 'K': case 0x41:
		/*
		上スクロール
		*/

			if(yy > 5)
			{
				yy--;
				break;
			}

			y -= 1;
			if(y < 1)
				y = 0;
			cls_all(0);
			break;

		 case 'j': case 'J': case 0x42:
		/*
		下スクロール
		*/
			if(y+yy > MAX_FILES || y+yy > file_num + 3)
				break;
			if(yy > file_num + 5)
			{
				break;
			}
			/*
			if(yy < (max_lines - 8) && yy <= file_num + 5)
			*/
			if(yy < (max_lines - (botom + 2)) && yy <= file_num + 5)
			{
				yy++;
				break;
			}

			y += 1;
			if(y >= MAX_FILES - max_lines)
				y = MAX_FILES - max_lines;

			cls_all(0);
			break;

		case 'C':
		/*
		全ウインドウの再描画
		*/
		allCLS:
			wclear(pt[0].vs);
			max_lines = LINES;
			delwin(pt[0].vs);
			pt[0].vs = newwin(max_lines - botom,COLS,1,0);
			set_screen(0);
			wattron(pt[0].vs,A_REVERSE);
			box(pt[0].vs,' ',' ');
			wattroff(pt[0].vs,A_REVERSE);
			wrefresh(pt[0].vs);
			delwin(evs);
			evs = newwin(3,COLS,LINES-1,0);
			displaymenu1(evs,dflag);
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',512);
			}
			tabselectclear();
			wclrtoeol(pt[0].vs);
			cls_all(0);
			dirprint_all(".",fmode);
			break;

		 case 'Z':
		allCLS2:
			for(j=0;j<256;j++)
			{
				memset(selcp[j],'\0',512);
			}
			tabselectclear();

			for(j=5;j < (file_num - (max_lines - 8));j++)
				vs_print(" ",pt[0].vs,line1[0]+1,j);
			dirprint_all(".",fmode);
			break;
		/*
		検索実行
		*/
		 case 'q': case 'Q':
		/*
		終了
		*/
			if(popmsg(30,LINES - 11,"FTXに戻ります。") == 1)
				goto filerend;
			break;
		}
	}

filerend:
	endwin();
	printf("\033[5>l");
	for(i=0;i<MAX_WINDOW;i++)
		delwin(pt[i].vs);
	delwin(evs);
	initbuff();
	return(0);
}

