#include  "general_server.h"
#include  "compat_stringstream.h"
#include  "system_call_wrapper.h"
#include  <cstdio>
#include  <stdexcept>

General_Server::General_Server( const ref_count_ptr
				 <const General_Server_Interpreter_Factory> &
							 interpreter_factory ,
				const ref_count_ptr
				 <const General_Server_Default_Action> &
							 default_action ,
				const port_number_t &  port ,
				const std::vector<std::string> &  argv ,
				SOCKET_FD_TYTE  bind_fd )
	: interpreter_factory( interpreter_factory ) ,
	  default_action( default_action ) ,
	  port( port ) ,
	  argv( argv ) ,
	  with_bind_fd( bind_fd != BAD_SOCKET_FD ) ,
	  socket() ,
	  internal_status( Running ) ,
	  client_map()
{
	if ( with_bind_fd )
	{
		if ( this -> socket.socket( Stream_Socket::Opened_Socket ,
					    bind_fd ,
					    AF_INET ) == -1 )
		{
			throw std::runtime_error( "" );
		}
	}
	else
	{
		if ( this -> socket.socket( AF_INET , SOCK_STREAM ) == -1
		  || this -> socket.bind( this -> port ) == -1
		  || this -> socket.listen( SOMAXCONN ) == -1 )
		{
			throw std::runtime_error( "" );
		}
	}
}

General_Server::~General_Server()
{
}

General_Server::Status  General_Server::status() const
{
	return( this -> internal_status );
}

void   General_Server::shutdown()
{
	this -> internal_status = Shutdown;
}

void   General_Server::reboot()
{
	this -> client_map.clear();

	compat_stringstream	bind_fd;
	bind_fd << this -> socket.fd();

	std::vector<std::string>	exec_argv( this -> argv );

	if ( ! with_bind_fd )
	{
		exec_argv.push_back( "--bind-fd" );
		exec_argv.push_back( bind_fd.str() );
	}

	if ( System_Call_Wrapper::execvp( exec_argv[0] , exec_argv ) == -1 )
	{
		std::perror( "exec" );

		throw std::runtime_error( "" );
	}
}


bool   General_Server::run()
{
	//
	// main loop
	//
	for(;;)
	{
		if ( this -> status() == Shutdown )
		{
			break;
		}
		else if ( this -> status() == Sleeping )
		{
			// XXX
			std::cerr << "sleeping" << std::endl;
		}



		// if new client request comes
		if ( socket.poll() )
		{
			int			fd;
			struct sockaddr_in	addr;

			if ( (fd = this -> socket.accept( &addr )) != -1 )
			{
				// XXX
				std::cerr << "accepted!" << std::endl;

				client_map[fd] = this -> interpreter_factory
							     -> create( fd );
			}
		}


		// interpret each client message
		for ( Client_Map_Type::iterator
			  it = this -> client_map.begin()  ;
		      it != client_map.end()  ; )
		{
			(*it).second -> interpret( *this );

			if ( ! ((*it).second -> valid()) )
			{
				//
				// unregister
				//
				Client_Map_Type::iterator erase_it = it;
				++ it;
				client_map.erase( erase_it );

				continue;
			}

			if ( this -> status() != Running )
			{
				break;
			}

			++ it;
		}


		if ( this -> default_action )
		{
			this -> default_action -> action();
		}
	}


	return( true );
}
