#ifndef	   RANDOM_GENERATOR_H_INCLUDED
#define	   RANDOM_GENERATOR_H_INCLUDED


class  Random_Generator
{
public:
		 Random_Generator() {}
	virtual	~Random_Generator() {}

	virtual	unsigned long	max() const = 0;

	virtual	unsigned long	random() = 0;

	long	signed_random()
	{
		return( this -> random() - (this -> max() / 2) - 1 );
	}


	double	random_01()
	{
		return( double( this -> random() ) / double( this -> max() ) );
	}

	double	random_minus_plus_1()
	{
		return( (this -> random_01() - 0.5) * 2.0 );
	}

	unsigned long	random_n( unsigned int n )
	{
		if ( n == 0 )
		{
		    return( 0 );
		}

		return( this -> random() % n );
	}

	bool	random_bit()
	{
		return( bool( this -> random() % 2 ) );
	}
};


#endif	/* RANDOM_GENERATOR_H_INCLUDED */
